/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.arf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.arf.AArfConnection;
import com.wily.introscope.agent.arf.ArfMap;
import com.wily.introscope.agent.arf.ArfMessage;
import com.wily.introscope.agent.arf.ArfMessageFactory;
import com.wily.introscope.agent.arf.ArfMessageStatus;

public abstract class ArfCommandConnection
extends AArfConnection {
    private Object fPingMonitor = new Object();
    private long fLastPingResponseTime = System.currentTimeMillis();

    public ArfCommandConnection(IAgent agent, String connectMessage) throws Exception {
        super(agent, connectMessage);
        ArfMap map;
        ArfMessage m = ArfMessageFactory.getParserInstance().parseMessage(connectMessage);
        if (m.isInstIdSet()) {
            this.fInstanceId = m.getInstId();
        }
        if (m.isProgramSet()) {
            this.fProgram = m.getProgram();
        }
        if (m.isProbeSet()) {
            this.fProbe = m.getProbe();
        }
        if (m.isPidSet()) {
            this.fPid = m.getPid();
        }
        if (m.isTidSet()) {
            this.fTid = m.getTid();
        }
        if ((map = m.getParams()) != null) {
            String host = map.getString("hostName");
            this.fHost = this.isValidParamValue(host) ? host : null;
            String containerId = map.getString("containerId");
            this.fContainerId = this.isValidParamValue(containerId) ? containerId : null;
            String app = map.getString("appName");
            this.fApp = this.isValidParamValue(app) ? app : null;
            String containerName = map.getString("containerName");
            this.fContainerName = this.isValidParamValue(containerName) ? containerName : null;
            String podName = map.getString("podName");
            this.fPodName = this.isValidParamValue(podName) ? podName : null;
            String podNamespace = map.getString("podNamespace");
            this.fPodNamespace = this.isValidParamValue(podNamespace) ? podNamespace : null;
            String podIpAddress = map.getString("podIpAddress");
            this.fPodIpAddress = this.isValidParamValue(podIpAddress) ? podIpAddress : null;
        }
    }

    public ArfCommandConnection(IAgent agent) {
        super(agent);
    }

    @Override
    public String toString() {
        return "ArfCommandConnection " + (this.isClient() ? "Client" : "Server");
    }

    @Override
    protected ArfMessageStatus processMessage(ArfMessage m) {
        if (m.getOp().equals("arf")) {
            this.pingResponse();
            return ArfMessageStatus.MSG_SUCCESS;
        }
        if (this.fListener != null) {
            return this.fListener.processMessage(this, m);
        }
        return ArfMessageStatus.MSG_FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pingConnection(long maxPingDelay) throws Exception {
        this.sendNow(ArfMessageFactory.getWriterInstance("speak").writeMessage());
        Object object = this.fPingMonitor;
        synchronized (object) {
            if (this.fLastPingResponseTime < System.currentTimeMillis() - maxPingDelay) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pingResponse() {
        Object object = this.fPingMonitor;
        synchronized (object) {
            this.fLastPingResponseTime = System.currentTimeMillis();
        }
    }

    protected boolean isValidParamValue(String param) {
        return param != null && !param.isEmpty();
    }
}

