/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.collector;

import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;

public class CollectorAgentWarmUp {
    private static final Module AGENT_WARM_UP = new Module("CollectorAgentWarmUp");
    private static final CollectorAgentWarmUp INSTANCE = new CollectorAgentWarmUp();
    public static final String INTROSCOPE_REMOTEAGENT_WARMUP = "introscope.remoteagent.warmup";
    private long waitTime = -1L;

    public static CollectorAgentWarmUp getInstance() {
        return INSTANCE;
    }

    public void agentWarmUp(IAgent fAgent) {
        boolean isAgentNameEmpty;
        this.initWaitTime(fAgent);
        IModuleFeedbackChannel moduleFeedback = fAgent.IAgent_getModuleFeedback();
        String agentName = null;
        int retryCount = 0;
        do {
            ++retryCount;
            agentName = fAgent.IAgent_getName();
            boolean bl = isAgentNameEmpty = agentName == null || "UnknownAgent".equals(agentName);
            if (isAgentNameEmpty) {
                if (moduleFeedback.isDebugEnabled(AGENT_WARM_UP)) {
                    moduleFeedback.debug(AGENT_WARM_UP, "Agent Name is not initialized yet in retry count [" + retryCount + "].");
                }
                this.sleep(moduleFeedback);
            } else {
                moduleFeedback.info(AGENT_WARM_UP, "Agent Name is initialized with [" + agentName + "] in retry count [" + retryCount + "].");
            }
            boolean bl2 = isAgentNameEmpty = agentName == null || "UnknownAgent".equals(agentName);
        } while (retryCount <= 6 && isAgentNameEmpty);
        if (isAgentNameEmpty && moduleFeedback.isDebugEnabled(AGENT_WARM_UP)) {
            moduleFeedback.debug(AGENT_WARM_UP, "Agent Name is still not initialized. It can lead to UnknownAgent for probes connect via ARF/HTTP.");
        }
    }

    private void sleep(IModuleFeedbackChannel moduleFeedback) {
        block2: {
            try {
                Thread.sleep(this.getWaitTime());
            }
            catch (InterruptedException ex) {
                if (!moduleFeedback.isDebugEnabled(AGENT_WARM_UP)) break block2;
                moduleFeedback.debug(AGENT_WARM_UP, "sleep interruption - " + ex.getMessage(), ex);
            }
        }
    }

    public long getWaitTime() {
        if (this.waitTime == -1L) {
            return 1000L;
        }
        return this.waitTime;
    }

    private void initWaitTime(IAgent fAgent) {
        if (this.waitTime != -1L) {
            return;
        }
        int timeInSecs = fAgent.IAgent_getIndexedProperties().getIntProperty(INTROSCOPE_REMOTEAGENT_WARMUP, 2);
        this.waitTime = timeInSecs * 1000;
    }
}

