/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.collector;

import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.arf.AArfConnection;
import com.wily.introscope.agent.arf.ArfCommandConnection;
import com.wily.introscope.agent.arf.ArfDataConnection;
import com.wily.introscope.agent.arf.ArfMap;
import com.wily.introscope.agent.arf.ArfMessage;
import com.wily.introscope.agent.arf.ArfMessageFactory;
import com.wily.introscope.agent.arf.IArfConnectionListener;
import com.wily.introscope.agent.collector.CollectorAgentInfo;
import com.wily.introscope.agent.collector.GenericProbeCollector;
import com.wily.introscope.agent.collector.ProbeCollector;
import com.wily.introscope.agent.collector.ProbeCollectorLoader;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.agent.transformer.dynamic.IDirectiveLoadListener;
import com.wily.util.adt.ConcurrentStripLockByKey;
import com.wily.util.adt.ICappedMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;

public class ProbeManager
implements IArfConnectionListener,
IDirectiveLoadListener {
    private final IAgent fAgent;
    private final IModuleFeedbackChannel fFeedback;
    private final Module kModule = new Module("ProbeCollector");
    private final ConcurrentHashMap<String, ProbeCollector> fProbes = new ConcurrentHashMap();
    private final Map fMethodCache;
    private static volatile IIntelligentInstrumentationTracerHelper sSIService = null;
    private final ConcurrentStripLockByKey lockByKey = new ConcurrentStripLockByKey();
    private final boolean kAllowLocalProbesOnly;
    private static final String ARF_PROTOCOL_VERSION = "1.1.0";
    private final String kProbeProcessNameKey = "introscope.remoteagent.probe.process.name";
    private final String kProbeProcessDefaultName = "{type}";
    private final String kProbeProcessName;
    private final String kProbeAgentNameKey = "introscope.remoteagent.probe.agent.name";
    private final String kProbeAgentDefaultName = "{program}";
    private final String kProbeAgentName;
    private final ProbeCollectorLoader fLoader;
    public static String sSustainabilityBaseMetricName = "Agent Stats|Sustainability|Probe Collector";

    public ProbeManager(IAgent agent, boolean localOnly) {
        this.fAgent = agent;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fMethodCache = this.fAgent.IAgent_getConcurrentMapFactory().getConcurrentCappedMap("ProbeCollectorMethodCache");
        if (this.fAgent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer() != null) {
            this.fAgent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().registerDirectiveLoadListener(this);
        }
        this.kAllowLocalProbesOnly = localOnly;
        this.kProbeProcessName = this.fAgent.IAgent_getIndexedProperties().getProperty("introscope.remoteagent.probe.process.name", "{type}");
        this.kProbeAgentName = this.fAgent.IAgent_getIndexedProperties().getProperty("introscope.remoteagent.probe.agent.name", "{program}");
        ICappedMap map = (ICappedMap)((Object)this.fMethodCache);
        map.setCallback(new ICappedMap.IOnEntryRemovedListener(){

            public void onEntryRemoved(Map.Entry entry) {
                if (ProbeManager.this.fFeedback.isDebugEnabled(ProbeManager.this.kModule)) {
                    ProbeManager.this.fFeedback.debug(ProbeManager.this.kModule, "Method Cache entry " + entry.getKey() + " aged out.");
                }
            }
        });
        this.fLoader = new ProbeCollectorLoader(this.fAgent, this);
        this.startProbeManagerService();
    }

    public IIntelligentInstrumentationTracerHelper getSIService() {
        if (sSIService == null && this.fAgent != null) {
            try {
                sSIService = this.fAgent.IAgent_getTracerAdministrator().getIntelligentInstrumentationService();
            }
            catch (Exception e) {
                this.fFeedback.error(e.getMessage(), e);
            }
        }
        return sSIService;
    }

    private void startProbeManagerService() {
        this.fAgent.IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

            @Override
            public void ITimestampedRunnable_execute(long nowInMillis) {
                try {
                    ProbeManager.this.serviceProbeCollectors();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, "ProbeManagerService", true, 1000L, false);
    }

    public Map getMethodCache() {
        return this.fMethodCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProbeCollector getCollector(AArfConnection conn) {
        String instid = conn.getInstanceId();
        ProbeCollector c = null;
        c = this.fProbes.get(instid);
        if (c == null) {
            Lock lock = this.lockByKey.lock(instid);
            try {
                if (this.fProbes.containsKey(instid)) {
                    c = this.fProbes.get(instid);
                } else {
                    c = this.createProbeCollector(conn, instid);
                    this.fProbes.put(instid, c);
                }
            }
            finally {
                this.lockByKey.unlock(instid, lock);
            }
        }
        if (c != null) {
            if (c.getProbe() == null) {
                c.setProbe(conn.getProbe());
                TransactionHarvestHelper.fLanguage = conn.getProbe();
            }
            if (c.getProgram() == null) {
                c.setProgram(conn.getProgram());
            }
            if (c.getPid() == null) {
                c.setPid(conn.getPid());
            }
            if (c.getTid() == null) {
                c.setTid(conn.getTid());
            }
            if (c.getHost() == null) {
                c.setHost(conn.getHost());
            }
            if (c.getAppName() == null) {
                c.setAppName(conn.getAppName());
            }
            if (c.getContainerId() == null && conn.getContainerId() != null) {
                c.setContainerId(conn.getContainerId());
            }
            if (c.getContainerName() == null && conn.getContainerName() != null) {
                c.setContainerName(conn.getContainerName());
            }
            if (c.getPodIpAddress() == null && conn.getPodIpAddress() != null) {
                c.setPodIpAddress(conn.getPodIpAddress());
            }
            if (c.getPodName() == null && conn.getPodName() != null) {
                c.setPodName(conn.getPodName());
            }
            if (c.getPodNamespace() == null && conn.getPodNamespace() != null) {
                c.setPodNamespace(conn.getPodNamespace());
            }
        }
        c.addConnection(conn);
        return c;
    }

    private ProbeCollector createProbeCollector(AArfConnection conn, String instid) {
        ProbeCollector c = "java".equals(conn.getProbe()) ? new GenericProbeCollector(this.fAgent, this) : this.fLoader.loadProbeCollector(conn.getProbe());
        if (c == null) {
            this.fFeedback.info(this.kModule, "Unknown probe type " + conn.getProbe() + ", using Generic Probe Collector.");
            c = new GenericProbeCollector(this.fAgent, this);
        }
        c.setInstId(instid);
        return c;
    }

    @Override
    public void openConnection(ArfDataConnection conn) {
        ProbeCollector c = this.getCollector(conn);
        if (c.isOpen()) {
            conn.setListener(c);
        } else {
            this.fFeedback.info(this.kModule, "Collector is closed, rejecting data connection: " + conn.toString());
            conn.close();
        }
    }

    @Override
    public void openConnection(ArfCommandConnection conn) {
        ProbeCollector c = this.getCollector(conn);
        conn.setListener(c);
        this.sendCollectorInfo(conn);
    }

    public void removeCollector(String instid) {
        this.fProbes.remove(instid);
    }

    public void resetMethodCache() {
        IIntelligentInstrumentationTracerHelper sis = this.getSIService();
        if (sis != null) {
            sis.resetDeepInstrumentationParameter();
        } else {
            this.fFeedback.debug(this.kModule, "resetMethodCache() not calling resetDeepInstrumentationParameter() due to IntelligentInstrumentationService not available.");
        }
        for (Map.Entry<String, ProbeCollector> e : this.fProbes.entrySet()) {
            ProbeCollector c = e.getValue();
            c.sendProbeFilterResetMsg();
        }
    }

    public void getProbeCollectorMetrics() {
        this.getProbeCollectorMetrics("");
    }

    public void getHttpProbeCollectorMetrics() {
        this.getProbeCollectorMetrics("HTTP|");
    }

    public void getProbeCollectorMetrics(String nodeName) {
        DataAccumulatorFactory daf = this.fAgent.IAgent_getDataAccumulatorFactory();
        daf.safeGetIntegerFluctuatingCounterDataAccumulator(sSustainabilityBaseMetricName + nodeName + ":Probe Count").IIntegerCounterDataAccumulator_setValue(this.fProbes.size());
        IIntegerAverageDataAccumulator ta = daf.safeGetIntegerAverageDataAccumulator(sSustainabilityBaseMetricName + nodeName + ":Concurrent Tracers");
        for (Map.Entry<String, ProbeCollector> e : this.fProbes.entrySet()) {
            ProbeCollector c = e.getValue();
            ta.IIntegerAggregatingDataAccumulator_recordDataPoint(c.getTracerMapSize());
        }
        daf.safeGetIntegerFluctuatingCounterDataAccumulator(sSustainabilityBaseMetricName + nodeName + ":Remote Thread Count").IIntegerCounterDataAccumulator_setValue(InvocationData.getCacheHelper().getExternalThreadCount());
        daf.safeGetIntegerFluctuatingCounterDataAccumulator(sSustainabilityBaseMetricName + nodeName + ":Traced Method Count").IIntegerCounterDataAccumulator_setValue(this.fMethodCache.size());
    }

    public void serviceProbeCollectors() throws Exception {
        Iterator<Map.Entry<String, ProbeCollector>> i = this.fProbes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, ProbeCollector> e = i.next();
            ProbeCollector c = e.getValue();
            if (c.serviceProbe()) continue;
            i.remove();
        }
    }

    @Override
    public void notifyDirectivesLoaded(Object settings) {
        this.resetMethodCache();
    }

    public boolean allowLocalProbesOnly() {
        return this.kAllowLocalProbesOnly;
    }

    public String getProbeProcessNameFormat() {
        return this.kProbeProcessName;
    }

    public String getProbeAgentNameFormat() {
        return this.kProbeAgentName;
    }

    @Override
    public void notifyRedefinitionComplete() {
    }

    private void sendCollectorInfo(AArfConnection conn) {
        try {
            ArfMessage m = ArfMessageFactory.getWriterInstance("config");
            m.setCmd("version");
            ArfMap map = new ArfMap();
            map.putString("collector", CollectorAgentInfo.INSTANCE.getVersion());
            map.putString("arfp", ARF_PROTOCOL_VERSION);
            m.setParams(map);
            conn.sendNow(m.writeMessage());
        }
        catch (Exception e) {
            this.fFeedback.error(e);
        }
    }
}

