/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.gcmonitor.instrumentation;

import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.gcmonitor.instrumentation.ApplicationException;
import com.wily.introscope.gcmonitor.metricpublisher.MetricPublisher;
import com.wily.introscope.gcmonitor.metricpublisher.MetricPublisherFactory;
import com.wily.introscope.gcmonitor.ui.Messages;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.MetricNotFoundException;
import java.lang.management.MemoryPoolMXBean;
import java.util.ArrayList;

public class GCMemoryPool {
    protected MetricPublisher metricPublisher = null;
    private MemoryPoolMXBean fMemoryPoolMXBean;
    private String memoryTypeName;
    private String memoryType;
    private String spaceUsedName;
    private String currCapacityName;
    private String maxCapacityName;
    private String percentageMaxCapacityName = "";
    private long spaceUsed;
    private long currCapacity;
    private long maxCapacity;
    private long percentageMaxCapacity;
    private ArrayList<String> fMetricNames = null;

    public GCMemoryPool(MemoryPoolMXBean bean) {
        this.initPublisher();
        if (bean != null) {
            this.fMemoryPoolMXBean = bean;
            this.init();
        }
    }

    protected void init() {
        String metricPath = this.generateMetricPath();
        this.memoryTypeName = metricPath + Messages.getString("GCMonitorTypeViewer.memoryType");
        this.spaceUsedName = metricPath + Messages.getString("GCMonitorTypeViewer.SpaceUsed");
        this.currCapacityName = metricPath + Messages.getString("GCMonitorTypeViewer.CurrentCapacity");
        this.maxCapacityName = metricPath + Messages.getString("GCMonitorTypeViewer.MaximumCapacity");
        this.percentageMaxCapacityName = metricPath + Messages.getString("GCMonitorTypeViewer.PercentageCapacity");
        if (this.fMemoryPoolMXBean != null) {
            this.memoryType = this.fMemoryPoolMXBean.getType().name();
        }
        this.fMetricNames = new ArrayList();
    }

    public void publishMetricValues() {
        if (this.fMemoryPoolMXBean != null) {
            boolean reportCapacityMetrics = true;
            int percentageMax = 0;
            this.spaceUsed = this.fMemoryPoolMXBean.getUsage().getUsed();
            this.currCapacity = this.fMemoryPoolMXBean.getUsage().getCommitted();
            this.maxCapacity = this.fMemoryPoolMXBean.getUsage().getMax();
            this.percentageMaxCapacity = Math.round((double)this.spaceUsed * 100.0 / (double)this.maxCapacity);
            reportCapacityMetrics = this.maxCapacity != -1L;
            this.metricPublisher.publish(this.memoryTypeName, this.memoryType);
            if (!this.fMetricNames.contains(this.memoryTypeName)) {
                this.fMetricNames.add(this.memoryTypeName);
            }
            this.metricPublisher.publish(this.spaceUsedName, this.spaceUsed);
            if (!this.fMetricNames.contains(this.spaceUsedName)) {
                this.fMetricNames.add(this.spaceUsedName);
            }
            this.metricPublisher.publish(this.currCapacityName, this.currCapacity);
            if (!this.fMetricNames.contains(this.currCapacityName)) {
                this.fMetricNames.add(this.currCapacityName);
            }
            if (reportCapacityMetrics) {
                percentageMax = (int)this.percentageMaxCapacity;
                if (percentageMax > 100) {
                    percentageMax = 100;
                } else if (percentageMax < 0) {
                    percentageMax = 0;
                }
                this.metricPublisher.publish(this.maxCapacityName, this.maxCapacity);
                if (!this.fMetricNames.contains(this.maxCapacityName)) {
                    this.fMetricNames.add(this.maxCapacityName);
                }
                this.metricPublisher.publish(this.percentageMaxCapacityName, percentageMax);
                if (!this.fMetricNames.contains(this.percentageMaxCapacityName)) {
                    this.fMetricNames.add(this.percentageMaxCapacityName);
                }
            } else {
                this.metricPublisher.publish(this.maxCapacityName, Messages.getString("GCMonitorMetricValue.Unlimited"));
                if (!this.fMetricNames.contains(this.maxCapacityName)) {
                    this.fMetricNames.add(this.maxCapacityName);
                }
                this.metricPublisher.publish(this.percentageMaxCapacityName, percentageMax);
                if (!this.fMetricNames.contains(this.percentageMaxCapacityName)) {
                    this.fMetricNames.add(this.percentageMaxCapacityName);
                }
            }
        }
    }

    private String generateMetricPath() {
        String metricName = "";
        String rootNode = Messages.getString("GCMonitorTypeViewer.RootNode");
        metricName = rootNode + "|" + Messages.getString("GCMonitorTypeViewer.MemoryPoolsNode") + "|" + this.fMemoryPoolMXBean.getName() + ":";
        return metricName;
    }

    public void turnOffMetrics(DataAccumulatorFactory factory) throws ApplicationException {
        ArrayList<String> metricsTobeRemoved = new ArrayList<String>();
        for (String metricName : this.fMetricNames) {
            metricsTobeRemoved.add(metricName);
        }
        for (String metric : metricsTobeRemoved) {
            try {
                factory.removeMetric(metric);
                this.fMetricNames.remove(metric);
            }
            catch (BadlyFormedNameException e) {
                throw new ApplicationException(e);
            }
            catch (MetricNotFoundException e) {
                throw new ApplicationException(e);
            }
        }
    }

    protected String getString(String key) {
        return Messages.getString(key);
    }

    protected void initPublisher() {
        this.metricPublisher = MetricPublisherFactory.getInstance().getMetricPublisher();
    }

    protected int getMetricNamesSize() {
        return this.fMetricNames.size();
    }

    public String getMemoryType() {
        return this.memoryType;
    }
}

