/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.api;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.Utils;
import com.ca.apm.agent.jmxclient.api.BeanConfigElement;
import com.ca.apm.agent.jmxclient.api.BeanConfiguration;
import com.ca.apm.agent.jmxclient.api.ConfigurationReader;
import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.wily.introscope.agent.trace.intelligent.Logger;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class CustomConfigProvider
implements BeanConfiguration.ConfigProvider {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private final MBeanServerConnection server;
    private final JmxNodeInfo nodeInfo;
    private final String[] paths;
    private final QueryExp queryExp;

    public CustomConfigProvider(MBeanServerConnection server, JmxNodeInfo nodeInfo, String[] paths) {
        this.server = server;
        this.nodeInfo = nodeInfo;
        this.paths = paths;
        this.queryExp = Utils.jmxQueryExp(Utils.handleRegexInYML(ConfigurationReader.readModuleConfig(paths)));
    }

    @Override
    public Map<ObjectName, Map<String, Set<BeanConfigElement>>> getConfig() {
        return this.getConfig(this.loadMBeans());
    }

    protected Map<ObjectName, Map<String, Set<BeanConfigElement>>> getConfig(Set<ObjectName> names) {
        HashMap<ObjectName, Map<String, Set<BeanConfigElement>>> objectMap = new HashMap<ObjectName, Map<String, Set<BeanConfigElement>>>();
        try {
            Set<BeanConfigElement> config = ConfigurationReader.readModuleConfig(this.paths);
            LOGGER.logDebugMessage("File based custom configuration: " + config);
            if (!config.isEmpty()) {
                TreeSet<ObjectName> ciNames = new TreeSet<ObjectName>(new Comparator<ObjectName>(){

                    @Override
                    public int compare(ObjectName o1, ObjectName o2) {
                        if (o1 == o2) {
                            return 0;
                        }
                        return o1.getCanonicalName().compareToIgnoreCase(o2.getCanonicalName());
                    }
                });
                ciNames.addAll(names);
                for (BeanConfigElement ce : config) {
                    Set<ObjectName> objects = this.getMatchingBeans(ce.getObjectName(), ciNames);
                    for (ObjectName object : objects) {
                        String opName;
                        String atName;
                        TreeMap<String, HashSet<BeanConfigElement>> atMap = (TreeMap<String, HashSet<BeanConfigElement>>)objectMap.get(object);
                        if (atMap == null) {
                            atMap = new TreeMap<String, HashSet<BeanConfigElement>>(String.CASE_INSENSITIVE_ORDER);
                            objectMap.put(object, atMap);
                        }
                        if ((atName = ce.getAttribute()) != null) {
                            HashSet<BeanConfigElement> atConfigElements = (HashSet<BeanConfigElement>)atMap.get(atName);
                            if (atConfigElements == null) {
                                atConfigElements = new HashSet<BeanConfigElement>();
                                atMap.put(atName, atConfigElements);
                            }
                            atConfigElements.add(ce);
                        }
                        if ((opName = ce.getOperationName()) == null) continue;
                        HashSet<BeanConfigElement> opConfigElements = (HashSet<BeanConfigElement>)atMap.get(opName);
                        if (opConfigElements == null) {
                            opConfigElements = new HashSet<BeanConfigElement>();
                            atMap.put(opName, opConfigElements);
                        }
                        opConfigElements.add(ce);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.logDebugMessage("Got exception while creating custom configuration for jmx server: " + this.nodeInfo.getHost(), (Throwable)e);
        }
        return objectMap;
    }

    protected Set<ObjectName> getMatchingBeans(String objNameString, Set<ObjectName> names) throws MalformedObjectNameException {
        HashSet<ObjectName> matching = new HashSet<ObjectName>();
        ObjectName objName = ObjectName.getInstance(objNameString);
        matching.addAll(names);
        Map<String, String> attributeMap = Utils.getAttributeMap(objName.toString());
        for (Map.Entry<String, String> entry : attributeMap.entrySet()) {
            Utils.filterBeans(entry.getKey(), entry.getValue(), matching, Utils.getDomainName(objName.toString()));
        }
        return matching;
    }

    protected Set<ObjectName> loadMBeans() {
        LOGGER.logDebugMessage("Custom Configuration Provider - Querying jmx server " + this.nodeInfo.getHost() + " for: " + this.queryExp);
        if (this.queryExp != null) {
            try {
                Set<ObjectName> beans = this.server.queryNames(null, this.queryExp);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebugMessage("Custom Configuration Provider Query result: ");
                    for (ObjectName bean : beans) {
                        LOGGER.logTraceMessage(bean.toString());
                    }
                }
                return beans;
            }
            catch (Throwable e) {
                LOGGER.logDebugMessage("Got exception while loading beans", e);
            }
        }
        return Collections.emptySet();
    }
}

