/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.thread;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.ca.apm.agent.jmxclient.thread.ThreadMonMetricsProcess;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;

public class ThreadMonService {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    MBeanServerConnection mbeanServer;
    JmxNodeInfo jmxNode;
    String metricPrefix = "Threads";
    IAgent agent;
    private List<String> includeList = new ArrayList<String>();
    private List<String> excludeList = new ArrayList<String>();
    private ThreadMonMetricsProcess threadProcessMetrics;
    private volatile int numOfThreadsToMonitor = 5;
    private PositiveIntegerConfigurationProperty numOfThreadsToMonitorProperty;
    private volatile boolean isThreadMonitoringEnabled = true;
    private BooleanConfigurationProperty isThreadMonitoringEnabledProperty;

    public ThreadMonService() {
    }

    public ThreadMonService(IAgent agent, MBeanServerConnection mbeanServer, JmxNodeInfo jmxNode) {
        this.agent = agent;
        this.mbeanServer = mbeanServer;
        this.jmxNode = jmxNode;
        this.threadProcessMetrics = new ThreadMonMetricsProcess(this);
        this.includeList = jmxNode.getMetricInfo().getThreadNameIncludeList();
        this.excludeList = jmxNode.getMetricInfo().getThreadNameExcludeList();
        this.initializeThreadMonitoringEnabledProperty();
        this.initializeNoOfThreadClamp();
    }

    public void fetchAndProcessThreads() {
        this.threadProcessMetrics.fetchAndProcessThreads();
    }

    public void initializeThreadMonitoringEnabledProperty() {
        boolean defaultIsThreadMonitoringEnabled = true;
        this.isThreadMonitoringEnabled = Boolean.parseBoolean(this.agent.IAgent_getConfigurationManager().getProperty("introscope.agent.remotejmx.threadMonitor.enabled"));
        this.isThreadMonitoringEnabledProperty = new BooleanConfigurationProperty("introscope.agent.remotejmx.threadMonitor.enabled", true, "", this.agent.IAgent_getModuleFeedback(), Configuration.getModule(), this.agent.IAgent_getStringLocalizer()){

            public void set(Object value) {
                Boolean temp = (Boolean)value;
                if (temp == null) {
                    ThreadMonService.this.isThreadMonitoringEnabled = ThreadMonService.this.isThreadMonitoringEnabled;
                } else {
                    ThreadMonService.this.isThreadMonitoringEnabled = temp;
                }
            }
        };
        this.agent.IAgent_getConfigurationManager().add((ConfigurationProperty)this.isThreadMonitoringEnabledProperty, true);
    }

    public void initializeNoOfThreadClamp() {
        int defaultThreadToMonitor = 5;
        try {
            this.numOfThreadsToMonitor = Integer.parseInt(this.agent.IAgent_getConfigurationManager().getProperty("introscope.agent.remotejmx.threadMonitor.numOfThreadsToMonitor"));
        }
        catch (NumberFormatException nfe) {
            LOGGER.logError("Invalid value for introscope.agent.remotejmx.threadMonitor.numOfThreadsToMonitor. Setting with default value:5");
            this.numOfThreadsToMonitor = 5;
        }
        this.numOfThreadsToMonitorProperty = new PositiveIntegerConfigurationProperty("introscope.agent.remotejmx.threadMonitor.numOfThreadsToMonitor", 5, "", this.agent.IAgent_getModuleFeedback(), Configuration.getModule(), this.agent.IAgent_getStringLocalizer()){

            public void set(Object value) {
                Integer temp = (Integer)value;
                if (temp == null) {
                    ThreadMonService.this.numOfThreadsToMonitor = 5;
                } else if (temp >= 0) {
                    ThreadMonService.this.numOfThreadsToMonitor = temp;
                }
            }
        };
        this.agent.IAgent_getConfigurationManager().add((ConfigurationProperty)this.numOfThreadsToMonitorProperty, true);
    }

    public String getNormalizedThreadName(String threadName) {
        String normalizedThreadName = threadName.replaceAll("[\\d\\s]+$", "");
        normalizedThreadName = normalizedThreadName.replaceAll("[:|]", "_");
        return normalizedThreadName;
    }

    public boolean includeThread(String threadName) {
        for (String regex : this.includeList) {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(threadName);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean excludeThread(String threadName) {
        for (String regex : this.excludeList) {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(threadName);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public long[] threadIdsToMonitor(long[] ids) {
        if (this.numOfThreadsToMonitor > 0) {
            if (ids.length > this.numOfThreadsToMonitor) {
                Arrays.sort(ids);
                ids = Arrays.copyOfRange(ids, 0, this.numOfThreadsToMonitor);
                return ids;
            }
            return ids;
        }
        return new long[0];
    }

    public int getNumOfThreadsToMonitor() {
        return this.numOfThreadsToMonitor;
    }

    public boolean isThreadMonitoringEnabled() {
        return this.isThreadMonitoringEnabled;
    }
}

