/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.nass.publisher;

import com.ca.apm.agent.apmservices.client.httpclient.APMServicesHostConnection;
import com.ca.apm.agent.apmservices.client.httpclient.HttpClientFactory;
import com.ca.apm.agent.apmservices.client.nass.publisher.MetricResponseHandler;
import com.ca.apm.agent.apmservices.client.nass.publisher.model.IngestRecord;
import com.ca.apm.agent.apmservices.client.nass.publisher.model.IngestRecords;
import com.ca.apm.agent.apmservices.client.sustainability.SustainabilityRecorder;
import com.ca.apm.agent.apmservices.client.utils.APMServiceEndpointURL;
import com.ca.apm.agent.apmservices.client.utils.APMServicesConnection;
import com.google.gson.stream.JsonWriter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class MetricPublisher {
    private static final String AUTH_HDR_STR = "Authorization";
    private APMServicesConnection apmServicesConnection;
    private IModuleFeedbackChannel logger;
    private String extensionName;

    public MetricPublisher(APMServicesConnection apmServicesConnection, IModuleFeedbackChannel logger, String extensionName) {
        this.apmServicesConnection = apmServicesConnection;
        this.logger = logger;
        this.extensionName = extensionName;
    }

    public Integer publishMetricRecords(IngestRecords batchToLoad, boolean async) {
        Integer result = null;
        try {
            long startTime = System.currentTimeMillis();
            APMServicesHostConnection hostConnection = this.apmServicesConnection.getApmServicesHostConnection();
            Request.Builder httpReq = new Request.Builder();
            if (this.apmServicesConnection.getCredential() != null && !this.apmServicesConnection.getCredential().isEmpty()) {
                httpReq.addHeader(AUTH_HDR_STR, String.format("Bearer %s", this.apmServicesConnection.getCredential()));
            }
            httpReq.addHeader("content-type", "application/json");
            httpReq.url(hostConnection.getConnectionURL("/nass/metricValue/store"));
            String postBody = this.createNASSValuePayload(batchToLoad);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("sending metric vales to  NASS :" + postBody);
            }
            httpReq.post(RequestBody.create((MediaType)APMServiceEndpointURL.JSON, (String)new String(postBody.getBytes(), Charset.forName("UTF-8"))));
            MetricResponseHandler metricResponseHandler = new MetricResponseHandler(this.logger, this.extensionName, batchToLoad.getSize());
            if (async) {
                HttpClientFactory.executeRequestAsync(httpReq.build(), metricResponseHandler);
            } else {
                Response response = HttpClientFactory.executeRequestSync(httpReq.build());
                metricResponseHandler.onResponse(null, response);
                result = metricResponseHandler.numRecordsLoaded;
            }
            long totalTime = System.currentTimeMillis() - startTime;
            SustainabilityRecorder.putMetric("|NASS:Metric Store Average Response Time(ms)", totalTime);
        }
        catch (Exception e1) {
            this.logger.error("Exception encountered when sending metric:  " + e1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createNASSValuePayload(IngestRecords records) {
        ByteArrayOutputStream jsonOut = new ByteArrayOutputStream();
        JsonWriter writer = null;
        try {
            writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)jsonOut, "UTF-8"));
            writer.beginObject().name("values").beginArray();
            for (IngestRecord record : records.getValues()) {
                writer.beginArray();
                writer.value(record.getId());
                writer.value((long)record.getEndTime());
                if (record.getValue() instanceof Number) {
                    writer.value(this.asDouble(record.getMinValue()));
                    writer.value(this.asDouble(record.getMaxValue()));
                    writer.value(this.asDouble(record.getValue()));
                } else {
                    writer.value((String)null);
                    writer.value((String)null);
                    writer.value(record.getValue().toString().trim());
                }
                writer.value(record.getCount());
                writer.value((long)record.getInterval());
                writer.endArray();
            }
            writer.endArray().endObject().flush();
        }
        catch (Exception ex) {
            this.logger.error("Error generating JSON metric registration payload for NASS Metrics", (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
        }
        return jsonOut.toString();
    }

    double asDouble(Object o) {
        Double val = null;
        if (o instanceof Number) {
            val = ((Number)o).doubleValue();
        }
        return val;
    }
}

