/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.service;

import com.ca.apm.agent.apmservices.client.api.TracestoreServiceAPI;
import com.ca.apm.agent.apmservices.client.httpclient.APMServicesHostConnection;
import com.ca.apm.agent.apmservices.client.utils.APMServicesConnection;
import com.ca.apm.agent.apmservices.client.utils.CustomNameThreadFactory;
import com.ca.apm.tas.api.entities.OperationFailure;
import com.ca.apm.tracestore.api.entities.TraceData;
import com.ca.apm.tracestore.api.entities.TraceDataCollection;
import com.ca.apm.tracestore.api.entities.TraceProcessResponse;
import com.google.gson.Gson;
import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.Route;

public class TracestoreService
implements TracestoreServiceAPI {
    private IAgent iAgent;
    private APMServicesConnection connection;
    private IModuleFeedbackChannel logger;
    private OkHttpClient httpClient;
    private static long displayCount = 0L;
    private static long tcdCompsDisplaySucessSize = 0L;
    private static long tcdCompsDisplayFailureSize = 0L;
    private static final String PREFIX_THREADNAME = "OkHttpThread-";
    private static final String AUTH_HDR_STR = "Authorization";
    private static final String BEARER_TOKEN_STR = "Bearer %s";
    private static final String CONTENTTYPE_HDR_STR = "Content-Type";
    private static final String ACCEPT_HDR_STR = "Accept";
    private static final String APPLICATION_JSON_STR = "application/json";
    private static final int CONNECT_REQUEST_TIMEOUT_MILLIS = 2000;
    private static final int CONNECT_ESTABLISH_TIMEOUT_MILLIS = 2000;
    private static final int DEFAULT_THREADS_SIZE = 100;
    private static final String TRACESTORE_THREADSSIZE_PROPERTY = "introscope.agent.mainframe.tracestore.threadsSize";
    private static final String AGENTMANAGER_HTTPPROXY_HOST_PROPERTY = "agentManager.httpProxy.host";
    private static final String AGENTMANAGER_HTTPPROXY_PORT_PROPERTY = "agentManager.httpProxy.port";
    private static final String AGENTMANAGER_HTTPPROXY_USERNAME_PROPERTY = "agentManager.httpProxy.username";
    private static final String AGENTMANAGER_HTTPPROXY_PASSWORD_PROPERTY = "agentManager.httpProxy.password";
    private static final String PROXY_AUTHORIZATION_STR = "Proxy-Authorization";
    private static final String EMPTY_STR = "";

    public TracestoreService(IAgent iAgent, APMServicesConnection connection) {
        this.iAgent = iAgent;
        this.connection = connection;
        this.logger = iAgent.IAgent_getModuleFeedback();
        this.httpClient = this.customOKHttpClient();
    }

    private OkHttpClient customOKHttpClient() {
        String httpProxyHost = this.iAgent.IAgent_getIndexedProperties().getProperty(AGENTMANAGER_HTTPPROXY_HOST_PROPERTY, EMPTY_STR);
        int httpProxyPort = this.iAgent.IAgent_getIndexedProperties().getIntProperty(AGENTMANAGER_HTTPPROXY_PORT_PROPERTY, 0);
        final String httpProxyUsername = this.iAgent.IAgent_getIndexedProperties().getProperty(AGENTMANAGER_HTTPPROXY_USERNAME_PROPERTY, EMPTY_STR);
        final String httpProxyPassword = this.iAgent.IAgent_getIndexedProperties().getProperty(AGENTMANAGER_HTTPPROXY_PASSWORD_PROPERTY, EMPTY_STR);
        int THREADS_SIZE = this.iAgent.IAgent_getIndexedProperties().getIntProperty(TRACESTORE_THREADSSIZE_PROPERTY, 100);
        int MAX_TOTAL_CONNECTIONS = THREADS_SIZE / 2;
        Dispatcher dispatcher = new Dispatcher(Executors.newFixedThreadPool(THREADS_SIZE, new CustomNameThreadFactory("TraceStorePool-")));
        dispatcher.setMaxRequests(MAX_TOTAL_CONNECTIONS);
        dispatcher.setMaxRequestsPerHost(MAX_TOTAL_CONNECTIONS);
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient().newBuilder();
        okHttpClientBuilder.connectTimeout(2000L, TimeUnit.MILLISECONDS);
        okHttpClientBuilder.readTimeout(2000L, TimeUnit.MILLISECONDS);
        okHttpClientBuilder.connectionPool(new ConnectionPool(MAX_TOTAL_CONNECTIONS, 60L, TimeUnit.SECONDS));
        if (httpProxyHost.length() > 0 && httpProxyPort > 0) {
            okHttpClientBuilder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxyHost, httpProxyPort)));
        }
        if (httpProxyUsername.length() > 0 && httpProxyPassword.length() > 0) {
            Authenticator proxyAuthenticator = new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)httpProxyUsername, (String)httpProxyPassword);
                    return response.request().newBuilder().header(TracestoreService.PROXY_AUTHORIZATION_STR, credential).build();
                }
            };
            okHttpClientBuilder.proxyAuthenticator(proxyAuthenticator);
        }
        okHttpClientBuilder.dispatcher(dispatcher);
        try {
            TrustManager[] trustAllCerts = TracestoreService.getTrustManagers();
            SSLSocketFactory sslSocketFactory = TracestoreService.getSslSocketFactory(trustAllCerts);
            okHttpClientBuilder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            okHttpClientBuilder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return okHttpClientBuilder.build();
    }

    private static SSLSocketFactory getSslSocketFactory(TrustManager[] trustAllCerts) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        return sslContext.getSocketFactory();
    }

    private static TrustManager[] getTrustManagers() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        return trustAllCerts;
    }

    @Override
    public void processTrace(final List<TraceData> traceData) {
        try {
            APMServicesHostConnection hostConnection = this.connection.getApmServicesHostConnection();
            Request.Builder httpReq = new Request.Builder();
            httpReq.url(hostConnection.getConnectionURL("/tracestore/process"));
            String token = this.connection.getCredential();
            if (token != null && !token.isEmpty()) {
                httpReq.addHeader(AUTH_HDR_STR, String.format(BEARER_TOKEN_STR, token));
            }
            httpReq.addHeader(CONTENTTYPE_HDR_STR, APPLICATION_JSON_STR);
            httpReq.addHeader(ACCEPT_HDR_STR, APPLICATION_JSON_STR);
            String jasonPayload = new Gson().toJson((Object)new TraceDataCollection(traceData), TraceDataCollection.class);
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=UTF-8"), (String)jasonPayload);
            httpReq.post(body);
            if (this.logger.isDebugEnabled()) {
                if (token == null || token.isEmpty()) {
                    this.logger.debug(PREFIX_THREADNAME + Thread.currentThread().getId() + " -> ##### tracestore Authorization TOKEN not set. Will fallback to CloudProxy token");
                } else {
                    this.logger.debug(PREFIX_THREADNAME + Thread.currentThread().getId() + " -> ##### tracestore Authorization :Bearer " + token);
                }
                this.logger.debug(PREFIX_THREADNAME + Thread.currentThread().getId() + " -> ##### tracestore URL :" + hostConnection.getConnectionURL("/tracestore/process"));
                this.logger.debug(PREFIX_THREADNAME + Thread.currentThread().getId() + " -> ##### tracestore Payload Size:" + jasonPayload.length());
            }
            this.httpClient.newCall(httpReq.build()).enqueue(new Callback(){
                private final long startTime = System.currentTimeMillis();
                private final int tracesSize = traceData.size();

                public void onFailure(Call call, IOException e) {
                    throw new RuntimeException(e);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    try (ResponseBody responseBody = response.body();){
                        if (!response.isSuccessful()) {
                            TracestoreService.this.logger.error(TracestoreService.PREFIX_THREADNAME + Thread.currentThread().getId() + " -> Unexpected HTTP status:" + response.message());
                            TracestoreService.this.logger.error(TracestoreService.PREFIX_THREADNAME + Thread.currentThread().getId() + " -> Response Message:" + responseBody.string());
                            throw new IOException("Unexpected code " + response);
                        }
                        TraceProcessResponse tpResponse = (TraceProcessResponse)new Gson().fromJson(responseBody.string(), TraceProcessResponse.class);
                        int failedTracesCount = tpResponse.getFailedTraces().size();
                        long endTime = System.currentTimeMillis() - this.startTime;
                        tcdCompsDisplaySucessSize += this.tracesSize - failedTracesCount;
                        if (failedTracesCount > 0) {
                            for (OperationFailure ofObj : tpResponse.getFailedTraces()) {
                                TracestoreService.this.logger.info(TracestoreService.PREFIX_THREADNAME + Thread.currentThread().getId() + " -> Failed Details - " + (String)ofObj.getObject() + " :: " + ofObj.getCode() + " :: " + ofObj.getMessage());
                            }
                            tcdCompsDisplayFailureSize += failedTracesCount;
                        }
                        if (TracestoreService.this.logger.isDebugEnabled()) {
                            TracestoreService.this.logger.debug(TracestoreService.PREFIX_THREADNAME + Thread.currentThread().getId() + " -> Stored trace data comps: " + (this.tracesSize - failedTracesCount) + "/" + this.tracesSize + ", time: " + endTime + " ms,  TotalSuccessComps: " + tcdCompsDisplaySucessSize + ", TotalFailComps: " + tcdCompsDisplayFailureSize);
                        } else if (++displayCount % 1L == 0L) {
                            TracestoreService.this.logger.info(TracestoreService.PREFIX_THREADNAME + Thread.currentThread().getId() + " -> Stored trace data comps: " + (this.tracesSize - failedTracesCount) + "/" + this.tracesSize + ", time: " + endTime + " ms,  TotalSuccessComps: " + tcdCompsDisplaySucessSize + ", TotalFailComps: " + tcdCompsDisplayFailureSize);
                        }
                    }
                    catch (IOException e) {
                        tcdCompsDisplayFailureSize += this.tracesSize;
                        TracestoreService.this.logger.error(TracestoreService.PREFIX_THREADNAME + Thread.currentThread().getId() + " -> Failed request due to ", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            tcdCompsDisplayFailureSize += (long)traceData.size();
            this.logger.error(PREFIX_THREADNAME + Thread.currentThread().getId() + " -> Exception in posting traces -:", (Throwable)e);
        }
    }
}

