/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

public class RegularExpressionBuilder {
    public static final String kKleeneClosureString = "*";
    public static final String kPositiveClosureString = "+";
    public static final String kOrString = "|";
    private static final String kAllLegalCharactersExceptSeparatorsGroup = "[^|:]";
    private static final String kAllLegalCharactersWithSegmentSeparatorGroup = "[^:]";
    private static final String kAllLegalCharactersWithMetricSeparatorGroup = "[^|]";
    private static final String kAllLegalCharactersWithBothSeparatorsGroup = ".";
    private static final String kSpecialChars = "^$[]().?*{},+|&";
    private StringBuffer fBuffer = new StringBuffer();

    public static RegularExpressionBuilder or(String regex1, String regex2) {
        return RegularExpressionBuilder.or(new String[]{regex1, regex2});
    }

    public static RegularExpressionBuilder or(String[] regExp) {
        RegularExpressionBuilder builder = new RegularExpressionBuilder();
        int i = 0;
        while (i < regExp.length) {
            if (i > 0) {
                builder.append(kOrString);
            }
            builder.append("(");
            builder.append(regExp[i]);
            builder.append(")");
            ++i;
        }
        return builder;
    }

    public RegularExpressionBuilder() {
    }

    public RegularExpressionBuilder(String initialRegExp) {
        this();
        this.append(initialRegExp);
    }

    public void append(String text) {
        this.fBuffer.append(text);
    }

    public String toString() {
        return this.fBuffer.toString();
    }

    public void appendSegmentSeparator() {
        this.append("\\");
        this.append(kOrString);
    }

    public void appendMetricSeparator() {
        this.append(":");
    }

    public void appendKleeneClosure(String text) {
        this.append("(");
        this.append(text);
        this.append(kKleeneClosureString);
        this.append(")");
    }

    public void appendPositiveClosure(String text) {
        this.append("(");
        this.append(text);
        this.append(kPositiveClosureString);
        this.append(")");
    }

    public static String getAllLegalCharactersNoSeparatorsExpression() {
        return kAllLegalCharactersExceptSeparatorsGroup;
    }

    public static String getAllLegalCharactersWithSegmentSeparatorExpression() {
        return kAllLegalCharactersWithSegmentSeparatorGroup;
    }

    public static String getAllLegalCharactersWithMetricSeparatorExpression() {
        return kAllLegalCharactersWithMetricSeparatorGroup;
    }

    public static String getAllLegalCharactersIncludingSeparatorsExpression() {
        return kAllLegalCharactersWithBothSeparatorsGroup;
    }

    public static String getAllLegalCharactersExpression() {
        return kAllLegalCharactersWithBothSeparatorsGroup;
    }

    public static String getMatchAny() {
        return "(.*)";
    }

    public static String getMatchNone() {
        return "";
    }

    public void appendConvertingEscapeSequences(String input) {
        String converted = RegularExpressionBuilder.convertClearTextToRegExp(input);
        this.append(converted);
    }

    public static String convertClearTextToRegExp(String clearText) {
        StringBuilder result = new StringBuilder();
        int x = 0;
        while (x < clearText.length()) {
            char currentChar = clearText.charAt(x);
            if (RegularExpressionBuilder.requiresEscape(currentChar)) {
                result.append("\\");
            }
            result.append(currentChar);
            ++x;
        }
        return result.toString();
    }

    private static boolean requiresEscape(char inputCharacter) {
        switch (inputCharacter) {
            case '$': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }
}

