/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.apmservices.client.service;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.apmservices.client.httpclient.HttpClientFactory;
import com.wily.introscope.agent.apmservices.client.service.MetadataService;
import com.wily.introscope.agent.apmservices.client.service.NASSService;
import com.wily.introscope.agent.apmservices.client.utils.APMServicesConnection;
import com.wily.introscope.agent.externalId.APMMetricExternalIdService;
import com.wily.introscope.agent.externalId.ExternalIdExtractor;
import com.wily.introscope.agent.nass.NassMetricService;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.Arrays;
import java.util.Map;
import okhttp3.Request;

public class APMServicesClientAPIService
implements NassMetricService {
    public static final String INTROSCOPE_AGENT_NASS_METRIC_BATCH = "introscope.agent.nass.metric.batch";
    private volatile APMServicesConnection connection;
    private volatile MetadataService metadataService;
    private volatile NASSService nassService;
    private IModuleFeedbackChannel fFeedback;
    private static final Module kModule = new Module("APMServicesClientAPIService");
    public static Integer BATCH_TO_PROCESS = 100000;

    public APMServicesClientAPIService(IAgent agent, String extensionName) {
        this.fFeedback = agent.IAgent_getModuleFeedback();
    }

    public void connect(IAgent agent) {
        try {
            this.connection = new APMServicesConnection(agent);
            this.metadataService = new MetadataService(agent, this.connection, "");
            this.nassService = new NASSService(agent, this.connection, this.metadataService, "");
            BATCH_TO_PROCESS = agent.IAgent_getIndexedProperties().getIntProperty(INTROSCOPE_AGENT_NASS_METRIC_BATCH, BATCH_TO_PROCESS.intValue());
            this.fFeedback.info(kModule, "NassServiceAPI connection initialized");
        }
        catch (Throwable ex) {
            this.fFeedback.error(kModule, "Error seen during NassServiceAPI connection initialization with classpath ", ex);
        }
    }

    public void sendMetricCommand(String agentSource, AgentMetricData[] agentMetricsData, String bridgeAppName, boolean firstTimeSlice) {
        if (this.nassService != null) {
            this.nassService.sendBatchMetric(agentSource, Arrays.asList(agentMetricsData), firstTimeSlice, bridgeAppName);
        } else {
            this.fFeedback.error(kModule, "NassServiceAPI is not yet initialized");
        }
    }

    public boolean checkConnection() {
        Request.Builder httpReq = HttpClientFactory.getRequestBuilder(this.connection.getCredential());
        String url = this.connection.getApmServicesHostConnection().getConnectionURL("/apm/appmap/acc");
        return HttpClientFactory.checkConnection(httpReq, url);
    }

    public void addMetricAttributes(String extensionName, String rootPath, String attrKey, String attrValue) {
        if (extensionName == null) {
            return;
        }
        Map<String, ExternalIdExtractor> metricExtractorMap = APMMetricExternalIdService.getInstance().getMetricExtractorMap();
        for (Map.Entry<String, ExternalIdExtractor> entry : metricExtractorMap.entrySet()) {
            if (!extensionName.equals(entry.getValue().getExtensionType())) continue;
            entry.getValue().addMetricAttributes(rootPath, attrKey, attrValue);
            return;
        }
    }
}

