:: ######################################################################
:: #	description: CA APM Infrastructure Agent                        #
:: #	Usage:                                                          #	
:: #	APMIACtrl.bat install                                           #
:: #	APMIACtrl.bat install sysedge                                   #
:: #    APMIACtrl.bat uninstall                                         #
:: #    APMIACtrl.bat clean_uninstall                                   #
:: #    APMIACtrl.bat start                                             #
:: #    APMIACtrl.bat stop                                              #
:: #    APMIACtrl.bat restart                                           #
:: #    APMIACtrl.bat status                                            #
:: #    APMIACtrl.bat console_start                                     #
:: #    APMIACtrl.bat console_stop                                      #
:: #    APMIACtrl.bat help                                              #
:: #    Edited on - 09-August-2021                                        #
:: ######################################################################

:: turn on/off console output
@echo off

SETLOCAL EnableDelayedExpansion
set ERRORLEVEL=0
set NL=^&echo.

:: set current location is located.
set MASTER_INSTALLER=%~dp0

:: specify the location where APM Infrastructure agent is located
set APMIA_INSTALLER_HOME=%MASTER_INSTALLER%

:: specify the location where APM Infrastructure agent bin is located
set APMIA_INSTALLER_BIN=%APMIA_INSTALLER_HOME%bin

set APMIA_WRAPPER_SERVICE_HOME=%APMIA_INSTALLER_HOME%

:: specify the location where SYSEDGE script located
set CASYSTEMEDGE_DIR=casystemedge-6.1.7.3-windows

:: specify the location where Host Monitor install script located
set HOSTMONITOR_INSTALLER_HOME=%APMIA_INSTALLER_HOME%%CASYSTEMEDGE_DIR%\CA_SystemEDGE_Core

if not "%RELEASE_DIR%" == "" (
	:: Update wrapper service home Location
    set APMIA_WRAPPER_SERVICE_HOME=%SCRIPT_DIR%

	:: specify the location where APM Infrastructure agent bin is located
    set APMIA_INSTALLER_BIN=%SCRIPT_DIR%bin

	if exist "%APMIA_INSTALLER_HOME%%CASYSTEMEDGE_DIR%" (
	    xcopy /s /y /i "%APMIA_INSTALLER_HOME%%CASYSTEMEDGE_DIR%" "%SCRIPT_DIR%%CASYSTEMEDGE_DIR%" >nul
		:: Update Hostmonitor installer home Location
		set HOSTMONITOR_INSTALLER_HOME=%SCRIPT_DIR%%CASYSTEMEDGE_DIR%\CA_SystemEDGE_Core
	)
)

:: specify the location where APMIA logs are located
set WRAPPER_HOME=%APMIA_INSTALLER_HOME%wrapper

:: specify the location where APMIA logs are located
set JRE_HOME=%APMIA_INSTALLER_HOME%jre

:: create APMIA log file
call :Logit>>"%APMIA_INSTALLER_HOME%APMIA_install.log" 2>&1

:: specify the location where APMIA logs are located
set APMIA_Installation.log="%APMIA_INSTALLER_HOME%APMIA_install.log"

:: set service name
set SERVICE_NAME=not_a_valid_service_name_tmp

:: set service display name
set DISPLAY_NAME=

:: variables used in script
set isFolderHostMonitor=0
set isFolderAPMIA=0
set withHostMonitor=0
set APMIA_Service=1
set APMIA_Location=1
set HM_Location=1
set PORTNUMBER=1691
set folderOK=0
set portAvailable=0
set userPermission=0
set clean_del=0
set install_hostmonitor=0
set min_java_heap=256
set max_java_heap=512
set command_line=0
set min_yes=0
set max_yes=0
set sysedge_only=0
set property_set=0
set update_service_name=1
set server2022=2022
set server2019=2019
set server2025=2025
set osname=-Dos.name='Windows Server 2016'
set osname2025=-Dos.name='Windows Server 2019'
set JAVA_TOOL_OPTIONS=-Djdk.util.zip.disableZip64ExtraFieldValidation=true

if exist "%APMIA_INSTALLER_BIN%\APMIA_service.txt" (
	set /p SERVICE_NAME=<"%APMIA_INSTALLER_BIN%\APMIA_service.txt"
	echo [%date%] [%TIME%] APMIA service name is !SERVICE_NAME!. >>%APMIA_Installation.log%
)

:: variable for HostMonitor only ecluding Sysedge
set hostmonitor_only=0
if "%AIOPS_INSTALL_ROLE%" EQU "team" (
	set hostmonitor_only=1
	echo [%date%] [%TIME%] APM Infrastructure Agent installing HostMonitor only as SNMPCollector without CA SystemEDGE >>%APMIA_Installation.log%
)

if "%hostmonitor_only%" == "0" (
	findstr /B "introscope.agent.hostmonitor.sysedge.enabled=" "core\config\IntroscopeAgent.profile"|findstr /I "false" > tmprysysedge.txt
	set /p sysEdgeEnable=<tmprysysedge.txt
	IF "!SysEdgeEnable!" NEQ "" (
		set hostmonitor_only=1
		echo [%date%] [%TIME%] APM Infrastructure Agent installing HostMonitor only as SNMPCollector without CA SystemEDGE using IntroscopeAgent property >>%APMIA_Installation.log%
	)
	del /f /q  tmprysysedge.txt
)

if "%MIN_HEAP_VAL_IN_MB%" == "" (
	echo "do nothing" >nul
)else (
	set min_java_heap=%MIN_HEAP_VAL_IN_MB%
)

if "%MAX_HEAP_VAL_IN_MB%" == "" (
	echo "do nothing" >nul
)else (
	set max_java_heap=%MAX_HEAP_VAL_IN_MB%
)

set argument2=%2
set argument3=%3
set argument4=%4
set argument5=%5
set argument6=%6
set argument7=%7
set argument8=%8
set argument9=%9

if [%argument2%] == [property] (
	set property_set=1
	set property_val=%argument3%
	FOR /f "tokens=1,2,3,4,5 delims= " %%a IN (%argument3%) do set param1=%%a&set param2=%%b&set param3=%%c&set param4=%%d &set param5=%%e
) else if [%argument3%] == [property] (
	set property_set=1
	set property_val=%argument4%
	FOR /f "tokens=1,2,3,4,5 delims= " %%a IN (%argument4%) do set param1=%%a&set param2=%%b&set param3=%%c&set param4=%%d &set param5=%%e
) else if [%argument4%] == [property] (
	set property_set=1
	set property_val=%argument5%
	FOR /f "tokens=1,2,3,4,5 delims= " %%a IN (%argument5%) do set param1=%%a&set param2=%%b&set param3=%%c&set param4=%%d &set param5=%%e
) else if [%argument5%] == [property] (
	set property_set=1
	set property_val=%argument6%
	FOR /f "tokens=1,2,3,4,5 delims= " %%a IN (%argument6%) do set param1=%%a&set param2=%%b&set param3=%%c&set param4=%%d &set param5=%%e
) else if [%argument6%] == [property] (
	set property_set=1
	set property_val=%argument7%
	FOR /f "tokens=1,2,3,4,5 delims= " %%a IN (%argument7%) do set param1=%%a&set param2=%%b&set param3=%%c&set param4=%%d &set param5=%%e
) else if [%argument7%] == [property] (
	set property_set=1
	set property_val=%argument8%
	FOR /f "tokens=1,2,3,4,5 delims= " %%a IN (%argument8%) do set param1=%%a&set param2=%%b&set param3=%%c&set param4=%%d &set param5=%%e
) else if [%argument8%] == [property] (
	set property_set=1
	set property_val=%argument9%
	FOR /f "tokens=1,2,3,4,5 delims= " %%a IN (%argument9%) do set param1=%%a&set param2=%%b&set param3=%%c&set param4=%%d &set param5=%%e
)

if [%argument2%] == [service_name] (
		set sc_name=%argument3:"=%
) else if [%argument3%] == [service_name] (
		set sc_name=%argument4:"=%
) else if [%argument4%] == [service_name] (
		set sc_name=%argument5:"=%
) else if [%argument5%] == [service_name] (
		set sc_name=%argument6:"=%
) else if [%argument6%] == [service_name] (
		set sc_name=%argument7:"=%
)

if [%argument2%] == [display_name] (
		set sd_name=%argument3:"=%
) else if [%argument3%] == [display_name] (
		set sd_name=%argument4:"=%
) else if [%argument4%] == [display_name] (
		set sd_name=%argument5:"=%
) else if [%argument5%] == [display_name] (
		set sd_name=%argument6:"=%
) else if [%argument6%] == [display_name] (
		set sd_name=%argument7:"=%
)

if [%argument2%] == [min_heap] (
	call :CheckValid %argument3%
	if "!isValid!" == "0" (
		set min_java_heap=%argument3%
		set command_line=1
		set min_yes=1
	)
) else if [%argument3%] == [min_heap] (
	call :CheckValid %argument4%
	if "!isValid!" == "0" (
		set min_java_heap=%argument4%
		set command_line=1
		set min_yes=1
	)
) else if [%argument4%] == [min_heap] (
	call :CheckValid %argument5%
	if "!isValid!" == "0" (
		set min_java_heap=%argument5%
		set command_line=1
		set min_yes=1
	)
) else if [%argument5%] == [min_heap] (
	call :CheckValid %argument6%
	if "!isValid!" == "0" (
		set min_java_heap=%argument6%
		set command_line=1
		set min_yes=1
	)
) else if [%argument6%] == [min_heap] (
	call :CheckValid %argument7%
	if "!isValid!" == "0" (
		set min_java_heap=%argument7%
		set command_line=1
		set min_yes=1
	)
) else if [%argument7%] == [min_heap] (
	call :CheckValid %argument8%
	if "!isValid!" == "0" (
		set min_java_heap=%argument8%
		set command_line=1
		set min_yes=1
	)
) else if [%argument8%] == [min_heap] (
	call :CheckValid %argument9%
	if "!isValid!" == "0" (
		set min_java_heap=%argument9%
		set command_line=1
		set min_yes=1
	)
)


if [%argument2%] == [max_heap] (
	call :CheckValid %argument3%
	if "!isValid!" == "0" (
		set max_java_heap=%argument3%
		set command_line=1
		set max_yes=1
	)
) else if [%argument3%] == [max_heap] (
	call :CheckValid %argument4%
	if "!isValid!" == "0" (
		set max_java_heap=%argument4%
		set command_line=1
		set max_yes=1
	)
) else if [%argument4%] == [max_heap] (
	call :CheckValid %argument5%
	if "!isValid!" == "0" (
		set max_java_heap=%argument5%
		set command_line=1
		set max_yes=1
	)
) else if [%argument5%] == [max_heap] (
	call :CheckValid %argument6%
	if "!isValid!" == "0" (
		set max_java_heap=%argument6%
		set command_line=1
		set max_yes=1
	)
) else if [%argument6%] == [max_heap] (
	call :CheckValid %argument7%
	if "!isValid!" == "0" (
		set max_java_heap=%argument7%
		set command_line=1
		set max_yes=1
	)
) else if [%argument7%] == [max_heap] (
	call :CheckValid %argument8%
	if "!isValid!" == "0" (
		set max_java_heap=%argument8%
		set command_line=1
		set max_yes=1
	)
) else if [%argument8%] == [max_heap] (
	call :CheckValid %argument9%
	if "!isValid!" == "0" (
		set max_java_heap=%argument9%
		set command_line=1
		set max_yes=1
	)
)


if [%argument2%] == [sysedge] (
	set sysedge_only=1
)


cd "%APMIA_INSTALLER_HOME%"
:: ==================================Begin installation process of all component=============================================
::Checking command line argument
if "%1"=="install" GOTO install
if "%1"=="uninstall" GOTO uninstall
if "%1"=="clean_uninstall" GOTO clean_uninstall
if "%1"=="start" GOTO start
if "%1"=="stop" GOTO stop
if "%1"=="restart" GOTO restart
if "%1"=="restart_service" GOTO restart_service
if "%1"=="status" GOTO status
if "%1"=="console_start" GOTO console_start
if "%1"=="console_stop" GOTO console_stop
if "%1"=="help" GOTO help
if "%1"=="" GOTO help

:help
	echo ------------------------------------------%NL%Usage:%NL%APMIACtrl.bat install%NL%APMIACtrl.bat install sysedge%NL%APMIACtrl.bat uninstall%NL%APMIACtrl.bat clean_uninstall%NL%APMIACtrl.bat start%NL%APMIACtrl.bat stop%NL%APMIACtrl.bat restart%NL%APMIACtrl.bat status%NL%APMIACtrl.bat console_start%NL%APMIACtrl.bat console_stop%NL%APMIACtrl.bat help%NL%Java Heap - APMIACtrl.bat install min_heap value max_heap value%NL%Service Name - APMIACtrl.bat install service_name value display_name value%NL%------------------------------------------
EXIT /B 0

:install
	echo [%date%] [%TIME%] APM Infrastructure Agent user entered install >>%APMIA_Installation.log%

	call :APMIA_Folder_Check
	if "%isFolderAPMIA%" == "1" (
		echo APM Infrastructure Agent installation\corrupt installation is present at location : %APMIA_INSTALLER_HOME%
		echo [%date%] [%TIME%] APM Infrastructure Agent installation\corrupt installation is present at location : %APMIA_INSTALLER_HOME%.>>%APMIA_Installation.log%
		EXIT /B 1
	)

	call :checkUserPermission
	IF "%userPermission%" == "1" (

		Call :CheckAllFolder
		if "%folderOK%" == "1" (
			EXIT /B 1
		)

		if "%withHostMonitor%" == "1" (
			Call :HostMonitor_Install_Location
			if "!HM_Location!" == "0" (
				EXIT /B 1
			)
		)

		if exist "%APMIA_INSTALLER_BIN%\Sysedge.mode" (
			echo APMIA sysedge only installation/corrupt installation is present.
			echo [%date%] [%TIME%] APMIA sysedge only installation/corrupt installation is present. >>%APMIA_Installation.log%
			EXIT /B 1
		)

		if "%sysedge_only%" == "1" (
			echo [%date%] [%TIME%] APM Infrastructure Agent install mode is set with only sysedge option >>%APMIA_Installation.log%
			Call :HostMonitor_Install_Location
			if "!HM_Location!" == "0" (
				EXIT /B 1
			)
			Call :installHostMonitor
			echo Host Monitoring Agent installation completed.
			echo [%date%] [%TIME%] Host Monitoring Agent installation completed. >>%APMIA_Installation.log%
		)else (
			Call :installAPMIA
		)
	)else (
		del /f /q  tmpry.txt
		echo User do not have administrator permissions. Please use APMIACtrl.bat console_start
		echo [%date%] [%TIME%] User do not have administrator permissions. Please use APMIACtrl.bat console_start >> %APMIA_Installation.log%
	)
EXIT /B 0

:installAPMIA
	Call :checkServiceAndDisplayName
	IF "%doExit%" == "1" (
		EXIT /B 1
	)

	IF "%update_service_name%" == "0" (
		Call :ConfigureAPMIA
	)

	cd "%APMIA_INSTALLER_BIN%"
	echo Installing APM Infrastructure Agent...
	echo [%date%] [%TIME%] Installing APM Infrastructure Agent... >>%APMIA_Installation.log%
	echo [%date%] [%TIME%] APMIA_INSTALLER_HOME %APMIA_INSTALLER_HOME%>>%APMIA_Installation.log%
	echo [%date%] [%TIME%] WRAPPER_HOME %WRAPPER_HOME%>>%APMIA_Installation.log%
	echo [%date%] [%TIME%] JRE_HOME %JRE_HOME%>>%APMIA_Installation.log%
	call :update_java_heap
	call APMIAgent.bat install>>%APMIA_Installation.log%

	if %ERRORLEVEL% neq 0 (
		echo Please check APM Infrastructure Agent installation log at : "%APMIA_INSTALLER_HOME%\logs\IntroscopeAgent.txt"
		echo exit /b %ERRORLEVEL%
	)

	if "%withHostMonitor%" == "1" (
		if "%hostmonitor_only%" == "0" (
			Call :installHostMonitor
		)
	)

	echo APM Infrastructure Agent installation completed.
	echo [%date%] [%TIME%] APM Infrastructure Agent installation completed. >>%APMIA_Installation.log%
EXIT /B 0

:installHostMonitor
    call :CheckingWindowsserver2022
	cd %APMIA_INSTALLER_HOME%
	sc qc !SERVICE_NAME! 5000 | findstr BINARY_PATH_NAME > tmpry.txt
	set /p checkSEInstall=<tmpry.txt
	set "string1=%checkSEInstall: -s =" & set "string2=%"
	set "string3=%string1:  : =" & set "string4=%"
	set "string2=%string4:wrapper-windows-x86-64.exe=" & set "string1=%"

	rem IF "!checkSEInstall!" NEQ "" (

	cd %APMIA_INSTALLER_HOME%
	del /f /q  tmpry.txt

	call :CheckPort
	if "%portAvailable%"=="1" (
		echo [%date%] [%TIME%] Host Monitoring Agent installation in progress.. >>%APMIA_Installation.log%
		echo Host Monitoring Agent installation in progress..
		echo [%date%] [%TIME%] HOSTMONITOR_INSTALLER_HOME %HOSTMONITOR_INSTALLER_HOME%>>%APMIA_Installation.log%
		echo [%date%] [%TIME%] APMIA_INSTALLER_HOME %APMIA_INSTALLER_HOME%>>%APMIA_Installation.log%
		echo [%date%] [%TIME%] WRAPPER_HOME %WRAPPER_HOME%>>%APMIA_Installation.log%
		echo [%date%] [%TIME%] JRE_HOME %JRE_HOME%>>%APMIA_Installation.log%

		::install Host Monitor
		cd "%HOSTMONITOR_INSTALLER_HOME%"
		echo [%date%] [%TIME%] Host Monitoring Agent installation directory %HOSTMONITOR_INSTALLER_HOME% >>%APMIA_Installation.log%
		echo [%date%] [%TIME%] Host Monitoring Agent is installing at %APMIA_INSTALLER_HOME%SystemEDGE >>%APMIA_Installation.log%
		echo [%date%] [%TIME%] Host Monitoring Agent installation logs at %APMIA_WRAPPER_SERVICE_HOME%SystemEDGE/sysedge_install.log >>%APMIA_Installation.log%

		echo [%date%] [%TIME%] ca-setup LAX_VM "%JRE_HOME%\bin\java.exe" -i silent -DUSER_INSTALL_DIR="%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE" -DUSER_INPUT_RESULT_DATA_PATH="%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\config\" -DUSER_INPUT_RESULT_COMMUNITY="apmmonitor" -DUSER_INPUT_RESULT_SNMP_PORT=!PORTNUMBER! -DUSER_INPUT_RESULT_SYSEDGE_LOG_PATH="%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\sysedge_install.log">>%APMIA_Installation.log%

		echo Installing Host Monitoring Agent on PORT !PORTNUMBER!

		call ca-setup LAX_VM "%JRE_HOME%\bin\java.exe" -i silent -DUSER_INSTALL_DIR="%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE" -DUSER_INPUT_RESULT_DATA_PATH="%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\config\" -DUSER_INPUT_RESULT_COMMUNITY="apmmonitor" -DUSER_INPUT_RESULT_SNMP_PORT=!PORTNUMBER! -DUSER_INPUT_RESULT_SYSEDGE_LOG_PATH="%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\sysedge_install.log"'
		if "!PORTNUMBER!"=="1791" (
			echo Host Monitoring Agent is installed on !PORTNUMBER!, please update bundle properties of HostMonitor extension and restart APMIA service.
			echo [%date%] [%TIME%] Host Monitoring Agent is installed on !PORTNUMBER!, please update the property introscope.agent.hostmonitor.profiles.localhost.port in bundle.properties of HostMonitor extension and restart APMIA service>>%APMIA_Installation.log%
		)
		echo %CASYSTEMEDGE_DIR% > "%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\SysedgeVersion.txt"
		if %ERRORLEVEL% neq 0 (
			echo Please check Host Monitoring Agent installer log at : %APMIA_WRAPPER_SERVICE_HOME%SystemEDGE/sysedge_install.log
			exit /b %ERRORLEVEL%
		)

		if "%sysedge_only%" == "0" (
			cd "%APMIA_INSTALLER_BIN%"
			call APMIAgent.bat stop >> %APMIA_Installation.log%
			call :update_java_heap
			call APMIAgent.bat start >> %APMIA_Installation.log% 2>>&1
		)else (
			echo "Sysedge is running in sysedge only mode" >> %APMIA_INSTALLER_BIN%\Sysedge.mode
		)
	)else (
		EXIT /B 1
	)
EXIT /B 0

:uninstall
	echo [%date%] [%TIME%] APM Infrastructure Agent user entered uninstall for SERVICE_NAME !SERVICE_NAME!>>%APMIA_Installation.log%
	Call :APMIA_Sysedge_mode_present
	if "%Sysedge_mode%" == "0" (
		call :APMIA_Service_Present
 		if "!APMIA_Service!" == "0" (
			EXIT /B 1
		)
	)else (
		call :HostMonitor_Folder_Check
		if "!isFolderHostMonitor!" == "0" (
			Call :HostMonitor_Install_Location
			if "!HM_Location!" == "0" (
				EXIT /B 1
			)
		)
	)

	Call :uninstallHostMonitor
	Call :uninstallAPMIA

EXIT /B 0

:clean_uninstall
	echo [%date%] [%TIME%] APM Infrastructure Agent user entered clean_uninstall >>%APMIA_Installation.log%

	call :uninstall

	if "%clean_del%" == "1" (
		cd "%APMIA_INSTALLER_HOME%"
		del /q "%APMIA_INSTALLER_HOME%*"
		FOR /D %%p IN ("%APMIA_INSTALLER_HOME%*.*") DO rmdir "%%p" /s /q
		EXIT
		echo  Removed APM Infrastructure Agent directory.
		echo [%date%] [%TIME%] Removed APM Infrastructure Agent directory.>>%APMIA_Installation.log%
		DEL "%~f0"
	)

EXIT /B 0

:uninstallHostMonitor
    call :CheckingWindowsserver2022
	call :HostMonitor_Folder_Check
	if "%isFolderHostMonitor%" == "1" (
		echo APM Infrastructure Agent uninstall in progress..
		echo [%date%] [%TIME%] APM Infrastructure Agent uninstall in progress.. >>%APMIA_Installation.log%
		echo Uninstalling HostMonitor
		echo [%date%] [%TIME%] Uninstalling HostMonitor >>%APMIA_Installation.log%

		::uninstall Host Monitor
		cd "%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE"
		if exist "SysEDGE_uninstaller.exe" (
			call SysEDGE_uninstaller -i silent >>%APMIA_Installation.log%
			cd "%APMIA_WRAPPER_SERVICE_HOME%
			if exist "%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE" (
				rmdir /s /q SystemEDGE
			)
			if not "%RELEASE_DIR%" == "" (
				if exist "%APMIA_WRAPPER_SERVICE_HOME%%CASYSTEMEDGE_DIR%" (
					rmdir /s /q %APMIA_WRAPPER_SERVICE_HOME%%CASYSTEMEDGE_DIR%
				)
			)
		)else (
			sc delete sysedge >>%APMIA_Installation.log%
			taskkill /IM  sysedge.exe /F >>%APMIA_Installation.log%
			if exist "%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE" (
				rmdir /s /q SystemEDGE
			)
			echo [%date%] [%TIME%] Uninstaller not found for HostMonitor, manual removal of HostMonitor >>%APMIA_Installation.log%
		)

		cd "%APMIA_INSTALLER_HOME%"
		echo [%date%] [%TIME%] Removed Host Monitor directory >>%APMIA_Installation.log%

		call :APMIA_Sysedge_mode_present
		if "%Sysedge_mode%" == "1" (
			set /a clean_del=1
			echo APM Infrastructure Agent uninstall completed.
			echo [%date%] [%TIME%] APM Infrastructure Agent uninstall completed. >>%APMIA_Installation.log%
		)

		if exist "%APMIA_INSTALLER_BIN%\Sysedge.mode" (
			del /f /q  %APMIA_INSTALLER_BIN%\Sysedge.mode
		)
	)else (
		echo [%date%] [%TIME%] Host Monitoring Agent is not present at %APMIA_INSTALLER_HOME% >>%APMIA_Installation.log%
	)
EXIT /B 0

:uninstallAPMIA
	call :APMIA_Folder_Check
	if "%isFolderAPMIA%" == "1" (
		echo [%date%] [%TIME%] Uninstalling APM Infrastructure Agent in progress... >>%APMIA_Installation.log%

		::uninstall APM Infrastructure Agent
		cd "%APMIA_INSTALLER_BIN%"
		call APMIAgent.bat remove>>%APMIA_Installation.log%
		echo [%date%] [%TIME%] Removed APM Infrastructure Agent >>%APMIA_Installation.log%

		cd "%APMIA_WRAPPER_SERVICE_HOME%"
		del /f /q wrapper-windows-x86-32.exe
		del /f /q wrapper-windows-x86-64.exe
		del /f /q lib\wrapper*
		if not "%RELEASE_DIR%" == "" (
			rmdir /s /q lib
		)
		rmdir /s /q conf
		del /f /q %APMIA_INSTALLER_BIN%\java_heap.txt

		set /a clean_del=1
		TIMEOUT 15 > nul
		echo APM Infrastructure Agent uninstallation completed.
		echo [%date%] [%TIME%] APM Infrastructure Agent uninstallation completed. >>%APMIA_Installation.log%

	)else (
		call :APMIA_Install_Location
		if "%APMIA_Location%" == "0" (
			EXIT /B 1
		)
	)

EXIT /B 0

:start
	call :checkUserPermission
	IF "%userPermission%" == "0" (
		echo User do not have administrator permissions. Please use APMIACtrl.bat console_start
		echo [%date%] [%TIME%] User do not have administrator permissions. Please use APMIACtrl.bat console_start >> %APMIA_Installation.log%
		EXIT /B 1
	)
	echo [%date%] [%TIME%] APM Infrastructure Agent user entered start for SERVICE_NAME !SERVICE_NAME! >>%APMIA_Installation.log%
	call :APMIA_Sysedge_mode_present
	if "%Sysedge_mode%" == "0" (
		call :APMIA_Service_Present
		if "!APMIA_Service!" == "0" (
			EXIT /B 1
		)

		call :APMIA_Folder_Check
		if "!isFolderAPMIA!" == "1" (
			call :update_java_heap
			cd "%APMIA_INSTALLER_BIN%"
			call APMIAgent.bat start >> %APMIA_Installation.log% 2>>&1
			echo APM Infrastructure Agent start in progress...
			echo [%date%] [%TIME%] APM Infrastructure Agent start in progress... >>%APMIA_Installation.log%
		)else (
			call :APMIA_Install_Location
			if "!APMIA_Location!" == "0" (
				EXIT /B 1
			)
		)

		call :check_hostmonitor_mode
		if "%install_hostmonitor%" == "0" (
			call :HostMonitor_Folder_Check
			if "!isFolderHostMonitor!" == "1" (
				call :start_hostmonitor
			)
		)
		echo APM Infrastructure Agent start completed.
		echo [%date%] [%TIME%] APM Infrastructure Agent start completed. >>%APMIA_Installation.log%
	)else (
		call :HostMonitor_Folder_Check
		if "!isFolderHostMonitor!" == "1" (
		    call :start_hostmonitor
		)else (
			Call :HostMonitor_Install_Location
			if "!HM_Location!" == "0" (
			EXIT /B 1
			)
		)
	)

EXIT /B 0

:start_hostmonitor
    echo APM HostMonitor start in progress...
    echo [%date%] [%TIME%] APM HostMonitor start in progress... >>%APMIA_Installation.log%
	for /f "tokens=1 delims=" %%A in (%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE/SysedgeVersion.txt) do (
	   set "sysedgeversion=%%A"
	   set "sysedgeversion=!sysedgeversion: =!"
    )
	if not "%sysedgeversion%"=="%CASYSTEMEDGE_DIR%" (
	call :upgrade_sysedge
	del /f /q %APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\SysedgeVersion.txt
    echo %CASYSTEMEDGE_DIR% > %APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\SysedgeVersion.txt
    )
    sc start sysedge>>%APMIA_Installation.log%
    echo APM HostMonitor start completed.
    echo [%date%] [%TIME%] APM HostMonitor start completed. >>%APMIA_Installation.log%


EXIT /B 0

:upgrade_sysedge
    echo "Called upgrade sysedge"
    echo [%date%] [%TIME%] Called upgrade sysedge. >>%APMIA_Installation.log%
    call :CheckingWindowsserver2022 
    xcopy /s /y /i "%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\config" "%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\config_bp" >nul
    "%HOSTMONITOR_INSTALLER_HOME%\ca-setup" LAX_VM "%JRE_HOME%\bin\java.exe" -i silent -DUSER_INSTALL_DIR="%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE" -DUSER_INPUT_RESULT_DATA_PATH="%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\config\" -DUSER_INPUT_RESULT_COMMUNITY="apmmonitor" -DUSER_INPUT_RESULT_SNMP_PORT=!PORTNUMBER! -DUSER_INPUT_RESULT_SYSEDGE_LOG_PATH="%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\sysedge_install.log"'
    call :stop_and_wait_sysedge
    rmdir "%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\config" /Q/S
    xcopy /s /y /i "%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\config_bp" "%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\config" >nul
    rmdir /s /q %APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\config_bp"
    echo "upgrade sysedge completed" >>%APMIA_Installation.log%
    echo "Restarting the services to take the new config into effect" >>%APMIA_Installation.log%
EXIT /B 0

:stop
	call :checkUserPermission
	IF "%userPermission%" == "0" (
		echo User do not have administrator permissions. Please use APMIACtrl.bat console_start
		echo [%date%] [%TIME%] User do not have administrator permissions. Please use APMIACtrl.bat console_start >> %APMIA_Installation.log%
		EXIT /B 1
	)
	echo [%date%] [%TIME%] APM Infrastructure Agent user entered stop for SERVICE_NAME !SERVICE_NAME! >>%APMIA_Installation.log%
	call :APMIA_Sysedge_mode_present
	if "%Sysedge_mode%" == "0" (
		call :APMIA_Service_Present
		if "%APMIA_Service%" == "0" (
			EXIT /B 1
		)

		call :HostMonitor_Folder_Check
		if "!isFolderHostMonitor!" == "1" (
			echo Host Monitor Agent stop in progress...
			echo [%date%] [%TIME%] Host Monitor Agent stop in progress... >>%APMIA_Installation.log%
			sc stop sysedge >>%APMIA_Installation.log%
		)

		call :APMIA_Folder_Check
		if "!isFolderAPMIA!" == "1" (
			cd "%APMIA_INSTALLER_BIN%"
			call APMIAgent.bat stop >> %APMIA_Installation.log%
			echo APM Infrastructure Agent stop in progress...
			echo [%date%] [%TIME%] APM Infrastructure Agent stop in progress... >>%APMIA_Installation.log%
		)else (
			call :APMIA_Install_Location
			if "%APMIA_Location%" == "0" (
			EXIT /B 1
			)
		)
		echo APM Infrastructure Agent stop completed.
		echo [%date%] [%TIME%] APM Infrastructure Agent stop completed. >>%APMIA_Installation.log%
	)else (
		call :HostMonitor_Folder_Check
		if "!isFolderHostMonitor!" == "1" (
			echo APM Infrastructure Agent stop in progress...
			echo [%date%] [%TIME%] APM Infrastructure Agent stop in progress... >>%APMIA_Installation.log%
			sc stop sysedge>>%APMIA_Installation.log%
			echo APM Infrastructure Agent stop completed.
			echo [%date%] [%TIME%] APM Infrastructure Agent stop completed. >>%APMIA_Installation.log%
		)else (
			Call :HostMonitor_Install_Location
			if "!HM_Location!" == "0" (
			EXIT /B 1
			)
		)
	)

EXIT /B 0

:restart
	echo [%date%] [%TIME%] APM Infrastructure Agent user entered restart >>%APMIA_Installation.log%

	call :APMIA_Sysedge_mode_present
	if "%Sysedge_mode%" == "0" (
		call :APMIA_Service_Present
		if "%APMIA_Service%" == "0" (
			EXIT /B 1
		)
	)else (
		call :HostMonitor_Folder_Check
		if "!isFolderHostMonitor!" == "1" (
			call :stop
			timeout 5 > NUL
			call :start
		)else (
			Call :HostMonitor_Install_Location
			if "!HM_Location!" == "0" (
				EXIT /B 1
			)
		)
	)

	call :APMIA_Folder_Check
	if "%isFolderAPMIA%" == "1" (
		call :stop
		call :start
	)else (
		call :APMIA_Install_Location
		if "%APMIA_Location%" == "0" (
			EXIT /B 1
		)
	)
	echo [%date%] [%TIME%] APM Infrastructure Agent is restarted. >>%APMIA_Installation.log%
EXIT /B 0

:restart_service
    echo Manual restart of the APM Infrastructure Agent is required. The Agent Controller is currently running within the same Agent instance.
	echo [%date%] [%TIME%] Manual restart of the APM Infrastructure Agent is required. The Agent Controller is currently running within the same Agent instance. >>%APMIA_Installation.log%
EXIT /B 0

:status
	echo [%date%] [%TIME%] APM Infrastructure Agent user entered status for SERVICE_NAME !SERVICE_NAME! >>%APMIA_Installation.log%
	if exist "%APMIA_INSTALLER_HOME%bin\console.mode" (
	    powershell -Command "Get-CimInstance Win32_Process | Where-Object { $_.CommandLine -like '*UnifiedMonitoringAgent*' -and $_.CommandLine -like '*%APMIA_INSTALLER_HOME%jre\bin\java*' -and $_.CommandLine -notlike '*powershell*' } | ForEach-Object { Write-Output ($_.CommandLine + ' ' + $_.ProcessId.ToString()) }" > temp.txt
		for /f "delims=" %%i in (temp.txt) do set check_consolestart=%%i
		IF "!check_consolestart!" NEQ "" (
			echo APM Infrastructure Agent  	-	RUNNING
			echo [%date%] [%TIME%] APM Infrastructure Agent -	RUNNING >>%APMIA_Installation.log%
		)
	) else (
		sc query !SERVICE_NAME! | findstr STATE > tmpry.txt
		set /p checkAPMIAStatus=<tmpry.txt
		IF "!checkAPMIAStatus!" NEQ "" (
			FOR /F "tokens=4" %%a IN (tmpry.txt) DO set command=%%a
			echo APM Infrastructure Agent  	-	!command!
			echo [%date%] [%TIME%] APM Infrastructure Agent -	!command! >>%APMIA_Installation.log%
		)else (
			echo APM Infrastructure Agent  	-	NOT ACTIVE
			echo [%date%] [%TIME%] APM Infrastructure Agent -	NOT ACTIVE >>%APMIA_Installation.log%
		)
		del /f /q  tmpry.txt
	)

	call :HostMonitor_Folder_Check
	if "%isFolderHostMonitor%" == "1" (
		sc query sysedge | findstr STATE > tmpry.txt
		set /p checkHMStatus=<tmpry.txt
		IF "!checkHMStatus!" NEQ "" (
			FOR /F "tokens=4" %%a IN (tmpry.txt) DO set command=%%a
			echo Host Monitor Agent 		-	!command!
			echo [%date%] [%TIME%] Host Monitor Agent 		-	!command! >>%APMIA_Installation.log%
		)else (
			echo Host Monitor Agent 		-	NOT ACTIVE
			echo [%date%] [%TIME%] Host Monitor Agent 		-	NOT ACTIVE >>%APMIA_Installation.log%
		)
		del /f /q  tmpry.txt
	)else (
		Call :APMIA_Sysedge_mode_present
		if "!Sysedge_mode!" == "1" (
			sc query sysedge | findstr STATE > tmpry.txt
			set /p checkHMStatus=<tmpry.txt
			IF "!checkHMStatus!" NEQ "" (
				FOR /F "tokens=4" %%a IN (tmpry.txt) DO set command=%%a
				echo Host Monitor Agent 		-	!command!
				echo [%date%] [%TIME%] Host Monitor Agent 		-	!command! >>%APMIA_Installation.log%
			)else (
				echo Host Monitor Agent 		-	NOT ACTIVE
				echo [%date%] [%TIME%] Host Monitor Agent 		-	NOT ACTIVE >>%APMIA_Installation.log%
			)
			del /f /q  tmpry.txt
		)
	)

EXIT /B 0

:console_start
	echo [%date%] [%TIME%] APM Infrastructure Agent user entered console_start >>%APMIA_Installation.log%
	powershell -Command "Get-CimInstance Win32_Process | Where-Object { $_.CommandLine -like '*UnifiedMonitoringAgent*' -and $_.CommandLine -like '*%APMIA_INSTALLER_HOME%jre\bin\java*' -and $_.CommandLine -notlike '*powershell*' } | ForEach-Object { Write-Output ($_.CommandLine + ' ' + $_.ProcessId.ToString()) }" > temp.txt
	set /p check_consolestart=<temp.txt
	del /f /q  temp.txt
	IF "!check_consolestart!" EQU "" (
		cd "%APMIA_INSTALLER_HOME%bin"
		start /b APMIAgent_ConsoleStart.cmd ^& exit
		echo True > %APMIA_INSTALLER_HOME%bin\console.mode
		echo APM Infrastructure Agent started with console_start.
		echo [%date%] [%TIME%] APM Infrastructure Agent started with console_start. >>%APMIA_Installation.log%
	)else (
		echo APM Infrastructure Agent already running with console_start.
		echo [%date%] [%TIME%] APM Infrastructure Agent already running with console_start. >>%APMIA_Installation.log%
	)
EXIT /B 0

:console_stop
	echo [%date%] [%TIME%] APM Infrastructure Agent user entered console_stop >>%APMIA_Installation.log%
	powershell -Command "Get-CimInstance Win32_Process | Where-Object { $_.CommandLine -like '*UnifiedMonitoringAgent*' -and $_.CommandLine -like '*%APMIA_INSTALLER_HOME%jre\bin\java*' -and $_.CommandLine -notlike '*powershell*' } | ForEach-Object { Write-Output ($_.CommandLine + ' ' + $_.ProcessId.ToString()) }" > temp.txt
	for /f "delims=" %%i in (temp.txt) do set check_consolestart=%%i
	IF "!check_consolestart!" NEQ "" (
		for %%i in (!check_consolestart!) do set "pidtokill=%%i"
		taskkill /F /PID !pidtokill! >>%APMIA_Installation.log%
		del /f /q %APMIA_INSTALLER_HOME%bin\console.mode
		echo APM Infrastructure Agent Stopped.
	)else (
		echo APM Infrastructure Agent is not running with console_start.
		echo [%date%] [%TIME%] APM Infrastructure Agent is not running with console_start. >>%APMIA_Installation.log%
	)
	del /f /q  temp.txt
EXIT /B 0

:: ===================================================Log messages==========================================================

:Logit
	echo ========================================Start time is: %date% %TIME%========================================
	echo [%date%] [%TIME%] Home Directory %APMIA_INSTALLER_HOME%
	echo [%date%] [%TIME%] Operating system is %OS%
EXIT /B 0

:: =================================================================================================================================

:CheckValid
	IF  [%1] NEQ [] (
		echo(%~1|findstr "^[-][1-9][0-9]*$ ^[1-9][0-9]*$ ^0$">nul&&set isValid=0||set isValid=1
		if "!isValid!" == "1" (
			echo [%date%] [%TIME%] java heap value is not numeric, contiuning with default value. >>%APMIA_Installation.log%
			echo java heap value is not numeric, contiuning with default value.
		)
	)else (
		echo [%date%] [%TIME%] java heap value is missing, contiuning with default value. >>%APMIA_Installation.log%
		echo java heap value is missing, contiuning with default value.
	)

EXIT /B 0

:InstallationMode
	if exist "%APMIA_WRAPPER_SERVICE_HOME%%CASYSTEMEDGE_DIR%" (
		dir %APMIA_INSTALLER_HOME%extensions\HostMonitor*  1> NUL 2> tmpry1.txt
		set /p CMDstatus=<tmpry1.txt
		del /f /q  tmpry1.txt

		IF "!CMDstatus!" NEQ "File Not Found" (
			cd "%APMIA_INSTALLER_HOME%"
			findstr /B "introscope.agent.extensions.bundles.load=" "%APMIA_INSTALLER_HOME%extensions\Extensions.profile"|findstr /I "HostMonitor" > tmpry.txt
			set /p DirectoryFile=<tmpry.txt
			del /f /q  tmpry.txt
			IF "!DirectoryFile!" NEQ "" (
				set /A withHostMonitor=1
				echo [%date%] [%TIME%] APM Infrastructure Agent installation mode is with Host Monitoring Agent. >>%APMIA_Installation.log%
				EXIT /B 0
			) else (
				set /A withHostMonitor=0
				echo [%date%] [%TIME%] APM Infrastructure Agent installation mode is without Host Monitoring Agent. >>%APMIA_Installation.log%
				echo [%date%] [%TIME%] User did not loaded HostMonitor in Extensions.profile >>%APMIA_Installation.log%
				EXIT /B 0
			)
		)else (
			dir %APMIA_INSTALLER_HOME%extensions\deploy\hostmonitor*.tar.gz  1> NUL 2> tmpry.txt
			set /p CMDstatus2=<tmpry.txt
			del /f /q  tmpry.txt

			IF "!CMDstatus2!" NEQ "File Not Found" (
				set /A withHostMonitor=1
				echo [%date%] [%TIME%] APM Infrastructure Agent installation mode is with Host Monitoring Agent. >>%APMIA_Installation.log%
				EXIT /B 0
			) else (
				set /A withHostMonitor=0
				echo [%date%] [%TIME%] APM Infrastructure Agent installation mode is without Host Monitoring Agent. >>%APMIA_Installation.log%
				echo [%date%] [%TIME%] HostMonitor tar is not found in deploy. >>%APMIA_Installation.log%
				EXIT /B 0
			)
		)
	)else (
		set /A withHostMonitor=0
		echo [%date%] [%TIME%] APM Infrastructure Agent installation mode is without Host Monitoring Agent. >>%APMIA_Installation.log%
		echo [%date%] [%TIME%] Host Monitor installation folder not found.. >>%APMIA_Installation.log%
		EXIT /B 0
	)
EXIT /B 0

:check_hostmonitor_mode
	call :InstallationMode
	if "%withHostMonitor%" == "1" (
		call :HostMonitor_Folder_Check
		if "%isFolderHostMonitor%" == "1" (
			set install_hostmonitor=0
			echo [%date%] [%TIME%] APM Infrastructure Agent Host Monitor found installed. >>%APMIA_Installation.log%
		)
	)
	if "%withHostMonitor%" == "1" (
		call :HostMonitor_Folder_Check
		if "%isFolderHostMonitor%" == "0" (
			set install_hostmonitor=1
			echo [%date%] [%TIME%] APM Infrastructure Agent Host Monitor to be install. >>%APMIA_Installation.log%
		)
	)
	if "%withHostMonitor%" == "0" (
		call :HostMonitor_Folder_Check
		if "%isFolderHostMonitor%" == "0" (
			set install_hostmonitor=0
			echo [%date%] [%TIME%] APM Infrastructure Agent is without Host Monitor. >>%APMIA_Installation.log%
		)
	)
	if "%withHostMonitor%" == "0" (
		call :HostMonitor_Folder_Check
		if "%isFolderHostMonitor%" == "1" (
			echo [%date%] [%TIME%] APM Infrastructure Agent Host Monitor to be uninstall. >>%APMIA_Installation.log%
			call :uninstallHostMonitor
		)
	)

	if "%install_hostmonitor%" == "1" (
		if "%hostmonitor_only%" == "0" (
			call :installHostMonitor
		)
	)

EXIT /B 0

:checkUserPermission
	whoami /groups | findstr "S-1-5-32-544" > temp.txt
	set /p CMDOutput=<temp.txt
	del /f /q temp.txt
	IF "%CMDOutput%" NEQ "" (
		set /A userPermission=1
		echo [%date%] [%TIME%] User have administrator permissions. >>%APMIA_Installation.log%
	)else (
		set /A userPermission=0
		echo [%date%] [%TIME%] User do not have administrator permissions. >>%APMIA_Installation.log%
	)
EXIT /B 0

:checkServiceAndDisplayName
	IF "!sc_name!" == "" (
		IF "!sd_name!" == "" (
			set SERVICE_NAME=infrastructure_agent
			sc qc !SERVICE_NAME! 5000 | findstr BINARY_PATH_NAME > tmpry.txt
			set /p checkAPMIAInstall=<tmpry.txt
 			IF "!checkAPMIAInstall!" NEQ "" (
				echo Service name "!SERVICE_NAME!" already exist, Please use another Service name
				echo [%date%] [%TIME%] Service name "!SERVICE_NAME!" already exist, Please use another Service name >> %APMIA_Installation.log%
				del /f /q  tmpry.txt
				set doExit=1
				EXIT /B 1
			)
			del /f /q  tmpry.txt
			echo !SERVICE_NAME! > "%APMIA_INSTALLER_BIN%/APMIA_service.txt"
			set update_service_name=0
			echo [%date%] [%TIME%] User have not provided service and display name, continue with default service name !SERVICE_NAME!. >>%APMIA_Installation.log%

		)else (
			echo Service Name is not provided, Please input the Service Name.
			echo [%date%] [%TIME%] Service Name is not provided, Please input the Service Name. >>%APMIA_Installation.log%
			set doExit=1
			EXIT /B 1
		)
	)else (
		IF "!sd_name!" == "" (
			echo Display Name is not provided, Please input the Display Name.
			echo [%date%] [%TIME%] Display Name is not provided, Please input the Display Name. >>%APMIA_Installation.log%
			set doExit=1
		)else (
			cmd /v:on /c echo(^^!sc_name^^! | findstr /r "^[^\\/?%%*:|<>\.\"]*$^" > nul&&set isValid=0||set isValid=1
			if "!isValid!" == "1" (
				set doExit=1
				echo [%date%] [%TIME%] Service name is not valid, Please input valid Service Name. >>%APMIA_Installation.log%
				echo Service name is not valid, Please input valid the Service Name.
				EXIT /B 1
			)
			cmd /v:on /c echo(^^!sd_name^^! | findstr /r "^[^\\/?%%*:|#<>\.\"]*$^" > nul&&set isValid=0||set isValid=1
			if "!isValid!" == "1" (
				set doExit=1
				echo [%date%] [%TIME%] Display name is not valid, Please input valid Display Name. >>%APMIA_Installation.log%
				echo Display name is not valid, Please input valid Display Name.
				EXIT /B 1
			)

			sc qc !sc_name! 5000 | findstr BINARY_PATH_NAME > tmpry.txt
			set /p checkAPMIAInstall=<tmpry.txt
			IF "!checkAPMIAInstall!" NEQ "" (
				echo Service name "!sc_name!" already exist, Please use another Service name
				echo [%date%] [%TIME%] Service name "!sc_name!" already exist, Please use another Service name >> %APMIA_Installation.log%
				del /f /q  tmpry.txt
				set doExit=1
				EXIT /B 1
			)
			del /f /q  tmpry.txt

			sc query type= service state= all | findstr "DISPLAY_NAME" | findstr /n /c:"%sd_name%" > tmpry2.txt
			set /p checkDisplayName=<tmpry2.txt
			if "!checkDisplayName!" NEQ "" (
				set doExit=1
				echo Display name "!sd_name!" already exist, Please use another Display name
				echo [%date%] [%TIME%] Display name "!sd_name!" already exist, Please use another Display name. >>%APMIA_Installation.log%
				del /f /q  tmpry2.txt
				EXIT /B 1
			)
			del /f /q  tmpry2.txt

			set SERVICE_NAME=!sc_name!
			set DISPLAY_NAME=!sd_name!
			echo [%date%] [%TIME%] Updating Service name as !SERVICE_NAME! and Display name as !DISPLAY_NAME! >>%APMIA_Installation.log%
			call :update_service_details !SERVICE_NAME! "!DISPLAY_NAME!"
		)
	)

EXIT /B 0


:APMIA_Service_Present
	call :checkUserPermission
	IF "%userPermission%" == "1" (
		sc qc !SERVICE_NAME! 5000 | findstr BINARY_PATH_NAME > tmpry.txt
		set /p checkAPMIAService=<tmpry.txt
		IF "!checkAPMIAService!" EQU "" (
			set /A APMIA_Service=0
			echo APM IA is not installed/corrupt installation is present/APM IA is started using console_start.
			echo [%date%] [%TIME%] APM IA is not installed/corrupt installation is present/APM IA is started using console_start. >>%APMIA_Installation.log%
		)else (
			set /A APMIA_Service=1
		)
		del /f /q  tmpry.txt
	)else (
		echo User do not have administrator permissions. Please use APMIACtrl.bat console_start
		echo [%date%] [%TIME%] User do not have administrator permissions. Please use APMIACtrl.bat console_start >> %APMIA_Installation.log%
	)
EXIT /B 0

:APMIA_Install_Location
	sc qc !SERVICE_NAME! 5000 | findstr BINARY_PATH_NAME > tmpry.txt
	set /p checkAPMIALocation=<tmpry.txt
	set "string1=%checkAPMIALocation: -s =" & set "string2=%"
	set "string3=%string1:  : =" & set "string4=%"
	set "string2=%string4:wrapper-windows-x86-64.exe=" & set "string1=%"
	IF "!checkAPMIALocation!" NEQ "" (
		set /A APMIA_Location=0
		echo APMIA installation/corrupt installation is present at location : 	%string2%
		echo [%date%] [%TIME%] APMIA installation/corrupt installation is present at location : !string2! >>%APMIA_Installation.log%
	)else (
		set /A APMIA_Location=1
	)
	del /f /q  tmpry.txt
EXIT /B 0

:APMIA_Sysedge_mode_present
	call :checkUserPermission
	IF "%userPermission%" == "1" (
		sc qc !SERVICE_NAME! 5000 | findstr BINARY_PATH_NAME > tmpry.txt
		set /p checkAPMIALocation=<tmpry.txt
		IF "!checkAPMIALocation!" EQU "" (
			sc qc sysedge 5000 | findstr BINARY_PATH_NAME > tmpry1.txt
			set /p checkAPMIASysedgeLocation=<tmpry1.txt
			IF "!checkAPMIASysedgeLocation!" NEQ "" (
				set Sysedge_mode=1
				echo [%date%] [%TIME%] APMIA installation is present using sysedge only. >>%APMIA_Installation.log%
			)else (
				set Sysedge_mode=0
				echo [%date%] [%TIME%] APMIA installation is not present using sysedge only. >>%APMIA_Installation.log%
			)
			del /f /q  tmpry1.txt
		)else (
				set Sysedge_mode=0
				echo [%date%] [%TIME%] APMIA installation is not present. >>%APMIA_Installation.log%
		)
		del /f /q  tmpry.txt
	)
EXIT /B 0

:HostMonitor_Install_Location
	sc qc sysedge 5000 | findstr BINARY_PATH_NAME > tmpry.txt
	set /p checkAPMIALocation=<tmpry.txt
	set "string1=%checkAPMIALocation: -s =" & set "string2=%"
	set "string3=%string1:  : =" & set "string4=%"
	set "string2=%string4:wrapper-windows-x86-64.exe=" & set "string1=%"
	IF "!checkAPMIALocation!" NEQ "" (
		set /A HM_Location=0
		echo APMIA sysedge only installation/corrupt installation is present at location :	 %string2%
		echo [%date%] [%TIME%] APMIA sysedge only installation/corrupt installation is present at location : !string2! >>%APMIA_Installation.log%
	)else (
		set /A HM_Location=1
	)
	del /f /q  tmpry.txt
EXIT /B 0

:APMIA_Folder_Check
	echo [%date%] [%TIME%] Checking if APM Infrastructure Agent installed at %APMIA_INSTALLER_HOME% >>%APMIA_Installation.log%
	if exist "%APMIA_WRAPPER_SERVICE_HOME%\conf" (
		set /A isFolderAPMIA=1
		echo [%date%] [%TIME%] APM Infrastructure Agent folders are found. >>%APMIA_Installation.log%
	)else (
		set /A isFolderAPMIA=0
		echo [%date%] [%TIME%] APM Infrastructure Agent folders are not found. >>%APMIA_Installation.log%
	)
EXIT /B 0

:HostMonitor_Folder_Check
	if exist "%APMIA_WRAPPER_SERVICE_HOME%SystemEDGE\bin" (
		set /A isFolderHostMonitor=1
	)else (
		set /A isFolderHostMonitor=0
	)
EXIT /b 0

:CheckPort
	echo [%date%] [%TIME%] Checking port for Host Monitor installation. >>%APMIA_Installation.log%
	call :check1691
EXIT /B 0

:Check1691
	(netstat -aof |findstr ":1691 ")>>temp.tmp
	set /p port=<temp.tmp
	del /f /q  temp.tmp
	IF "%port%" NEQ "" (
		echo [%date%] [%TIME%] Port 1691 found busy, checking Port 1791. >>%APMIA_Installation.log%
		set portAvailable=0
		goto :check1791
	)else (
		set /A PORTNUMBER=1691
		set portAvailable=1
		echo [%date%] [%TIME%] Port 1691 found free. >>%APMIA_Installation.log%
		EXIT /B 0
	)
EXIT /B 0

:Check1791
	(netstat -aof |findstr /i 1791)>>temp1.tmp
	set /p port1=<temp1.tmp
	del /f /q temp1.tmp
	IF "%port1%" NEQ "" (
		echo 1691 and 1791 both ports are busy. Cannot install Host Monitor.
		echo [%date%] [%TIME%] 1691 and 1791 both ports are busy. Cannot install Host Monitor. >>%APMIA_Installation.log%
		set portAvailable=0
		EXIT /B 1
	)else (
		set PORTNUMBER=1791
		set portAvailable=1
		echo [%date%] [%TIME%] Port 1791 found free. >>%APMIA_Installation.log%
	)
EXIT /B 0

:update_service_details
	set SERVICE_NAME=%1
	set DISPLAY_NAME=%~2
	Call :ConfigureAPMIA
	set "conffile=%APMIA_WRAPPER_SERVICE_HOME%\conf\wrapper.conf"

	for /f "tokens=*" %%l in ('type "%conffile%"^&cd.^>"%conffile%"'
	) do for /f "tokens=1 delims== " %%a in ("%%~l"
	) do if /i "%%~a"=="wrapper.name" (
	>>"%conffile%" echo(wrapper.name=!SERVICE_NAME!
	) else (
	>>"%conffile%" echo(%%l
	)

	for /f "tokens=*" %%l in ('type "%conffile%"^&cd.^>"%conffile%"'
	) do for /f "tokens=1 delims== " %%a in ("%%~l"
	) do if /i "%%~a"=="wrapper.ntservice.displayname" (
	>>"%conffile%" echo(wrapper.ntservice.displayname=!DISPLAY_NAME!
	) else (
	>>"%conffile%" echo(%%l
	)

	echo !SERVICE_NAME! > "%APMIA_INSTALLER_BIN%/APMIA_service.txt"
EXIT /B 0

:update_java_heap
	set "conffile=%APMIA_WRAPPER_SERVICE_HOME%\conf\wrapper.conf"
	if %min_java_heap% LEQ 16 (
		set min_java_heap=16
	)

	if %max_java_heap% LEQ %min_java_heap% (
		set max_java_heap=%min_java_heap%
	)

	if exist "%APMIA_INSTALLER_BIN%\java_heap.txt" (
		if %command_line% == 1 (
			if %max_yes% == 0 (
				set /a max_java_heap=512
			)
			if %min_yes% == 0 (
				set min_java_heap=256
			)

			for /f "tokens=*" %%l in ('type "%conffile%"^&cd.^>"%conffile%"'
			) do for /f "tokens=1 delims== " %%a in ("%%~l"
			) do if /i "%%~a"=="wrapper.java.initmemory" (
				>>"%conffile%" echo(wrapper.java.initmemory=!min_java_heap!
			) else (
				>>"%conffile%" echo(%%l
			)
			for /f "tokens=*" %%l in ('type "%conffile%"^&cd.^>"%conffile%"'
			) do for /f "tokens=1 delims== " %%a in ("%%~l"
			) do if /i "%%~a"=="wrapper.java.maxmemory" (
				>>"%conffile%" echo(wrapper.java.maxmemory=!max_java_heap!
			) else (
				>>"%conffile%" echo(%%l
			)

			echo min_heap=!min_java_heap! > "%APMIA_INSTALLER_BIN%/java_heap.txt"
			echo max_heap=!max_java_heap! >> "%APMIA_INSTALLER_BIN%/java_heap.txt"
		)
	)else (
		if %command_line% == 1 (
			if %max_yes% == 0 (
				set max_java_heap=512
			)
			if %min_yes% == 0 (
				set min_java_heap=256
			)
		)
		for /f "tokens=*" %%l in ('type "%conffile%"^&cd.^>"%conffile%"'
		) do for /f "tokens=1 delims== " %%a in ("%%~l"
		) do if /i "%%~a"=="wrapper.java.initmemory" (
			>>"%conffile%" echo(wrapper.java.initmemory=!min_java_heap!
		) else (
			>>"%conffile%" echo(%%l
		)
		for /f "tokens=*" %%l in ('type "%conffile%"^&cd.^>"%conffile%"'
		) do for /f "tokens=1 delims== " %%a in ("%%~l"
		) do if /i "%%~a"=="wrapper.java.maxmemory" (
			>>"%conffile%" echo(wrapper.java.maxmemory=!max_java_heap!
		) else (
			>>"%conffile%" echo(%%l
		)

		echo min_heap=!min_java_heap! > "%APMIA_INSTALLER_BIN%/java_heap.txt"
		echo max_heap=!max_java_heap! >> "%APMIA_INSTALLER_BIN%/java_heap.txt"
	)

	if %property_set% == 1 (

		IF not [!param1!] == [] (
			set param1=!param1:_==!
			echo wrapper.java.additional.1=!param1! >> %APMIA_INSTALLER_HOME%\conf\wrapper.conf
		)
		IF not [!param2!] == [] (
			set param2=!param2:_==!
			echo wrapper.java.additional.2=!param2! >> %APMIA_INSTALLER_HOME%\conf\wrapper.conf
		)
		IF not [!param3!] == [] (
			set param3=!param3:_==!
			echo wrapper.java.additional.3=!param3! >> %APMIA_INSTALLER_HOME%\conf\wrapper.conf
		)
		IF not [!param4!] == [] (
			set param4=!param4:_==!
			echo wrapper.java.additional.4=!param4! >> %APMIA_INSTALLER_HOME%\conf\wrapper.conf
		)
		IF not [!param5!] == [] (
			set param5=!param5:_==!
			echo wrapper.java.additional.5=!param5! >> %APMIA_INSTALLER_HOME%\conf\wrapper.conf
		)
	)

EXIT /B 0

:ConfigureAPMIA
	echo [%date%] [%TIME%] Coppying wrapper to APMIA. >>%APMIA_Installation.log%
	cd "%APMIA_WRAPPER_SERVICE_HOME% "
	md conf
	if not "%RELEASE_DIR%" == "" (
		md lib
	)
	cd "%APMIA_INSTALLER_HOME%"
	copy "%WRAPPER_HOME%\wrapper-windows-x86-64.exe" "%APMIA_WRAPPER_SERVICE_HOME%" >NUL
	copy "%WRAPPER_HOME%\wrapper-windows-x86-32.exe" "%APMIA_WRAPPER_SERVICE_HOME%" >NUL
	xcopy "%WRAPPER_HOME%\conf" "%APMIA_WRAPPER_SERVICE_HOME%\conf" >nul
	xcopy "%WRAPPER_HOME%\lib" "%APMIA_WRAPPER_SERVICE_HOME%\lib" >nul
EXIT /B 0

:CheckAllFolder
	echo [%date%] [%TIME%] Checking if any folder is missing. >>%APMIA_Installation.log%
	Call :InstallationMode
	set /a folderOK=0
	if "%withHostMonitor%" == "1" (
		if not exist "%HOSTMONITOR_INSTALLER_HOME%" (
			echo CA_SystemEDGE_Core directory not found at %HOSTMONITOR_INSTALLER_HOME%
			echo [%date%] [%TIME%] CA_SystemEDGE_Core directory not found at %HOSTMONITOR_INSTALLER_HOME% >>%APMIA_Installation.log%
			set /a folderOK=1
		)
	)
	if not exist "%APMIA_INSTALLER_HOME%lib" (
		echo APM Infrastructure Agent lib directory not found at %APMIA_INSTALLER_HOME%
		echo [%date%] [%TIME%] APM Infrastructure Agent lib directory not found at %APMIA_INSTALLER_HOME% >>%APMIA_Installation.log%
		set /a folderOK=1
	)
	if not exist "%WRAPPER_HOME%" (
		echo Wrapper directory not found at %WRAPPER_HOME%
		echo [%date%] [%TIME%] Wrapper directory not found at %WRAPPER_HOME% >>%APMIA_Installation.log%
		set /a folderOK=1
	)
	if not exist "%JRE_HOME%" (
		echo JRE directory not found at %JRE_HOME%
		echo [%date%] [%TIME%] JRE directory not found at %JRE_HOME% >>%APMIA_Installation.log%
		set /a folderOK=1
	)
	if exist "%APMIA_INSTALLER_HOME%wrapper-windows-x86-32" (
		call :errorlog
		EXIT /B 1
	)
	if exist "%APMIA_INSTALLER_HOME%wrapper-windows-x86-64" (
		call :errorlog
		EXIT /B 1
	)
	if exist "%APMIA_INSTALLER_HOME%lib\wrapper.jar" (
		del /f /q  "%APMIA_INSTALLER_HOME%lib\wrapper.jar"
	)
	if exist "%APMIA_INSTALLER_HOME%lib\wrapper-windows-x86-32.dll" (
		call :errorlog
		EXIT /B 1
	)
	if exist "%APMIA_INSTALLER_HOME%lib\wrapper-windows-x86-64.dll" (
		call :errorlog
		EXIT /B 1
	)
EXIT /B 0
:CheckingWindowsserver2022
	 systeminfo | find "OS Name" | findstr /C:"%server2025%" > nul &&set isIt2025=0 || set isIt2025=1
     if %isIt2025% == 0 (
         set JAVA_TOOL_OPTIONS=%osname2025% %JAVA_TOOL_OPTIONS%
         echo [%date%] [%TIME%] Added Java Tool Option : %APMIA_INSTALLER_HOME% >>%APMIA_Installation.log%
     	 EXIT /B 1
     )
     systeminfo | find "OS Name" | findstr /C:"%server2022%" > nul &&set isIt2022=0 || set isIt2022=1
     if %isIt2022% == 0 (
         set JAVA_TOOL_OPTIONS=%osname% %JAVA_TOOL_OPTIONS%
     	 echo [%date%] [%TIME%] Added Java Tool Option : %APMIA_INSTALLER_HOME% >>%APMIA_Installation.log%
     	 EXIT /B 1
     )
     systeminfo | find "OS Name" | findstr /C:"%server2019%" > nul &&set isIt2019=0 || set isIt2019=1
     if %isIt2019% == 0 (
         set JAVA_TOOL_OPTIONS=%osname% %JAVA_TOOL_OPTIONS%
       	 echo [%date%] [%TIME%] Added Java Tool Option : %APMIA_INSTALLER_HOME% >>%APMIA_Installation.log%
     	 EXIT /B 1
     )
EXIT /B 0
:errorlog
	set /a folderOK=1
    echo APM Infrastructure Agent installation/corrupt installation is present at location : %APMIA_INSTALLER_HOME%
    echo [%date%] [%TIME%] APM Infrastructure Agent installation/corrupt installation is present at location : %APMIA_INSTALLER_HOME% >>%APMIA_Installation.log%
EXIT /B 1


:stop_and_wait_sysedge
    echo [%date%] [%TIME%] Checking status of sysedge service. >>%APMIA_Installation.log%
    echo [%date%] [%TIME%] Stopping sysedge service... >>%APMIA_Installation.log%
    sc stop sysedge >>%APMIA_Installation.log%
    
    echo Waiting for the sysedge service to stop...
    
    FOR /L %%N IN (1,1,12) DO (
        ping 127.0.0.1 -n 6 > nul 
        sc query sysedge | findstr "STATE" | findstr "STOPPED" > nul
        if %errorlevel% equ 0 (
            echo [%date%] [%TIME%] Sysedge service has stopped. >>%APMIA_Installation.log%
            echo Service sysedge has stopped.
            GOTO:EOF
        )       
        echo - Still waiting...
    )           
        
    echo [%date%] [%TIME%] ERROR: Sysedge service did not stop within the timeout. >>%APMIA_Installation.log%
    echo ERROR: The sysedge service did not stop in time. Please check the service manually.
EXIT /B 1
