:: Only for APMIA Console Start
:: APMIAgent_ConsoleStart.cmd
:: Control script for running the Introscope APM Infrastructure Agent
:: via an easy-to-use command line interface. 

:: |||||||||||||||||||| START CONFIGURATION SECTION  ||||||||||||||||||||
:: Set the home directory if it is unset.
:: Different OSes require different test statements 
:: Edited on - 27-Sep-2020

@echo off

set ERROR=0

set WILYBIN=%~dp0
set WILYHOME=%WILYBIN:\bin\=%

set WILYLIB=%WILYHOME%\lib
set WILYLOGDIR=%WILYHOME%\logs

echo WILYHOME   = %WILYHOME% >> "%WILYLOGDIR%\APMIA_ConsoleStart.log" 2>&1

:: The logfiles
set LOGFILE="%WILYLOGDIR%\APMIA_ConsoleStart.log"
set JVMERRORFILE=%WILYLOGDIR%\jvm_error.log

:: the path to your PID file
set PIDFILE="%WILYHOME%\bin\CollectorAgent.pid"


:: changes for passing heap values in arguments
set MIN_HEAP_VAL_IN_MB=256
set MAX_HEAP_VAL_IN_MB=512

:: Set JAVA_HOME to locally installed JRE
set JAVA_HOME=%WILYHOME%\jre
echo JAVA_HOME  = %JAVA_HOME% >> "%WILYLOGDIR%\APMIA_ConsoleStart.log" 2>&1

:: the command to start the CollectorAgent
set JavaCmd="%JAVA_HOME%\bin\java" -server -Xms%MIN_HEAP_VAL_IN_MB%m -Xmx%MAX_HEAP_VAL_IN_MB%m -cp "%WILYLIB%\*" -XX:ErrorFile="%JVMERRORFILE%" com.wily.introscope.agent.uma.UnifiedMonitoringAgent
echo %JavaCmd% >> "%WILYLOGDIR%\APMIA_ConsoleStart.log" 2>&1
:: ||||||||||||||||||||   END CONFIGURATION SECTION  ||||||||||||||||||||

setlocal

pushd "%WILYHOME%"

%JavaCmd% >> "%WILYLOGDIR%\APMIA_ConsoleStart.log" 2>&1

popd

endlocal

:END
