

################################################################################
# Bundle: em-connection:25.10.1.10
################################################################################

# This bundle contains the configuration settings the CollectorAgents use for
# connections to the Enterprise Manager. 
#
# The Enterprise Manager 'connection order' list the Agent uses if it is
# disconnected from its Enterprise Manager is determined automatically based on
# the numeric suffix provided to "agentManager.url" property. 
#
# For example if "agentManager.url.1" , "agentManager.url.2" and
# "agentManager.url.3" are defined and enabled then connection order will be
# "1,2,3" with "1" getting the highest precedence and so on. 
#
# Default channel is "1". All the related properties of default channel are
# suffixed with "1". Similarly if channel "2" is defined and enabled , then all
# of the properties related to it must be suffixed with "2". 

# Changing this property requires restarting the Monitored Process
agentManager.credential=eyJ0eXAiOiJKV1QiLCJhbGciOiJFUzI1NiJ9.eyJhZ2VudCI6dHJ1ZSwiZXhwIjo5MjIzMzcyMDM2ODU0Nzc1LCJ0aWQiOjEyLCJqdGkiOiIxM2U3YzNhNC1jZjZlLTRhM2EtODczYy0wN2UwMmVmMzUxNWUifQ.bPNBcW6EZkXffeU3zE9cFIiVrOFiwtZREwG37qSWdMWTX32YQsRqYN-7xvI_wezPXPqzxRom60n-vpRBYpFoiQ

# Agent connection properties Agent will connect to Enterprise Manager over
# websocket by default. If using a cloud proxy to connect to the EM, use the
# properties in the Cloud proxy section for Advanced configuration. 
#
# Changing this property requires restarting the Monitored Process
agentManager.url.1=wss://apmgw.dxi-eu1.saas.broadcom.com:443

# Changing this property requires restarting the Monitored Process
agentManager.url.2=https://apmgw.dxi-eu1.saas.broadcom.com:443

# Set the enabled cipher suites. A comma-separated list of cipher suites. If not
# specified, use the default enabled cipher suites. 
#
# Changing this property requires restarting the Monitored Process
#agentManager.cipherSuites.1=

# Location of a truststore containing trusted EM certificates. If no truststore
# is specified, the agent trusts all certificates. Either an absolute path or a
# path relative to the agent's working directory. On Windows, backslashes must
# be escaped.  For example: C:\\keystore 
#
# Changing this property requires restarting the Monitored Process
#agentManager.trustStore.1=

# The password for the truststore
#
# Changing this property requires restarting the Monitored Process
#agentManager.trustStorePassword.1=

# Location of a keystore containing the agent's certificate. A keystore is
# needed if the EM requires client authentication. Either an absolute path or a
# path relative to the agent's working directory. On Windows, backslashes must
# be escaped.  For example: C:\\keystore 
#
# Changing this property requires restarting the Monitored Process
#agentManager.keyStore.1=

# The password for the keystore
#
# Changing this property requires restarting the Monitored Process
#agentManager.keyStorePassword.1=

# Location of a truststore containing trusted EM certificates for second
# configured connection. If no truststore is specified, the agent trusts all
# certificates. Either an absolute path or a path relative to the agent's
# working directory. On Windows, backslashes must be escaped.  For example:
# C:\\keystore 
#
# Changing this property requires restarting the Monitored Process
#agentManager.trustStore.2=

# The password for the truststore
#
# Changing this property requires restarting the Monitored Process
#agentManager.trustStorePassword.2=

# Location of a keystore containing the agent's certificate. A keystore is
# needed if the EM requires client authentication. Either an absolute path or a
# path relative to the agent's working directory. On Windows, backslashes must
# be escaped.  For example: C:\\keystore 
#
# Changing this property requires restarting the Monitored Process
#agentManager.keyStore.2=

# The password for the keystore
#
# Changing this property requires restarting the Monitored Process
#agentManager.keyStorePassword.2=

# Validate that certificate matches hostname connecting to. Default value is
# false, enabling it will increase security of installation by preventing
# potential man in the middle attacks. This will be filled automatically during
# download as long as property agentManager.trustStore.autoConfiguration is true
#
# Changing this property requires restarting the Monitored Process
#agentManager.tls.validateHostname=false

# HttpProxy connection properties The agentManager.httpProxy properties are used
# only when the Agent is tunneling over HTTP and the Agent must connect to the
# Enterprise Manager through a proxy server (forward proxy). Uncomment and set
# the appropriate proxy host and port values. If the proxy server cannot be
# reached at the specified host and port, the Agent will try a direct HTTP
# tunneled connection to the Enterprise Manager before failing the connection
# attempt. 
#
# Changing this property requires restarting the Monitored Process
#agentManager.httpProxy.host=

# Changing this property requires restarting the Monitored Process
#agentManager.httpProxy.port=

# The following properties are used only when the proxy server requires
# authentication. Uncomment and set the user name and password properties. For
# NTLM credentials you must separate domain name from user name by escaped
# backslash e.g. mydomain.com\\jack01 
#
# Changing this property requires restarting the Monitored Process
#agentManager.httpProxy.username=

# Changing this property requires restarting the Monitored Process
#agentManager.httpProxy.password=

# Enterprise Manager Failback Retry Interval 
#
# When the Agent is configured to have multiple Enterprise Managers in its
# connection order and this property is enabled, the Introscope Agent will
# automatically attempt to connect to the Enterprise Manager in its connection
# order to which it can connect in allowed mode. In case no such Enterprise
# Manager is found, the reconnection attempt will occur on a regular interval as
# specified. Agent will not connect to any Enterprise Manager in disallowed
# mode, when this property is enabled. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.enterprisemanager.failbackRetryIntervalInSeconds=120

# To disable System Edge installion while deploying Host Monitor extension
# change value to false.
#
# Changing this property requires restarting the Monitored Process
introscope.agent.hostmonitor.sysedge.enabled=true

# This property specifies the value in seconds for stale metrics removal for
# EPAgent. Default value for below property is 300 seconds. 
#
# Changing this property requires restarting the Monitored Process
introscope.epagent.config.staleMetricsRemoval.intervalInSec=360


################################################################################
# Bundle: acc:25.10.1.10
################################################################################

# You can enable or disable the APM Command Center extension and control which
# port the Controller uses. 

# Enable/disable Agent Controller Registration Extension. When set to true it
# will allow APM Agents to register with the local ACC Agent Controller and
# Config Server. Default value is false (i.e. if property commented out). 
#
# Changing this property does not require restarting the Monitored Process
introscope.agent.acc.enable=true

# The port used to contact the Agent Controller. Default value is 51914
#
# Changing this property does not require restarting the Monitored Process
introscope.agent.acc.port=51914


################################################################################
# Bundle: apmia:25.10.1.10
################################################################################

# AutoProbe Properties # On/Off Switch 
#
# ================
# This boolean property gives you the ability to disable Introscope AutoProbe by
# settings the property value to false. You must restart the collector agent
# before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.autoprobe.enable=true

# Custom Log File Location 
#
# ================
# Introscope AutoProbe will always attempt to log the changes it makes.  Set
# this property to move the location of the log file to something other than the
# default.  Non-absolute names are resolved relative to the location of this
# properties file. You must restart the collector agent before changes to this
# property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.autoprobe.logfile={AgentHome}/logs/AutoProbe.log

# Directives Files 
#
# ================
# This property specifies all the directives files that determine how Introscope
# AutoProbe performs the instrumentation.  Specify a single entry, or a
# comma-delimited list of entries. The list may include any combination of: 
# - directives (.pbd) files 
# - directives list (.pbl) files  
# - directories that will be scanned about once per minute for   
# .pbd files. Directives files placed in a listed directory will be loaded
# automatically, without any need to edit this Agent profile. If dynamic
# instrumentation is enabled, the directives will take effect immediately
# without an app reboot. Non-absolute names will be resolved relative to the
# location of this properties file. IMPORTANT NOTE: This is a required parameter
# and it MUST be set to a valid value. 
# - If the property is not specified or the values are invalid,  the Introscope
# Agent will not run! 
# - If the property is set to include a directory, and invalid  directives files
# are placed in the directory, AutoProbe 
# metrics will no longer be reported! 
# - If the property is set to include a directory, and loaded  directives files
# are removed from the directory, AutoProbe 
# metrics will no longer be reported! You must restart the collector agent
# before changes to this property take effect. However, if the property includes
# one or more directories, and dynamic instrumentation is enabled, the
# Introscope Agent will load directives files from the specified directories
# without an app restart, as noted above. 
#
# Changing this property requires restarting the Monitored Process
introscope.autoprobe.directivesFile=hotdeploy

# Agent Properties    # Remote Probe Collector Port 
#
# ================
# Introscope will listen to connections from probes on this port to collect
# events. You must restart agent before the changes to this property take
# effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.remoteagent.collector.tcp.port=5005

# Changing this property requires restarting the Monitored Process
introscope.remoteagent.collector.tcp.local.only=false

# Each probe instance connection to collector is mapped to the virtual agent at
# EM Following two properties will govern how this agent will be named. 
#
# There are three replacementvariables that allowed in the configured name: 
#
# 	{type} - Probe type. Currently supported types are php and nodejs 
# 	{program} - Name of the program that probe is attached to (e.g.
# /usr/bin/httpd) 
# 	{collector} - Name of collector agent. See agent naming properties below. 
#
# These properties are not hot and require collector re-start to take effect.
# Default value for probe process name is {type} 
#
# Changing this property requires restarting the Monitored Process
introscope.remoteagent.probe.process.name={type}-probes

# Default value for probe agent name is {program}
#
# Changing this property requires restarting the Monitored Process
introscope.remoteagent.probe.agent.name={collector}({program})

# EPAgent Configuration 
# -----------------
# Network port on which to receive simple or XML formatted data. If commented
# out or left unconfigured then EPAgent will not listen for data. 
#
# Changing this property requires restarting the Monitored Process
#introscope.epagent.config.networkDataPort=8000

# Network port on which to listen for HTTP GET commands. If commented out or
# left unconfigured then EPAgent will not listen for HTTP commands 
#
# Changing this property requires restarting the Monitored Process
#introscope.epagent.config.httpServerPort=8080

# Property to enable SSL communication if needed for EPAgent Default value is
# false 
#
# Changing this property requires restarting the Monitored Process
#introscope.epagent.config.sslEnabled=false

# Location of a keystore containing the client's certificate. A keystore is
# needed if the EPAgent requires client authentication. On Windows, backslashes
# must be escaped.  For example: C:\\keystore 
#
# Changing this property requires restarting the Monitored Process
#introscope.epagent.config.ssl.keystorepath=

# Keystore password
#
# Changing this property requires restarting the Monitored Process
#introscope.epagent.config.ssl.keystorepassword=

# KeyManager password
#
# Changing this property requires restarting the Monitored Process
#introscope.epagent.config.ssl.keymanagerpassword=

# Time period in seconds that a stateless plugin is allowed to run before it is
# considered stalled and forcefully killed. If commented out or left
# unconfigured the default is 60 seconds. A value of zero will prevent stalled
# plugins from being detected and killed. 
#
# Changing this property requires restarting the Monitored Process
introscope.epagent.config.stalledStatelessPluginTimeoutInSeconds=60

# Agent log directory 
#
# This property specifies directory where agent writes it's logfiles. Default is
# application home directory. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.log.directory={AgentHome}/logs

# Agent log file path 
#
# This property specifies full custom path for agent logfile. If set, it
# overrides introscope.agent.log.directory property and agent agent logfile auto
# naming properties. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.log.file.path={AgentHome}/logs/IntroscopeAgent.log

# Agent log file maximum size 
#
# This property specifies maximum size for agent logfile before it's rolled over
# by rolling file appender. The value can be in either kilobytes or megabytes
# e.g. 500KB or 10MB Default is 2MB 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.log.max.file.size=2MB

# Agent log file maximum rollover index 
#
# This property specifies maximum index for agent logfile rolled over files by
# rolling file appender. The value should be more than 0 and not more than 20
# Default is 4 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.log.max.rollover.index=4

# Choose logging backend factory class 
#
# Logging framework to be used for agent logs. Current possible values are: -
# com.wily.introscope.agent.feedback.backend.logback.LogbackBackendFactory
# (default) - com.wily.util.feedback.backend.NoOpBackend 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.log.backend=com.wily.introscope.agent.feedback.backend.logback.LogbackBackendFactory

# Log framework configuration file 
#
# This file is loaded for backend for appender configuration. Default name is
# agent-logback-configuration.xml 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.log.config.file=agent-logback-configuration.xml

# Logging level properties for root logger 
#
# Set the logging level for root logger. Possibe values are: 
# - OFF 
# - FATAL (not supported by all backends, if so use ERROR 
# - ERROR  
# - WARN 
# - INFO 
# - VERBOSE (not supported by all backends, if so use DEBUG) 
# - DEBUG 
# - TRACE 
# - ALL Default value is INFO 
#
# Changing this property does not require restarting the Monitored Process
introscope.agent.log.level.root=INFO

# Logging level properties for specific child module loggers 
#
# By default modules inherit logging level from parent or root logger. This
# property allows overriding logging level for specific module and it's
# children. Same values are supported as by root logger. 
#
# Changing this property does not require restarting the Monitored Process
#introscope.agent.log.level.IntroscopeAgent.Agent=INFO

# DNS lookup configuration 
#
# Agent has following DNS lookup implementations: direct and separateThread. 
# Implementation to use is specified by value of
# introscope.agent.dns.lookup.type property. direct performs DNS lookups in
# application thread. Application thread will be delayed by length of time the
# underlying DNS mechanism takes to perform a specific lookup. separateThread
# performs DNS lookups in a separate thread. The application thread is delayed
# at most by introscope.agent.dns.lookup.max.wait.in.milliseconds milliseconds.
# When using separateThread implementation, if lookup of host name by IP address
# times out, IP address will be returned in place of name and if lookup of IP
# address by host name times out, empty IP address will be returned. Default DNS
# lookup implementation is separateThread 
#
# You must restart the collector agent before change to this property takes
# effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.dns.lookup.type=direct

# Changing this property requires restarting the Monitored Process
introscope.agent.dns.lookup.type=separateThread

# Maximum time in milliseconds separateThread implementation waits to lookup a
# host name or IP address. It is ignored by direct implementation.  Default
# value is 200. Change to this property takes effect immediately and does not
# require the collector agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.dns.lookup.max.wait.in.milliseconds=200

# Custom Process Name 
#
# ================
# Specify the process name as it should appear in the Introscope Enterprise
# Manager and Workstation. You must restart the collector agent before changes
# to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.customProcessName=CustomProcessName

# Default Process Name 
#
# ================
# If no custom process name is provided and the agent is unable to determine the
# name of the main application class, this value will be used for the process
# name. You must restart the collector agent before changes to this property
# take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.defaultProcessName=Infrastructure

# Agent Name 
#
# ================
# Specify the name of this agent as it appears in the Introscope Enterprise
# Manager and Workstation. Use this property if you want to specify the Agent
# Name using the value of a Java System Property. You must restart the collector
# agent before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.agentNameSystemPropertyKey=

# This enables/disables auto naming of the agent using an Application Server
# custom service. You must restart the collector agent before changes to this
# property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.agentAutoNamingEnabled=false

# Uncomment this property to provide a default Agent Name if the other methods
# fail. You must restart the collector agent before changes to this property
# take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.agentName=Agent

# Fully Qualified Domain Name (FQDN) can be enabled by setting this property
# value to 'true'. By Default (false) it will display HostName. Set to 'true'
# when integrating with Catalyst. You must restart the collector agent before
# changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.display.hostName.as.fqdn=false

# When container host name override is enabled, the Agent determines a
# non-ephemeral host name for an agent running in a container. The new agent
# host name selected might be different from the network host name of the
# container. The default value is true. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.container.hostname.override=true

# Agent Extensions Directory 
#
# ================
# This property specifies the location of all extensions to be loaded by the
# Introscope Agent.  Non-absolute names are resolved relative to the location of
# this properties file. You must restart the collector agent before changes to
# this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.extensions.directory=../../core/ext

# This property specifies the location of extension bundles to be loaded by the
# Introscope Agent from the extensions directory. You must restart the managed
# application before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.extensions.bundles.directory=../../extensions

# Extensions deployment has three modes: controlled, dynamic, and off. In
# dynamic mode extensions can be added/removed from the agent's
# extensions/deploy directory without requiring an agent restart. 
#
# In controlled mode, adding or removing extensions requires an agent restart
# and the agent will only load extensions from the extensions/deploy directory
# during the agent startup. 
#
# In off mode, extensions deployment is disabled and no extensions will be
# loaded from the extensions\deploy directory of the agent. You must restart the
# managed application before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.extensions.bundles.mode=dynamic

# Agent Common Directory 
#
# ================
# This property specifies the location of common directory to be loaded by the
# Introscope Agent.  Non-absolute names are resolved relative to the location of
# this properties file. You must restart the collector agent before changes to
# this property take effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.common.directory=../../common

# SQL Agent Configuration 
#
# You must restart the collector agent before changes to these properties take
# effect. Configuration settings for Introscope SQL Agent 
# ================
# Turns off metrics for individual SQL statements. The default value is false. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.sql.turnoffmetrics=false

# Report only Average Response Time metric for individual SQL statements. The
# default value is false.
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.sql.artonly=false

# Turn off transaction tracing for individual sql statements. The default value
# is false.
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.sql.turnofftrace=false

# Unnormalized sql will appear as parameter for Sql components in Transaction
# Trace Caution: enabling this property may result in passwords and sensitive
# information to be presented in Transaction Trace The default value is false. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.sql.rawsql=false

# SQL Agent Normalizer extension 
#
# ================
# Configuration settings for SQL Agent normalizer extension Specifies the name
# of the sql normalizer extension that will be used to override the
# preconfigured normalization scheme. To make custom normalization extension
# work, the value of its manifest attribute
# com-wily-Extension-Plugin-{pluginName}-Name should match with the value given
# to this property. If you specify a comma separated list of names, only the
# first name will be used. Example, 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.extension=ext1, ext2

# Only ext1 will be used for normalization. By default we now ship the
# RegexSqlNormalizer extension Changes to this property take effect immediately
# and do not require the collector agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.extension=RegexSqlNormalizer

# RegexSqlNormalizer extension 
#
# ==================
# The following properties pertain to RegexSqlNormalizer which uses regex
# patterns and replace formats to normalize the sql in a user defined way. This
# property if set to true will make sql strings to be evaluated against all the
# regex key groups. The implementation is chained. Hence, if the sql matches
# multiple key groups, the normalized sql output from group1 is fed as input to
# group2 and so on. If the property is set to 'false', as soon as a key group
# matches, the normalized sql output from that group is returned Changes to this
# property take effect immediately and do not require the collector agent to be
# restarted. Default value is 'false' 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.regex.matchFallThrough=true

# This property specifies the regex group keys. They are evaluated in order
# Changes to this property take effect immediately and do not require the
# collector agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.regex.keys=key1

# This property specifies the regex pattern that will be used to match against
# the sql. All valid regex alowed by java.util.Regex package can be used here.
# Changes to this property take effect immediately and do not require the
# collector agent to be restarted. eg: (\\b[0-9,.]+\\b) will filter all number
# values, ('.*?') will filter anything between single quotes,
# ((?i)\\bTRUE\\b|\\bFALSE\\b) will filter boolean values from the query. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.regex.key1.pattern=(".*?")|('.*?')|(\\b[0-9,.]+\\b)|((?i)\\bTRUE\\b|\\bFALSE\\b)

# This property if set to 'false' will replace the first occurrence of the
# matching pattern in the sql with the replacement string. If set to 'true' it
# will replace all occurrences of the matching pattern in the sql with
# replacement string Changes to this property take effect immediately and do not
# require the collector agent to be restarted. Default value is 'false' 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.regex.key1.replaceAll=true

# This property specifies the replacement string format. All valid regex allowed
# by java.util.Regex package java.util.regex.Matcher class can be used here. eg:
# The default normalizer replaces the values with a question mark (?) Changes to
# this property take effect immediately and do not require the collector agent
# to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.regex.key1.replaceFormat=?

# This property specifies whether the pattern match is sensitive to case Changes
# to this property take effect immediately and do not require the collector
# agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.sqlagent.normalizer.regex.key1.caseSensitive=false

# Agent Metric Clamp Configuration 
#
# ================
# The following setting configures the Agent to approximately clamp the number
# of metrics sent to the EM If the number of metrics pass this metric clamp
# value then no new metrics will be created.  Old metrics will still report
# values. The value must be equal to or larger than 1000 to take effect. Lower
# value will be rejected. The default value is 50000. You must restart the
# collector agent before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.metricClamp=50000

# Agent Metric Reporting Queue Size 
#
# Agent metric reporting queue size in minutes of data stored, when EM
# connection is not available. Default value is 3 minutes. Value 0 means that
# metrics are not harvested when connection is down. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.reportingqueue.size.minutes=3

# Agent Metric Reporting Queue Maximum Memory Usage. 
#
# This property limits maximum size of memory used for stored metric values,
# when EM is not available in KB. Due to performance concerns this limit is
# monitored approximately and may be triggered with a little delay above the
# specified value. Default value is 1MB (1024KB) 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.reportingqueue.memory.max=1024

# Transaction Tracer Configuration 
#
# ================
# Configuration settings for Introscope Transaction Tracer Uncomment the
# following property to specify the maximum number of components allowed in a
# Transaction Trace.  By default, the clamp is set at 5000. Note that any
# Transaction Trace exceeding the clamp will be discarded at the agent, and a
# warning message will be logged in the Agent log file. Warning: If this clamp
# size is increased, the requirement on the memory will be higher and as such,
# the max heap size for the JVM may need to be adjusted accordingly, or else the
# collector agent may run out of memory. Changes to this property take effect
# immediately and do not require the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontrace.componentCountClamp=5000

# Uncomment the following property to specify the maximum depth of components
# allowed in head filtering, which is the process of examining the start of a
# transaction for the purpose of potentially collecting the entire transaction. 
# Head filtering will check until the first blamed component exits, which can be
# a problem on very deep call stacks when no clamping is done.  The clamp value
# will limit the memory and CPU utilization impact of this behavior by forcing
# the agent to only look up to a fixed depth.  By default, the clamp is set at
# 30. Note that any Transaction Trace whose depth exceeds the clamp will no
# longer be examined for possible collection UNLESS some other mechanism, such
# as sampling or user-initiated transaction tracing, is active to select the
# transaction for collection. Warning: If this clamp size is increased, the
# requirement on the memory will be higher and as such, garbage collection
# behavior may be affected, which will have an application-wide performance
# impact. Changes to this property take effect immediately and do not require
# the collector agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontrace.headFilterClamp=30

# Uncomment the following property to disable Transaction Tracer Sampling
# Changes to this property take effect immediately and do not require the
# collector agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontracer.sampling.enabled=false

# The following property limits the number of transactions that are reported by
# the agent per reporting cycle. The default value if the property is not set is
# 50. You must restart the collector agent before changes to this property take
# effect. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.ttClamp=50

# TT Sampling 
# ================
# These are normally configured in the EM. Configuring in the Agent disables
# configuring them in the EM You must restart the collector agent before changes
# to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontracer.sampling.perinterval.count=1

# Changing this property requires restarting the Monitored Process
#introscope.agent.transactiontracer.sampling.interval.seconds=120

# 	Application Naming 
# ===========================
# This property allows to configure a Custom Application name for all the
# applications connected to this agent.  Change to this property takes effect
# immediately and does not require the managed application to be restarted. This
# property is not configured by default. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.application.name=Default

# URL Grouping Configuration 
#
# ================
# Configuration settings for Frontend naming.  By default, frontends go into the
# group with two segments after url port For example, frontend with a url
# http://localhost:80/abc/def/index.jsp goes to /abc/def/, until the number of
# url groups created across all apps reach a value defined in the property
# "introscope.agent.urlgroup.frontend.url.clamp" below. After the clamp is
# reached, all frontends go into the "Default" group. To get customized metrics
# out of the Frontends|Apps|URLs tree, set up URL groups that are relevant to
# the deployment Changes to this property take effect immediately and do not
# require the collector agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.urlgroup.keys=default

# Changing this property requires restarting the Monitored Process
introscope.agent.urlgroup.group.default.pathprefix=*

# Changing this property requires restarting the Monitored Process
introscope.agent.urlgroup.group.default.format={path_delimited:/:0:5}

# Changing this property requires restarting the Monitored Process
introscope.agent.urlgroup.frontend.url.clamp=5

# Frontends containing the resources listed below would go into a URL group
# called "Resources" by default. This is done so that invalid URLs (i.e.those
# that would generate a 404 error) and  Resource URLs do not create unique,
# one-time metrics -- this can bloat the EM's memory. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.urlgroup.frontend.url.resources.list=tif,tiff,jpg,jpeg,gif,png,bmp,bmpf,ico,cur,xbm,svg,img,css,woff,nil

# Configuration settings for Backend URL Path naming.  By default, frontends go
# into the group with two segments after url port , until the number of url
# groups created across all apps reach a value defined in the property
# "introscope.agent.urlgroup.backend.url.clamp" below. This is hot property.
# After the clamp is reached, all backend urls go into the "Default" group. It
# is applicable for metric path Backends|WebService at
# {protocol}_//{host}_{port}|Paths tree. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.backendpathgroup.keys=default

# Changing this property requires restarting the Monitored Process
introscope.agent.backendpathgroup.group.default.pathprefix=*

# Changing this property requires restarting the Monitored Process
introscope.agent.backendpathgroup.group.default.format={path_delimited:/:0:5}

# Changing this property requires restarting the Monitored Process
introscope.agent.urlgroup.backend.url.clamp=5

# Error Detector Configuration 
#
# ================
# Configuration settings for Error Detector Please include errors.pbd in your
# pbl (or in introscope.autoprobe.directivesFile) The error snapshot feature
# captures transaction details about serious errors and enables recording of
# error count metrics. Changes to this property take effect immediately and do
# not require the collector agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.errorsnapshots.enable=true

# The following series of properties lets you specify error messages to ignore.
# For errors with messages matching these filters, error snapshots and error
# metrics will not be generated or sent. You may specify as many as you like
# (using .0, .1, .2 ...). You may use wildcards (*). The following are examples
# only. Changes to this property take effect immediately and do not require the
# managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.errorsnapshots.ignore.0=*com.company.HarmlessException*

# Changing this property requires restarting the Monitored Process
#introscope.agent.errorsnapshots.ignore.1=*HTTP Error Code: 404*

# The following setting configures the maximum number of error snapshots that
# the Agent can send in a 15-second period. Changes to this property take effect
# immediately and do not require the collector agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.errorsnapshots.throttle=10

# Minimum threshold for stall event duration Changes to this property take
# effect immediately and do not require the collector agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.stalls.thresholdseconds=30

# Frequency that the agent checks for stall events Changes to this property take
# effect immediately and do not require the collector agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.stalls.resolutionseconds=10

# Dynamic Instrumentation Settings 
# ================================= 
# This feature enables changes to PBDs to take effect without restarting the
# application server or the agent process. This is a very CPU intensive
# operation, and it is highly recommended to use configuration to minimize the
# classes that are being redefined.PBD editing is all that is required to
# trigger this process. Enable/disable the dynamic instrumentation feature. You
# must restart the collector agent before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.autoprobe.dynamicinstrument.enabled=true

# The polling interval in minutes to poll for PBD changes You must restart the
# collector agent before changes to this property take effect. 
#
# Changing this property requires restarting the Monitored Process
#introscope.autoprobe.dynamicinstrument.pollIntervalMinutes=1

# Agent Metric Aging 
# ==============================
# Detects metrics that are not being updated consistently with new data and
# removes these metrics. By removing these metrics you can avoid metric
# explosion. Metrics that are in a group will be removed only if all metrics
# under this group are considered candidates for removal. BlamePointTracer
# metrics are considered a group. 
#
# Enable/disable the metric agent aging feature. Changes to this property take
# effect immediately and do not require the collector agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.metricAging.turnOn=true

# You can choose to ignore metrics from removal by adding the metric name or
# metric filter to the list below. Changes to this property take effect
# immediately and do not require the collector agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.metricAging.metricExclude.ignore.0=Threads*

# To ignore ChangeDetector.AgentID  metric from metric aging.
#
# Changing this property requires restarting the Monitored Process
introscope.agent.metricAging.metricExclude.ignore.1=ChangeDetector.AgentID

# Garbage collection and Memory Monitoring 
#
# ================
# Enable/disable Garbage Collection monitor Changes to following property take
# effect immediately and do not require the collector agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.gcmonitor.enable=true

# Thread Dump Collection Enable/disable Thread Dump Feature support. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.threaddump.enable=true

# Configure the maximum stack elements the Thread dump can have, If the user
# configures the max stack elements beyond 25000, The property is reset to the
# default value of 12000 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.threaddump.MaxStackElements=12000

# Enable/disable DeadLock poller Metric support.
#
# Changing this property requires restarting the Monitored Process
introscope.agent.threaddump.deadlockpoller.enable=false

# The property determines the interval in which the Agent queries for any
# deadlock in the system.
#
# Changing this property requires restarting the Monitored Process
introscope.agent.threaddump.deadlockpollerinterval=15000

# Transaction Structure aging properties 
#
# ================
# This property is to evaluate the number of elements in the transaction
# structure at the period interval, to determine if "emergency aging" is
# required. Default value is "30000" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.transaction.creation.checkperiod=30000

# This property specifies the period in milliseconds that the aging for the
# transaction structure is checked, Default value is "30000" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.transaction.aging.checkperiod=30000

# This property specifies the minimum amount in milliseconds that a tree in the
# transaction structure must be inactive before it is purged. The inactivity
# does not imply that it will be aged out. Default value is "60000" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.transaction.aging.period=60000

# This property sets the maximum percentage increment in the size of the
# structure that is allowed to happen before aging of the transaction structure
# is forced If the change in the number of nodes between the aging periods is
# more than this percentage value, then checking for aging occurs if set to a
# small value, the transaction structure will be aged more frequently, and the
# memory utilization of the agent will be therefore kept lower. Default value is
# "5", i.e. 5% 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.transaction.aging.attentionlevel.percentage=5

# This property sets the maximum absolute increment in the size of the structure
# that is allowed to happen before aging of the transaction structure is forced
# If the change in the number of nodes between the aging periods is more than
# this percentage value, then checking for aging occurs if set to a small value,
# the transaction structure will be aged more frequently, and the memory
# utilization of the agent will be therefore kept lower. Default value is
# "100000" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.transaction.attentionlevel.absolute=100000

# This property is used to avoid spikes in memory utilization of the transaction
# structure. If there is an increase of elements at any time bigger than a third
# of this value, then "emergency aging" occurs immediately. Emergency aging will
# agent parts of the transaction structures that are younger than the value
# specified in com.wily.introscope.agent.harvesting.transaction.aging.period, 
# and will likely reduce the amount of data sent by the agent. Only modify this
# value if the memory requirement are very strict. Default value is "100000" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.transaction.creation.attentionlevel.absolute=100000

# This property specifies the maximum duration in milliseconds of the aging
# process. It is used to avoid long aging process when resources available are
# not sufficient. default value if 30000 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.transaction.aging.duration.max=30000

# Transaction Structure properties 
#
# ================
# Enable/disable to shut down globally the transaction trace feature. Default
# value is "true" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.blame.transaction.doTransactionTrace=true

# Enable/disable high concurrency mode for all repositories. Set to true, it
# will use more memory but may give more throughput Default value is "false" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.blame.highconcurrency.enabled=false

# This property defines the number of stripes in the striped repositories It
# works when the high concurrency mode is on, which is
# "com.wily.introscope.agent.blame.highconcurrency.enabled=true" Default value
# is "16" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.blame.highconcurrency.stripes=16

# Enable/disable to removes stalls from all traces, and remove stall feature
# altogether. Default value is "true" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.blame.stall.trace.enabled=true

# Enable synchronized repositories instead of compare and swap repositories The
# synchronized repository is not used in java5 because of overhead in locking.
# the default value is true in java 6 and above, and false for java 5. In java
# 5, setting to false will cause overhead 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.blame.synchronized.enabled=true

# Properties to activate sustainability metrics 
#
# ================
# Sustainability metrics are generated to provide information on the agent
# health and internal status. There is a substantial overhead associated with
# these metrics, and therefore, their usage is not suggested at this time in
# production environments. 
#
# Enable/disable to generate globally sustainability debug metrics. Set to true,
# it will generate globally sustainability debug metrics that can be used to
# evaluate the Transaction Structure Default value is "false" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.blame.transactions.debugmetrics.enabled=false

# Enable/disable to generate sustainability metrics on the harvesting process.
# Default value is "false" 
#
# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.harvesting.debugmetrics.enabled=false

# This property is to generate the metrics for the health of the data structures
# in the agent. Default value is "false" 
#
# Changing this property requires restarting the Monitored Process
#concurrentMapPolicy.generatemetrics=false

# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.sustainabilitymetrics.enabled=true

# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.sustainabilitymetrics.metrics.enabled=true

# Changing this property requires restarting the Monitored Process
#com.wily.introscope.agent.sustainabilitymetrics.report.enabled=true

# com.wily.introscope.agent.sustainabilitymetrics.report.frequency
# Enable/disable to generate collector agent java metrics Default value is
# "true" 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.environment.java.metrics.enabled=false

# Smart Instrumentation properties 
#
#
# -------------------------------------
# Note: The following describes the functional behaviour on combination of the
# two properties introscope.agent.deep.instrumentation.enabled and
# introscope.agent.deep.trace.enabled 
#
# 1. The introscope.agent.deep.instrumentation.enabled property must be enabled
# for the introscope.agent.deep.trace.enabled property to function. 
#
# 2. When introscope.agent.deep.instrumentation.enabled=true and
# introscope.agent.deep.trace.enabled=true, the agent automatically instruments
# deep transaction trace components and collects deep transaction traces. 
#
# 3. When introscope.agent.deep.instrumentation.enabled=true and
# introscope.agent.deep.trace.enabled=false, the agent automatically instruments
# deep transaction trace components. However no deep transaction trace component
# data is sent to the Enterprise Manager or displayed. 
# --------------------------------------
#
# Enables and disables deep transaction trace visibility. Enables and disables
# the agent ability to automatically instrument transaction trace components
# without PBD configuration to provide deep transaction trace visibility. The
# default value is true. You must restart the managed application before changes
# to this property take effect 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.deep.instrumentation.enabled=true

# Enables and disables the agent ability to collect deep transaction traces and
# send the data to the Enterprise Manager. The default value is true. Change to
# this property takes effect immediately and does not require the managed
# application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.deep.trace.enabled=true

# This property enables and disables deep component visibility into error
# snapshots Change to this property takes effect immediately and do not require
# the collector agent to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.deep.errorsnapshot.enable=true

# This property limits the maximum number of deep trace components in a
# Transaction Trace Change to this property takes effect immediately and does
# not require the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.deep.trace.max.components=1000

# This property limits the maximum number of consecutive deep trace components
# in a Transaction Trace Change to this property takes effect immediately and
# does not require the managed application to be restarted. 
#
# Changing this property requires restarting the Monitored Process
introscope.agent.deep.trace.max.consecutive.components=15

# Changing this property requires restarting the Monitored Process
introscope.agent.deep.automatic.trace.crossprocess.enabled=false

# Access Token Configuration It specifies security token to be configured for
# adding attributes. Generate the access token in the CA APM Team Center UI. In
# CA APM Team Center select Settings, open the Security tab and click on the
# Generate New Token button. Copy and save the token as it will only be
# displayed once. Token corresponds to user, check user has access to Agent 
#
# Changing this property requires restarting the Monitored Process
attribute.decoration.apm.access.token=

# This property defines the number of threads to be created for Request Queue
# (used to hit REST Endpoints)/ Publish Queue (used to send data to EM) Change
# to this property doesnt take effect immediately. IA Agent restart is required
# to take this effect This property define the number of parallel profile
# execution in restmon extensions 
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.restmon.profileThreadCount=

# This property define max number of http connection in restmon extensions
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.restmon.httpclient.maxConnections=

# This property define the timeout for pooled http connection in restmon
# extensions. Unit in Seconds.
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.restmon.httpclient.pooledConnectionIdleTimeout=

# This property define the number of parallel thread to publish metric and node
# to EM in restmon extensions.
#
# Changing this property requires restarting the Monitored Process
#introscope.agent.restmon.pubThreadCount=

# Changing this property requires restarting the Monitored Process
#
# Changing this property requires restarting the Monitored Process
introscope.agent.nass.metric.ingestion.enabled=false

# Changing this property requires restarting the Monitored Process
#
# Changing this property requires restarting the Monitored Process
introscope.agent.nass.metric.externalId.default={AgentHome}/core/config/MetricAttributeDecorator.json


################################################################################
# PACKAGE DETAILS
# Tenant name = DX-QA
# Tenant id = 12
################################################################################
acc.package.id=70368744883111
acc.server.id=Cn4CqzE1ODUxNjU4ODY
acc.package.name=Node.js-apmia-20251104
acc.package.version=1
acc.package.truststore.hash=0
