/*
 * Copyright (c) 2024 Broadcom. All rights reserved. The term "Broadcom"
 * refers to Broadcom Inc. and/or its subsidiaries. All trademarks, trade
 * names, service marks, and logos referenced herein belong to their
 * respective companies.
 *
 * This software and all information contained therein is confidential and
 * proprietary and shall not be duplicated, used, disclosed or disseminated
 * in any way except as authorized by the applicable license agreement,
 * without the express written permission of Broadcom. All authorized
 * reproductions must be marked with this language.
 *
 * EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT
 * PERMITTED BY APPLICABLE LAW OR AS AGREED BY BROADCOM IN ITS APPLICABLE
 * LICENSE AGREEMENT, BROADCOM PROVIDES THIS DOCUMENTATION "AS IS" WITHOUT
 * WARRANTY OF ANY KIND, INCLUDING WITHOUT LIMITATION, ANY IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NONINFRINGEMENT.  IN NO EVENT WILL BROADCOM BE LIABLE TO THE END USER OR
 * ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE
 * OF THIS DOCUMENTATION, INCLUDING WITHOUT LIMITATION, LOST PROFITS, LOST
 * INVESTMENT, BUSINESS INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF
 * BROADCOM IS EXPRESSLY ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH LOSS
 * OR DAMAGE.
 */

import com.ca.apm.acc.plugin.PluginException
import groovy.json.JsonBuilder
import groovy.json.JsonSlurper
import groovy.util.logging.Slf4j

@Slf4j(value = "LOGGER", category = "com.ca.apm.acc.plugin.GetServerLog")
class GetServerLog {
    static def run(final String request) {
        try {
            return worker(request);
        } catch (final Exception ex) {
            throw new PluginException("GetServerLog", ex);
        }
    }

    private static def worker(final String request) {
        def inputs = new JsonSlurper().parseText(request);

        def r = [:];
        r.version = "1.0";
        r.className = "ZippedContent";

        def files = [];

        def logsDir = java.lang.System.getProperty("acc.controller.logs.dir");
        def fileName = java.lang.System.getProperty("acc.controller.logs.fileName");

        if (logsDir == null) {
            def base = inputs["acc.controller.dir"];
            if (base == null) {
                base = java.lang.System.getProperty("user.dir");
            }
            logsDir = base + "/logs/";
        }

        if (fileName == null) {
            fileName = ".*\\.log";
        }

        // for testing purpose
        if (inputs["acc.controller.logs.dir"]) {
            logsDir = inputs["acc.controller.logs.dir"];
            fileName = inputs["acc.controller.logs.fileName"] ?: ".*\\.log";
        }

        LOGGER.debug(" logs dir: $logsDir");
        LOGGER.debug(" fileName: $fileName");
        getVersionedFiles(files, logsDir, fileName);

        r.files = files;

        def json = new JsonBuilder(r);
        def response = json.toString()
        return response;
    }

/*
 * Get all file details needed for a log file
 */
    static getFileDetails(files, filename) {
        LOGGER.info("Fetching $filename");
        def openFile = new java.io.File(filename);
        if (!openFile.exists()) {
            LOGGER.info("does not exist ?");
        }
        def aFile = [:];
        aFile.filePath = filename;
        aFile.fileType = "log4j.appender.logfile.File";

        /* 'permissioned denied' gives 0 modified time. */
        if (openFile.lastModified() != 0) {
            aFile.modified = openFile.lastModified() as String;
        }

        /* actual file content is automatically added by the controller. */

        files.add(aFile);
    }

    static getVersionedFiles(files, basedir, fileName) {

        def fileList = java.nio.file.Files.newDirectoryStream(new java.io.File(basedir).toPath());
        for (def it = fileList.iterator(); it.hasNext();) {
            def log = it.next().toString();
            if (log ==~ ".*\\Q" + fileName + "\\E(\\.[0-9]*)?\$") {
                getFileDetails(files, log);
            }
        }
        fileList.close();
    }

    static class Error {
        String errno;
        String[] arguments;
    }
}

def handler() {
    if (binding.variables.containsKey("request")) {
        logger.info("Running GetServerLog.groovy");

        handler = new GetServerLog();
        response = handler.run(request);
        return response;
    }
}

handler();
