#produces a mapping of namespace, pod, container, if java process exist and if wily is there or not
# useful to debug if autoattach is working or not
#
help() {
  cat <<EOF
Usage: ./getUmaLogs.sh --namespace=<namespacename|ALL> --deployment=<deploymentname|ALL>
--namespace or -n        namespace where application is running

--deployment or -d       provide deployment or deploymentconfig name of the application for which autoattach related logs are needed

--pod or -p              Provide pod name of the application for which autoattach related logs are needed

--type or -t             kubernetes or openshift, default kubernetes, optional

--uma_namespace or -u    provide  uma  running on different namespace other than dx-uma

Provide --namespace, either deploymentname or podname to get the associated autoattach logs

EOF
}

processAutoattachLog() {
  POD=$1
  NAMESPACE=$2
  NODE=$3
  CONTAINER=$4
  PRINTINSCREEN=false
  podlog="$(grep -r $POD app* --color)"
  if $PRINTINSCREEN; then
    echo "*** Printing appcontainer logs related to $POD from Node $NODE"
    grep -r $POD app* --color
  fi
  echo "****************************************************** "
  #echo "*** --------- $POD from Node $NODE --------- "

  if grep -r $POD app* | grep -q "Skip"; then
    echo "*** --------- Attach Skipped: $POD from Node $NODE --------- "
    grep -r $POD app* --color | grep --color -e "Skip"
  fi

  if grep -r $POD app* | grep -q "Attach successful"; then
    echo "*** --------- Attach successful: $POD from Node $NODE --------- "
    grep -r $POD app* --color | grep --color -e "Attach successful"
  fi
  if grep -r $POD app* | grep -q "Agent already running"; then
    echo "*** --------- Agent already running: $POD from Node $NODE --------- "
    grep -r $POD app* --color | grep --color -e "Agent already running"
  fi

  if grep -r $POD app* | grep -q "Attach possibly failed"; then
    echo "*** --------- Attach possibly failed: $POD from Node $NODE --------- "
    grep -r $POD app* --color | grep --color -e "Attach possibly failed"
  fi

  if grep -r $POD app* | grep -q ".NET process"; then
    echo "*** --------- .NET process --------- "
    grep -r $POD app* --color | grep --color -e ".NET process"
  fi

  if grep -r $POD app* | grep -q "Java process"; then
    echo "*** --------- Java process --------- "
    grep -r $POD app* --color | grep --color -e "Java process"
  fi

  echo "*** Saving autoattach logs related to $POD from Node $NODE into autoattach_pod_$POD.log"
  grep -r $POD app* &>autoattach_pod_$POD.log

  echo "****************************************************** "
}

getApplicationLogs(){
POD=$1
NAMESPACE=$2
deployment=$3
deploymentStatus=""
AUTOATTACHSTATUSLOG=$deployment/AutoAttachStatus.log
APPLOG=$POD.log
DESCRIBELOG=$POD-description.log

echo "***checking the pod $POD in deployment $deployment"
$(mkdir -p $deployment 2>/dev/null)

$KUBECMD logs $POD -n $NAMESPACE 2>/dev/null > $deployment/$APPLOG

$KUBECMD describe po $POD -n $NAMESPACE 2>/dev/null > $deployment/$DESCRIBELOG

probeAutoAttachStatus=$($KUBECMD describe pod $POD -n $NAMESPACE | grep -i "ca.broadcom.com/probe-autoattach.status"| awk -F' ' '{print $2}')
probeAutoAttachType=$($KUBECMD describe pod $POD -n $NAMESPACE | grep -i "ca.broadcom.com/probe-autoattach.type"| awk -F' ' '{print $2}')

if [ "$probeAutoAttachStatus" == "attached" ]; then
	if [ -f "$AUTOATTACHSTATUSLOG" ]; then
		status=`cat $AUTOATTACHSTATUSLOG | grep -i "$deployment" |cut -d"=" -f2`
		if [ "$status" == "attached" ]; then
			echo "***Pod [$POD] part of deployment [$deployment] already attached as $probeAutoAttachType autoattach is at deployment level"
	  	fi
	else
		echo "$deployment=$probeAutoAttachStatus" >$deployment/AutoAttachStatus.log	
		echo "***Deplpoyment [$deployment] is successfully auto attached" 
	fi
else
	echo "***Auto attach status is not updated for pod $POD.For complete logs check $APPLOG"
fi

echo "****************************************************** "
}

getProbeAutoAttachLogs(){
probeDeployment=apm-probe-autoattach-monitor
POD=$1
NAMESPACE=$2
deployment=$3
AUTOATTACHSTATUSLOG=$deployment/AutoAttachStatus.log

#NODE=$($KUBECMD get pod $POD -n $NAMESPACE -o wide | grep -v NAME | awk '{print $7}')
PROBEPOD=$($KUBECMD get pods -n $UMANAMESPACE -o wide | grep -v NAME | grep $probeDeployment |awk '{print $1}')
PROBECONTAINERS=$($KUBECMD describe pod $PROBEPOD -n $UMANAMESPACE | grep -B 1 "Container ID:" | grep -v "Container ID:" | grep -v "\-\-" | sed "s/://g")

echo "****************************************************** "

for PROBECONTAINER in $PROBECONTAINERS; do
    echo "***checking the POD $PROBEPOD"
    $(mkdir -p $PROBECONTAINER 2>/dev/null)
    PROBE_LOG_FILE="${PROBEPOD}".log
    $KUBECMD logs $PROBEPOD -n $UMANAMESPACE -c $PROBECONTAINER >$PROBECONTAINER/$PROBE_LOG_FILE

        if [ ! -f "$AUTOATTACHSTATUSLOG" ]; then
   	   echo "***Annotations updated on pod are"
   	   $KUBECMD get pod $POD -n $NAMESPACE -o jsonpath='{.metadata.annotations}{"\n"}'
           grep -r "$deployment" apm* | grep -e "updated deployment"
           grep -r "$deployment" apm* | grep -e "AnnotateResource UpdateResource"
	else
	   echo "***POD:[$POD] is part of deployment:[$deployment] which is already auto attached"
        fi
done
}

printLogIfDeplpoymentIsAttached(){
deployment=$1
POD=$2
NODE=$3

AUTOATTACHSTATUSLOG=$deployment/AutoAttachStatus.log

if [ -f "$AUTOATTACHSTATUSLOG" ]; then
	if grep -r "$POD" app* | grep -q "part of deployment"; then
    		grep -r "$POD" app* | grep --color -e "part of deployment"
  	fi
else
	echo "***Attach successful for deployment:["$deployment"] pod:[$POD] from Node ["$NODE"]"
fi
}

processAgentProbeLogs(){
  POD=$1
  NAMESPACE=$2
  NODE=$3
  CONTAINER=$4
  PRINTINSCREEN=false
  deployment=$5
  if [ X"$deployment" == "XALL" ]; then
                podName=$POD
                replicaSetName=`kubectl describe po $podName -n $NAMESPACE|  grep "Controlled By" |cut -d":" -f2|cut -d"/" -f2`
                deployment=`kubectl describe replicaset $replicaSetName -n $NAMESPACE | grep "Controlled By" |cut -d":" -f2|cut -d"/" -f2`
                echo "Current Deployment is:$deployment"
  fi
  getProbeAutoAttachLogs $POD $NAMESPACE $deployment
  msgPrinted=false
  podlog="$(grep -r $POD app* --color)"
 
  echo "****************************************************** " 
  echo "***checking the appcontainer logs related to $deployment from Node $NODE"

  if $PRINTINSCREEN; then
    echo "*** Printing appcontainer logs related to $deployment from Node $NODE"
    grep -r $deployment app* --color
  fi

  if grep -r "deploymentName/$deployment" app* | grep -q "Skip" ; then
    echo "***Attach Skipped: [$deployment] from Node [$NODE]"
  fi

   if grep -r "deploymentName/$deployment" app* | grep -q "Attach successful" ; then
	printLogIfDeplpoymentIsAttached $deployment $POD $NODE 
  fi

  if grep -r "deploymentName/$deployment" app* | grep -q "Attach possibly failed"; then
    echo "*** Attach possibly failed: [$deployment] from Node [$NODE] *** "
  fi

echo "****************************************************** "
getApplicationLogs $POD $NAMESPACE $deployment
###Recreate the tar file with Nodejs/PHP and apm-probe pods##########
cd ..
rm -rf umaLogs.tar 2>/dev/null
tar cvf umaLogs.tar CA_APM &>/dev/null
sleep 2
cd -
}


getAllUmaLogs(){

if [ X"$Additional_Deployments" == "X" ]; then
  echo "*** Started uma log collection"
  UMAPODS=$($KUBECMD get pods -n $UMANAMESPACE -o wide | grep -v NAME | awk '{print $1}')
else
  echo "***Started uma log collection for Additional deployments added are $Additional_Deployments"
  UMAPODS=$($KUBECMD get pods -n $UMANAMESPACE -o wide | grep -v NAME | grep $Additional_Deployments | awk '{print $1}')
fi
for UMAPOD in $UMAPODS; do
  UMACONTAINERS=$($KUBECMD describe pod $UMAPOD -n $UMANAMESPACE | grep -B 1 "Container ID:" | grep -v "Container ID:" | grep -v "\-\-" | sed "s/://g")
  for UMACONTAINER in $UMACONTAINERS; do
    echo "***checking the container $UMACONTAINER"
    $(mkdir -p $UMAPOD/$UMACONTAINER 2>/dev/null)
    if [[ $UMACONTAINER =~ "clusterinfo" ]]; then
      echo "***Collecting clusterinfo logs"
      LOGLOCATION="/tmp/clusterinfo/logs/"
      UMALOG_FILES=""
      UMALOG_FILES=$($KUBECMD exec $UMAPOD -n $UMANAMESPACE -c $UMACONTAINER -- ls $LOGLOCATION 2>/dev/null)
      elif [[ $UMACONTAINER =~ "containerinfo" ]]; then
      echo "***Collecting containerinfo logs"
      LOGLOCATION="/tmp/"
      UMALOG_FILES=""
      UMALOG_FILES=$($KUBECMD exec $UMAPOD -n $UMANAMESPACE -c $UMACONTAINER -- ls $LOGLOCATION 2>/dev/null)
      else
        LOGLOCATION="/usr/local/openshift/apmia/logs/"
        UMALOG_FILES=$($KUBECMD exec $UMAPOD -n $UMANAMESPACE -c $UMACONTAINER -- ls $LOGLOCATION 2>/dev/null)
    fi
            for UMALOG_FILE in $UMALOG_FILES; do
              echo "****Picking up $UMALOG_FILE from pod $UMAPOD"
              $KUBECMD exec $UMAPOD -n $UMANAMESPACE -c $UMACONTAINER -- cat $LOGLOCATION$UMALOG_FILE >$UMAPOD/$UMACONTAINER/$UMALOG_FILE
            done
            echo "****************************************************** "
  done
done
 cd ..
 echo "**** creating umaLogs.tar from logs collected"
 tar cvf umaLogs.tar CA_APM
 sleep 2
 cd -
 echo "collection of uma logs completed."
}

export namespace=ALL
export deployment=ALL
options=$(getopt -l "namespace:,deployment:,type:,pod:,uma_namespace:,additional_deployments:,help" -o "n:d:t:p:u:a:h" -a -- "$@")
eval set -- "$options"
while true; do
  case $1 in
  -h | --help)
    help
    exit 0
    ;;
  -n | --namespace)
    echo "Namespace $2"
    NS=$2
    ;;
  -u | --uma_namespace)
      echo "uma Namespace $2"
      UMANS=$2
      ;;
  -d | --deployment)
    DEPLOYMENT=$2
    echo "deployment $2"
    ;;
  -p | --pod)
    PD=$2
    echo "Pod $2"
    ;;
  -t | --type)
    TYPE=kubernetes
    TYPE=$2
    echo "type $TYPE"
    ;;
  --)
    #help
    break
    ;;
  esac
  shift
done

mkdir CA_APM 2>/dev/null
cd CA_APM
ERR_FILE=err.log
echo >$ERR_FILE

if [ X"$UMANS" == "X" ]; then
  echo "***uma namespace is default set to dx-uma"
  UMANAMESPACE=dx-uma
else
  echo "***uma namespace is set to $UMANS"
  UMANAMESPACE=$UMANS
fi

if [ X"$TYPE" == "X" ]; then
  KUBECMD=kubectl
  IS_OC=$(oc) 2>> $ERR_FILE
  if [ X"$IS_OC" != "X" ]; then
    KUBECMD=oc
  fi
fi
if [ X"$TYPE" == "Xkubernetes" ]; then
  KUBECMD=kubectl
fi
if [ X"$TYPE" == "Xopenshift" ]; then
  KUBECMD=oc
fi
echo "CLI used is $KUBECMD"
echo >$ERR_FILE

if [ X"$NS" == "X" ] && [ Y"$DEPLOYMENT" == "Y" ] && [ Z"$PD" == "Z" ];  then
  echo "***collecting all uma logs ***"
  getAllUmaLogs
  exit
fi
if [ X"$NS" == "X" ]; then
  echo "****Setting NAMESPACE to ALL"
  NS=ALL
fi
if [ X"$DEPLOYMENT" == "X" ]; then
  if [ X"$PD" == "X" ]; then
    echo "****Setting deployment to ALL"
    DEPLOYMENT=ALL
  fi
fi

#echo "***, Namespace, Node,  POD, container, is_Java, is_wily, is_attach, container_id, Java process details" >$OUTPUT_FILE

if [ X"$NS" == "XALL" ]; then
  NAMESPACES=$($KUBECMD get namespaces | grep -v ingress | grep -v 'dx-uma ' | grep -v openshift | grep -v kube | awk '{print $1}' | grep -v NAME)
else
  NAMESPACES[0]=$NS
fi



for NAMESPACE in $NAMESPACES; do
  echo "*** checking the namespace $NAMESPACE"
  if [ X"$DEPLOYMENT" == "XALL" ]; then
    PODS=$($KUBECMD get pods -n $NAMESPACE -o wide | grep -v NAME | awk '{print $1}')
  elif [ X"$PD" == "X" ]; then
    PODS=$($KUBECMD get pods -n $NAMESPACE -o wide | grep -v NAME | grep $DEPLOYMENT | awk '{print $1}')
  elif [ X"$DEPLOYMENT" == "X" ]; then
    PODS[0]=$PD
  fi

  for POD in $PODS; do

    echo "*** checking the pod $POD"
    NODE=$($KUBECMD get pod $POD -n $NAMESPACE -o wide | grep -v NAME | awk '{print $7}')
    if [ X"$NODE" == "X" ]; then
      echo "Pod not present in this namespace exiting namespace loop"
      continue
    fi

    #CONTAINERS=$($KUBECMD describe pod $POD -n $NAMESPACE | grep -B 1 "Container ID:" | grep -v "Container ID:" | grep -v "\-\-" | sed "s/://g")
    CONTAINERS=$($KUBECMD get pod $POD -n $NAMESPACE -o jsonpath="{.spec['containers','Containers'][*].name}" | sed "s/://g")

    for CONTAINER in $CONTAINERS; do
      echo "***checking the container $CONTAINER"
      CON=$CONTAINER:
      CONTAINER_ID=$($KUBECMD describe pod $POD -n $NAMESPACE | grep -B 1 "$CON" | grep -B 1 "Container ID:" | awk -F"docker://" '{print $2}' | awk -F" " '{print $1}')

      IS_JAVA=$($KUBECMD exec $POD -n $NAMESPACE -c $CONTAINER -- ps -ef | grep java | grep -v grep) #2>> $ERR_FILE
     
      IS_NODEJS=$($KUBECMD exec $POD -n $NAMESPACE -c $CONTAINER -- ps -ef | grep node | grep -v grep) #2>> $ERR_FILE
      
      IS_PHP=$($KUBECMD exec $POD -n $NAMESPACE -c $CONTAINER -- php -i | grep 'PHP Version' | grep -v grep) #2>> $ERR_FILE
      
      IS_NGINX=$($KUBECMD exec $POD -n $NAMESPACE -c $CONTAINER -- nginx -v | grep nginx | grep -v grep) #2>> $ERR_FILE

      if [ X"$IS_JAVA" != "X" ]; then
        IS_WILY=$($KUBECMD exec $POD -n $NAMESPACE -c $CONTAINER -- ls -d /tmp/ca-deps/wily/ | grep "No such file") #2>> $ERR_FILE
        ATTACH_COUNT=$($KUBECMD exec $POD -n $NAMESPACE -c $CONTAINER -- ls -l /tmp/ca-deps/wily/logs/ | wc -l)     #2>> $ERR_FILE

        if [ $ATTACH_COUNT -eq 0 ]; then
          IS_ATTACH="Attach_no"
        else
          IS_ATTACH="Attach_yes"
        fi

        #if [ X"$IS_WILY" == "X" ]; then
         # echo "***, $NAMESPACE, $NODE, $POD, $CONTAINER, Java_yes, Wily_yes, $IS_ATTACH, $CONTAINER_ID, $IS_JAVA" >>$OUTPUT_FILE
        #else
          #echo "***, $NAMESPACE, $NODE, $POD, $CONTAINER, Java_yes, Wily_no, $IS_ATTACH, $CONTAINER_ID, $IS_JAVA" >>$OUTPUT_FILE

        #fi

      #else
        #echo "***, $NAMESPACE, $NODE, $POD, $CONTAINER, Java_no, wily_undefined, $CONTAINER_ID, Attach_undefined" >>$OUTPUT_FILE
      fi

      echo "*** getting appcontainer logs related to $POD from Node $NODE"
      KAFKADS=false
      #add any additional deployments here to like apm-kafka-monitor\|app-monitor\|customdeployment
      Additional_Deployments=apm-kafka-monitor
      APPPODS=$($KUBECMD get pods -n $UMANAMESPACE -o wide | grep -v NAME | grep 'app-container-monitor\|apm-kafka-monitor' | grep $NODE | awk '{print $1}')
      for APPPOD in $APPPODS; do
        CONTAINERS=$($KUBECMD describe pod $APPPOD -n $UMANAMESPACE | grep -B 1 "Container ID:" | grep -v "Container ID:" | grep -v clusterinfo | grep -v "\-\-" | sed "s/://g")

        for CONTAINER in $CONTAINERS; do
          echo "***checking the container $CONTAINER"
          CON=$CONTAINER:

          $(mkdir -p $APPPOD/$CONTAINER 2>/dev/null)

          LOG_FILES=$($KUBECMD exec $APPPOD -n $UMANAMESPACE -c $CONTAINER ls /usr/local/openshift/apmia/logs/ 2>/dev/null)

          for LOG_FILE in $LOG_FILES; do

            echo "****Picking up $LOG_FILE from pod $APPPOD"
            $KUBECMD exec $APPPOD -n $UMANAMESPACE -c $CONTAINER -- cat /usr/local/openshift/apmia/logs/$LOG_FILE >$APPPOD/$CONTAINER/$LOG_FILE
          done
        done


      done
    done
    echo "CA APM KAFKA monitoring daemonset: $KAFKADS"
    if [[ $KAFKADS == "false" ]]; then
              echo "*** collecting logs for kafka deployments $Additional_Deployments"
              getAllUmaLogs
    fi

    if [ X"$IS_NODEJS" != "X" ]  || [ X"$IS_PHP" != "X" ] || [ X"$IS_NGINX" != "X" ]; then
        processAgentProbeLogs $POD $NAMESPACE $NODE $CONTAINER $DEPLOYMENT
    else
        processAutoattachLog $POD $NAMESPACE $NODE $CONTAINER
    fi

  done
done

sleep 2
echo "****share umaLogs.tar with CA/BC"
