{{- define "prometheus.clusterName" }} {{- .Values.monitor.container.prometheus.backend.endPoint.url | replace ":" "_" }} {{- end }}
#{{- define "runtime.info"}} {{ .Values.runtime | default "docker" }} {{- end }}
#| replace ":" "_"

{{/*
Helper template for agentManager credential environment variable
*/}}
{{- define "agentManager.credentialEnv" -}}
{{- if and .Values.agentManager.credentialSecret .Values.agentManager.credentialSecret.enabled }}
        - name: agentManager_credential
          valueFrom:
            secretKeyRef:
              name: "{{ .Values.agentManager.credentialSecret.name }}"
              key: "{{ .Values.agentManager.credentialSecret.key }}"
{{- else if .Values.agentManager.credential }}
        - name: agentManager_credential
          valueFrom:
            configMapKeyRef:
              key: agentManager.credential
              {{- if eq .Values.role "common" }}
              name: caaiops-config-common
              {{- else }}
              name: caaiops-config-{{- .Values.role | default "common" }}{{- .Values.id | default "1" }}
              {{ end }}
{{- end }}
{{- end }}

