/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.service;

import Xnet.XnetRowsetColumn;
import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.utils.CommonUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DB2EditorSQLEngine {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static Logger logger = Logger.getLogger(DB2EditorSQLEngine.class);
    private static String SQL_SELECT = "SELECT ";
    private static String SQL_SELECT_ALL_COLUMNS = " * ";
    private static String SQL_SELECT_FROM = " FROM ";
    private static String SQL_SELECT_WHERE = " WHERE ";
    private static String SQL_SELECT_ORDER = " ORDER BY ";
    private static String SQL_SELECT_AND = " AND ";
    private static String SQL_SELECT_LIKE = " LIKE ";
    public static String SYSSTOGROUP = "SYSIBM.SYSSTOGROUP";
    public static String SYSDATABASE = "SYSIBM.SYSDATABASE";
    public static String SYSTABLESPACE = "SYSIBM.SYSTABLESPACE";
    public static String SYSTABLES = "SYSIBM.SYSTABLES";
    public static String SYSVIEWS = "SYSIBM.SYSVIEWS";
    public static String SYSSYNONYMS = "SYSIBM.SYSSYNONYMS";
    public static String SYSCOLUMNS = "SYSIBM.SYSCOLUMNS";
    public static String OBJECT_TYPE_SG = "Storage Group";
    public static String OBJECT_TYPE_DB = "Database";
    public static String OBJECT_TYPE_TS = "Tablespace";
    public static String OBJECT_TYPE_T = "Table";
    public static String OBJECT_TYPE_VW = "Views";
    public static String OBJECT_TYPE_SY = "Synonyms";
    public static String OBJECT_TYPE_AL = "Alias";
    public static int DB2_SYSTABLES_NAME_COLNO = 0;
    public static int DB2_SYSTABLES_CREATOR_COLNO = 1;
    public static int DB2_SYSTABLES_TYPE_COLNO = 2;
    public static int DB2_SYSTABLES_DBNAME_COLNO = 3;
    public static int DB2_SYSDATABASE_DBNAME_COLNO = 0;
    public static int DB2_SYSVIEWS_NAME_COLNO = 0;
    public static int DB2_SYSVIEWS_CREATOR_COLNO = 1;
    public static int DB2_SYSSYNONYMS_NAME_COLNO = 0;
    public static int DB2_SYSSYNONYMS_CREATOR_COLNO = 1;
    public static String DB2_DATATYPE_CHAR = "CHAR";
    public static String DB2_DATATYPE_VARCHAR = "VARCHAR";
    public static String DB2_DATATYPE_TIMESTAMP = "TIMESTAMP";
    public static String DB2_DATATYPE_INTEGER = "INTEGER";
    public static String DB2_DATATYPE_SMALLINT = "SMALLINT";
    public static String DB2_DATATYPE_DECIMAL = "DECIMAL";
    String catalogSpecificType;
    String sql;
    String columnNameList = "";

    public String getCatalogueTable(String tableName) {
        String returnValue = null;
        if (tableName.equals(OBJECT_TYPE_SG)) {
            returnValue = SYSSTOGROUP;
        } else if (tableName.equals(OBJECT_TYPE_DB)) {
            returnValue = SYSDATABASE;
        } else if (tableName.equals(OBJECT_TYPE_TS)) {
            returnValue = SYSTABLESPACE;
        } else if (tableName.equals(OBJECT_TYPE_T)) {
            returnValue = SYSTABLES;
        } else if (tableName.equals(OBJECT_TYPE_VW)) {
            returnValue = SYSTABLES;
        } else if (tableName.equals(OBJECT_TYPE_AL)) {
            returnValue = SYSTABLES;
        } else if (tableName.equals(OBJECT_TYPE_SY)) {
            returnValue = SYSSYNONYMS;
        }
        return returnValue;
    }

    public String getQueryForOrderColumnsRetrieval(String tableName, String creatorName) throws Exception {
        if (tableName == null) {
            throw new Exception("Invalid table name supplied");
        }
        String tName = this.getCatalogueTable(tableName);
        if (tName == null) {
            tName = tableName;
        } else {
            int index = tName.indexOf(46);
            if (creatorName == null) {
                creatorName = tName.substring(0, index);
            }
            tName = tName.substring(index + 1);
        }
        String sql = "";
        sql = String.valueOf(sql) + SQL_SELECT + " NAME,COLTYPE " + SQL_SELECT_FROM + " SYSIBM.SYSCOLUMNS " + SQL_SELECT_WHERE;
        sql = String.valueOf(sql) + "TBNAME=" + "'" + CommonUtils.escapeSpecialCharacters(tName) + "'";
        if (creatorName != null) {
            sql = String.valueOf(sql) + SQL_SELECT_AND + "TBCREATOR=" + "'" + CommonUtils.escapeSpecialCharacters(creatorName) + "'";
        }
        sql = String.valueOf(sql) + " order by COLNO";
        return sql;
    }

    public String getSELECTSQLForCatalogueTable(String TableName, String ObjectName, String CreatorName, String WhereClause, String[] OrderBy) {
        String sql = null;
        boolean whereClauseAdded = false;
        String tableName = this.getCatalogueTable(TableName);
        sql = SQL_SELECT;
        sql = this.addColumns(sql, tableName);
        sql = String.valueOf(sql) + SQL_SELECT_FROM + tableName;
        if (tableName.equals(SYSTABLES)) {
            if (ObjectName != null && ObjectName.length() > 0) {
                sql = String.valueOf(sql) + SQL_SELECT_WHERE + this.getObjectColumnName(TableName);
                sql = ObjectName.contains("%") ? String.valueOf(sql) + SQL_SELECT_LIKE + "'" + ObjectName + "'" : String.valueOf(sql) + "='" + ObjectName + "'";
                whereClauseAdded = true;
            }
            if (CreatorName != null && CreatorName.length() > 0) {
                CreatorName = CreatorName.toUpperCase();
                if (whereClauseAdded) {
                    sql = String.valueOf(sql) + SQL_SELECT_AND;
                    sql = CreatorName.contains("%") ? String.valueOf(sql) + "UPPER(CREATOR) " + SQL_SELECT_LIKE + "'" + CreatorName + "'" : String.valueOf(sql) + "UPPER(CREATOR) ='" + CreatorName + "'";
                } else {
                    sql = String.valueOf(sql) + SQL_SELECT_WHERE;
                    sql = CreatorName.contains("%") ? String.valueOf(sql) + "UPPER(CREATOR)" + SQL_SELECT_LIKE + "'" + CreatorName + "'" : String.valueOf(sql) + "UPPER(CREATOR) ='" + CreatorName + "'";
                    whereClauseAdded = true;
                }
            }
            if (WhereClause != null && WhereClause.length() > 0) {
                if (whereClauseAdded) {
                    sql = String.valueOf(sql) + SQL_SELECT_AND + WhereClause;
                } else {
                    sql = String.valueOf(sql) + SQL_SELECT_WHERE + WhereClause;
                    whereClauseAdded = true;
                }
            }
            if (whereClauseAdded) {
                sql = String.valueOf(sql) + SQL_SELECT_AND + "TYPE <> 'A'" + SQL_SELECT_AND + "TYPE <> 'V'";
            } else {
                sql = String.valueOf(sql) + SQL_SELECT_WHERE + "TYPE <> 'A'" + SQL_SELECT_AND + "TYPE <> 'V'";
                whereClauseAdded = true;
            }
            if (OrderBy != null && OrderBy.length > 0) {
                sql = String.valueOf(sql) + SQL_SELECT_ORDER;
                int i = 0;
                while (i < OrderBy.length) {
                    sql = String.valueOf(sql) + OrderBy[i];
                    if (i + 1 < OrderBy.length) {
                        sql = String.valueOf(sql) + ",";
                    }
                    ++i;
                }
            } else {
                sql = String.valueOf(sql) + SQL_SELECT_ORDER + " NAME ";
            }
        }
        return sql;
    }

    private String addColumns(String SQL, String tableName) {
        if (tableName.equals(SYSTABLES) || tableName.equals(SYSSYNONYMS)) {
            SQL = String.valueOf(SQL) + " NAME, CREATOR, TYPE ";
        } else if (tableName.equals(SYSDATABASE)) {
            SQL = String.valueOf(SQL) + " NAME ";
        }
        return SQL;
    }

    public String getSQL(String TableName, String ObjectName, String CreatorName, String WhereClause, String[] OrderBy, List<ColumnModel> columns) {
        ArrayList<String> columnList = new ArrayList<String>(columns.size());
        for (ColumnModel model : columns) {
            columnList.add(model.getName());
        }
        return this.getSQLFor(TableName, ObjectName, CreatorName, WhereClause, OrderBy, columnList);
    }

    public String getSQLFor(String TableName, String ObjectName, String CreatorName, String WhereClause, String[] OrderBy, List<String> columnList) {
        boolean whereClauseAdded = false;
        String tableName = this.getCatalogueTable(TableName);
        if (tableName == null) {
            tableName = TableName;
        }
        tableName = this.reformatTableNameAndCreator(tableName);
        this.sql = columnList == null ? String.valueOf(SQL_SELECT) + SQL_SELECT_ALL_COLUMNS + SQL_SELECT_FROM + tableName : String.valueOf(SQL_SELECT) + this.getColumnNamesAsString(columnList) + SQL_SELECT_FROM + tableName;
        if (ObjectName != null && ObjectName.length() > 0) {
            this.sql = String.valueOf(this.sql) + SQL_SELECT_WHERE + this.getObjectColumnName(TableName);
            this.sql = ObjectName.contains("%") ? String.valueOf(this.sql) + SQL_SELECT_LIKE + "'" + ObjectName + "'" : String.valueOf(this.sql) + "='" + ObjectName + "'";
            whereClauseAdded = true;
        }
        if (CreatorName != null && CreatorName.length() > 0) {
            if (whereClauseAdded) {
                this.sql = String.valueOf(this.sql) + SQL_SELECT_AND;
                this.sql = CreatorName.contains("%") ? String.valueOf(this.sql) + "CREATOR " + SQL_SELECT_LIKE + "'" + CreatorName + "'" : String.valueOf(this.sql) + "CREATOR ='" + CreatorName + "'";
            } else {
                this.sql = String.valueOf(this.sql) + SQL_SELECT_WHERE;
                this.sql = CreatorName.contains("%") ? String.valueOf(this.sql) + "CREATOR " + SQL_SELECT_LIKE + "'" + CreatorName + "'" : String.valueOf(this.sql) + "CREATOR ='" + CreatorName + "'";
                whereClauseAdded = true;
            }
        }
        if (WhereClause != null && WhereClause.length() > 0) {
            if (whereClauseAdded) {
                this.sql = String.valueOf(this.sql) + SQL_SELECT_AND + WhereClause;
            } else {
                this.sql = String.valueOf(this.sql) + SQL_SELECT_WHERE + WhereClause;
                whereClauseAdded = true;
            }
        }
        if (this.getCatalogueTable(TableName) != null) {
            if (TableName.equals("Table")) {
                this.catalogSpecificType = "TYPE NOT IN ('A','V')";
            } else if (TableName.equals("Views")) {
                this.catalogSpecificType = "TYPE = 'V'";
            } else if (TableName.equals("Alias")) {
                this.catalogSpecificType = "TYPE = 'A'";
            }
        }
        if (this.catalogSpecificType != null) {
            if (whereClauseAdded) {
                this.sql = String.valueOf(this.sql) + SQL_SELECT_AND + this.catalogSpecificType;
            } else {
                this.sql = String.valueOf(this.sql) + SQL_SELECT_WHERE + this.catalogSpecificType;
                whereClauseAdded = true;
            }
        }
        if (OrderBy != null && OrderBy.length > 0) {
            this.sql = String.valueOf(this.sql) + SQL_SELECT_ORDER;
            int i = 0;
            while (i < OrderBy.length) {
                this.sql = String.valueOf(this.sql) + OrderBy[i];
                if (i + 1 < OrderBy.length) {
                    this.sql = String.valueOf(this.sql) + ",";
                }
                ++i;
            }
        } else if (this.getCatalogueTable(TableName) != null && this.getCatalogueTable(TableName).equals(SYSTABLES)) {
            this.sql = String.valueOf(this.sql) + SQL_SELECT_ORDER + " NAME ";
        }
        return this.sql;
    }

    public String getObjectColumnName(String tableName) {
        return " NAME ";
    }

    public String getColumnPropertiesSQL(String columnName, String tbName, String tbCreator) {
        String sql = null;
        sql = String.valueOf(SQL_SELECT) + SQL_SELECT_ALL_COLUMNS + SQL_SELECT_FROM + SYSCOLUMNS + SQL_SELECT_WHERE + "NAME='" + columnName + "' " + SQL_SELECT_AND + "TBNAME='" + CommonUtils.escapeSpecialCharacters(tbName) + "' " + SQL_SELECT_AND + "TBCREATOR='" + CommonUtils.escapeSpecialCharacters(tbCreator) + "' ";
        return sql;
    }

    private String appendValue(String SQL, String nValue, String colType) {
        String sql = null;
        sql = colType.equals(DB2_DATATYPE_CHAR) || colType.equals(DB2_DATATYPE_VARCHAR) || colType.equals(DataType.DATE.toString()) ? String.valueOf(SQL) + "'" + nValue + "' " : String.valueOf(SQL) + nValue + " ";
        return sql;
    }

    private String appendValueXnetType(String SQL, String nValue, String colType) {
        String sql = null;
        int columnType = 0;
        try {
            columnType = Integer.parseInt(colType);
            if (columnType != 0) {
                sql = columnType == XnetRowsetColumn.CHAR || columnType == XnetRowsetColumn.CHAR + XnetRowsetColumn.NULLS ? String.valueOf(SQL) + " '" + nValue + "' " : (columnType == XnetRowsetColumn.VC254 || columnType == XnetRowsetColumn.VC254 + XnetRowsetColumn.NULLS ? String.valueOf(SQL) + " '" + nValue + "' " : (columnType == XnetRowsetColumn.DATE || columnType == XnetRowsetColumn.DATE + XnetRowsetColumn.NULLS ? String.valueOf(SQL) + " '" + nValue + "' " : String.valueOf(SQL) + " " + nValue + " "));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to build SQL. SQLENgine:AppendValueXnetType():" + colType + ",invalid type."), (Throwable)e);
        }
        return sql;
    }

    public String getSQLForColumnTypes(String tableName, String creator) {
        String sql = String.valueOf(SQL_SELECT) + "NAME,COLTYPE" + SQL_SELECT_FROM + SYSCOLUMNS + SQL_SELECT_WHERE + "TBNAME = '" + CommonUtils.escapeSpecialCharacters(tableName) + "' " + SQL_SELECT_AND + "TBCREATOR = '" + CommonUtils.escapeSpecialCharacters(creator) + "' " + SQL_SELECT_ORDER + "COLNO";
        return sql;
    }

    public String getColumnNamesAsString(List<String> columnList) {
        this.columnNameList = "";
        int j = 0;
        while (j < columnList.size()) {
            String currentColumnName = columnList.get(j);
            if (currentColumnName.contains(" ")) {
                currentColumnName = "\"" + currentColumnName + "\"";
            }
            this.columnNameList = String.valueOf(this.columnNameList) + "\r\n\t " + currentColumnName;
            if (j < columnList.size() - 1) {
                this.columnNameList = String.valueOf(this.columnNameList) + ",";
            }
            ++j;
        }
        return String.valueOf(this.columnNameList) + "\r\n";
    }

    public String reformatTableNameAndCreator(String tableName) {
        tableName = "\"" + tableName.replace(".", "\".\"") + "\"";
        return tableName;
    }
}

