/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.common.Context;
import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.CommonBundle;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.widgets.DataSourceExplorer;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;

public class SqlIdAction
extends BaseAction {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final Logger logger = Logger.getLogger(SqlIdAction.class);
    private InputDialog inputDialog;
    private DataSourceExplorer explorer;

    public SqlIdAction(DataSourceExplorer explorer) {
        super(CommonBundle.SQLID);
        this.explorer = explorer;
        this.setToolTipText(CommonBundle.SQLID);
        this.setImageDescriptor(Images.SQLID);
    }

    @Override
    public void execute() {
        final String initialValue = Context.getInstance().getSQLID("DSE");
        this.inputDialog = new InputDialog(null, CommonBundle.SQLID_INPUT_DIALOG_TITLE, CommonBundle.SQLID_INPUT_DIALOG_MSG, initialValue, new IInputValidator(){

            public String isValid(String s) {
                if (s == initialValue) {
                    return initialValue;
                }
                if (s.trim().isEmpty()) {
                    return CommonBundle.SQLID_ERROR_MSG;
                }
                return null;
            }
        });
        int returnCode = this.inputDialog.open();
        if (returnCode == 0 && this.inputDialog.getValue() != null && !this.inputDialog.getValue().isEmpty()) {
            Context.getInstance().setSQLID("DSE", this.inputDialog.getValue());
            Context.getInstance().setActiveSQLID(this.inputDialog.getValue());
            logger.info((Object)("SQLID set:" + this.inputDialog.getValue()));
        }
    }

    @Override
    public void updateUI() {
        this.setEnabled(this.explorer.getRoot() != null && !this.explorer.getRoot().getLparNodes().isEmpty());
    }
}

