/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.model.RowModel;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.utils.DataTypeUtils;
import com.ca.db2.editor.ui.utils.DateTimeUtil;
import com.ca.db2.editor.ui.utils.TableSorter;
import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.TableColumn;

public class DWColumnSorter {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final Logger logger = Logger.getLogger(DWColumnSorter.class);
    private TableViewer viewer;
    private int columnIndex;
    private String dateformat;
    private ColumnModel model;
    private String NULL_TEXT = DWBundle.NULL_VALUE_TEXT;
    private String DEFAULT = "default";

    public DWColumnSorter(ObjectIdentity identity, TableViewer viewer, TableColumn column, int columnIndex, ColumnModel model) {
        this.viewer = viewer;
        this.columnIndex = columnIndex;
        this.dateformat = CommonUtils.getDateFormat(identity.getSsid());
        this.model = model;
        TableSorter sorter = new TableSorter(viewer, column){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return DWColumnSorter.this.compare(e1, e2);
            }
        };
    }

    private int compare(Object e1, Object e2) {
        int returnValue = 0;
        ITableLabelProvider labelProvider = (ITableLabelProvider)this.viewer.getLabelProvider();
        String val1 = labelProvider.getColumnText(e1, this.columnIndex);
        String val2 = labelProvider.getColumnText(e2, this.columnIndex);
        RowModel rowModel1 = (RowModel)e1;
        RowModel rowModel2 = (RowModel)e2;
        if (rowModel1.isAddableRow() || rowModel2.isAddableRow()) {
            int sortDirection = this.viewer.getTable().getSortDirection();
            if (sortDirection == 1024) {
                return rowModel1.isAddableRow() ? 1 : -1;
            }
            if (sortDirection == 128) {
                return rowModel1.isAddableRow() ? -1 : 1;
            }
            return 1;
        }
        if (this.model.isAutoGeneratedColumn() && (val1.equals(this.DEFAULT) || val2.equals(this.DEFAULT))) {
            if (!val1.equals(this.DEFAULT) || !val2.equals(this.DEFAULT)) {
                return val1.equals(this.NULL_TEXT) ? 1 : -1;
            }
        } else if (this.model.isNullable() && (val1.equals(this.NULL_TEXT) || val2.equals(this.NULL_TEXT))) {
            if (!val1.equals(this.NULL_TEXT) || !val2.equals(this.NULL_TEXT)) {
                returnValue = val1.equals(this.NULL_TEXT) ? 1 : -1;
            }
        } else if (DataTypeUtils.isNumeric(this.model.getColType())) {
            int b;
            int a = Integer.parseInt(val1);
            returnValue = a < (b = Integer.parseInt(val2)) ? -1 : 1;
        } else if (DataTypeUtils.isChar(this.model.getColType()) || DataTypeUtils.isVarChar(this.model.getColType()) || DataTypeUtils.isTimestamp(this.model.getColType())) {
            returnValue = val1.compareTo(val2);
        } else if (DataTypeUtils.isVarChar(this.model.getColType()) || DataTypeUtils.isVarChar(this.model.getColType()) || DataTypeUtils.isTimestamp(this.model.getColType())) {
            returnValue = val1.compareTo(val2);
        } else if (DataTypeUtils.isDecimal(this.model.getColType())) {
            double b;
            double a = Double.parseDouble(val1);
            returnValue = a < (b = Double.parseDouble(val2)) ? -1 : 1;
        } else if (DataTypeUtils.isFloat(this.model.getColType())) {
            float b;
            float a = Float.parseFloat(val1);
            returnValue = a < (b = Float.parseFloat(val2)) ? -1 : 1;
        } else if (DataTypeUtils.isSmallInt(this.model.getColType())) {
            short b;
            short a = Short.parseShort(val1);
            returnValue = a < (b = Short.parseShort(val2)) ? -1 : 1;
        } else if (DataTypeUtils.isBigInt(this.model.getColType())) {
            BigInteger a = new BigInteger(val1, 16);
            BigInteger b = new BigInteger(val2, 16);
            returnValue = a.doubleValue() < b.doubleValue() ? -1 : 1;
        } else if (DataTypeUtils.isDecimal(this.model.getColType())) {
            double b;
            double a = Double.parseDouble(val1);
            returnValue = a < (b = Double.parseDouble(val2)) ? -1 : 1;
        } else if (DataTypeUtils.isDate(this.model.getColType())) {
            try {
                return DateTimeUtil.getDate(this.dateformat, val1).compareTo(DateTimeUtil.getDate(this.dateformat, val2));
            }
            catch (Exception e) {
                logger.error((Object)e);
                returnValue = val1.compareTo(val2);
            }
        } else if (DataTypeUtils.isTime(this.model.getColType())) {
            try {
                return DateTimeUtil.getSystemTime(val1).compareTo(DateTimeUtil.getSystemTime(val2));
            }
            catch (Exception e) {
                logger.error((Object)e);
                returnValue = val1.compareTo(val2);
            }
        } else if (DataTypeUtils.isTimeSTZ(this.model.getColType())) {
            try {
                return DateTimeUtil.getSystemTimestampTZ(val1, (short)1).compareTo(DateTimeUtil.getSystemTimestampTZ(val2, (short)1));
            }
            catch (Exception e) {
                logger.error((Object)e);
                returnValue = val1.compareTo(val2);
            }
        }
        return returnValue;
    }
}

