/***********************************************************************

Copyright (c) 2017 CA, All rights reserved.

This software and all information contained therein is confidential and
proprietary and shall not be duplicated, used, disclosed or disseminated
in any way except as authorized by the applicable license agreement,
without the express written permission of CA ("CA"). All authorized
reproductions must be marked with this language.

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT
PERMITTED BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY
OF ANY KIND, INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL
CA BE LIABLE TO THE END USER OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE,
DIRECT OR INDIRECT, FROM THE USE OF THIS SOFTWARE, INCLUDING WITHOUT
LIMITATION, LOST PROFITS, BUSINESS INTERRUPTION, GOODWILL, OR LOST DATA,
EVEN IF CA IS EXPRESSLY ADVISED OF SUCH LOSS OR DAMAGE.

***********************************************************************/
package com.ca.filemaster.dsnlists.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

import com.ca.filemaster.dsnlists.view.DSNListView;
/**
 * @author galpe02
 *
 */

public class ExpandCollapseNodeHandler extends AbstractHandler {
    static String cacopyright = "Copyright (c) 2017 CA";


	public Object execute(final ExecutionEvent event) throws ExecutionException {
		final boolean parm  = Boolean.parseBoolean(event.getParameter("com.ca.filemaster.dsnlists.commands.expand"));
		final boolean all  = Boolean.parseBoolean(event.getParameter("com.ca.filemaster.dsnlists.commands.expandall"));
		final IWorkbenchPart part = HandlerUtil.getActivePart(event);
		char character = ((Event)event.getTrigger()).character;
		if (part instanceof DSNListView) {
			final TreeViewer viewer = ((DSNListView) part).getViewer();
			final ISelection sel = HandlerUtil.getCurrentSelection(event);
			if ((!all) && (sel instanceof IStructuredSelection) && !sel.isEmpty()){
				final IStructuredSelection selection = (IStructuredSelection) sel;
				for (final Object selected : selection.toArray()){
					doIt(selected, viewer, parm, all, character);
				}
			} else {
				doIt(null, viewer, parm, all, character);
			}
		}
		return null;
	}

	private void doIt(final Object selected, final TreeViewer viewer, final boolean parm, boolean all, char c) {
		if (selected == null || c == '/' || c == '*')
			all = true;
		if (parm){
			if (all)
				viewer.expandAll();
			else
				viewer.expandToLevel(selected, AbstractTreeViewer.ALL_LEVELS);
		} else {
			if (all && c == '*')
				viewer.expandAll();
			else if (all)
				viewer.collapseAll();
			else
				viewer.collapseToLevel(selected, AbstractTreeViewer.ALL_LEVELS);
		}		
	}

}
