/**
 * Copyright (c) 2017 CA, All rights reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.filemaster.dsnlists.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import com.ca.filemaster.common.FMDSNListTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.testingtools.core.TT_TreeItem;
/**
 * @author galpe02
 *
 */



public class AddDSNListWizard extends Wizard implements INewWizard{
	private AddDSNListWizardPage page1;
	private FMDSNListTreeModel dsnlistModel = FMDSNListTreeModel.getInstance();
	private boolean isDSNListTreeItem = false;
	private FileMasterServer server;
	private FileMasterDataset dataset;
	private FileMasterMember member;
	
	public AddDSNListWizard(){
		setWindowTitle("Add DSN List"); 
	}
	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		Object object = selection.getFirstElement();
		if (object != null) {
			TT_TreeItem treeItem = dsnlistModel.findObject(object);
			isDSNListTreeItem = true;
			if (treeItem != null) {
				if (isDSNListTreeItem) {
					server = null;
					if (treeItem.getParent() != null) {

						member = (FileMasterMember) treeItem
								.getAdapter(FileMasterMember.class);
						dataset = (FileMasterDataset) treeItem.getParent()
								.getAdapter(FileMasterDataset.class);

					} else {
						member = null;
						dataset = (FileMasterDataset) treeItem
								.getAdapter(FileMasterDataset.class);
					}
				}
		}else {
			member = null;
			dataset = null;
			server = null;
		}
		}
		
	}
public void addPages() {
	String datasetName = "";
	String memberName = "";

	if (dataset != null) {
		datasetName = dataset.getName();

	}
	if (member != null) {
		memberName = member.getName();

	}
		page1 = new AddDSNListWizardPage("Add DSN List",server,datasetName,memberName,false);
		addPage(page1);
	}
	@Override
	public boolean performFinish() {
		return (page1).doFinish();
	}
	
	@Override
	public boolean canFinish() {
		// TODO Auto-generated method stub
		return page1.canFinish();
	}

}
