/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.handlers;

import com.ca.filemaster.ConfigureMFsettingVariableList;
import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.editor.ui.wizards.EditorWizard;
import com.ca.filemaster.runners.RunSetConfigureSetting;
import com.ca.filemaster.ui.wizards.AddServerPage;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class OpenEditorWithOptionHandler
extends AbstractHandler
implements IElementUpdater {
    static final String cacopyright = "Copyright (c) 2017 CA";
    private static final FMServerTreeModel model = FMServerTreeModel.getInstance();
    private AddServerPage addServerPage = new AddServerPage();
    private Text jobInformationText;
    private final Logger logger = Logger.getLogger(OpenEditorWithOptionHandler.class.getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TT_TreeItem item;
        TT_TreeItem serverItem;
        TTServer server;
        this.logger.log(Level.INFO, "Opening 'Open Data Set' wizard");
        EditorWizard wizard = new EditorWizard();
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        this.jobInformationText = new Text((Composite)window.getShell(), 0);
        IWorkbench workbench = window.getWorkbench();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            selection = null;
        }
        if (!(server = (TTServer)(serverItem = (item = ((TT_TreeItem)((IStructuredSelection)selection).getFirstElement()).getParent()).getParent(TTServer.class)).getValue()).getStatusText().equals("Active")) {
            MessageDialog.openError(null, (String)"Server Not Active Error", (String)"The server is not active.");
            return null;
        }
        if (serverItem.getServer().getStatusText().equalsIgnoreCase("Active")) {
            String returnCode;
            ConfigureMFsettingVariableList configureVariableList = new ConfigureMFsettingVariableList();
            if (serverItem.getElement().getAttribute("PreferenceIsSet").equalsIgnoreCase("Y")) {
                configureVariableList.setPreferencescalltype("U");
                this.updateValuesForSetPreference((FileMasterServer)serverItem.getServer(), configureVariableList);
            } else if (serverItem.getElement().getAttribute("PreferenceIsSet").equalsIgnoreCase("N")) {
                configureVariableList.setPreferencescalltype("I");
            }
            RunSetConfigureSetting runner = new RunSetConfigureSetting((FileMasterServer)serverItem.getServer(), configureVariableList);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
            XMLRequest XmlRespond = runner.getXml();
            if (XmlRespond != null && ((returnCode = XmlRespond.getRoot().getAttribute("errorlevel")).equalsIgnoreCase("32") || returnCode.equalsIgnoreCase("16"))) {
                return null;
            }
            if (runner.getXml() != null) {
                ConfigureMFsettingVariableList configureMFsettingVariableList = this.addServerPage.setPreferance(runner);
                this.addServerPage.updateFMServerTreeModel(server, configureMFsettingVariableList, model);
                model.updateserver(server.getElement(), server, "Y");
                model.save();
            } else {
                return null;
            }
        }
        wizard.init(workbench, (IStructuredSelection)selection);
        if (wizard.getDataSet().getDsType().equalsIgnoreCase("N")) {
            MessageDialog.openError(null, (String)"Data Set Not Supported", (String)"Linear data set not supported.");
            return null;
        }
        Shell shell = window.getShell();
        TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(shell, (IWizard)wizard);
        if (!wizard.getDataSet().getVolume().equalsIgnoreCase("ARCIVE") && (CommonMFCalls.RETURN_CODE.equals("0") || CommonMFCalls.RETURN_CODE.equals(""))) {
            dialog.create();
            dialog.open();
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
    }

    private void updateValuesForSetPreference(FileMasterServer server, ConfigureMFsettingVariableList configureVariableList) {
        if (server.getFmpPreferences().getFmDefaultPrefs().isConfirmDeleteMember()) {
            configureVariableList.setDeleteMember(true);
        } else {
            configureVariableList.setDeleteMember(false);
        }
        if (server.getFmpPreferences().getFmDefaultPrefs().isConfirmDeleteDataset()) {
            configureVariableList.setDeleteDataset(true);
        } else {
            configureVariableList.setDeleteDataset(false);
        }
        if (server.getFmpPreferences().getFmDefaultPrefs().isUseDasdUnit()) {
            configureVariableList.setWorkSpaceallocationName("DASDUnitName");
            configureVariableList.setWorkSpaceallocationvalue(server.getFmpPreferences().getFmDefaultPrefs().getDASD_UNIT());
        } else {
            configureVariableList.setWorkSpaceallocationName("SMSStorageClass");
            configureVariableList.setWorkSpaceallocationvalue(server.getFmpPreferences().getFmDefaultPrefs().getSMS_Storage());
        }
        configureVariableList.setSizeCylinders(server.getFmpPreferences().getFmDefaultPrefs().getSizeInCYL());
        if (server.getElement().getElementsByTagName("JCL").getLength() > 0) {
            this.jobInformationText.setText(server.getElement().getElementsByTagName("JCL").item(0).getTextContent());
        }
        String jobCardFiller = new String("                                                                        ");
        String[] jobCard = this.jobInformationText.getText().split(this.jobInformationText.getLineDelimiter());
        int i = 0;
        while (i < jobCard.length) {
            String[] jobCardSplit = jobCard[i].split("'");
            if (jobCardSplit.length == 1) {
                jobCard[i] = jobCard[i].toUpperCase();
            } else {
                int j = 0;
                while (j < jobCardSplit.length) {
                    jobCardSplit[j] = jobCardSplit[j].toUpperCase();
                    j += 2;
                }
                jobCard[i] = "";
                j = 0;
                while (j < jobCardSplit.length) {
                    int n = i;
                    jobCard[n] = String.valueOf(jobCard[n]) + jobCardSplit[j] + "'";
                    ++j;
                }
                jobCard[i] = jobCard[i].substring(0, jobCard[i].length() - 1);
            }
            int n = i;
            jobCard[n] = String.valueOf(jobCard[n]) + jobCardFiller.substring(0, 70 - jobCard[i].length() + 2);
            ++i;
        }
        configureVariableList.setJobCard(jobCard);
        configureVariableList.setDsnList(server.getFmpPreferences().getFmParmFilePrefs().getDSNLists());
        configureVariableList.setSelCriteriaField(server.getFmpPreferences().getFmParmFilePrefs().getSelectionCriteria());
        configureVariableList.setReformatControl(server.getFmpPreferences().getFmParmFilePrefs().getReformatControl());
        configureVariableList.setCusRecordLayout(server.getFmpPreferences().getFmParmFilePrefs().getCustomerRecordLayout());
        configureVariableList.setNewDSN(server.getFmpPreferences().getFmChangeLogPrefs().getChangeLog_DSN());
        if (server.getFmpPreferences().getFmChangeLogPrefs().isUseVolSer()) {
            configureVariableList.setStorageName("ChangeLogVolser");
            configureVariableList.setStorageValue(server.getFmpPreferences().getFmChangeLogPrefs().getVolume_Serial());
        } else {
            configureVariableList.setStorageName("ChangeLogUnit");
            configureVariableList.setStorageValue(server.getFmpPreferences().getFmChangeLogPrefs().getGeneric_Unit());
        }
        configureVariableList.setPrimaryAllocation(Integer.toString(server.getFmpPreferences().getFmChangeLogPrefs().getPrimaryAlloc()));
        configureVariableList.setSecondaryAllocation(Integer.toString(server.getFmpPreferences().getFmChangeLogPrefs().getSecondaryAlloc()));
        configureVariableList.setSysoutClass(server.getFmpPreferences().getFmPrintPrefs().getSysoutClass());
        configureVariableList.setNumberOfCopies(Integer.toString(server.getFmpPreferences().getFmPrintPrefs().getNoCopies()));
        if (server.getFmpPreferences().getFmPrintPrefs().getPrintDestSel() == 1) {
            configureVariableList.setPrintDestination1(server.getFmpPreferences().getFmPrintPrefs().getDestPrinter());
            configureVariableList.setPrintDesSelection(server.getFmpPreferences().getFmPrintPrefs().getPrintDestSel());
        }
        if (server.getFmpPreferences().getFmPrintPrefs().getPrintDestSel() == 2) {
            configureVariableList.setPrintDestination1(server.getFmpPreferences().getFmPrintPrefs().getExtJESNode());
            configureVariableList.setPrintDestination2(server.getFmpPreferences().getFmPrintPrefs().getUserJESNode());
            configureVariableList.setPrintDesSelection(server.getFmpPreferences().getFmPrintPrefs().getPrintDestSel());
        }
        if (server.getFmpPreferences().getFmPrintPrefs().getPrintDestSel() == 3) {
            configureVariableList.setPrintDestination1(server.getFmpPreferences().getFmPrintPrefs().getSysoutWriter());
            configureVariableList.setPrintDesSelection(server.getFmpPreferences().getFmPrintPrefs().getPrintDestSel());
        }
        if (server.getFmpPreferences().getFmPrintPrefs().getPrintDestSel() == 4) {
            configureVariableList.setPrintDestination1(server.getFmpPreferences().getFmPrintPrefs().getPrintDSN());
            configureVariableList.setPrintDestination2(server.getFmpPreferences().getFmPrintPrefs().getPrintMember());
            configureVariableList.setDisPosition(server.getFmpPreferences().getFmPrintPrefs().getDataSetDisposition());
            configureVariableList.setPrintDesSelection(server.getFmpPreferences().getFmPrintPrefs().getPrintDestSel());
        }
        if (server.getFmpPreferences().getFmPrintPrefs().getPrintDestSel() == 0) {
            configureVariableList.setPrintDesSelection(server.getFmpPreferences().getFmPrintPrefs().getPrintDestSel());
        }
    }
}

