/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.pricommands.wizards;

import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class InsertRecordsWizardPage
extends WizardPage {
    public static final String CONTEXT_HELP_ID = "com.ca.filemaster.help.insertLineCommand";
    private Composite container;
    protected FileMasterServer server;
    protected String uuid;
    protected String displayMode;
    protected String hexMode;
    private Spinner spnNumberOfRecords;
    private Spinner spnRecordLength;
    private Button btnAfter;
    private Button btnBefore;
    private int recordLength;
    private String error = "";

    public InsertRecordsWizardPage(String pageName, FileMasterServer server, String uuid, String displayMode, String hexMode, int recordLength) {
        super(pageName);
        this.setTitle("Insert Records");
        this.server = server;
        this.uuid = uuid;
        this.displayMode = displayMode;
        this.hexMode = hexMode;
        this.recordLength = recordLength;
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_HELP_ID);
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(2, false));
        this.btnAfter = new Button(this.container, 16);
        this.btnAfter.setSelection(true);
        this.btnAfter.setText("&After current record");
        this.btnBefore = new Button(this.container, 16);
        this.btnBefore.setText("&Before current record");
        Label lblNumberOfRecords = new Label(this.container, 0);
        lblNumberOfRecords.setText("&Number of records:");
        this.spnNumberOfRecords = new Spinner(this.container, 2048);
        this.spnNumberOfRecords.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spnNumberOfRecords.setMinimum(1);
        this.spnNumberOfRecords.setMaximum(999);
        this.spnNumberOfRecords.setTextLimit(3);
        Label lblRecordLength = new Label(this.container, 0);
        lblRecordLength.setText("&Record length:");
        this.spnRecordLength = new Spinner(this.container, 2048);
        this.spnRecordLength.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spnRecordLength.setMaximum(Integer.MAX_VALUE);
        this.spnRecordLength.setEnabled(false);
        this.spnRecordLength.setSelection(this.recordLength);
        this.spnRecordLength.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    if (Integer.valueOf(InsertRecordsWizardPage.this.spnRecordLength.getText()) > InsertRecordsWizardPage.this.spnRecordLength.getMaximum() || Integer.valueOf(InsertRecordsWizardPage.this.spnRecordLength.getText()) < InsertRecordsWizardPage.this.spnRecordLength.getMinimum()) {
                        InsertRecordsWizardPage.this.error = "Record length must be in between " + InsertRecordsWizardPage.this.spnRecordLength.getMinimum() + " - " + InsertRecordsWizardPage.this.spnRecordLength.getMaximum();
                    } else {
                        InsertRecordsWizardPage.this.error = "";
                    }
                }
                catch (Exception exception) {
                    InsertRecordsWizardPage.this.error = "Record length must be in between " + InsertRecordsWizardPage.this.spnRecordLength.getMinimum() + " - " + InsertRecordsWizardPage.this.spnRecordLength.getMaximum();
                }
                InsertRecordsWizardPage.this.setPageComplete(InsertRecordsWizardPage.this.isPageComplete());
            }
        });
        Point size = this.getShell().computeSize(350, 280);
        this.getShell().setSize(size);
        this.spnNumberOfRecords.setFocus();
        this.setControl((Control)this.container);
        this.getShell().getDefaultButton().setText("OK");
    }

    public boolean isPageComplete() {
        if (this.error.length() == 0) {
            this.setErrorMessage(null);
            return true;
        }
        this.setErrorMessage(this.error);
        return false;
    }

    public void setVariableLength(int minLength, int maxLength) {
        this.spnRecordLength.setMinimum(minLength);
        this.spnRecordLength.setMaximum(maxLength);
        this.spnRecordLength.setEnabled(true);
    }

    public boolean doFinish() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window.getActivePage().getActivePart() instanceof EditorView) {
            ((EditorView)window.getActivePage().getActivePart()).insert(this.spnNumberOfRecords.getSelection(), this.spnRecordLength.getSelection(), this.spnRecordLength.isEnabled(), this.btnBefore.getSelection());
            return true;
        }
        return false;
    }
}

