/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.Constants;
import com.ca.filemaster.common.FMPCursor;
import com.ca.filemaster.common.FMPRange;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.verifyPacked;
import com.ca.filemaster.editor.ui.wizards.EditorWizardPageOne;
import com.ca.filemaster.editor.virtualtableviews.CharFormatMode;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.editor.virtualtableviews.FormatMode;
import com.ca.filemaster.editor.virtualtableviews.MultiRecordFormatMode;
import com.ca.filemaster.editor.virtualtableviews.SRFField;
import com.ca.filemaster.editor.virtualtableviews.SRFValueEditingSupport;
import com.ca.filemaster.editor.virtualtableviews.SingleRecordFormatMode;
import com.ca.filemaster.editor.virtualtableviews.TextCellEditorFileMaster;
import com.ca.filemaster.editor.virtualtableviews.TraverseListenerTable;
import com.ca.filemaster.runners.RunGetUpdateRecords;
import com.ca.testingtools.common.XMLRequest;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class EditingSupportFileMaster
extends EditingSupport
implements KeyListener,
FocusListener {
    protected static final String MFREQUEST = "MFRequest";
    protected static final String ODOCHANGE = "EditODOChange";
    private Logger log = Logger.getLogger(EditingSupportFileMaster.class.getName());
    private TableViewer tableViewer;
    protected FormatMode formatMode;
    protected int columnIndex;
    protected int columnIndexOnTable;
    protected FileMasterRecord currentFileMasterRecord = null;
    protected TextCellEditorFileMaster textCellEditorFileMaster;
    protected FileMasterRecord fileMasterRecord = null;
    protected FileMasterRecordField fileMasterRecordField = null;
    protected SRFField srfField = null;
    protected int subStringEndIndex = -1;
    protected int subStringBeginIndex = -1;
    private static boolean insertToggleFlag = false;
    private boolean dirtyFlag = false;
    private String textText = null;
    private Point textSelection;
    protected int textCaretPosition;
    protected int textCaretPositionRowIndex;
    protected int textCaretPositionOffset;
    protected int textCaretPositionTrue;
    private String[] textFromWidgetSplitIntoRows;
    protected int capacity;
    private ArrayList<Integer> protectedCursorPositionList;
    protected Text textFromKeyPressed;
    private static String clipboardDataToBePasted = null;
    private boolean fieldEdited;
    private String asciiCode = "";
    private String extendedASCIIChars = "\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\ufffd?\u00c2\u00c0\u00a9\u2563\u2551\u2557\ufffd?\u00a2\u00a5\ufffd?\u2514\u2534\u252c\u251c\u2500\u253c\u00e3\u00c3\u255a\u2554\u2569\u2566\u2560\ufffd?\u256c\u00a4\u00f0\ufffd?\u00ca\u00cb\u00c8\u0131\ufffd?\u00ce\ufffd?\u2518\u250c\u2588\u2584\u00a6\u00cc\u2580\u00d3\u00df\u00d4\u00d2\u00f5\u00d5\u00b5\u00fe\u00de\u00da\u00db\u00d9\u00fd\ufffd?\u00af\u00b4\u2261\u00b1\u2017\u00be\u00b6\u00a7\u00f7\u00b8\u00b0\u00a8\u00b7\u00b9\u00b3\u00b2\u25a0 ";

    public EditingSupportFileMaster(TableViewer tableViewer, FormatMode formatMode, int columnIndex, int columnIndexOnTable, boolean isSubString, int subStringBeginIndex, int subStringEndIndex) {
        super((ColumnViewer)tableViewer);
        this.tableViewer = tableViewer;
        this.formatMode = formatMode;
        this.columnIndex = columnIndex;
        this.columnIndexOnTable = columnIndexOnTable;
        this.textCellEditorFileMaster = new TextCellEditorFileMaster(tableViewer.getTable(), 64);
        this.subStringBeginIndex = subStringBeginIndex;
        this.subStringEndIndex = subStringEndIndex;
    }

    public int getSubStringBeginIndex() {
        return this.subStringBeginIndex;
    }

    protected int getSubStringEndIndex() {
        int aSubStringEndIndex = 0;
        if (this.formatMode instanceof CharFormatMode) {
            aSubStringEndIndex = this.subStringEndIndex;
        } else if (this.formatMode instanceof MultiRecordFormatMode) {
            int widthOfColumn = this.tableViewer.getTable().getColumn(this.columnIndexOnTable).getWidth();
            int numberOfVisibleCharacters = widthOfColumn / this.formatMode.getPixelSizeOfCharacter();
            aSubStringEndIndex = this.getSubStringBeginIndex() + numberOfVisibleCharacters;
            this.log.log(Level.INFO, "widthOfColumn: " + widthOfColumn + " numberOfVisibleCharacters: " + numberOfVisibleCharacters + " aSubStringEndIndex: " + aSubStringEndIndex);
        }
        int maxLengthP = this.getMaxLengthP();
        if (maxLengthP < aSubStringEndIndex) {
            aSubStringEndIndex = maxLengthP;
        }
        return aSubStringEndIndex - 1;
    }

    protected boolean canEdit(Object arg0) {
        return true;
    }

    protected Object getValue(Object arg0) {
        String result = "";
        if (this.fileMasterRecordField.getCharData() == null) {
            this.log.log(Level.WARNING, "charData is null");
        }
        int beginIndex = this.getSubStringBeginIndex();
        int endIndex = this.getSubStringEndIndex() + 1;
        if (!this.fileMasterRecordField.getCharData().isEmpty()) {
            result = this.fileMasterRecordField.getCharData().substring(beginIndex, endIndex);
        }
        if (this.fileMasterRecordField.getHexData1() != null) {
            String hexData1 = this.fileMasterRecordField.getHexData1().substring(beginIndex, endIndex);
            String hexData2 = this.fileMasterRecordField.getHexData2().substring(beginIndex, endIndex);
            result = String.valueOf(result) + Constants.LINE_SEPARATOR + hexData1 + Constants.LINE_SEPARATOR + hexData2;
        }
        return result;
    }

    protected void setValue(Object element, Object newName) {
        this.log.log(Level.INFO, "do nothing at setValue");
    }

    protected void updateView(XMLRequest xmlResponse) {
    }

    protected void updateView(XMLRequest xmlResponse, boolean fieldEdited) {
    }

    private synchronized XMLRequest sendFileMasterRecordFieldUpdateRequestToMainFrame(FileMasterRecord fileMasterRecord) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IWorkbenchPart workbenchPart = page.getActivePart();
        EditorView view = (EditorView)page.getActivePart();
        if (workbenchPart == null) {
            return null;
        }
        IWorkbenchPartSite workbenchPartSite = workbenchPart.getSite();
        String secondaryId = ((IViewSite)workbenchPartSite).getSecondaryId();
        if (!(workbenchPart instanceof EditorView)) {
            this.log.log(Level.INFO, "workbenchPart is not instanceof EditorView.  Unable to send request");
            return null;
        }
        FileMasterServer server = ((EditorView)workbenchPart).getServer(secondaryId);
        String uuid = ((EditorView)workbenchPart).getUUID(secondaryId);
        String displayMode = ((EditorView)workbenchPart).getDisplayMode(secondaryId);
        String hexMode = ((EditorView)workbenchPart).getHexMode(secondaryId);
        RunGetUpdateRecords run = new RunGetUpdateRecords(server, uuid, displayMode, hexMode, fileMasterRecord);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)run);
        XMLRequest xmlResponse = run.getXml();
        if (xmlResponse == null) {
            this.log.log(Level.WARNING, "xmlResponse is null");
            return null;
        }
        Element reqElement = xmlResponse.getRoot();
        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("16") || reqElement.getAttribute("errorlevel").equalsIgnoreCase("32") || reqElement.getAttribute("errorlevel").equalsIgnoreCase("16") || reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
            view.handleMissingSession(reqElement, page, secondaryId);
        }
        return xmlResponse;
    }

    protected FileMasterRecord setupFileMasterRecordRequestMessage() {
        String hexData2;
        String hexData1;
        String postSubString;
        String preSubString;
        boolean isFileMasterRecordFieldUpdated = false;
        if (this.fileMasterRecordField == null || this.fileMasterRecord == null || this.textCellEditorFileMaster == null) {
            this.getFormatMode().disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = true;
            return null;
        }
        String[] text = this.textCellEditorFileMaster.toString().split(Constants.LINE_SEPARATOR);
        if (text[0].length() == 0) {
            this.getFormatMode().disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = true;
            return null;
        }
        String charData = this.fileMasterRecordField.getCharData();
        if (charData != null) {
            String updatedCharData = "";
            if (charData.isEmpty()) {
                updatedCharData = text[0];
            } else {
                preSubString = "";
                if (charData.length() >= this.getSubStringBeginIndex()) {
                    preSubString = charData.substring(0, this.getSubStringBeginIndex());
                }
                postSubString = "";
                if (charData.length() >= this.getSubStringEndIndex() + 1) {
                    postSubString = charData.substring(this.getSubStringEndIndex() + 1);
                }
                updatedCharData = String.valueOf(preSubString) + text[0] + postSubString;
            }
            if (!charData.equals(updatedCharData)) {
                this.fileMasterRecordField.setCharData(updatedCharData);
                isFileMasterRecordFieldUpdated = true;
            }
        }
        if ((hexData1 = this.fileMasterRecordField.getHexData1()) != null) {
            if (this.getSubStringEndIndex() < this.getSubStringBeginIndex()) {
                this.log.log(Level.INFO, "nothing to display");
            } else {
                String updatedHexData1;
                preSubString = "";
                if (hexData1.length() >= this.getSubStringBeginIndex()) {
                    preSubString = hexData1.substring(0, this.getSubStringBeginIndex());
                }
                postSubString = "";
                if (hexData1.length() >= this.getSubStringEndIndex() + 1) {
                    postSubString = hexData1.substring(this.getSubStringEndIndex() + 1);
                }
                if (!hexData1.equals(updatedHexData1 = String.valueOf(preSubString) + text[1] + postSubString)) {
                    this.fileMasterRecordField.setHexData1(updatedHexData1);
                    isFileMasterRecordFieldUpdated = true;
                }
                this.log.log(Level.INFO, String.valueOf(hexData1) + ":" + updatedHexData1);
            }
        }
        if ((hexData2 = this.fileMasterRecordField.getHexData2()) != null) {
            if (this.getSubStringEndIndex() < this.getSubStringBeginIndex()) {
                this.log.log(Level.INFO, "nothing to display");
            } else {
                String preSubString2 = "";
                if (hexData2.length() >= this.getSubStringBeginIndex()) {
                    preSubString2 = hexData2.substring(0, this.getSubStringBeginIndex());
                }
                String postSubString2 = "";
                if (hexData2.length() >= this.getSubStringEndIndex() + 1) {
                    postSubString2 = hexData2.substring(this.getSubStringEndIndex() + 1);
                }
                String updatedHexData2 = String.valueOf(preSubString2) + text[2] + postSubString2;
                this.log.log(Level.INFO, String.valueOf(hexData2) + ":" + updatedHexData2);
                if (!hexData2.equals(updatedHexData2)) {
                    this.fileMasterRecordField.setHexData2(updatedHexData2);
                    isFileMasterRecordFieldUpdated = true;
                }
            }
        }
        if (!isFileMasterRecordFieldUpdated) {
            this.log.log(Level.INFO, "contains the same value, will not send a mainframe request");
            return null;
        }
        this.fileMasterRecord.getRecordFields().clear();
        this.fileMasterRecord.getRecordFields().add(this.fileMasterRecordField);
        return this.fileMasterRecord;
    }

    protected void setCursor(Text fileMasterPlusText) {
        int positionInText = fileMasterPlusText.getCaretPosition() + this.getSubStringBeginIndex();
        FMPCursor fmpCursor = this.getFormatMode().getEditorView().getCursor();
        fmpCursor.setCursorOffset(positionInText);
        fmpCursor.setRecordNumber(this.fileMasterRecord.getNumber());
        fmpCursor.setFieldPosition(this.fileMasterRecordField.getPosition());
        fmpCursor.setFieldId(Integer.parseInt(this.fileMasterRecordField.getId()));
        this.getFormatMode().getEditorView().setCursor(fmpCursor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CellEditor getCellEditor(Object element) {
        Listener[] listener;
        boolean isHexMode = false;
        final Text fileMasterPlusText = (Text)this.textCellEditorFileMaster.getControl();
        Listener[] keyListener = fileMasterPlusText.getListeners(1);
        if (keyListener.length == 1) {
            fileMasterPlusText.addKeyListener((KeyListener)this);
        }
        if ((listener = fileMasterPlusText.getListeners(16)).length == 1) {
            fileMasterPlusText.addFocusListener((FocusListener)this);
        }
        fileMasterPlusText.setFocus();
        TraverseListenerTable traverseListener = new TraverseListenerTable(this.textCellEditorFileMaster, this.getTableViewer(), this.fileMasterRecord, this.fileMasterRecordField);
        fileMasterPlusText.addTraverseListener((TraverseListener)traverseListener);
        Menu cellMenu = this.getFormatMode().getMenuManager().createContextMenu((Control)fileMasterPlusText);
        fileMasterPlusText.setMenu(cellMenu);
        fileMasterPlusText.addListener(4, new Listener(){

            public void handleEvent(Event arg0) {
                EditingSupportFileMaster.this.setCursor(fileMasterPlusText);
            }
        });
        if (element instanceof FileMasterRecord) {
            this.fileMasterRecord = (FileMasterRecord)element;
            int fileMasterRecordFieldSize = this.fileMasterRecord.getRecordFields().size();
            if (fileMasterRecordFieldSize <= 0) {
                this.log.log(Level.WARNING, "there are no record fields associated with the FileMasterRecord element");
                return null;
            }
            if (this.formatMode instanceof CharFormatMode) {
                this.fileMasterRecordField = (FileMasterRecordField)this.fileMasterRecord.getRecordFields().get(0);
                ((CharFormatMode)this.formatMode).setFileMasterRecordField(this.fileMasterRecordField);
            } else if (this.formatMode instanceof MultiRecordFormatMode) {
                this.fileMasterRecordField = (FileMasterRecordField)this.fileMasterRecord.getRecordFields().get(this.columnIndex - 1);
            }
            isHexMode = this.fileMasterRecordField.getHexData1() != null;
            int subStringBeginIndex = this.getSubStringBeginIndex();
            int lastPossibleCursorPosition = this.fileMasterRecordField.getMaxLengthP() - 1;
            if (lastPossibleCursorPosition < subStringBeginIndex) {
                this.log.log(Level.INFO, "maxLengthP has passed, nothing to edit");
                return null;
            }
        } else if (element instanceof SRFField) {
            this.srfField = (SRFField)element;
            this.getFormatMode().getEditorView().getCursor().setFieldName(this.srfField.getName());
            this.getFormatMode().getEditorView().getCursor().setFieldPosition(Integer.parseInt(this.srfField.getPosition()));
            this.getFormatMode().getEditorView().getCursor().setCursorOffset(0);
            this.log.log(Level.FINE, "srfField: " + this.srfField.getValue());
            int beginIndex = this.getSubStringBeginIndex();
            int endIndex = this.getSubStringEndIndex();
            int lengthOfValue = this.srfField.getValue().length();
            int maxLengthP = this.srfField.getMaxLengthP();
            this.log.log(Level.INFO, "lengthOfValue: " + lengthOfValue + " beginIndex: " + beginIndex + " endIndex: " + endIndex + " maxLenghtP: " + maxLengthP);
            if (lengthOfValue < beginIndex) {
                this.log.log(Level.INFO, "nothing to display");
                return null;
            }
        } else {
            this.log.log(Level.WARNING, "Unknown element type");
            return this.textCellEditorFileMaster;
        }
        if (!(this.formatMode instanceof SingleRecordFormatMode)) {
            if (this.formatMode instanceof CharFormatMode) {
                int fileMasterRecordNumber = this.fileMasterRecord.getNumber();
                if (fileMasterRecordNumber == 0) {
                    this.log.log(Level.INFO, "fileMasterRecordNumber: " + fileMasterRecordNumber + " fileMasterRecord not retrieved yet");
                    return null;
                }
                if (this.getTableViewer().getTable().getItemCount() <= ((FileMasterRecord)element).getTableRowNumber()) return null;
                TableItem tableItem = this.getTableViewer().getTable().getItem(((FileMasterRecord)element).getTableRowNumber());
                if (tableItem == null) {
                    return null;
                }
            } else if (this.formatMode instanceof MultiRecordFormatMode) {
                FMPCursor cursor = this.getFormatMode().getEditorView().getCursor();
                int fieldPosition = 0;
                if (this.fileMasterRecord.getNumber() != 0 && !this.fileMasterRecord.isExcluded() && this.fileMasterRecord.getRecordFields().size() >= this.columnIndex - 1) {
                    if (this.fileMasterRecord.getRecordFields().size() > 0) {
                        String fieldName = ((FileMasterRecordField)this.fileMasterRecord.getRecordFields().get(this.columnIndex - 1)).getLayoutField().getName();
                        if (!((FileMasterRecordField)this.fileMasterRecord.getRecordFields().get(this.columnIndex - 1)).getLayoutField().getPosition().isEmpty()) {
                            fieldPosition = Integer.parseInt(((FileMasterRecordField)this.fileMasterRecord.getRecordFields().get(this.columnIndex - 1)).getLayoutField().getPosition());
                            cursor.setRecordNumber(this.fileMasterRecord.getNumber());
                            cursor.setFieldName(fieldName);
                            cursor.setFieldPosition(fieldPosition);
                            this.getFormatMode().getEditorView().setCursor(cursor);
                        }
                    }
                    if (this.fileMasterRecordField.getLayoutField().getFormatChar().equalsIgnoreCase("N")) {
                        fileMasterPlusText.addVerifyListener(new VerifyListener(){

                            public void verifyText(VerifyEvent e) {
                                e.doit = false;
                                try {
                                    Integer.parseInt(e.text.trim());
                                    e.doit = true;
                                }
                                catch (Exception x) {
                                    x.printStackTrace();
                                }
                            }
                        });
                    }
                    if (((FileMasterRecordField)this.fileMasterRecord.getRecordFields().get(this.columnIndex - 1)).getLayoutField().getFormatChar().charAt(0) == 'P' || this.fileMasterRecordField.getLayoutField().getFormatChar().charAt(0) == 'F') {
                        boolean signed = this.fileMasterRecordField.getLayoutField().getSigned().equals("Y");
                        fileMasterPlusText.addVerifyListener((VerifyListener)new verifyPacked(signed, Integer.parseInt(this.fileMasterRecordField.getLayoutField().getIntegerLength()), Integer.parseInt(this.fileMasterRecordField.getLayoutField().getFractionLength())));
                    }
                }
            }
        }
        int textLimit = this.getSubStringEndIndex();
        if (this.formatMode instanceof CharFormatMode) {
            ++textLimit;
        }
        if (textLimit == 0) {
            fileMasterPlusText.setEditable(false);
            return this.textCellEditorFileMaster;
        } else if (textLimit == -1) {
            fileMasterPlusText.setTextLimit(Text.LIMIT);
            return this.textCellEditorFileMaster;
        } else {
            fileMasterPlusText.setTextLimit(textLimit);
            if (!isHexMode) return this.textCellEditorFileMaster;
            int finalLimit = textLimit * 3 + 3 * Constants.LINE_SEPARATOR.length();
            fileMasterPlusText.setTextLimit(finalLimit);
        }
        return this.textCellEditorFileMaster;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public FormatMode getFormatMode() {
        return this.formatMode;
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.checkForValidCharacter(keyEvent);
        this.getAsciiCode(keyEvent);
        if (!keyEvent.doit) {
            return;
        }
        if (keyEvent.keyCode == 0x1000006) {
            this.textCellEditorFileMaster.deactivate();
            Rectangle rect = this.tableViewer.getTable().getClientArea();
            int itemHeight = this.tableViewer.getTable().getItemHeight();
            int headerHeight = this.tableViewer.getTable().getHeaderHeight();
            int recordsOnScreen = (rect.height - headerHeight + itemHeight - 1) / itemHeight;
            this.tableViewer.getTable().setSelection(this.tableViewer.getTable().getTopIndex() + recordsOnScreen - 2);
            if (this.tableViewer.getTable().getItem(this.tableViewer.getTable().getTopIndex() + recordsOnScreen - 2).getData() == null) {
                this.tableViewer.setSelection(null);
            }
            keyEvent.doit = false;
            return;
        }
        if (keyEvent.keyCode == 0x1000005) {
            this.textCellEditorFileMaster.deactivate();
            this.tableViewer.getTable().setSelection(this.tableViewer.getTable().getTopIndex());
            keyEvent.doit = false;
            return;
        }
        this.ignoreSelectAllEvent(keyEvent);
        if (keyEvent.keyCode == 0x1000009) {
            insertToggleFlag = !insertToggleFlag;
            this.log.log(Level.INFO, "INSERT MODE: " + insertToggleFlag);
            keyEvent.doit = false;
            return;
        }
        this.initializeVariables((Text)keyEvent.getSource());
        TextTransfer transfer = TextTransfer.getInstance();
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay());
        clipboardDataToBePasted = (String)clipboard.getContents((Transfer)transfer);
        if (clipboardDataToBePasted != null) {
            this.log.log(Level.INFO, "length: " + clipboardDataToBePasted.length() + " clipboardDataToBePasted: " + clipboardDataToBePasted);
        }
        if (Character.toUpperCase((char)keyEvent.keyCode) == 'Z' && (keyEvent.stateMask & 0x40000) == 262144) {
            this.log.log(Level.INFO, "Ctrl+Z pressed --> ignore for now");
            keyEvent.doit = false;
        }
        if (keyEvent.keyCode == 0x1000003 && keyEvent.stateMask == 0) {
            if (this.textCaretPositionOffset == 0) {
                this.log.log(Level.INFO, "backward acting and already at the beginning, do nothing");
                keyEvent.doit = false;
                return;
            }
            if (this.textCaretPosition == 0) {
                this.log.log(Level.INFO, "backward acting and already at the beginning, do nothing");
                keyEvent.doit = false;
                return;
            }
            this.log.log(Level.INFO, "left arrow key pressed:" + this.textFromKeyPressed.getText() + ":" + this.textFromKeyPressed.getCaretPosition());
            this.moveToPreviousCharacter(this.textFromKeyPressed, this.textFromKeyPressed.getCaretPosition());
            this.positionCursorToNextLocation(this.textFromKeyPressed.getCaretPosition());
            keyEvent.doit = false;
            return;
        }
        if (keyEvent.keyCode == 8) {
            if (this.textCaretPositionOffset == 0) {
                this.log.log(Level.INFO, "backward acting and already at the beginning, do nothing");
                keyEvent.doit = false;
                return;
            }
            if (this.protectedCursorPositionList.contains(new Integer(this.textCaretPositionOffset + this.subStringBeginIndex - 1))) {
                this.log.log(Level.INFO, "trying to backspace a protected character, do nothing");
                keyEvent.doit = false;
                return;
            }
            int selectionCount = this.textFromKeyPressed.getSelectionCount();
            if (selectionCount > 0) {
                this.handleDeleteKeyOnSelection(this.textFromKeyPressed);
            } else {
                this.handleDeleteKey(this.textFromKeyPressed, this.textCaretPositionTrue - 1);
            }
            keyEvent.doit = false;
            return;
        }
        if (keyEvent.keyCode == 0x1000004 && keyEvent.stateMask == 0) {
            this.isEndOfRecordField(keyEvent);
            if (!keyEvent.doit) {
                return;
            }
            this.log.log(Level.INFO, "right arrow key pressed");
            this.moveToNextCharacter(this.textFromKeyPressed, this.textFromKeyPressed.getCaretPosition());
            this.positionCursorToNextLocation(this.textFromKeyPressed.getCaretPosition());
            keyEvent.doit = false;
            return;
        }
        if (keyEvent.keyCode == 127) {
            int selectionCount = this.textFromKeyPressed.getSelectionCount();
            if (selectionCount > 0) {
                this.handleDeleteKeyOnSelection(this.textFromKeyPressed);
            } else {
                if (this.protectedCursorPositionList.contains(new Integer(this.textCaretPositionTrue))) {
                    this.log.log(Level.INFO, "trying to delete a protected character, do nothing");
                    keyEvent.doit = false;
                    return;
                }
                Character characterToBeReplaced = this.getCharacterFromTextControl(this.textText);
                if (characterToBeReplaced != null && (characterToBeReplaced.charValue() == '\r' || characterToBeReplaced.charValue() == '\n')) {
                    this.log.log(Level.INFO, "trying to delete a carriage return, don't do it");
                    keyEvent.doit = false;
                    return;
                }
                if (characterToBeReplaced == null) {
                    this.log.log(Level.WARNING, "characterToBeReplaced is null");
                    return;
                }
                this.isEndOfRecordField(keyEvent);
                if (!keyEvent.doit) {
                    return;
                }
                this.handleDeleteKey(this.textFromKeyPressed, this.textCaretPositionTrue);
            }
            keyEvent.doit = false;
            return;
        }
        if (keyEvent.character != '\u0000' && keyEvent.doit) {
            if (this.textFromKeyPressed.getSelectionCount() > 0) {
                this.handleDeleteKeyOnSelection(this.textFromKeyPressed);
                if (this.textCaretPositionOffset == this.textSelection.y) {
                    this.textCaretPositionOffset -= Math.abs(this.textSelection.x - this.textSelection.y);
                }
            }
            this.isEndOfRecordField(keyEvent);
            if (!keyEvent.doit) {
                return;
            }
            Character characterToBeReplaced = this.getCharacterFromTextControl(this.textText);
            if (!(characterToBeReplaced == null || characterToBeReplaced.charValue() != '\r' && characterToBeReplaced.charValue() != '\n' || insertToggleFlag)) {
                this.log.log(Level.INFO, "trying to overwrite a carriage return, don't do it");
                keyEvent.doit = false;
                return;
            }
            if (characterToBeReplaced == null) {
                this.log.log(Level.WARNING, "characterToBeReplaced is null");
                return;
            }
            if (this.protectedCursorPositionList.contains(new Integer(this.textCaretPositionOffset + this.subStringBeginIndex))) {
                this.log.log(Level.INFO, "trying to overwrite a protected mode, don't do it");
                keyEvent.doit = false;
                return;
            }
            this.handleNonNullCharacter(keyEvent);
            return;
        }
    }

    public void initializeVariables(Text text) {
        this.textFromKeyPressed = text;
        this.textText = this.textFromKeyPressed.getText();
        this.textCaretPosition = this.textFromKeyPressed.getCaretPosition();
        this.textSelection = this.textFromKeyPressed.getSelection();
        this.textCaretPositionRowIndex = this.getRowIndexBasedOnText(this.textFromKeyPressed, this.textFromKeyPressed.getCaretPosition());
        this.textCaretPositionOffset = this.getRowPositionBasedOnText(this.textFromKeyPressed, this.textFromKeyPressed.getCaretPosition());
        this.textCaretPositionTrue = this.textCaretPositionOffset + this.getSubStringBeginIndex();
        this.textFromWidgetSplitIntoRows = this.textFromKeyPressed.getText().split(Constants.LINE_SEPARATOR);
        if (this.formatMode instanceof CharFormatMode && this.fileMasterRecordField == null) {
            this.fileMasterRecordField = ((CharFormatMode)this.formatMode).getFileMasterRecordField();
        }
        this.protectedCursorPositionList = this.textCaretPositionRowIndex == 0 ? this.getProtectedListInCharData() : this.getProtectedListInHexData();
    }

    private void checkForValidCharacter(KeyEvent keyEvent) {
        byte[] nonPrintChars = null;
        try {
            nonPrintChars = "bdfghijkloprstuy".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if ((keyEvent.stateMask & 0x40000) == 262144) {
            int i = 0;
            while (i < nonPrintChars.length) {
                if (nonPrintChars[i] == keyEvent.keyCode) {
                    keyEvent.doit = false;
                    return;
                }
                ++i;
            }
        }
        byte[] nonPrintCharsAltGr = null;
        try {
            nonPrintCharsAltGr = "e=".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if ((keyEvent.stateMask & 0x10000) == 65536) {
            int i = 0;
            while (i < nonPrintCharsAltGr.length) {
                if (nonPrintCharsAltGr[i] == keyEvent.keyCode) {
                    keyEvent.doit = false;
                    return;
                }
                ++i;
            }
        }
    }

    private void getAsciiCode(KeyEvent keyEvent) {
        if ((keyEvent.stateMask & 0x10000) == 65536 && keyEvent.character >= '0' && keyEvent.character <= '9') {
            this.asciiCode = String.valueOf(this.asciiCode) + keyEvent.character;
            keyEvent.doit = false;
        }
    }

    private Character getCharacterFromTextControl(String value) {
        try {
            return new Character(value.charAt(this.textCaretPosition));
        }
        catch (StringIndexOutOfBoundsException e) {
            this.log.log(Level.WARNING, "StringIndexOutOfBoundsException handled --> textCaretPosition: " + this.textCaretPosition + " textText: " + value);
            return null;
        }
    }

    protected void isEndOfRecordField(KeyEvent keyEvent) {
        int currentCursorPositionInRecordField = this.textCaretPositionOffset + this.getSubStringBeginIndex();
        int maxLength = this.getMaxLengthP();
        this.log.log(Level.INFO, "currentCursorPositionInRecordField: " + currentCursorPositionInRecordField + " maxLength: " + maxLength + " getSubStringEndIndex(): " + this.getSubStringEndIndex());
        if (currentCursorPositionInRecordField >= maxLength) {
            this.log.log(Level.INFO, "forward acting and already at the end of the record field, do nothing");
            keyEvent.doit = false;
            return;
        }
        if (currentCursorPositionInRecordField > this.getSubStringEndIndex()) {
            this.log.log(Level.INFO, "forward acting and already at the end of the record field, have reached end of substring, do nothing");
            keyEvent.doit = false;
            return;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!keyEvent.doit) {
            return;
        }
        if ((keyEvent.stateMask & 0x10000) == 65536 && keyEvent.character == '\u0000' && !this.asciiCode.isEmpty()) {
            if (Integer.parseInt(this.asciiCode) < 128) {
                keyEvent.character = (char)Integer.parseInt(this.asciiCode);
            } else if (Integer.parseInt(this.asciiCode) >= 128 && Integer.parseInt(this.asciiCode) < this.extendedASCIIChars.length() + 128) {
                keyEvent.character = this.extendedASCIIChars.charAt(Integer.parseInt(this.asciiCode) - 128);
            }
            this.asciiCode = "";
        }
        this.ignoreSelectAllEvent(keyEvent);
    }

    private void ignoreSelectAllEvent(KeyEvent keyEvent) {
        if (Character.toUpperCase((char)keyEvent.keyCode) == 'A' && (keyEvent.stateMask & 0x40000) == 262144) {
            this.log.log(Level.INFO, "Ctrl+A pressed --> ignore for now");
            Text text = (Text)keyEvent.getSource();
            text.setText(this.textText);
            text.setSelection(this.textCaretPosition);
            keyEvent.doit = false;
        }
    }

    protected void handleNonNullCharacter(KeyEvent keyEvent) {
        Text text = (Text)keyEvent.getSource();
        if (insertToggleFlag || this.textSelection.x != this.textSelection.y) {
            this.handleInsertMode(keyEvent, text, text.getCaretPosition());
        } else {
            this.handleOvertypeMode(keyEvent, text, text.getCaretPosition());
        }
        this.positionCursorToNextLocation(text.getCaretPosition());
        keyEvent.doit = false;
    }

    protected void positionCursorToNextLocation(int caretPosition) {
        if (this.formatMode instanceof CharFormatMode) {
            FMPCursor cursor = this.getFormatMode().getEditorView().getCursor();
            if (EditorWizardPageOne.dataSet instanceof FMPVSAMDataset) {
                if (!((FMPVSAMDataset)EditorWizardPageOne.dataSet).getLength().isEmpty()) {
                    int cursorOffset = caretPosition + Integer.parseInt(((FMPVSAMDataset)EditorWizardPageOne.dataSet).getLength()) + Integer.parseInt(((FMPVSAMDataset)EditorWizardPageOne.dataSet).getOffset()) - 1;
                    this.log.log(Level.INFO, "clicked on data column: " + cursor.getRecordNumber() + " cursorOffset: " + cursorOffset);
                    if (cursor != null) {
                        cursor.setCursorOffset(cursorOffset);
                        this.getFormatMode().getEditorView().setCursor(cursor);
                    }
                } else {
                    cursor.setCursorOffset(caretPosition);
                    this.getFormatMode().getEditorView().setCursor(cursor);
                }
            } else {
                cursor.setCursorOffset(caretPosition);
                this.getFormatMode().getEditorView().setCursor(cursor);
            }
        }
        this.getFormatMode().getEditorView().getCursor().setCursorOffset(caretPosition);
    }

    protected int getLastCursorPositionForDeletion(String source, int caretPosition) {
        int terminatingCharacterPosition = Math.min(this.getMaxLengthP(), this.subStringEndIndex);
        int currentPositionThatIncludesOffset = caretPosition + this.subStringBeginIndex;
        int subStringEndIndex = this.getSubStringEndIndex();
        for (Integer x : this.protectedCursorPositionList) {
            if (x <= currentPositionThatIncludesOffset || x > subStringEndIndex) continue;
            this.log.log(Level.INFO, "found the closest terminating character: " + x);
            terminatingCharacterPosition = x;
            break;
        }
        this.log.log(Level.INFO, "terminatingCharacterPosition --> " + terminatingCharacterPosition);
        return terminatingCharacterPosition;
    }

    protected int getLastCursorPositionForInsertion(String source, int caretPosition) {
        return this.getLastCursorPositionForDeletion(source, caretPosition);
    }

    protected void makeEditorDirty() {
        IWorkbench wb;
        IWorkbenchWindow win;
        IWorkbenchPage page;
        IWorkbenchPart workbenchPart;
        if (!this.isDirtyFlag()) {
            this.setDirtyFlag(true);
        }
        if ((workbenchPart = (page = (win = (wb = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()).getActivePage()).getActivePart()) instanceof EditorView) {
            ((EditorView)workbenchPart).setDirty(true);
        }
    }

    protected int moveToNextCharacter(Text text, int currentCaretPosition) {
        int nextCaretPosition = currentCaretPosition + 1;
        while (this.protectedCursorPositionList.contains(new Integer(this.textCaretPositionTrue + 1))) {
            this.log.log(Level.INFO, "this charater is protected, going to next charater: " + nextCaretPosition);
            ++this.textCaretPositionTrue;
            if (this.textCaretPositionTrue >= this.subStringEndIndex) break;
            ++nextCaretPosition;
        }
        text.setSelection(nextCaretPosition, nextCaretPosition);
        this.log.log(Level.INFO, "currentCaretPosition: " + currentCaretPosition + " nextCaretPosition: " + nextCaretPosition);
        return nextCaretPosition;
    }

    /*
     * Unable to fully structure code
     */
    private int moveToPreviousCharacter(Text text, int currentCaretPosition) {
        if (currentCaretPosition == 0) {
            this.log.log(Level.INFO, "currentCaretPosition is 0, no more room to move left to");
            return currentCaretPosition;
        }
        previousCaretPosition = currentCaretPosition - 1;
        if (this.protectedCursorPositionList.size() != 0) ** GOTO lbl12
        text.setSelection(previousCaretPosition, previousCaretPosition);
        return previousCaretPosition;
lbl-1000:
        // 1 sources

        {
            this.log.log(Level.INFO, "this charater is protected, going to next charater: " + previousCaretPosition);
            --this.textCaretPositionTrue;
            if (this.textCaretPositionTrue <= this.subStringBeginIndex) break;
            --previousCaretPosition;
lbl12:
            // 2 sources

            ** while (this.protectedCursorPositionList.contains((Object)new Integer((int)(this.textCaretPositionTrue - 1))))
        }
lbl13:
        // 2 sources

        text.setSelection(previousCaretPosition, previousCaretPosition);
        return previousCaretPosition;
    }

    protected boolean isInsertable(String text, int caretPosition, int numberOfCharactersToInsert) {
        int positionThatContainsProtectedValue = -1;
        if (this.textSelection.x == this.textSelection.y) {
            if (this.protectedCursorPositionList.contains(this.textCaretPositionTrue)) {
                this.log.log(Level.INFO, "Selected area is protected. Cannot paste");
                return false;
            }
        } else {
            int offset = this.textCaretPositionRowIndex * (String.valueOf(this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex]) + Constants.LINE_SEPARATOR).length();
            if (this.protectedCursorPositionList.contains(this.textSelection.x - offset + this.getSubStringBeginIndex()) || this.protectedCursorPositionList.contains(this.textSelection.y - offset + this.getSubStringBeginIndex())) {
                this.log.log(Level.INFO, "Selected area is protected. Cannot paste");
                return false;
            }
        }
        for (Integer x : this.protectedCursorPositionList) {
            int currentPositionModel = this.textCaretPositionOffset + this.subStringBeginIndex;
            if (x <= currentPositionModel) continue;
            positionThatContainsProtectedValue = x;
            this.log.log(Level.INFO, "positionThatContainsProtectedValue: " + positionThatContainsProtectedValue);
            break;
        }
        String textSubstringThatAccountsForCaretPositionAndProtectedValues = this.protectedCursorPositionList.size() == 0 || positionThatContainsProtectedValue == -1 || this.subStringEndIndex < positionThatContainsProtectedValue ? (this.textCaretPositionRowIndex > 0 ? text.substring(this.textCaretPositionOffset) : text.substring(caretPosition)) : text.substring(this.textCaretPositionOffset, positionThatContainsProtectedValue - this.subStringBeginIndex);
        int numberOfSpacesBeforeTerminatingPosition = Constants.getNumberOfTrailingSpaces((String)textSubstringThatAccountsForCaretPositionAndProtectedValues);
        return (numberOfSpacesBeforeTerminatingPosition += this.textFromKeyPressed.getSelectionCount()) >= numberOfCharactersToInsert;
    }

    private void handleOvertypeMode(KeyEvent keyEvent, Text text, int caretPosition) {
        this.log.log(Level.INFO, "inside overtype mode");
        this.log.log(Level.INFO, "text: " + text.getText() + " caretPosition: " + caretPosition + " charCount: " + text.getCharCount());
        String valueOfText = this.deleteCharAtPositionAndInsertCharAtPosition(keyEvent, text, caretPosition);
        this.log.log(Level.INFO, "replacing record value to: " + valueOfText.toString());
        text.setText(valueOfText.toString());
        this.moveToNextCharacter(text, caretPosition);
        this.log.log(Level.INFO, "text:position after --> \n" + text.getText() + ":" + text.getCaretPosition());
        this.makeEditorDirty();
    }

    private String deleteCharAtPositionAndInsertCharAtPosition(KeyEvent keyEvent, Text text, int caretPosition) {
        this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex] = String.valueOf(this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex].substring(0, this.textCaretPositionOffset)) + this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex].substring(this.textCaretPositionOffset + 1, this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex].length());
        this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex] = String.valueOf(this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex].substring(0, this.textCaretPositionOffset)) + keyEvent.character + this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex].substring(this.textCaretPositionOffset, this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex].length());
        if (this.textFromWidgetSplitIntoRows.length > 1) {
            return String.valueOf(this.textFromWidgetSplitIntoRows[0]) + Constants.LINE_SEPARATOR + this.textFromWidgetSplitIntoRows[1] + Constants.LINE_SEPARATOR + this.textFromWidgetSplitIntoRows[2];
        }
        return this.textFromWidgetSplitIntoRows[0];
    }

    public void pasteOvertypeMode(Object eventObject, Text text, int caretPosition_old, String stringThatWillBePasted) {
        boolean isPasteable;
        if (this.formatMode instanceof CharFormatMode && this.fileMasterRecordField == null) {
            this.fileMasterRecordField = ((CharFormatMode)this.formatMode).getFileMasterRecordField();
            this.textFromKeyPressed = text;
            this.textText = text.getText();
            this.textCaretPosition = this.textFromKeyPressed.getCaretPosition();
            this.textSelection = this.textFromKeyPressed.getSelection();
            this.protectedCursorPositionList = this.textCaretPositionRowIndex == 0 ? this.getProtectedListInCharData() : this.getProtectedListInHexData();
        }
        if (!(isPasteable = this.canPasteOvertypeMode(eventObject, text, caretPosition_old, stringThatWillBePasted))) {
            this.log.log(Level.INFO, "not able to paste in overtype mode");
            this.updateDoItFlagForEvent(eventObject, false);
            return;
        }
        this.deleteAndInsertToData(text, caretPosition_old, stringThatWillBePasted);
    }

    protected boolean canPasteOvertypeMode(Object eventObject, Text text, int caretPositionOffset, String clipboardData) {
        this.log.log(Level.INFO, "inside pasteOvertypeMode");
        int dataLength = clipboardData.length();
        this.log.log(Level.INFO, "dataLength: " + dataLength + " textCaretPositionOffset: " + this.textCaretPositionOffset);
        if (dataLength > this.getMaxLengthP()) {
            this.log.log(Level.INFO, "trying to paste object with a length of: " + dataLength + " when we only have " + this.getMaxLengthP() + " space left");
            return false;
        }
        int p = this.getLeftMostCaretPositionIncludingSelection(this.textCaretPositionOffset);
        if (dataLength > this.getMaxLengthP() - p) {
            this.log.log(Level.INFO, "cannot paste into buffer, too many characters. caretPosition also being considered");
            return false;
        }
        int subStringEndIndex = this.getSubStringEndIndex();
        if (this.formatMode instanceof CharFormatMode) {
            ++subStringEndIndex;
        }
        if (subStringEndIndex - (this.subStringBeginIndex + this.textCaretPositionOffset) < dataLength) {
            this.log.log(Level.INFO, "subStringEndIndex: " + subStringEndIndex + " textCaretPositionOffset: " + this.textCaretPositionOffset + " dataLength: " + dataLength);
            return false;
        }
        int terminatingCharacterPosition = this.getLastCursorPositionForDeletion(text.getText(), this.textCaretPositionOffset);
        int findTheLeftMostPosition = this.getLeftMostCaretPositionIncludingSelection(this.textCaretPositionOffset);
        int currentCaretPositionThatIncludesSubStringOffset = findTheLeftMostPosition - this.getSubStringBeginIndex();
        int pastingDestionationPosition = currentCaretPositionThatIncludesSubStringOffset + dataLength;
        if (pastingDestionationPosition > terminatingCharacterPosition) {
            this.log.log(Level.INFO, "cannot paste into buffer, too many characters. terminatingCharacterPosition: " + pastingDestionationPosition + ":" + terminatingCharacterPosition);
            return false;
        }
        this.checkIfPastingToProtectedValue(eventObject, text, caretPositionOffset, dataLength);
        if (eventObject instanceof Event) {
            Event event = (Event)eventObject;
            if (!event.doit) {
                return false;
            }
        } else if (eventObject instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)eventObject;
            if (!keyEvent.doit) {
                return false;
            }
        }
        return true;
    }

    protected void deleteAndInsertToData(Text text, int caretPosition_old, String stringThatWillBePasted) {
        this.log.log(Level.INFO, "pasteOvertype before --> " + text.getText() + ":" + text.getCaretPosition());
        char[] cArray = stringThatWillBePasted.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            String valueOfText = new String(text.getText());
            String preValueOfText = valueOfText.substring(0, caretPosition_old);
            String postValueOfText = valueOfText.substring(caretPosition_old + 1, valueOfText.length());
            valueOfText = String.valueOf(preValueOfText) + postValueOfText;
            valueOfText = String.valueOf(preValueOfText) + c + valueOfText.substring(caretPosition_old, valueOfText.length());
            text.setText(valueOfText.toString());
            caretPosition_old = this.moveToNextCharacter(text, caretPosition_old);
            ++n2;
        }
        this.log.log(Level.INFO, "pasteOvertype after --> " + text.getText() + ":" + text.getCaretPosition());
        this.makeEditorDirty();
    }

    private int getLeftMostCaretPositionIncludingSelection(int caretPosition) {
        this.log.log(Level.INFO, "textSelection.x: " + this.textSelection.x);
        this.log.log(Level.INFO, "textSelection.y: " + this.textSelection.y);
        int findTheLeftMostPositionBasedOnSelection = Math.min(this.textSelection.x, this.textSelection.y);
        int findTheLeftMostPosition = Math.min(caretPosition, findTheLeftMostPositionBasedOnSelection + this.getSubStringBeginIndex());
        return findTheLeftMostPosition;
    }

    public void pasteInsertMode(Object eventObject, Text text, int caretPosition, String data) {
        if (!this.isInsertable(this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex], this.textCaretPositionOffset, data.length())) {
            this.log.log(Level.INFO, "cannot be inserted");
            this.updateDoItFlagForEvent(eventObject, false);
            return;
        }
        if (this.formatMode instanceof SingleRecordFormatMode && this.capacity > this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex].length()) {
            int freeSpaceAtTheEnd = this.capacity - this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex].length();
            int count = 0;
            while (count < freeSpaceAtTheEnd) {
                this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex] = String.valueOf(this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex]) + " ";
                ++count;
            }
        }
        if (this.textFromKeyPressed.getSelectionCount() > 0) {
            this.handleDeleteKeyOnSelection(text);
            int offset = this.textCaretPositionRowIndex * (String.valueOf(this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex]) + Constants.LINE_SEPARATOR).length();
            if (this.textCaretPositionOffset == this.textSelection.y - offset) {
                this.log.log(Level.INFO, "before textCaretPositionOffset: " + this.textCaretPositionOffset);
                int numberOfCharactersSelected = Math.abs(this.textSelection.x - this.textSelection.y);
                this.textCaretPositionOffset -= numberOfCharactersSelected;
                this.log.log(Level.INFO, "after textCaretPositionOffset: " + this.textCaretPositionOffset + " numberOfCharactersSelected: " + numberOfCharactersSelected);
            }
        }
        if (this.textCaretPositionOffset < 0) {
            this.log.log(Level.WARNING, "textCaretPositionOffset is negative which should never be, aborting operation " + this.textCaretPositionOffset);
            return;
        }
        String editedRow = this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex];
        char[] cArray = data.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            this.log.log(Level.INFO, "character to insert: " + c);
            String valueOfText = null;
            if (this.formatMode instanceof CharFormatMode) {
                int terminatingCharacterPosition = this.getLastCursorPositionForInsertion(text.getText(), caretPosition) - this.subStringBeginIndex;
                editedRow = String.valueOf(editedRow.substring(0, terminatingCharacterPosition - 1)) + editedRow.substring(terminatingCharacterPosition, editedRow.length());
            }
            String firstSubstring = editedRow.substring(0, this.textCaretPositionOffset);
            String secondSubstring = "";
            secondSubstring = this.formatMode instanceof SingleRecordFormatMode ? editedRow.substring(this.textCaretPositionOffset, editedRow.length() - 1) : editedRow.substring(this.textCaretPositionOffset, editedRow.length());
            editedRow = String.valueOf(firstSubstring) + c + secondSubstring;
            if (this.textFromWidgetSplitIntoRows.length == 1) {
                valueOfText = editedRow;
            } else {
                this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex] = editedRow;
                valueOfText = String.valueOf(this.textFromWidgetSplitIntoRows[0]) + Constants.LINE_SEPARATOR + this.textFromWidgetSplitIntoRows[1] + Constants.LINE_SEPARATOR + this.textFromWidgetSplitIntoRows[2];
            }
            text.setText(valueOfText.toString());
            int hex = this.moveToNextCharacter(text, this.getTruePositionBasedOnRowIndexAndPositionOffset(this.textCaretPositionRowIndex, this.textCaretPositionOffset));
            this.textCaretPositionOffset = this.getRowPositionBasedOnText(text, hex);
            ++n2;
        }
        this.makeEditorDirty();
    }

    private synchronized void handleDeleteKeyOnSelection(Text text) {
        int numberOfCharactersToDelete = 0;
        if (this.textCaretPosition == this.textSelection.x) {
            numberOfCharactersToDelete = this.textSelection.y - this.textCaretPosition;
        } else if (this.textCaretPosition == this.textSelection.y) {
            numberOfCharactersToDelete = this.textCaretPosition - this.textSelection.x;
            this.textCaretPositionTrue -= numberOfCharactersToDelete;
        } else {
            this.log.log(Level.WARNING, "unknown selection to delete");
            return;
        }
        int x = 0;
        while (x < numberOfCharactersToDelete) {
            if (this.protectedCursorPositionList.contains(new Integer(this.textCaretPositionTrue + this.subStringBeginIndex + x))) {
                this.log.log(Level.INFO, "trying to delete a protected value, can't complete");
                return;
            }
            ++x;
        }
        x = 0;
        while (x < numberOfCharactersToDelete) {
            this.handleDeleteKey(text, this.textCaretPositionTrue);
            ++x;
        }
        this.log.log(Level.INFO, String.valueOf(text.getText()) + "length: " + text.getText().length());
    }

    private void handleDeleteKey(Text text, int currentPositionButNotRowAware) {
        this.log.log(Level.INFO, "text - " + text.getText() + " length: " + text.getText().length());
        this.log.log(Level.INFO, "text - " + Arrays.toString(this.textFromWidgetSplitIntoRows));
        if (this.protectedCursorPositionList.contains(new Integer(currentPositionButNotRowAware))) {
            this.log.log(Level.INFO, "trying to delete a protected value, can't complete");
            return;
        }
        String firstParameter = this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex].substring(0, currentPositionButNotRowAware - this.subStringBeginIndex);
        String secondParameter = this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex].substring(currentPositionButNotRowAware - this.subStringBeginIndex + 1, this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex].length());
        this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex] = String.valueOf(firstParameter) + secondParameter;
        int terminatingCharacterPosition = this.getLastCursorPositionForDeletion(this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex], this.textCaretPositionOffset);
        int terminatingCharacterPositionOffset = terminatingCharacterPosition - this.getSubStringBeginIndex();
        String before = this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex].substring(0, terminatingCharacterPositionOffset - 1);
        String after = this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex].substring(terminatingCharacterPositionOffset - 1, this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex].length());
        this.textFromWidgetSplitIntoRows[this.textCaretPositionRowIndex] = String.valueOf(before) + " " + after;
        if (this.textFromWidgetSplitIntoRows.length == 1) {
            text.setText(this.textFromWidgetSplitIntoRows[0]);
        } else {
            text.setText(String.valueOf(this.textFromWidgetSplitIntoRows[0]) + Constants.LINE_SEPARATOR + this.textFromWidgetSplitIntoRows[1] + Constants.LINE_SEPARATOR + this.textFromWidgetSplitIntoRows[2]);
        }
        int currentPosition = this.getTruePositionBasedOnRowIndexAndPositionOffset(this.textCaretPositionRowIndex, currentPositionButNotRowAware - this.subStringBeginIndex);
        text.setSelection(currentPosition, currentPosition);
        this.makeEditorDirty();
    }

    private void handleInsertMode(KeyEvent keyEvent, Text text, int caretPosition) {
        String stringContentOfTheTextWidget = text.getText();
        this.log.log(Level.INFO, "text: " + text.getText() + " caretPosition: " + caretPosition + " charCount: " + text.getCharCount());
        Object[] row = text.getText().split(Constants.LINE_SEPARATOR);
        if (this.textCaretPositionRowIndex > 2) {
            this.log.log(Level.WARNING, "incorrect row: " + this.textCaretPositionRowIndex);
            this.log.log(Level.WARNING, "row:" + Arrays.toString(row) + " caretPosition: " + caretPosition);
            return;
        }
        boolean insertableFlag = false;
        insertableFlag = this.isInsertable(row[this.textCaretPositionRowIndex], caretPosition, 1);
        if (insertableFlag) {
            int numberOfCharactersSelection;
            this.log.log(Level.INFO, "able to insert");
            String valueOfText = new String((String)row[this.textCaretPositionRowIndex]);
            if (this.formatMode instanceof SingleRecordFormatMode) {
                int beginIndex = this.getSubStringBeginIndex();
                int endIndex = this.getSubStringEndIndex();
                int howManySpacesToFillTillTheEnd = endIndex - beginIndex;
                int x = valueOfText.length();
                int numberOfSpacesToAdd = howManySpacesToFillTillTheEnd - x;
                int i = 0;
                while (i < numberOfSpacesToAdd) {
                    valueOfText = String.valueOf(valueOfText) + " ";
                    ++i;
                }
            }
            int terminatingCharacterPosition = -1;
            int indexForDelete = terminatingCharacterPosition - 1;
            if (!stringContentOfTheTextWidget.isEmpty()) {
                try {
                    terminatingCharacterPosition = this.getLastCursorPositionForInsertion(valueOfText, this.textCaretPositionOffset) - this.subStringBeginIndex;
                    valueOfText = this.deleteCharacterWhileEditing(valueOfText, terminatingCharacterPosition);
                    this.log.log(Level.INFO, "valueOfText length after delete: " + valueOfText.length());
                }
                catch (StringIndexOutOfBoundsException e) {
                    this.log.log(Level.WARNING, "unable to delete character --> position: " + indexForDelete + " text: " + valueOfText);
                }
            }
            if ((numberOfCharactersSelection = Math.abs(this.textSelection.x - this.textSelection.y)) > 0 && this.textSelection.y == this.textCaretPosition && this.textCaretPositionRowIndex != 0) {
                this.textCaretPositionOffset -= numberOfCharactersSelection;
            }
            valueOfText = String.valueOf(valueOfText.substring(0, this.textCaretPositionOffset)) + keyEvent.character + valueOfText.substring(this.textCaretPositionOffset, valueOfText.length());
            this.log.log(Level.INFO, "valueOfText length after insert: " + valueOfText.length());
            row[this.textCaretPositionRowIndex] = valueOfText.toString();
            if (row.length > 1) {
                this.log.log(Level.INFO, String.valueOf(((String)row[0]).length()) + ":" + ((String)row[1]).length() + ":" + ((String)row[2]).length());
                text.setText(String.valueOf(row[0]) + Constants.LINE_SEPARATOR + (String)row[1] + Constants.LINE_SEPARATOR + (String)row[2]);
            } else {
                text.setText((String)row[0]);
            }
            int correctCaretPositionEvenIfThereIsSelection = caretPosition;
            if (numberOfCharactersSelection > 0) {
                correctCaretPositionEvenIfThereIsSelection = this.textSelection.x == this.textCaretPosition ? this.textCaretPosition : this.textCaretPosition - numberOfCharactersSelection;
            }
            this.moveToNextCharacter(text, correctCaretPositionEvenIfThereIsSelection);
            this.log.log(Level.INFO, "after --> length: " + stringContentOfTheTextWidget.length() + "text: " + stringContentOfTheTextWidget + " caretPosition: " + caretPosition + " charCount: " + text.getCharCount());
            this.makeEditorDirty();
        } else {
            this.log.log(Level.INFO, "unable to insert since there is no room");
        }
    }

    protected String deleteCharacterWhileEditing(String valueOfText, int terminatingCharacterPosition) {
        String firstSubString = valueOfText.substring(0, terminatingCharacterPosition - 1);
        String secondSubString = valueOfText.substring(terminatingCharacterPosition, valueOfText.length());
        valueOfText = String.valueOf(firstSubString) + secondSubString;
        return valueOfText;
    }

    public boolean isDirtyFlag() {
        return this.dirtyFlag;
    }

    public void setDirtyFlag(boolean dirtyFlag) {
        this.dirtyFlag = dirtyFlag;
    }

    protected ArrayList<Integer> getProtectedListInCharData() {
        ArrayList<Integer> protectedList = new ArrayList<Integer>();
        ArrayList fmpRangeProtectedList = this.fileMasterRecordField.getProtectedList();
        if (fmpRangeProtectedList != null && fmpRangeProtectedList.size() > 0) {
            for (FMPRange fmpRange : fmpRangeProtectedList) {
                Integer start = new Integer(fmpRange.getStart()) - 1;
                Integer end = new Integer(fmpRange.getEnd()) - 1;
                int i = start;
                while (i <= end) {
                    int protectedRangeSingle = new Integer(i);
                    if (protectedRangeSingle > -1) {
                        protectedList.add(new Integer(i));
                    }
                    ++i;
                }
            }
        }
        return protectedList;
    }

    protected ArrayList<Integer> getProtectedListInHexData() {
        ArrayList<Integer> protectedList = new ArrayList<Integer>();
        ArrayList fmpRangeProtectedList = this.fileMasterRecordField.getProtectedList();
        if (fmpRangeProtectedList != null && fmpRangeProtectedList.size() > 0) {
            for (FMPRange fmpRange : fmpRangeProtectedList) {
                if (!fmpRange.getHex().equalsIgnoreCase("Y")) continue;
                Integer start = new Integer(fmpRange.getStart()) - 1;
                Integer end = new Integer(fmpRange.getEnd()) - 1;
                int i = start;
                while (i <= end) {
                    int protectedRangeSingle = new Integer(i);
                    if (protectedRangeSingle > -1) {
                        protectedList.add(new Integer(i));
                    }
                    ++i;
                }
            }
        }
        this.log.log(Level.INFO, "protectedList:" + protectedList);
        return protectedList;
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
        if (this.formatMode.bypassFocusLost) {
            this.formatMode.bypassFocusLost = false;
            return;
        }
        FileMasterRecord fileMasterRecord = null;
        XMLRequest xmlResponse = null;
        fileMasterRecord = this.setupFileMasterRecordRequestMessage();
        if (fileMasterRecord == null) {
            this.log.log(Level.INFO, "fileMasterRecord is null, not sending request to mainframe");
            this.textCellEditorFileMaster.deactivate();
            return;
        }
        xmlResponse = this.sendFileMasterRecordFieldUpdateRequestToMainFrame(fileMasterRecord);
        if (xmlResponse == null) {
            this.log.log(Level.WARNING, "xmlResponse is null, will not update view");
            this.textCellEditorFileMaster.deactivate();
            return;
        }
        this.fieldEdited = true;
        if (this instanceof SRFValueEditingSupport) {
            this.updateView(xmlResponse, this.fieldEdited);
        } else {
            this.updateView(xmlResponse);
        }
    }

    protected int getMaxLengthP() {
        return this.fileMasterRecordField.getMaxLengthP();
    }

    private int getRowIndexBasedOnText(Text text, int cursorPosition) {
        String[] row = text.getText().split(Constants.LINE_SEPARATOR);
        if (row.length == 1) {
            return 0;
        }
        int charDataLength = row[0].length() + Constants.LINE_SEPARATOR.length();
        int hexData1Length = charDataLength + row[1].length() + Constants.LINE_SEPARATOR.length();
        if (cursorPosition < charDataLength) {
            return 0;
        }
        if (cursorPosition < hexData1Length) {
            return 1;
        }
        return 2;
    }

    protected int getRowPositionBasedOnText(Text text, int cursorPosition) {
        String[] row = text.getText().split(Constants.LINE_SEPARATOR);
        if (row.length == 1) {
            return cursorPosition;
        }
        int charDataLength = row[0].length() + Constants.LINE_SEPARATOR.length();
        int hexData1Length = charDataLength + row[1].length() + Constants.LINE_SEPARATOR.length();
        if (cursorPosition < charDataLength) {
            return cursorPosition;
        }
        if (cursorPosition < hexData1Length) {
            return cursorPosition - charDataLength;
        }
        return cursorPosition - hexData1Length;
    }

    protected int getTruePositionBasedOnRowIndexAndPositionOffset(int rowIndex, int caretOffset) {
        if (rowIndex == 0) {
            return caretOffset;
        }
        if (rowIndex == 1) {
            return this.textFromWidgetSplitIntoRows[0].length() + Constants.LINE_SEPARATOR.length() + caretOffset;
        }
        if (rowIndex == 2) {
            return 2 * this.textFromWidgetSplitIntoRows[0].length() + 2 * Constants.LINE_SEPARATOR.length() + caretOffset;
        }
        return -1;
    }

    public boolean isInsertToggleFlag() {
        return insertToggleFlag;
    }

    private void updateDoItFlagForEvent(Object eventObject, boolean flag) {
        Event event = null;
        KeyEvent keyEvent = null;
        if (eventObject instanceof Event) {
            event = (Event)eventObject;
            event.doit = flag;
        } else if (eventObject instanceof KeyEvent) {
            keyEvent = (KeyEvent)eventObject;
            keyEvent.doit = flag;
        }
    }

    private void checkIfPastingToProtectedValue(Object eventObject, Text text, int caretPosition_old, int dataLength) {
        int x = this.textCaretPositionTrue;
        while (x < this.textCaretPositionTrue + dataLength) {
            this.log.log(Level.INFO, "x: " + x + " protectedList: " + this.protectedCursorPositionList.toString());
            if (this.protectedCursorPositionList.contains(new Integer(x))) {
                this.log.log(Level.INFO, "cannot paste into protected list");
                this.updateDoItFlagForEvent(eventObject, false);
                return;
            }
            ++x;
        }
    }

    public String getClipboardDataToBePasted() {
        return clipboardDataToBePasted;
    }
}

