/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.FMPRange;
import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import com.ca.filemaster.editor.virtualtableviews.CharFormatMode;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.editor.virtualtableviews.FileMasterLabelProviderBase;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;

public class EditorLabelProvider
extends FileMasterLabelProviderBase {
    Display display;
    private String CharHexData1 = "";
    private String CharHexData2 = "";
    private String CharData = "";
    private int keyPosition = 0;
    private int keyLength = 0;
    private boolean hexMode;
    private Logger log = Logger.getLogger(EditorLabelProvider.class.getName());
    private TextStyle plain;
    private TableViewer viewer;
    private CharFormatMode charFormatMode;
    private int columnNumber;
    int startSubString = 0;
    int endSubString = 0;
    private int recordLength;
    private Font font;

    public EditorLabelProvider(Font font, CharFormatMode charFormatMode, TableViewer viewer, int columnNumber, int startSubString, int endSubString, int recordLength) {
        this.charFormatMode = charFormatMode;
        this.viewer = viewer;
        this.columnNumber = columnNumber;
        this.startSubString = startSubString;
        this.endSubString = endSubString;
        this.recordLength = recordLength;
        this.font = font;
        this.plain = new TextStyle(font, null, null);
    }

    @Override
    protected void paint(Event event, Object element) {
        if (event == null || element == null) {
            return;
        }
        int lineNumberColumnWidth = this.viewer.getTable().getColumn(0).getWidth();
        if (this.viewer.getTable().getHorizontalBar() != null) {
            int hPosition = this.viewer.getTable().getHorizontalBar().getSelection();
            int columnWidthInPixels = this.charFormatMode.getMaximumNumberOfCharactersPerColumn() * this.charFormatMode.getPixelSizeOfCharacter();
            if ((event.index - 1) * columnWidthInPixels > hPosition + this.viewer.getTable().getClientArea().width - lineNumberColumnWidth || event.index * columnWidthInPixels < hPosition - lineNumberColumnWidth) {
                return;
            }
        }
        this.hexMode = this.charFormatMode.isHexDisplay().equalsIgnoreCase("Y");
        if (!(element instanceof FileMasterRecord)) {
            return;
        }
        FileMasterRecord fileMasterRecord = (FileMasterRecord)element;
        this.display = this.charFormatMode.getShell().getDisplay();
        if (event != null) {
            event.gc.setForeground(this.display.getSystemColor(19));
            TableItem item = (TableItem)event.item;
            Rectangle rect = item.getImageBounds(event.index);
            rect = item.getBounds(event.index);
            --rect.height;
            --rect.width;
            int[] borderPoints = new int[]{rect.x, rect.y, rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height};
            event.gc.drawPolyline(borderPoints);
            event.gc.setForeground(this.display.getSystemColor(2));
        }
        TextLayout textLayout = new TextLayout((Device)this.display);
        if (fileMasterRecord.getRecordFields().size() == 0) {
            textLayout.setText("");
        }
        if (fileMasterRecord.getRecordFields().size() > 0) {
            EditorView view;
            FileMasterRecordField fileMasterRecordField = (FileMasterRecordField)fileMasterRecord.getRecordFields().get(0);
            this.CharData = fileMasterRecordField.getCharData();
            if (this.CharData.contains("Line(s) not Displayed")) {
                while (this.CharData.length() < this.recordLength) {
                    this.CharData = String.valueOf(this.CharData) + "                  --------------------------------------------------------------------                  " + this.CharData;
                }
            }
            if (fileMasterRecordField.getVsamKey() != null && !fileMasterRecord.isExcluded()) {
                this.keyPosition = Integer.parseInt(fileMasterRecordField.getKeyPosition());
                this.keyLength = fileMasterRecordField.getVsamKey().length();
            }
            if (fileMasterRecordField.getHexData1() != null) {
                this.CharHexData1 = fileMasterRecordField.getHexData1();
                this.CharHexData2 = fileMasterRecordField.getHexData2();
                textLayout.setText(String.valueOf(this.getColumnCharData(this.CharData)) + "\n" + this.getColumnCharData(this.CharHexData1) + "\n" + this.getColumnCharData(this.CharHexData2));
            } else {
                textLayout.setText(this.getColumnCharData(this.CharData));
            }
            textLayout.setStyle(this.plain, 0, textLayout.getText().length());
            if (fileMasterRecordField.getProtectedList() != null) {
                this.highlightProtectedFields(fileMasterRecord, textLayout);
            }
            if (fileMasterRecordField.getFindList() != null || fileMasterRecordField.isCursorEnabled()) {
                this.highlightFindResults(fileMasterRecord, textLayout);
            }
            if ((view = this.charFormatMode.getEditorView()).getHexModeToggled() || view.getModeSwitched()) {
                view.setHexModeToggled(false);
                view.setModeSwitched(false);
                this.viewer.getTable().setTopIndex(view.preserveCharTopIndex);
            }
            textLayout.draw(event.gc, event.x, event.y);
        }
        textLayout.dispose();
    }

    private String getColumnCharData(String charData) {
        if (charData.length() > this.startSubString) {
            return charData.substring(this.startSubString, charData.length() < this.endSubString ? charData.length() : this.endSubString);
        }
        return "";
    }

    private void highlightProtectedFields(FileMasterRecord fileMasterRecord, TextLayout layout) {
        FileMasterRecordField fileMasterRecordField = (FileMasterRecordField)fileMasterRecord.getRecordFields().get(0);
        TextStyle protectedField = new TextStyle(this.font, this.display.getSystemColor(24), this.display.getSystemColor(15));
        int start = 0;
        int end = 0;
        int countProtectedFields = 0;
        while (countProtectedFields < fileMasterRecordField.getProtectedList().size()) {
            int layoutStart;
            start = Integer.parseInt(((FMPRange)fileMasterRecordField.getProtectedList().get(countProtectedFields)).getStart()) - 1;
            end = Integer.parseInt(((FMPRange)fileMasterRecordField.getProtectedList().get(countProtectedFields)).getEnd()) - 1;
            int n = layoutStart = start - this.startSubString < 0 ? 0 : start - this.startSubString;
            if (this.startSubString <= start && this.endSubString > start || this.startSubString <= end && this.endSubString > end || this.startSubString > start && this.endSubString <= end) {
                layout.setStyle(protectedField, layoutStart, Math.min(end - this.startSubString, this.endSubString - this.startSubString));
            }
            ++countProtectedFields;
        }
    }

    private void highlightKeys(FileMasterRecord fileMasterRecord, TextLayout layout) {
        FileMasterRecordField fileMasterRecordField = (FileMasterRecordField)fileMasterRecord.getRecordFields().get(0);
        if (fileMasterRecordField.getProtectedList() == null) {
            return;
        }
        TextStyle keyField = new TextStyle(this.font, this.display.getSystemColor(24), this.display.getSystemColor(19));
        int countProtectedFields = 0;
        while (countProtectedFields < fileMasterRecordField.getProtectedList().size()) {
            int protStart = Integer.parseInt(((FMPRange)fileMasterRecordField.getProtectedList().get(countProtectedFields)).getStart());
            int protEnd = Integer.parseInt(((FMPRange)fileMasterRecordField.getProtectedList().get(countProtectedFields)).getEnd());
            if (protStart == this.keyPosition && protEnd == this.keyPosition + this.keyLength - 1) {
                this.doColumnHighlight(layout, keyField, protStart, protEnd, this.hexMode);
            }
            ++countProtectedFields;
        }
    }

    private void highlightFindResults(FileMasterRecord fileMasterRecord, TextLayout layout) {
        FileMasterRecordField fileMasterRecordField = (FileMasterRecordField)fileMasterRecord.getRecordFields().get(0);
        TextStyle findResultStyle = new TextStyle(this.font, this.display.getSystemColor(24), this.display.getSystemColor(5));
        TextStyle cursorStyle = new TextStyle(this.font, this.display.getSystemColor(24), this.display.getSystemColor(7));
        EditorView editorView = this.charFormatMode.getEditorView();
        if (fileMasterRecordField.getFindList() != null) {
            int countFindFields = 0;
            while (countFindFields < fileMasterRecordField.getFindList().size()) {
                FMPRange findRange = (FMPRange)fileMasterRecordField.getFindList().get(countFindFields);
                if (editorView != null && (editorView.getCharMode().hiliteAllHits || fileMasterRecord.getNumber() == editorView.getCharMode().getHitNumber() && countFindFields == editorView.getCharMode().hitIndex)) {
                    this.doColumnHighlight(layout, findResultStyle, Integer.parseInt(findRange.getStart()) - 1, Integer.parseInt(findRange.getEnd()) - 1, this.hexMode);
                }
                ++countFindFields;
            }
        }
        boolean cursorEnabled = fileMasterRecordField.isCursorEnabled();
        int cursor = fileMasterRecordField.getCursor() - 1;
        if (cursorEnabled) {
            this.doColumnHighlight(layout, cursorStyle, cursor, cursor, false);
        }
    }

    private void doColumnHighlight(TextLayout layout, TextStyle highlightStyle, int start, int end, boolean hex) {
        if (this.startSubString <= start && this.endSubString > start || this.startSubString < end && this.endSubString > end) {
            int layoutStart = start - this.startSubString < 0 ? 0 : start - this.startSubString;
            int layoutEnd = end - this.startSubString < 0 ? 0 : end - this.startSubString;
            layout.setStyle(highlightStyle, layoutStart, layoutEnd);
            if (hex) {
                layout.setStyle(highlightStyle, this.getColumnCharData(this.CharData).length() + layoutStart + 1, this.getColumnCharData(this.CharData).length() + layoutEnd + 1);
                layout.setStyle(highlightStyle, 2 * this.getColumnCharData(this.CharData).length() + layoutStart + 2, 2 * this.getColumnCharData(this.CharData).length() + layoutEnd + 2);
            }
        }
    }
}

