/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.Constants;
import com.ca.filemaster.common.FMPCursor;
import com.ca.filemaster.common.FMPRange;
import com.ca.filemaster.common.FileMasterLayoutField;
import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.filemaster.common.LineRange;
import com.ca.filemaster.common.XMLResponseParser;
import com.ca.filemaster.editor.RunGetGetRecords;
import com.ca.filemaster.editor.virtualtableviews.CharLineNumLabelProvider;
import com.ca.filemaster.editor.virtualtableviews.EditorContentProvider;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.editor.virtualtableviews.MFEditorLabelProvider;
import com.ca.filemaster.editor.virtualtableviews.MultiEditorContentProvider;
import com.ca.filemaster.editor.virtualtableviews.MultiRecordDataCharEditingSupport;
import com.ca.filemaster.editor.virtualtableviews.TableFormatMode;
import com.ca.testingtools.common.XMLRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MultiRecordFormatMode
extends TableFormatMode
implements Runnable {
    private Composite tableContainer;
    private TableViewerColumn tableviewerColumn;
    private Table table;
    private int LAST_COLUMN_WIDTH = 0;
    private List<String> columnNames = new ArrayList<String>();
    private List<String> columnToolTips = new ArrayList<String>();
    private List<Integer> columnWidths = new ArrayList<Integer>();
    private List<Integer> eachRecordFieldLength = new ArrayList<Integer>();
    int countOfColumns = 0;
    public static int PAGE_SIZE = 0;
    public static int GUI_PAGESIZE = 50;
    public static int COUNT = 0;
    public int charactersPerColumn = 1000;
    private int oldIndex;
    private Thread t;
    private Runnable runnableObj = this;
    private int currentStartVal = -1;
    private int currentLastVal = -1;
    private boolean currentLastValisLastRecord = false;
    private boolean updateCurrentDisplay = false;
    private int currentIndex = -1;
    private boolean isHexMode = false;
    private static final int LineNumber = 0;
    private TableItem item;
    private boolean execute = false;
    private String hexDisplay;
    private boolean showMessage = false;
    private boolean locate;
    private boolean isExclude = false;
    private boolean excludeAll;
    private boolean isFind = false;
    private boolean isSwitch = false;
    private String direction = "";
    public static String totalMatch = "";
    private Logger logger = Logger.getLogger(MultiRecordFormatMode.class.getName());
    private boolean flip;
    public boolean callMF;
    private MenuManager menuManager;
    private int hitNumber = -1;
    private int tableLineNumber;
    Map<Integer, FileMasterRecord> selectionData = new HashMap<Integer, FileMasterRecord>();
    private Composite mainContainer;
    private Slider hSlider;
    private Slider vSlider;
    private final int LINENUM_LEN = 8;
    private int maxRecordLength;
    private boolean hscroll = false;
    private boolean insert;
    private int firstFieldIdOnScreen = -1;
    private int lastFieldIdOnScreen = -1;
    private MultiRecordDataCharEditingSupport multiRecordDataCharEditingSupport;
    private final HashMap<Integer, Integer> columnWidthsUM = new HashMap();
    private Runnable getChunk = new Runnable(){

        @Override
        public void run() {
            if (MultiRecordFormatMode.this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable) {
                MultiRecordFormatMode.this.logger.log(Level.INFO, "disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable: " + MultiRecordFormatMode.this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable);
                MultiRecordFormatMode.this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = false;
                return;
            }
            if (MultiRecordFormatMode.this.execute && !MultiRecordFormatMode.this.tableViewer.getTable().isDisposed()) {
                if (MultiRecordFormatMode.this.fileMasterRecords != null && MultiRecordFormatMode.this.fileMasterRecords.size() <= COUNT) {
                    MultiRecordFormatMode.this.oldIndex = MultiRecordFormatMode.this.tableViewer.getTable().getTopIndex() + 1;
                }
                if (MultiRecordFormatMode.this.oldIndex > PAGE_SIZE) {
                    MultiRecordFormatMode.this.tableViewer.getTable().setItemCount(PAGE_SIZE + MultiRecordFormatMode.this.getLastIndex() - 2);
                    MultiRecordFormatMode multiRecordFormatMode = MultiRecordFormatMode.this;
                    multiRecordFormatMode.oldIndex = multiRecordFormatMode.oldIndex - 1;
                }
                MultiRecordFormatMode.this.getChunk(MultiRecordFormatMode.this.oldIndex);
                MultiRecordFormatMode.this.execute = false;
            }
        }
    };
    private Runnable loadHorizontalData = new Runnable(){

        @Override
        public void run() {
            MultiRecordFormatMode.this.updateTableDisplay();
            MultiRecordFormatMode.this.tableViewer.getTable().redraw();
        }
    };

    public MultiRecordFormatMode(Composite parent, EditorView editorView) {
        super(parent, editorView);
    }

    public Composite getContainer() {
        return this.getContainer(0);
    }

    public Composite getContainer(int topIndex) {
        this.logger.log(Level.INFO, "New runnableObj Thread is created butnot started");
        this.t = new Thread(this.runnableObj, "Scrollable Thread");
        this.fileMasterRecordsUsedAsInputByTableViewer = new ArrayList(PAGE_SIZE);
        int i = 0;
        while (i < PAGE_SIZE) {
            this.fileMasterRecordsUsedAsInputByTableViewer.add(new FileMasterRecord());
            ++i;
        }
        this.mainContainer = new Composite(this.parent, 0);
        this.mainContainer.setLayout((Layout)new GridLayout(1, false));
        this.mainContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mainContainer.setLayout((Layout)new GridLayout(2, false));
        this.tableContainer = new Composite(this.mainContainer, 0);
        this.tableContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableContainer.setLayout((Layout)new GridLayout(1, false));
        this.createTable(this.tableContainer);
        this.createScrollBars(this.tableContainer);
        this.tableViewer.getTable().setItemCount(PAGE_SIZE + this.getLastIndex() - 1);
        this.tableViewer.getTable().setTopIndex(topIndex);
        return this.mainContainer;
    }

    private void createScrollBars(Composite mainContainer2) {
        this.hSlider = new Slider(mainContainer2, 256);
        this.hSlider.setBounds(2 * this.table.getBorderWidth(), this.tableViewer.getTable().getBounds().height + 2 * this.table.getBorderWidth(), this.table.getBounds().width - this.getPixelSizeOfCharacter() - 3 * this.table.getBorderWidth(), this.getPixelSizeOfCharacter() * 2);
        this.hSlider.setMinimum(0);
        this.hSlider.setIncrement(this.getPixelSizeOfCharacter());
        this.hSlider.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!MultiRecordFormatMode.this.t.isAlive()) {
                    MultiRecordFormatMode.this.hscroll = true;
                    MultiRecordFormatMode.this.logger.info("new Thread started");
                    MultiRecordFormatMode.this.t = new Thread(MultiRecordFormatMode.this.runnableObj, "ScrollThread");
                    MultiRecordFormatMode.this.t.start();
                    return;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.vSlider = new Slider(this.mainContainer, 512);
        this.vSlider.setBounds(this.table.getBounds().width, this.tableViewer.getTable().getBounds().y + 3 * this.table.getBorderWidth(), this.getPixelSizeOfCharacter() * 2, this.table.getBounds().height);
        this.vSlider.setMinimum(0);
        this.vSlider.setMaximum(this.table.getItemCount() * this.getPixelSizeOfCharacter());
        this.vSlider.setIncrement(this.getPixelSizeOfCharacter());
        this.vSlider.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MultiRecordFormatMode.this.logger.log(Level.INFO, "vbar changed");
                MultiRecordFormatMode.this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = false;
                MultiRecordFormatMode.this.execute = false;
                MultiRecordFormatMode.this.callMF = true;
                MultiRecordFormatMode.this.tableViewer.getTable().setTopIndex(MultiRecordFormatMode.this.vSlider.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public TableViewer createTable(Composite container) {
        this.tableViewer = new TableViewer(container, 268503058);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(false);
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.createColumns();
        this.tableViewer.setContentProvider((IContentProvider)new MultiEditorContentProvider(this.tableViewer));
        this.tableViewer.setInput(null);
        this.tableViewer.getTable().setFont(JFaceResources.getTextFont());
        this.tableViewer.getTable().addListener(36, new Listener(){

            public void handleEvent(Event event) {
                if (!MultiRecordFormatMode.this.execute) {
                    MultiRecordFormatMode.this.oldIndex = event.index;
                    if (!MultiRecordFormatMode.this.t.isAlive()) {
                        MultiRecordFormatMode.this.hscroll = false;
                        MultiRecordFormatMode.this.logger.info("new Thread started");
                        MultiRecordFormatMode.this.t = new Thread(MultiRecordFormatMode.this.runnableObj, "ScrollThread");
                        MultiRecordFormatMode.this.t.start();
                        return;
                    }
                }
            }
        });
        this.tableViewer.getControl().setFocus();
        this.tableViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selectedItems = ((Table)e.getSource()).getSelection();
                HashMap<Integer, FileMasterRecord> newSelectionData = new HashMap<Integer, FileMasterRecord>();
                int i = 0;
                while (i < selectedItems.length) {
                    int itemIndex = ((Table)e.getSource()).indexOf(selectedItems[i]);
                    if (selectedItems[i].getData() != null && ((FileMasterRecord)selectedItems[i].getData()).getRecordFields().size() != 0) {
                        newSelectionData.put(itemIndex, (FileMasterRecord)selectedItems[i].getData());
                    } else if (MultiRecordFormatMode.this.selectionData.get(itemIndex) != null) {
                        newSelectionData.put(itemIndex, MultiRecordFormatMode.this.selectionData.get(itemIndex));
                    } else {
                        ((Table)e.getSource()).deselect(itemIndex);
                    }
                    ++i;
                }
                MultiRecordFormatMode.this.selectionData = newSelectionData;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tableViewer.getTable().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MultiRecordFormatMode.this.tableViewer.getTable().setItemCount(PAGE_SIZE + MultiRecordFormatMode.this.getLastIndex() - 1);
                MultiRecordFormatMode.this.updateSliderAttr();
            }
        });
        this.tableViewer.getTable().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                MultiRecordFormatMode.this.updateSliderAttr();
            }
        });
        this.tableViewer.getTable().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                MultiRecordFormatMode.this.updateSliderAttr();
                MultiRecordFormatMode.this.updateTableDisplay();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.tableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000004) {
                    e.doit = false;
                    MultiRecordFormatMode.this.hSlider.setSelection(MultiRecordFormatMode.this.hSlider.getSelection() + MultiRecordFormatMode.this.getPixelSizeOfCharacter());
                    MultiRecordFormatMode.this.updateTableDisplay();
                }
                if (e.keyCode == 0x1000003) {
                    e.doit = false;
                    MultiRecordFormatMode.this.hSlider.setSelection(MultiRecordFormatMode.this.hSlider.getSelection() - MultiRecordFormatMode.this.getPixelSizeOfCharacter());
                    MultiRecordFormatMode.this.updateTableDisplay();
                }
            }
        });
        this.TABLE_HEADER_HEIGHT = this.table.getHeaderHeight();
        this.TABLE_BORDER_WIDTH = this.table.getBorderWidth();
        this.TABLE_ITEM_HEIGHT = this.table.getItemHeight();
        return this.tableViewer;
    }

    private void createColumns() {
        if (this.columnNames.size() == 0) {
            this.columnNames.add("");
            this.columnToolTips.add("");
            this.columnWidths.add(20);
            this.eachRecordFieldLength.add(20);
        }
        if (this.columnNames.size() == 1 && this.columnNames.get(0).isEmpty()) {
            this.columnNames.add("");
            this.columnWidths.add(8);
            this.columnToolTips.add("");
            this.eachRecordFieldLength.add(20);
        }
        this.updateTableDisplay();
    }

    private void addDataColumns(int count, int indexOfCurrentColumn) {
        int i = 0;
        while (i < count) {
            this.tableviewerColumn = new TableViewerColumn(this.tableViewer, 16384);
            this.tableviewerColumn.getColumn().setText(i > 0 ? " " : this.columnNames.get(indexOfCurrentColumn));
            this.tableviewerColumn.getColumn().setToolTipText(this.columnToolTips.get(indexOfCurrentColumn));
            this.tableViewer.getTable().setRedraw(false);
            this.tableviewerColumn.getColumn().setWidth(Math.max(this.charactersPerColumn, this.columnNames.get(indexOfCurrentColumn).length() + 2) * this.getPixelSizeOfCharacter());
            this.tableViewer.getTable().setRedraw(true);
            this.tableviewerColumn.getColumn().setMoveable(false);
            this.tableviewerColumn.getColumn().setResizable(true);
            ++i;
        }
        if (this.LAST_COLUMN_WIDTH > 0) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 16384);
            this.tableViewer.getTable().setRedraw(false);
            tableViewerColumn.getColumn().setWidth(Math.max(this.LAST_COLUMN_WIDTH, this.columnNames.get(indexOfCurrentColumn).length() + 2) * this.getPixelSizeOfCharacter());
            this.tableViewer.getTable().setRedraw(true);
            tableViewerColumn.getColumn().setText(this.columnNames.get(indexOfCurrentColumn));
            tableViewerColumn.getColumn().setToolTipText(this.columnToolTips.get(indexOfCurrentColumn));
            tableViewerColumn.getColumn().setMoveable(false);
            tableViewerColumn.getColumn().setResizable(true);
        }
    }

    private void getLineNumber(TableViewer viewer, TableViewerColumn tableViewerColumn, int count, boolean subString, int subStringIndex) {
        tableViewerColumn.setLabelProvider((CellLabelProvider)new CharLineNumLabelProvider(this.editorView.font, subString, subStringIndex));
    }

    private void getDataChar(TableViewer viewer, TableViewerColumn tableViewerColumn, int columnIndex, int columnIndexOnTable, boolean isSubString, int subStringBeginIndex) {
        tableViewerColumn.setLabelProvider((CellLabelProvider)new MFEditorLabelProvider(this.editorView.font, this, columnIndex, this.isHexMode, this.tableViewer, isSubString, subStringBeginIndex));
        this.logger.log(Level.INFO, "subString: " + isSubString + " subStringIndex: " + subStringBeginIndex);
        if (!isSubString) {
            subStringBeginIndex = 0;
        }
        this.multiRecordDataCharEditingSupport = new MultiRecordDataCharEditingSupport(this, viewer, columnIndex, columnIndexOnTable, isSubString, subStringBeginIndex, -1);
        tableViewerColumn.setEditingSupport((EditingSupport)this.multiRecordDataCharEditingSupport);
    }

    public ArrayList<FileMasterRecord> xmlResponse(XMLRequest xmlResponse) {
        this.columnNames = new ArrayList<String>();
        this.columnWidths = new ArrayList<Integer>();
        this.eachRecordFieldLength = new ArrayList<Integer>();
        boolean skipCursor = false;
        int fileMasterRecordFieldPosition = 0;
        this.columnToolTips = new ArrayList<String>();
        ArrayList<FileMasterRecord> fileMasterRecords = new ArrayList<FileMasterRecord>();
        int maxRecordLength = 0;
        int exludedRecords = 0;
        boolean isFirstCursorAttributFound = false;
        if (xmlResponse == null) {
            this.logger.log(Level.WARNING, "xmlResponse is null");
            return null;
        }
        Element element = xmlResponse.getRoot();
        Node editResponse = element.getElementsByTagName("EditResponse").item(0);
        Node recordList = ((Element)editResponse).getElementsByTagName("RecordList").item(0);
        if (recordList == null) {
            this.setTotalMatch(element, null);
            this.logger.log(Level.WARNING, "recordList is null");
            return null;
        }
        this.hexDisplay = ((Element)recordList).getAttribute("hex");
        NodeList record = ((Element)recordList).getElementsByTagName("Record");
        this.setTotalMatch(element, record);
        if (record.getLength() <= 0) {
            String EmptyDataset;
            NodeList messages = element.getElementsByTagName("Message");
            if (messages.getLength() > 0 && (EmptyDataset = MultiRecordFormatMode.getTagValue("Message", (Element)messages.item(0))).contains("CAWA725W")) {
                MessageDialog.openInformation((Shell)this.parent.getShell(), (String)"Information", (String)"This data set does not contain any records. To insert a record, use the Insert Record menu option");
            }
            this.logger.log(Level.WARNING, "length of record is 0 or less");
            return null;
        }
        this.columnNames = new ArrayList<String>();
        this.columnWidths = new ArrayList<Integer>();
        this.eachRecordFieldLength = new ArrayList<Integer>();
        this.columnNames.add("");
        this.eachRecordFieldLength.add(8);
        this.columnWidths.add(8);
        this.columnToolTips.add("");
        int count = 0;
        while (count < record.getLength()) {
            FileMasterRecord fileMasterRecord = new FileMasterRecord();
            exludedRecords = 0;
            Node recordNode = record.item(count);
            NamedNodeMap recordAttributes = recordNode.getAttributes();
            int recordNumber = Integer.parseInt(this.getAttributeValue("number", recordAttributes));
            fileMasterRecord.setNumber(recordNumber);
            if (this.getAttributeValue("rrn", recordAttributes) != "") {
                fileMasterRecord.setRRN(Integer.parseInt(this.getAttributeValue("rrn", recordAttributes)));
            }
            if (((Element)record.item(count)).hasAttribute("status")) {
                String recordStatus = ((Element)record.item(count)).getAttribute("status");
                fileMasterRecord.setStatus(recordStatus);
            }
            fileMasterRecord.setLastRecord(false);
            String eof = ((Element)record.item(count)).getAttribute("eof");
            if (eof.endsWith("Y")) {
                fileMasterRecord.setLastRecord(true);
                String secondaryID = ((IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite()).getSecondaryId();
                FileMasterSession fileMasterSession = this.editorView.getCurrentSession(secondaryID);
                fileMasterSession.setRecordCount(fileMasterRecord.getNumber());
            }
            FileMasterRecordField fileMasterRecordField = new FileMasterRecordField();
            if (((Element)record.item(count)).hasAttribute("excluded")) {
                fileMasterRecordField = new FileMasterRecordField();
                fileMasterRecord.setExcluded(true);
                exludedRecords = Integer.parseInt(((Element)record.item(count)).getAttribute("excluded"));
                fileMasterRecordField.setCharData(String.valueOf(exludedRecords) + " Line(s) not Displayed");
                fileMasterRecord.getRecordFields().add(fileMasterRecordField);
                fileMasterRecords.add(fileMasterRecord);
            } else {
                String layChange;
                fileMasterRecord.setExcluded(false);
                if (((Element)record.item(0)).hasAttribute("layoutChange") && (layChange = ((Element)record.item(0)).getAttribute("layoutChange")).equalsIgnoreCase("Y")) {
                    fileMasterRecord.setLayoutChange(true);
                }
                fileMasterRecord.setLength(Integer.parseInt(this.getAttributeValue("length", recordAttributes)));
                Node layout = ((Element)recordNode).getElementsByTagName("Layout").item(0);
                if (layout != null) {
                    fileMasterRecord.setLayoutDataSetName(this.getTagValue("DataSetName", layout));
                    fileMasterRecord.setLayoutMemberName(this.getTagValue("MemberName", layout));
                }
                Node recordFields = ((Element)recordNode).getElementsByTagName("RecordFields").item(0);
                NodeList recordField = ((Element)recordFields).getElementsByTagName("RecordField");
                int i = 0;
                while (i < recordField.getLength()) {
                    Node fieldNode = recordField.item(i);
                    String fieldString = "";
                    if (this.getTagValue("Name", fieldNode) != null) {
                        fieldString = this.getTagValue("Name", fieldNode).trim();
                    }
                    if (!fieldString.split("\\s")[0].equalsIgnoreCase("01")) {
                        NodeList xyzElement;
                        fileMasterRecordField = new FileMasterRecordField();
                        NamedNodeMap fieldAttributes = fieldNode.getAttributes();
                        String fileMasterRecordFieldId = fieldAttributes.getNamedItem(Constants.ATTRIBUTE_ID).getNodeValue();
                        String fileMasterRecordFieldMaxLengthD = fieldAttributes.getNamedItem("maxLengthD").getNodeValue();
                        String fileMasterRecordFieldMaxLengthP = fieldAttributes.getNamedItem("maxLengthP").getNodeValue();
                        if (this.eachRecordFieldLength.size() > i + 1) {
                            if (this.eachRecordFieldLength.get(i + 1) < Integer.parseInt(fileMasterRecordFieldMaxLengthP)) {
                                this.eachRecordFieldLength.set(i + 1, Integer.parseInt(fileMasterRecordFieldMaxLengthP));
                            }
                        } else {
                            this.eachRecordFieldLength.add(Integer.parseInt(fileMasterRecordFieldMaxLengthP));
                        }
                        if (fieldAttributes.getNamedItem("position") != null) {
                            fileMasterRecordFieldPosition = Integer.parseInt(fieldAttributes.getNamedItem("position").getNodeValue());
                            fileMasterRecordField.setPosition(fileMasterRecordFieldPosition);
                            fileMasterRecordField.getLayoutField().setPosition(fieldAttributes.getNamedItem("position").getNodeValue());
                        }
                        fileMasterRecordField.getLayoutField().setId(this.getAttributeValue("id", fieldAttributes));
                        fileMasterRecordField.getLayoutField().setLength(this.getAttributeValue("length", fieldAttributes));
                        fileMasterRecordField.setMaxLengthD(fileMasterRecordFieldMaxLengthD);
                        fileMasterRecordField.setMaxLengthP(fileMasterRecordFieldMaxLengthP);
                        fileMasterRecordField.setId(fileMasterRecordFieldId);
                        if (((Element)fieldNode).hasAttribute(Constants.ATTRIBUTE_CHARDATAHEX)) {
                            String fileMasterRecordFieldCharDataHex = fieldAttributes.getNamedItem(Constants.ATTRIBUTE_CHARDATAHEX).getNodeValue();
                            fileMasterRecordField.setCharDataHex(fileMasterRecordFieldCharDataHex);
                        }
                        if (((Element)fieldNode).hasAttribute("colorData")) {
                            String fileMasterRecordFieldColorData = fieldAttributes.getNamedItem("colorData").getNodeValue();
                            if (fileMasterRecordFieldColorData.equals("Y")) {
                                fileMasterRecordField.setColorData(true);
                            } else {
                                fileMasterRecordField.setColorData(false);
                            }
                        }
                        if (((Element)fieldNode).hasAttribute("dataInputError")) {
                            String fileMasterRecordFieldDataInputError = fieldAttributes.getNamedItem("dataInputError").getNodeValue();
                            if (fileMasterRecordFieldDataInputError.equals("Y")) {
                                fileMasterRecordField.setDataInputError(true);
                            } else {
                                fileMasterRecordField.setDataInputError(false);
                            }
                        }
                        if (((Element)fieldNode).hasAttribute("cursor") && !skipCursor && !isFirstCursorAttributFound) {
                            isFirstCursorAttributFound = true;
                            int cursor = Integer.parseInt(this.getAttributeValue("cursor", fieldAttributes));
                            fileMasterRecordField.setCursorEnabled(true);
                            fileMasterRecordField.setCursor(cursor);
                            int cursorOffset = cursor - 1;
                            this.editorView.getCursor().setCursorOffset(cursorOffset);
                            this.editorView.getCursor().setRecordNumber(fileMasterRecord.getNumber());
                            this.editorView.getCursor().setFieldName(this.getTagValue("Name", fieldNode));
                            if (!this.getAttributeValue("position", fieldAttributes).isEmpty()) {
                                this.editorView.getCursor().setFieldPosition(Integer.parseInt(this.getAttributeValue("position", fieldAttributes)));
                            }
                            skipCursor = true;
                            this.tableLineNumber = fileMasterRecord.getNumber() - 1;
                        }
                        fileMasterRecordField.getLayoutField().setName(this.getTagValue("Name", fieldNode));
                        fileMasterRecordField.getLayoutField().setLevel(this.getTagValue("Level", fieldNode));
                        fileMasterRecordField.getLayoutField().setFormatChar(this.getTagValue("FormatChar", fieldNode));
                        fileMasterRecordField.getLayoutField().setSigned(this.getTagValue("Signed", fieldNode));
                        fileMasterRecordField.getLayoutField().setIntegerLength(this.getTagValue("IntegerLength", fieldNode));
                        fileMasterRecordField.getLayoutField().setFractionLength(this.getTagValue("FractionLength", fieldNode));
                        FileMasterLayoutField filemasterLayoutField = fileMasterRecordField.getLayoutField();
                        String formChar = filemasterLayoutField.getFormatChar();
                        int parameterOne = filemasterLayoutField.getName() == null ? 1 : filemasterLayoutField.getName().length() + 2;
                        int parameterTwo = fileMasterRecordField.getMaxLengthD() + 2;
                        this.columnWidths.add(Math.max(parameterOne, parameterTwo));
                        if (this.columnWidths.size() <= recordField.getLength()) {
                            maxRecordLength += this.columnWidths.get(this.columnWidths.size() - 1).intValue();
                        }
                        if (this.columnNames.size() <= recordField.getLength()) {
                            this.columnNames.add(fieldString);
                        }
                        if (this.columnToolTips.size() <= recordField.getLength()) {
                            this.columnToolTips.add(String.valueOf(formChar) + "     " + fileMasterRecordField.getMaxLengthD() + "\n" + fileMasterRecordFieldPosition);
                        }
                        if (!fileMasterRecord.isExcluded()) {
                            fileMasterRecordField.setCharData(this.getTagValue("CharData", fieldNode));
                        }
                        if (((Element)fieldNode).getElementsByTagName("HexData1").getLength() > 0) {
                            fileMasterRecordField.setHexData1(this.getTagValue("HexData1", fieldNode));
                            fileMasterRecordField.setHexData2(this.getTagValue("HexData2", fieldNode));
                        }
                        if ((xyzElement = ((Element)fieldNode).getElementsByTagName("ProtectedList")).getLength() > 0) {
                            Element nodeElement = (Element)xyzElement.item(0);
                            NodeList nodeList = nodeElement.getElementsByTagName("Range");
                            int x = 0;
                            while (x < nodeList.getLength()) {
                                Element rangeElement = (Element)nodeList.item(x);
                                FMPRange fmpRange = null;
                                fmpRange = rangeElement.hasAttribute(Constants.ATTRIBUTE_HEX) ? new FMPRange(rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_START), rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_END), rangeElement.getAttribute(Constants.ATTRIBUTE_HEX)) : new FMPRange(rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_START), rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_END), "N");
                                fileMasterRecordField.addProtectedRange(fmpRange);
                                ++x;
                            }
                        }
                        fileMasterRecord.getRecordFields().add(fileMasterRecordField);
                    }
                    ++i;
                }
                fileMasterRecords.add(fileMasterRecord);
            }
            ++count;
        }
        this.maxRecordLength = maxRecordLength * this.getPixelSizeOfCharacter();
        return fileMasterRecords;
    }

    private void setTotalMatch(Element element, NodeList record) {
        NodeList messages = element.getElementsByTagName("Message");
        if (messages.getLength() > 0) {
            totalMatch = "";
            totalMatch = MultiRecordFormatMode.getTagValue("Message", (Element)messages.item(0));
            if (totalMatch.contains("CAWA3000E")) {
                MessageDialog.openError((Shell)this.parent.getShell(), (String)"Error", (String)MultiRecordFormatMode.getTagValue(Constants.ELEMENT_MESSAGE, (Element)messages.item(0)));
            } else if (totalMatch.startsWith("CAWA442I")) {
                totalMatch.indexOf("found");
                totalMatch = String.valueOf(totalMatch.substring(totalMatch.indexOf("found") + 6, totalMatch.indexOf("found") + 8)) + " matches found";
            } else if (totalMatch.startsWith("CAWA445I") || record != null && record.getLength() == 0) {
                totalMatch = "";
                totalMatch = "String not found";
            } else if (totalMatch.startsWith("CAWA160E") || totalMatch.startsWith("CAWA162I")) {
                totalMatch = "";
                totalMatch = "String not found in any field name";
            } else if (totalMatch.startsWith("CAWA161E")) {
                totalMatch = "";
                totalMatch = "Field is not valid for Change";
            } else if (totalMatch.startsWith("CAWA441I") || totalMatch.startsWith("CAWA163I")) {
                totalMatch = "";
                totalMatch = "String found";
            } else if (totalMatch.startsWith("CAWA448I")) {
                totalMatch = "";
                totalMatch = "String changed";
            } else if (totalMatch.startsWith("CAWA449I")) {
                String[] temp = totalMatch.split("'");
                totalMatch = String.valueOf(totalMatch.substring(totalMatch.indexOf(temp[4]) + 1, totalMatch.indexOf(temp[4]) + 3)) + " matches changed";
            } else if (totalMatch.startsWith("CAWA443I")) {
                totalMatch = "";
                totalMatch = "String Exculde";
            } else if (totalMatch.startsWith("CAWA444I") || totalMatch.startsWith("CAWA438I")) {
                totalMatch = "";
                totalMatch = "String Exculde";
            } else if (totalMatch.startsWith("CAWA446I")) {
                totalMatch = "";
                totalMatch = "No more matches found";
            } else if (record != null && record.getLength() > 0) {
                totalMatch = "";
                if (this.showMessage) {
                    MessageDialog.openInformation((Shell)this.parent.getShell(), (String)"Information", (String)MultiRecordFormatMode.getTagValue("Message", (Element)messages.item(0)));
                    this.showMessage = false;
                }
            }
        }
    }

    private String getTagValue(String tagName, Node node) {
        if (((Element)node).getElementsByTagName(tagName).item(0) != null) {
            return ((Element)node).getElementsByTagName(tagName).item(0).getTextContent();
        }
        return null;
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue == null) {
            return "";
        }
        return nValue.getNodeValue();
    }

    private String getAttributeValue(String attributeName, NamedNodeMap namedNodeMap) {
        if (namedNodeMap != null && namedNodeMap.getNamedItem(attributeName) != null) {
            return namedNodeMap.getNamedItem(attributeName).getNodeValue() == null ? "" : namedNodeMap.getNamedItem(attributeName).getNodeValue();
        }
        return "";
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public boolean isSwitch() {
        return this.isSwitch;
    }

    public void setSwitch(boolean isSwitch) {
        this.isSwitch = isSwitch;
    }

    public void setXmlResponse(XMLRequest xml) {
        this.currentLastValisLastRecord = false;
        this.tableViewer.getTable().setItemCount(PAGE_SIZE + this.getLastIndex() - 1);
        this.setShowMessage(true);
        this.fileMasterRecords = this.xmlResponse(xml);
        if (this.fileMasterRecords != null) {
            int i = 0;
            while (i < this.fileMasterRecords.size()) {
                FileMasterRecord fileMasterRecord = (FileMasterRecord)this.fileMasterRecords.get(i);
                if (this.isInsert()) {
                    this.fileMasterRecordsUsedAsInputByTableViewer.add(fileMasterRecord.getNumber() - 1, fileMasterRecord);
                } else {
                    this.fileMasterRecordsUsedAsInputByTableViewer.set(fileMasterRecord.getNumber() - 1, fileMasterRecord);
                }
                ++i;
            }
        }
        if (this.isExcludeAll()) {
            this.tableViewer.setInput((Object)this.fileMasterRecords.toArray(new FileMasterRecord[this.fileMasterRecords.size()]));
            this.vSlider.setEnabled(false);
        } else {
            if (!this.vSlider.getEnabled()) {
                this.vSlider.setEnabled(true);
                this.vSlider.setSelection(1);
            }
            this.tableViewer.setInput((Object)this.fileMasterRecordsUsedAsInputByTableViewer.toArray(new FileMasterRecord[this.fileMasterRecordsUsedAsInputByTableViewer.size()]));
        }
        this.tableViewer.refresh();
        if (this.tableViewer.getTable().getColumnCount() == 0) {
            this.createColumns();
        }
        this.changeTable();
        this.updateTableDisplay();
        if (this.fileMasterRecords == null || this.fileMasterRecords.size() == 0) {
            this.tableViewer.setItemCount(0);
            this.logger.log(Level.WARNING, "record size is 0");
            return;
        }
        if (this.isLocate() || this.isFind() || this.isSwitch) {
            this.isSwitch = false;
            this.setSelection(this.tableViewer, this.tableLineNumber);
            if (!this.isFind || this.isSwitch) {
                this.tableViewer.getTable().setTopIndex(this.tableLineNumber);
                this.tableViewer.getTable().setItemCount(PAGE_SIZE + this.getLastIndex() - 2);
            }
        }
        this.tableViewer.refresh();
        this.tableViewer.getTable().deselectAll();
        this.tableViewer.getTable().select(this.editorView.getCursor().getRecordNumber() - 1);
        this.vSlider.setSelection(this.tableViewer.getTable().getTopIndex());
    }

    public void setUpdateCurrentDisplay(boolean updateCurrentDisplay) {
        this.updateCurrentDisplay = updateCurrentDisplay;
    }

    private List<FileMasterRecord> createModel(int offset, int length) {
        String direction = this.getDirection(offset);
        String secondaryID = "";
        if (direction.equalsIgnoreCase("UP") && (offset = this.getOffset(this.getLastIndex() + offset)) > PAGE_SIZE) {
            offset = this.tableViewer.getTable().getTopIndex();
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        secondaryID = ((IViewSite)window.getActivePage().getActivePart().getSite()).getSecondaryId();
        if (!this.editorView.getHexModeToggled()) {
            int updatedCount = this.getFontDependentCountVal();
            RunGetGetRecords runner = new RunGetGetRecords(this.editorView.getCurrentSession(secondaryID).getServer(), this.editorView.getCurrentSession(secondaryID).getUuid(), offset, offset >= this.editorView.getCurrentSession(secondaryID).getRecordCount() ? 1 : updatedCount, direction, "M", this.editorView.getCurrentSession(secondaryID).getHexMode());
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
            XMLRequest xmlResponse = runner.getXml();
            this.fileMasterRecords = this.xmlResponse(xmlResponse);
            if (this.fileMasterRecordsUsedAsInputByTableViewer == null) {
                this.fileMasterRecordsUsedAsInputByTableViewer = new ArrayList(PAGE_SIZE);
            }
            this.fileMasterRecordsUsedAsInputByTableViewer.clear();
            int i = 0;
            while (i < PAGE_SIZE) {
                this.fileMasterRecordsUsedAsInputByTableViewer.add(new FileMasterRecord());
                ++i;
            }
        }
        return this.fileMasterRecords;
    }

    private int getFontDependentCountVal() {
        return (int)Math.ceil(9.75 * (double)COUNT / (double)this.tableViewer.getControl().getFont().getFontData()[0].height);
    }

    private String getDirection(int currentStartVal) {
        this.direction = "DOWN";
        return this.direction;
    }

    private void changeTable() {
        int formatValue;
        int displayWidth = this.parent.getBounds().width;
        int startOfDisplay = this.hSlider.getSelection();
        int endOfDisplay = startOfDisplay + displayWidth;
        int columnStart = 0;
        int columnCount = 0;
        int i = this.tableViewer.getTable().getColumnCount() - 1;
        while (i >= 0) {
            this.tableViewer.getTable().getColumn(i).dispose();
            --i;
        }
        this.callMF = false;
        if (this.columnNames.size() == 0) {
            i = 0;
            if (i > this.tableViewer.getTable().getColumns().length - 1) {
                this.columnWidths.add(8);
                this.columnToolTips.add("");
                this.LAST_COLUMN_WIDTH = 0;
                this.countOfColumns = 0;
                switch (i) {
                    case 0: {
                        this.tableviewerColumn = new TableViewerColumn(this.tableViewer, 16384);
                        this.tableviewerColumn.getColumn().setText(" ");
                        this.tableviewerColumn.getColumn().setWidth(this.columnWidths.get(i) * this.getPixelSizeOfCharacter());
                        this.tableviewerColumn.getColumn().setMoveable(false);
                        this.tableviewerColumn.getColumn().setResizable(true);
                        formatValue = this.columnWidths.get(i);
                        ++formatValue;
                        this.getLineNumber(this.tableViewer, this.tableviewerColumn, i, columnCount == 1, (startOfDisplay - columnStart) / this.getPixelSizeOfCharacter());
                        break;
                    }
                    default: {
                        this.addDataColumns(this.countOfColumns, i);
                        break;
                    }
                }
            } else {
                this.tableViewer.getTable().getColumns()[i].setText("");
            }
        }
        if (this.columnNames.size() == 1) {
            this.columnNames.add("");
            if (this.isExcludeAll()) {
                this.columnWidths.add(((FileMasterRecordField)((FileMasterRecord)this.fileMasterRecords.get(0)).getRecordFields().get(0)).getCharData().length());
                this.setExcludeAll(false);
            } else {
                this.columnWidths.add(8);
            }
            this.columnToolTips.add("");
        }
        i = 0;
        while (i < this.columnNames.size()) {
            ++columnCount;
            if (i == 0) {
                this.tableviewerColumn = new TableViewerColumn(this.tableViewer, 16384);
                this.tableviewerColumn.getColumn().setText(" ");
                this.tableviewerColumn.getColumn().setToolTipText(this.columnToolTips.get(i));
                this.tableviewerColumn.getColumn().setWidth(this.columnWidths.get(i) * this.getPixelSizeOfCharacter());
                this.tableviewerColumn.getColumn().setMoveable(false);
                this.tableviewerColumn.getColumn().setResizable(true);
                formatValue = this.columnWidths.get(i);
                ++formatValue;
                this.getLineNumber(this.tableViewer, this.tableviewerColumn, i, columnCount == 1, (startOfDisplay - columnStart) / this.getPixelSizeOfCharacter());
            }
            if (columnStart > startOfDisplay && columnStart < endOfDisplay || columnStart + this.eachRecordFieldLength.get(i) > startOfDisplay && columnStart + this.eachRecordFieldLength.get(i) < endOfDisplay || columnStart < startOfDisplay && columnStart + this.eachRecordFieldLength.get(i) > endOfDisplay) {
                switch (i) {
                    case 0: {
                        break;
                    }
                    default: {
                        this.tableviewerColumn = new TableViewerColumn(this.tableViewer, 16384);
                        this.tableviewerColumn.getColumn().setText(this.columnNames.get(i));
                        this.tableviewerColumn.getColumn().setToolTipText(this.columnToolTips.get(i));
                        if (columnCount == 1) {
                            this.tableviewerColumn.getColumn().setWidth(this.columnWidths.get(i) - (startOfDisplay - columnStart));
                            this.firstFieldIdOnScreen = i;
                        } else {
                            this.tableViewer.getTable().setRedraw(false);
                            this.tableviewerColumn.getColumn().setWidth(this.columnWidths.get(i) * this.getPixelSizeOfCharacter());
                            this.tableViewer.getTable().setRedraw(true);
                        }
                        this.tableviewerColumn.getColumn().setMoveable(false);
                        this.tableviewerColumn.getColumn().setResizable(true);
                        formatValue = this.columnWidths.get(i);
                        ++formatValue;
                        this.getDataChar(this.tableViewer, this.tableviewerColumn, i, columnCount, columnCount == 1, 0);
                        this.lastFieldIdOnScreen = i;
                    }
                }
            }
            if (i < this.eachRecordFieldLength.size()) {
                columnStart += this.eachRecordFieldLength.get(i).intValue();
            }
            ++i;
        }
    }

    @Override
    public void run() {
        this.logger.log(Level.INFO, "Executing the thread run method");
        int currentIndex = this.oldIndex;
        try {
            if (this.hscroll) {
                Thread.sleep(500L);
                Display.getDefault().asyncExec(this.loadHorizontalData);
                return;
            }
            this.execute = false;
            Thread.sleep(700L);
            if (this.isUpdateCurrentDisplay()) {
                while (currentIndex != this.oldIndex) {
                    Thread.sleep(700L);
                    currentIndex = this.oldIndex;
                }
            } else {
                Thread.sleep(700L);
                currentIndex = this.oldIndex;
            }
            this.execute = true;
            Display.getDefault().asyncExec(this.getChunk);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void updateTbl(int start, int end) {
        int i;
        if (this.fileMasterRecords == null) {
            this.logger.log(Level.WARNING, "fileMasterRecords is null");
            return;
        }
        this.logger.log(Level.INFO, "start: " + start + ",end: " + end);
        int[] selection = this.tableViewer.getTable().getSelectionIndices();
        if (this.callMF) {
            this.createModel(this.getOffset(start), COUNT);
            this.updateTableDisplay();
            this.tableViewer.getTable().redraw();
            this.vSlider.setSelection(this.tableViewer.getTable().getTopIndex());
        }
        this.callMF = true;
        if (this.isFlip()) {
            FileMasterRecord emptyRecord = new FileMasterRecord();
            int x = 0;
            while (x < this.fileMasterRecordsUsedAsInputByTableViewer.size()) {
                if (x < this.fileMasterRecords.size()) {
                    this.fileMasterRecordsUsedAsInputByTableViewer.set(x, this.fileMasterRecords.get(x));
                } else {
                    this.fileMasterRecordsUsedAsInputByTableViewer.set(x, emptyRecord);
                }
                ++x;
            }
        } else if (this.isInsert()) {
            int index = 0;
            int count = 0;
            while (count < this.fileMasterRecords.size()) {
                index = ((FileMasterRecord)this.fileMasterRecords.get(count)).getNumber() - 1;
                this.fileMasterRecordsUsedAsInputByTableViewer.set(index, this.fileMasterRecords.get(count));
                ++count;
            }
            i = index + 1;
            while (i < this.fileMasterRecordsUsedAsInputByTableViewer.size()) {
                ((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(i)).setNumber(i + 1);
                ++i;
            }
            this.setInsert(false);
        } else {
            int count = 0;
            while (count < this.fileMasterRecords.size()) {
                if (start + count < this.fileMasterRecordsUsedAsInputByTableViewer.size() + 1) {
                    int index = start + count - 1;
                    FileMasterRecord fileMasterRecord = (FileMasterRecord)this.fileMasterRecords.get(count);
                    this.fileMasterRecordsUsedAsInputByTableViewer.set(index, fileMasterRecord);
                }
                ++count;
            }
        }
        if (!this.isContentProviderSet()) {
            this.setContentProvider();
        }
        if (!this.tableViewer.getTable().isDisposed()) {
            FileMasterRecord[] fileMasterRecordsUsedAsInputByTableViewerAsAnArray = this.fileMasterRecordsUsedAsInputByTableViewer.toArray(new FileMasterRecord[this.fileMasterRecordsUsedAsInputByTableViewer.size()]);
            if (!this.isLocate()) {
                this.tableViewer.setInput((Object)fileMasterRecordsUsedAsInputByTableViewerAsAnArray);
            }
            i = start;
            while (i < end - 1) {
                if (this.tableViewer.getTable().getItems().length - 1 < i) {
                    this.tableViewer.getTable().setItemCount(i + 1);
                }
                this.item = this.tableViewer.getTable().getItem(i);
                if (((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(i)).getRecordFields().size() > 0) {
                    this.item.setText(((FileMasterRecordField)((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(i)).getRecordFields().get(0)).getCharData());
                }
                if (((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(i)).isLastRecord()) {
                    this.tableViewer.getTable().setItemCount(i + this.getLastIndex());
                    break;
                }
                ++i;
            }
            if (this.fileMasterRecords.size() == 1) {
                this.item = this.tableViewer.getTable().getItem(0);
                if (((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(0)).getRecordFields().size() > 0) {
                    this.item.setText(((FileMasterRecordField)((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(0)).getRecordFields().get(0)).getCharData());
                }
                if (((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(0)).isLastRecord()) {
                    this.tableViewer.getTable().setItemCount(1);
                }
            }
        }
        if (this.isExclude) {
            this.isExclude = false;
            this.setSelection(this.tableViewer, this.tableLineNumber);
        }
        if (this.isLocate()) {
            this.vSlider.setSelection(this.tableLineNumber);
            this.setLocate(false);
        }
        if (this.isFlip() && this.fileMasterRecords.size() < this.tableLineNumber) {
            this.setSelection(this.tableViewer, 0);
        }
        this.tableViewer.refresh();
        this.tableViewer.getTable().deselectAll();
        this.tableViewer.getTable().select(selection);
        if (this.tableViewer.getTable().getSelection().length > 0) {
            this.selectionData.put(0, (FileMasterRecord)this.tableViewer.getTable().getSelection()[0].getData());
        }
    }

    private int getOffset(int start) {
        if (this.fileMasterRecordsUsedAsInputByTableViewer.size() > start - 1) {
            int recordNumberafterCurrentStart;
            int currentStartVal = start;
            int recordNumberAtCurrentStart = start > 0 ? ((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(start - 1)).getNumber() : 0;
            int recordNumberbeforeCurrentStart = start > 1 ? ((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(start - 2)).getNumber() : 0;
            int n = recordNumberafterCurrentStart = start < this.fileMasterRecordsUsedAsInputByTableViewer.size() ? ((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(start)).getNumber() : 0;
            if (recordNumberAtCurrentStart == 0) {
                if (recordNumberbeforeCurrentStart == 0) {
                    if (recordNumberafterCurrentStart == 0) {
                        return start;
                    }
                    if (currentStartVal != recordNumberafterCurrentStart) {
                        return recordNumberafterCurrentStart - 1;
                    }
                } else if (currentStartVal != recordNumberbeforeCurrentStart) {
                    return recordNumberbeforeCurrentStart + 1;
                }
            } else if (currentStartVal != recordNumberAtCurrentStart) {
                return recordNumberAtCurrentStart;
            }
        }
        return start;
    }

    private void getChunk(int currentIndex) {
        this.logger.log(Level.INFO, "currentIndex: " + currentIndex);
        if (this.loadNewChunk(currentIndex) && (this.currentIndex != currentIndex || this.isUpdateCurrentDisplay())) {
            this.setUpdateCurrentDisplay(false);
            int start = currentIndex;
            int end = start + COUNT;
            if (!this.tableViewer.getTable().isDisposed()) {
                this.tableViewer.getTable().getItemCount();
                end = Math.min(end, PAGE_SIZE + 1);
                int i = 0;
                while (i < this.fileMasterRecordsUsedAsInputByTableViewer.size()) {
                    if (((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(i)).isLastRecord()) {
                        this.tableViewer.getTable().setItemCount(i + this.getLastIndex());
                        break;
                    }
                    ++i;
                }
            }
            if (currentIndex <= PAGE_SIZE && start != 0) {
                this.updateTbl(start, end);
                this.currentStartVal = currentIndex;
                this.logger.log(Level.INFO, "currentStartVal: " + this.currentStartVal);
                this.logger.log(Level.FINE, "records.size(): " + this.fileMasterRecords.size());
                if (this.fileMasterRecords.size() > 0) {
                    this.currentLastVal = ((FileMasterRecord)this.fileMasterRecords.get(this.fileMasterRecords.size() - 1)).getNumber();
                    this.currentLastValisLastRecord = ((FileMasterRecord)this.fileMasterRecords.get(this.fileMasterRecords.size() - 1)).isLastRecord();
                }
                this.currentIndex = currentIndex;
            }
        }
    }

    public boolean isUpdateCurrentDisplay() {
        return this.updateCurrentDisplay;
    }

    public boolean isHexMode() {
        return this.isHexMode;
    }

    public void setHexMode(boolean isHexMode) {
        this.isHexMode = isHexMode;
    }

    public String isHexDisplay() {
        if (this.hexDisplay == null) {
            return "";
        }
        return this.hexDisplay;
    }

    private boolean isContentProviderSet() {
        if (this.tableViewer == null) {
            return false;
        }
        return this.tableViewer.getContentProvider() != null;
    }

    private void setContentProvider() {
        if (this.tableViewer != null) {
            this.tableViewer.setContentProvider((IContentProvider)new EditorContentProvider(this.tableViewer));
        }
    }

    public void setLocate(boolean locate) {
        this.locate = locate;
    }

    public void setExcluded(boolean exclude) {
        this.isExclude = exclude;
    }

    public void setFlip(boolean flip) {
        this.flip = flip;
    }

    public boolean isFlip() {
        return this.flip;
    }

    public boolean isExcludeAll() {
        return this.excludeAll;
    }

    public void setExcludeAll(boolean excludeAll) {
        this.excludeAll = excludeAll;
    }

    public boolean isSequentialSelection() {
        TableItem[] selectedItems = this.tableViewer.getTable().getSelection();
        boolean cnd_1 = false;
        boolean cnd_2 = false;
        int i = 0;
        while (i < selectedItems.length - 1) {
            int index_i = this.tableViewer.getTable().indexOf(selectedItems[i]);
            int index_i_plus_1 = this.tableViewer.getTable().indexOf(selectedItems[i + 1]);
            boolean bl = cnd_1 = !this.selectionData.get(index_i).isExcluded() && this.selectionData.get(index_i_plus_1).getNumber() != this.selectionData.get(index_i).getNumber() + 1;
            if (this.selectionData.get(index_i).isExcluded() && this.selectionData.get(index_i_plus_1).getNumber() != this.selectionData.get(index_i).getNumber() + Integer.parseInt(((FileMasterRecordField)this.selectionData.get(index_i).getRecordFields().get(0)).getCharData().substring(0, ((FileMasterRecordField)this.selectionData.get(index_i).getRecordFields().get(0)).getCharData().indexOf(" ")))) {
                cnd_2 = true;
            }
            if (cnd_1 || cnd_2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int firstSelected() {
        TableItem[] selectedItems = this.tableViewer.getTable().getSelection();
        if (selectedItems.length > 0) {
            return this.selectionData.get(this.tableViewer.getTable().indexOf(selectedItems[0])).getNumber();
        }
        return -1;
    }

    public int lastSelected() {
        TableItem[] selectedItems = this.tableViewer.getTable().getSelection();
        if (selectedItems.length > 0) {
            int index = this.tableViewer.getTable().indexOf(selectedItems[selectedItems.length - 1]);
            if (!this.selectionData.get(index).isExcluded()) {
                return this.selectionData.get(index).getNumber();
            }
            return this.selectionData.get(index).getNumber() + Integer.parseInt(((FileMasterRecordField)this.selectionData.get(index).getRecordFields().get(0)).getCharData().substring(0, ((FileMasterRecordField)this.selectionData.get(index).getRecordFields().get(0)).getCharData().indexOf(" "))) - 1;
        }
        return -1;
    }

    public int getRecordCountInSelection() {
        int recordCount = 0;
        TableItem[] selectedItems = this.tableViewer.getTable().getSelection();
        int i = 0;
        while (i < selectedItems.length) {
            int index = this.tableViewer.getTable().indexOf(selectedItems[i]);
            if (!this.selectionData.get(index).isExcluded()) {
                ++recordCount;
            } else if (this.selectionData.get(index).isExcluded()) {
                recordCount += Integer.parseInt(((FileMasterRecordField)this.selectionData.get(index).getRecordFields().get(0)).getCharData().substring(0, ((FileMasterRecordField)this.selectionData.get(index).getRecordFields().get(0)).getCharData().indexOf(" ")));
            }
            ++i;
        }
        return recordCount;
    }

    public void increaseRecordCount(int numberOfRecords) {
        int i = 0;
        while (i < numberOfRecords) {
            this.fileMasterRecordsUsedAsInputByTableViewer.add(new FileMasterRecord());
            ++i;
        }
    }

    public ArrayList<LineRange> getSelectedRanges() {
        ArrayList<LineRange> ranges = new ArrayList<LineRange>();
        LineRange range = new LineRange();
        boolean isRangeOpen = false;
        TableItem[] selectedItems = this.tableViewer.getTable().getSelection();
        if (selectedItems.length == 0) {
            range = new LineRange();
            range.setStart(0);
            range.setEnd(0);
            ranges.add(range);
            return ranges;
        }
        int i = 0;
        while (i < selectedItems.length) {
            int index_i = this.tableViewer.getTable().indexOf(selectedItems[i]);
            if (!isRangeOpen) {
                range = new LineRange();
                ranges.add(range);
                range.setStart(this.selectionData.get(index_i).getNumber());
                isRangeOpen = true;
            }
            if (i != selectedItems.length - 1) {
                int index_i_plus_1 = this.tableViewer.getTable().indexOf(selectedItems[i + 1]);
                boolean cnd_1 = false;
                boolean cnd_2 = false;
                boolean bl = cnd_1 = !this.selectionData.get(index_i).isExcluded() && this.selectionData.get(index_i_plus_1).getNumber() != this.selectionData.get(index_i).getNumber() + 1;
                if (this.selectionData.get(index_i).isExcluded() && this.selectionData.get(index_i_plus_1).getNumber() != this.selectionData.get(index_i).getNumber() + Integer.parseInt(((FileMasterRecordField)this.selectionData.get(index_i).getRecordFields().get(0)).getCharData().substring(0, ((FileMasterRecordField)this.selectionData.get(index_i).getRecordFields().get(0)).getCharData().indexOf(" ")))) {
                    cnd_2 = true;
                }
                if (cnd_1 || cnd_2) {
                    if (!this.selectionData.get(index_i).isExcluded()) {
                        range.setEnd(this.selectionData.get(index_i).getNumber());
                    } else {
                        range.setEnd(this.selectionData.get(index_i).getNumber() + Integer.parseInt(((FileMasterRecordField)this.selectionData.get(index_i).getRecordFields().get(0)).getCharData().substring(0, ((FileMasterRecordField)this.selectionData.get(index_i).getRecordFields().get(0)).getCharData().indexOf(" "))) - 1);
                    }
                    isRangeOpen = false;
                }
            }
            ++i;
        }
        if (isRangeOpen) {
            int index = this.tableViewer.getTable().indexOf(selectedItems[selectedItems.length - 1]);
            if (!this.selectionData.get(index).isExcluded()) {
                range.setEnd(this.selectionData.get(index).getNumber());
            } else {
                range.setEnd(this.selectionData.get(index).getNumber() + Integer.parseInt(((FileMasterRecordField)this.selectionData.get(index).getRecordFields().get(0)).getCharData().substring(0, ((FileMasterRecordField)this.selectionData.get(index).getRecordFields().get(0)).getCharData().indexOf(" "))) - 1);
            }
        }
        return ranges;
    }

    public boolean isOneRecordSelected() {
        return this.tableViewer.getTable().getSelection().length == 1;
    }

    public int getSelectedRecordLength() {
        TableItem[] selectedItems = this.tableViewer.getTable().getSelection();
        if (selectedItems.length > 0) {
            if (this.selectionData.get(0) != null) {
                if (this.selectionData.get(0).isExcluded()) {
                    return ((EditorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()).getProfile().getMaxLength();
                }
                return this.selectionData.get(0).getLength();
            }
            return ((EditorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()).getProfile().getMaxLength();
        }
        return -1;
    }

    public boolean isShowMessage() {
        return this.showMessage;
    }

    public void setShowMessage(boolean showMessage) {
        this.showMessage = showMessage;
    }

    public boolean isLocate() {
        return this.locate;
    }

    @Override
    public void setMenuManager(MenuManager popupMenuMgr) {
        this.menuManager = popupMenuMgr;
    }

    @Override
    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    @Override
    public void setFind(boolean isFind) {
        this.isFind = isFind;
    }

    @Override
    public boolean isFind() {
        return this.isFind;
    }

    public void setInsert(boolean insert) {
        this.insert = insert;
    }

    public boolean isInsert() {
        return this.insert;
    }

    public void setHighlight(int lineNumber, int rangeIndex) {
        this.hitNumber = lineNumber;
        this.tableLineNumber = lineNumber - 1;
        this.tableViewer.refresh();
        this.tableViewer.getTable().setSelection(this.hitNumber - 1);
        this.editorView.getCursor().setRecordNumber(this.hitNumber);
    }

    public void setHightlightAll(int lineNumber) {
        this.hitNumber = -1;
        this.tableLineNumber = lineNumber - 1;
        this.tableViewer.refresh();
        this.tableViewer.getTable().setTopIndex(lineNumber - 1);
        this.tableViewer.getTable().setSelection(lineNumber - 1);
        this.editorView.getCursor().setRecordNumber(lineNumber);
    }

    public void setCursor(int cursor) {
        this.tableLineNumber = cursor - 1;
    }

    public void setSelection(TableViewer tableViewer, int selectionIndex) {
        int recordNumber = selectionIndex + 1;
        this.logger.log(Level.INFO, "setting recordNumber to: " + recordNumber);
        tableViewer.getTable().setSelection(selectionIndex);
        this.editorView.getCursor().setRecordNumber(recordNumber);
    }

    public void clearHits() {
        this.hitNumber = -1;
    }

    private boolean loadNewChunk(int currentIndex) {
        int lastIndex = this.getLastIndex();
        int page = (int)Math.ceil(Float.intBitsToFloat(this.currentLastVal) / Float.intBitsToFloat(lastIndex));
        boolean firstCondition = currentIndex < this.currentStartVal;
        boolean secondCondition = currentIndex > this.currentLastVal;
        boolean thirdCondition = this.currentLastVal < lastIndex * page;
        boolean fourthCondition = !this.currentLastValisLastRecord;
        boolean result = firstCondition || secondCondition || thirdCondition && fourthCondition;
        this.logger.log(Level.INFO, "result of loadNewChunk: " + result + "first: " + firstCondition + " second: " + secondCondition + " third: " + thirdCondition + " fourthCondition: " + fourthCondition);
        return result;
    }

    public void updateTableBasedOnFindResult(XMLResponseParser xmlResponseParser) {
        int i;
        ArrayList<FileMasterRecord> fileMasterRecordsComingFromParameter;
        this.fileMasterRecordsUsedAsInputByTableViewer = new ArrayList();
        this.initOldarrayFMRecord();
        this.fileMasterRecords.clear();
        this.isFind = true;
        this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = true;
        int fieldId = 1;
        int cursor = xmlResponseParser.getCursorPosition();
        int position = xmlResponseParser.getCursorPositionBase();
        int recordNumber = xmlResponseParser.getCursorPositionLineNumber();
        fieldId = xmlResponseParser.getCursorFieldId();
        int actualPositionOfCursor = position + cursor - 1;
        int actualColumnPosition = 0;
        int actualFieldPosition = 0;
        if (recordNumber != -1) {
            FMPCursor fmpCursor = new FMPCursor(recordNumber, "", 1, actualPositionOfCursor, fieldId);
            fmpCursor.setField(this.getEditorView().getCursor().isField());
            this.editorView.setCursor(fmpCursor);
        }
        if ((fileMasterRecordsComingFromParameter = this.xmlResponse(xmlResponseParser.getXmlRequest())).size() == 0) {
            return;
        }
        int start = fileMasterRecordsComingFromParameter.get(0).getNumber();
        int count = 0;
        while (count < fileMasterRecordsComingFromParameter.size()) {
            if (start + count < this.fileMasterRecordsUsedAsInputByTableViewer.size() + 1 && (fileMasterRecordsComingFromParameter.get(count).getNumber() - 1 >= start + count - 1 || fileMasterRecordsComingFromParameter.get(count).isExcluded())) {
                this.fileMasterRecordsUsedAsInputByTableViewer.set(start + count - 1, fileMasterRecordsComingFromParameter.get(count));
            }
            ++count;
        }
        this.tableViewer.getTable().setItemCount(PAGE_SIZE + this.getLastIndex() - 1);
        if (this.fileMasterRecordsUsedAsInputByTableViewer.size() == 0) {
            this.tableViewer.getTable().setItemCount(0);
        } else {
            int i2 = 0;
            while (i2 < this.fileMasterRecordsUsedAsInputByTableViewer.size()) {
                if (this.fileMasterRecordsUsedAsInputByTableViewer.get(i2) instanceof FileMasterRecord && ((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(i2)).isLastRecord()) {
                    this.tableViewer.getTable().setItemCount(i2 + this.getLastIndex());
                    break;
                }
                ++i2;
            }
        }
        int topIndex = fileMasterRecordsComingFromParameter.get(0).getNumber() - 1;
        this.tableViewer.getTable().setTopIndex(topIndex);
        this.vSlider.setSelection(topIndex);
        this.tableViewer.setInput((Object)this.fileMasterRecordsUsedAsInputByTableViewer.toArray(new FileMasterRecord[this.fileMasterRecordsUsedAsInputByTableViewer.size()]));
        this.updateTableDisplay();
        if (!this.getEditorView().getCursor().isField() && fieldId != -1) {
            if (this.getFirstFieldIdOnScreen() < fieldId + 1) {
                i = this.getFirstFieldIdOnScreen();
                while (i < fieldId) {
                    actualColumnPosition += this.columnWidths.get(i).intValue();
                    ++i;
                }
            } else {
                i = this.getFirstFieldIdOnScreen();
                while (i < fieldId - 1) {
                    actualColumnPosition += this.columnWidths.get(i).intValue();
                    --i;
                }
            }
        }
        if (fieldId != -1 && this.getEditorView().getCursor().isField()) {
            i = 1;
            while (i < fieldId) {
                actualFieldPosition += this.columnWidths.get(i).intValue();
                ++i;
            }
            this.HScrollToChar(actualFieldPosition - 1);
        } else if (fieldId != -1 && fieldId <= this.getFirstFieldIdOnScreen() || fieldId >= this.getLastFieldIdOnScreen()) {
            this.HScrollToChar(actualColumnPosition - 1);
        }
    }

    private void initOldarrayFMRecord() {
        this.fileMasterRecordsUsedAsInputByTableViewer = new ArrayList();
        int i = 0;
        while (i < PAGE_SIZE) {
            this.fileMasterRecordsUsedAsInputByTableViewer.add(new FileMasterRecord());
            ++i;
        }
    }

    public Slider getHSlider() {
        return this.hSlider;
    }

    public Composite getMainContainer() {
        return this.mainContainer;
    }

    private void updateTableDisplay() {
        this.tableViewer.getTable().setRedraw(false);
        int hSliderSel = this.hSlider == null ? 0 : this.hSlider.getSelection();
        int displayWidth = this.parent.getBounds().width;
        int startOfDisplay = hSliderSel + 8 * this.getPixelSizeOfCharacter();
        int endOfDisplay = hSliderSel + displayWidth - this.getPixelSizeOfCharacter() * 5;
        int columnStart = 0;
        int columnEnd = 0;
        int columnCount = 0;
        boolean cont = true;
        int i = this.tableViewer.getTable().getColumnCount() - 1;
        while (i >= 1) {
            this.tableViewer.getTable().getColumn(i).dispose();
            --i;
        }
        i = 0;
        while (i < this.columnNames.size()) {
            columnEnd = columnStart + (this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) != null ? this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) : this.columnWidths.get(i) * this.getPixelSizeOfCharacter());
            if (cont) {
                if (columnStart >= startOfDisplay && columnStart < endOfDisplay || columnEnd > startOfDisplay && columnEnd < endOfDisplay || columnStart < startOfDisplay && columnStart + columnEnd > endOfDisplay) {
                    if (columnStart < startOfDisplay && columnEnd > endOfDisplay) {
                        cont = false;
                    }
                    ++columnCount;
                    switch (i) {
                        case 0: {
                            this.tableviewerColumn = new TableViewerColumn(this.tableViewer, 16384);
                            this.tableviewerColumn.getColumn().setText(" ");
                            this.tableviewerColumn.getColumn().setToolTipText(this.columnToolTips.get(i));
                            if (columnCount == 1) {
                                this.tableviewerColumn.getColumn().setWidth((this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) != null ? this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) : this.columnWidths.get(i) * this.getPixelSizeOfCharacter()) - (startOfDisplay - columnStart));
                            } else {
                                this.tableviewerColumn.getColumn().setWidth(this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) != null ? this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) : this.columnWidths.get(i) * this.getPixelSizeOfCharacter());
                            }
                            this.tableviewerColumn.getColumn().setMoveable(false);
                            this.tableviewerColumn.getColumn().setResizable(true);
                            int formatValue = this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) != null ? this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) : this.columnWidths.get(i);
                            ++formatValue;
                            this.getLineNumber(this.tableViewer, this.tableviewerColumn, i, columnCount == 1, (startOfDisplay - columnStart) / this.getPixelSizeOfCharacter());
                            break;
                        }
                        default: {
                            this.tableviewerColumn = new TableViewerColumn(this.tableViewer, 16384);
                            this.tableviewerColumn.getColumn().setText(this.columnNames.get(i));
                            this.tableviewerColumn.getColumn().setToolTipText(this.columnToolTips.get(i));
                            if (columnCount == 1) {
                                this.tableviewerColumn.getColumn().setWidth((this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) != null ? this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) : this.columnWidths.get(i) * this.getPixelSizeOfCharacter()) - (startOfDisplay - columnStart));
                                this.firstFieldIdOnScreen = i;
                            } else {
                                this.tableviewerColumn.getColumn().setWidth(this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) != null ? this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) : this.columnWidths.get(i) * this.getPixelSizeOfCharacter());
                            }
                            this.tableviewerColumn.getColumn().setMoveable(false);
                            this.tableviewerColumn.getColumn().setResizable(true);
                            this.tableviewerColumn.getColumn().addControlListener(new ControlListener(){

                                public void controlResized(ControlEvent e) {
                                    MultiRecordFormatMode.this.logger.log(Level.INFO, "Control Resized");
                                    if (e.getSource() instanceof TableColumn) {
                                        MultiRecordFormatMode.this.columnWidthsUM.put(((TableColumn)e.getSource()).getText().hashCode(), ((TableColumn)e.getSource()).getWidth());
                                    }
                                }

                                public void controlMoved(ControlEvent e) {
                                }
                            });
                            int formatValue = this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) != null ? this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) : this.columnWidths.get(i);
                            ++formatValue;
                            this.getDataChar(this.tableViewer, this.tableviewerColumn, i, columnCount, columnCount == 1, (startOfDisplay - columnStart) / this.getPixelSizeOfCharacter());
                            this.lastFieldIdOnScreen = i;
                        }
                    }
                }
                columnStart += this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) != null ? this.columnWidthsUM.get(this.columnNames.get(i).hashCode()) : this.columnWidths.get(i) * this.getPixelSizeOfCharacter();
            }
            ++i;
        }
        this.tableViewer.getTable().setRedraw(true);
        this.logger.log(Level.INFO, "First Field : " + this.firstFieldIdOnScreen + "," + "\nLast Field: " + this.lastFieldIdOnScreen);
    }

    private void HScrollToChar(int charPos) {
        this.hSlider.setSelection(charPos * this.getPixelSizeOfCharacter());
        this.hSlider.notifyListeners(13, new Event());
    }

    private int getFirstFieldIdOnScreen() {
        return this.firstFieldIdOnScreen;
    }

    private int getLastFieldIdOnScreen() {
        return this.lastFieldIdOnScreen;
    }

    private void updateSliderAttr() {
        this.hSlider.setBounds(2 * this.table.getBorderWidth(), this.tableViewer.getTable().getBounds().height + 2 * this.table.getBorderWidth(), this.table.getBounds().width, this.getPixelSizeOfCharacter() * 2);
        this.vSlider.setBounds(this.tableContainer.getBounds().width + this.table.getBorderWidth() * 2, this.tableViewer.getTable().getBounds().y + 3 * this.table.getBorderWidth(), this.getPixelSizeOfCharacter() * 2, this.table.getBounds().height);
        this.vSlider.setMaximum(PAGE_SIZE + 9);
        this.vSlider.setIncrement(1);
        this.vSlider.setPageIncrement(this.getLastIndex());
        this.hSlider.setMaximum(this.maxRecordLength - 64);
    }

    public MultiRecordDataCharEditingSupport getMultiRecordDataCharEditingSupport() {
        return this.multiRecordDataCharEditingSupport;
    }
}

