/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.FMPCursor;
import com.ca.filemaster.editor.virtualtableviews.SRFField;
import com.ca.filemaster.editor.virtualtableviews.SingleRecordFormatMode;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class SRFNameLabelProvider
extends OwnerDrawLabelProvider {
    private SRFField srfField;
    private TextLayout layout;
    private TextStyle findStyle;
    private TextStyle errorStyle;
    private TextStyle cursorStyle;
    private Shell shell = new Shell();
    private SingleRecordFormatMode singleRecordFormatMode;
    private Font font;

    public SRFNameLabelProvider(Font font, SingleRecordFormatMode singleRecordFormatMode) {
        this.layout = new TextLayout((Device)this.shell.getDisplay());
        this.singleRecordFormatMode = singleRecordFormatMode;
        this.font = font;
        this.findStyle = new TextStyle(font, this.shell.getDisplay().getSystemColor(24), this.shell.getDisplay().getSystemColor(5));
        this.errorStyle = new TextStyle(font, this.shell.getDisplay().getSystemColor(3), this.shell.getDisplay().getSystemColor(25));
        this.cursorStyle = new TextStyle(font, this.shell.getDisplay().getSystemColor(24), this.shell.getDisplay().getSystemColor(7));
    }

    public String getText(Object element) {
        if (element instanceof SRFField) {
            return ((SRFField)element).getName();
        }
        return "";
    }

    protected void measure(Event event, Object element) {
        if (element == null) {
            return;
        }
        if (!(element instanceof SRFField)) {
            return;
        }
        if (event == null) {
            return;
        }
        event.gc.setFont(this.font);
        Point size = event.gc.textExtent("H");
        event.height = size.y;
    }

    protected void paint(Event event, Object element) {
        if (element != null && element instanceof SRFField) {
            this.srfField = (SRFField)element;
            TextStyle plain = new TextStyle(this.font, null, null);
            if (this.srfField.getFields().size() == 0) {
                this.layout.setText("");
                this.layout.setStyle(plain, 0, 20000);
            }
            this.layout.setText(this.srfField.getName());
            this.layout.setStyle(plain, 0, this.layout.getText().length());
            FMPCursor fmpCursor = this.singleRecordFormatMode.getEditorView().getCursor();
            if (this.srfField.isColorFieldName()) {
                this.layout.setStyle(this.errorStyle, 0, this.srfField.getName().length());
            }
            this.layout.draw(event.gc, event.x, event.y);
        }
    }
}

