/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.layout.wizards;

import com.ca.filemaster.common.CRLClass;
import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMLayoutTreeModel;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterLayout;
import com.ca.filemaster.common.FileMasterLayoutField;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.GenericAddPageMemberSorter;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.customlayout.wizards.InsertTopLayoutWizard;
import com.ca.filemaster.layout.wizards.AddLayoutPage2;
import com.ca.filemaster.runners.RunGetCRLMem;
import com.ca.filemaster.runners.RunGetViewLayout;
import com.ca.filemaster.runners.RunGetWCMEM;
import com.ca.filemaster.ui.wizards.ChangedLabelProvider;
import com.ca.filemaster.ui.wizards.CreatedLabelProvider;
import com.ca.filemaster.ui.wizards.DatasetWizard;
import com.ca.filemaster.ui.wizards.DescriptionLabelProvider;
import com.ca.filemaster.ui.wizards.GenericImportWizard;
import com.ca.filemaster.ui.wizards.IDLabelProvider;
import com.ca.filemaster.ui.wizards.MemberLabelProvider;
import com.ca.filemaster.ui.wizards.SizeLabelProvider;
import com.ca.filemaster.views.layout.LayoutView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AddLayoutPage
extends FileMasterWizard
implements SelectionListener,
ICheckStateListener {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.addLayoutPage";
    protected final String NEW_CONTEXT_HELP_ID = "com.ca.filemaster.help.insertLayout";
    protected final String CONTEXT_SEL_HELP_ID = "com.ca.filemaster.help.addSelCritMemPage";
    public String dataSetName = "";
    private String memberName = "";
    private String newDatasetName;
    private String oldDatasetName;
    private String newServer;
    private String oldServer;
    private boolean pendingMessage = false;
    private boolean isSingleMember;
    private boolean topLayoutSelection = false;
    private Label serverNameLabel;
    private Label memberNameLabel;
    protected Combo serverNameCombo;
    public Combo memberNameCombo;
    protected Button memberSelectBtn;
    protected Button selectAllClearButton;
    private Group selectMembersGroup;
    protected CheckboxTableViewer checkboxTableViewer;
    private Table membersTable;
    private Listener sortListener;
    private static FileMasterServer server;
    private boolean msgDisplayed;
    private FMServerTreeModel fmstModel = FMServerTreeModel.getInstance();
    private static FMLayoutTreeModel fmltModel;
    private boolean isDirectoryListCaller = false;
    private static Element memElement;
    private static TT_TreeItem memItem;
    private static Text numberOfMem;
    public XMLRequest xml;
    private static CRLClass crl;
    private static List<FileMasterMember> fmMemberList;
    private IPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
    private Boolean ShowDialog = false;

    static {
        fmltModel = FMLayoutTreeModel.getInstance();
        fmMemberList = new ArrayList<FileMasterMember>();
    }

    public AddLayoutPage(String pageName, FileMasterServer server, String datasetName, String memberName, boolean isDirectoryListCaller) {
        super(pageName, datasetName, server);
        this.setTitle("Add Layout");
        AddLayoutPage.server = server;
        this.dataSetName = datasetName;
        this.memberName = memberName;
        this.isDirectoryListCaller = isDirectoryListCaller;
        this.oldDatasetName = "";
        this.msgDisplayed = false;
    }

    public AddLayoutPage(String pageName, FileMasterServer server, String datasetName, String memberName, boolean isDirectoryListCaller, boolean topLayoutSelection) {
        super(pageName, datasetName, server);
        this.setTitle(pageName);
        AddLayoutPage.server = server;
        this.dataSetName = datasetName;
        this.memberName = memberName;
        this.isDirectoryListCaller = isDirectoryListCaller;
        this.oldDatasetName = "";
        this.msgDisplayed = false;
        this.topLayoutSelection = topLayoutSelection;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.getTitle().equalsIgnoreCase("Add Layout")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.addLayoutPage");
        } else if (this.getTitle().equalsIgnoreCase("Add Selection Criteria")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.addSelCritMemPage");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.insertLayout");
        }
        this.serverNameLabel = new Label(this.dataSetComposite, 0);
        this.serverNameLabel.setText("Se&rver:");
        this.serverNameCombo = new Combo(this.dataSetComposite, 2056);
        GridData gd_serverNameCombo = new GridData(4, 4, false, false, 1, 1);
        this.serverNameCombo.setLayoutData((Object)gd_serverNameCombo);
        this.serverNameCombo.setItems(this.getServers());
        if (this.serverNameCombo.getItemCount() > 0) {
            boolean lastServerExists = false;
            String lastServerUsed = FMHistory.getServer((String)"ServerAddLayoutPage1");
            int count = 0;
            while (count < this.serverNameCombo.getItemCount()) {
                if (this.serverNameCombo.getItem(count).toString().equalsIgnoreCase(lastServerUsed)) {
                    lastServerExists = true;
                    this.serverNameCombo.setText(this.serverNameCombo.getItem(count).toString());
                    break;
                }
                ++count;
            }
            if (!lastServerExists) {
                this.serverNameCombo.setText(this.serverNameCombo.getItem(0));
            }
            this.changeServer();
        }
        this.serverNameCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!AddLayoutPage.this.msgDisplayed) {
                    AddLayoutPage.this.oldServer = AddLayoutPage.this.serverNameCombo.getText();
                }
                AddLayoutPage.this.msgDisplayed = false;
            }
        });
        this.serverNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddLayoutPage.this.newServer = AddLayoutPage.this.serverNameCombo.getText().trim();
                AddLayoutPage.this.pendingMessage = true;
                AddLayoutPage.this.displayServerChangedMsg();
                AddLayoutPage.this.changeServer();
                AddLayoutPage.this.setPageComplete(AddLayoutPage.this.canFlipToNextPage());
            }
        });
        if (this.isDirectoryListCaller) {
            this.serverNameCombo.setEnabled(false);
        }
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        super.createDataSet();
        this.dataSetCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!AddLayoutPage.this.msgDisplayed) {
                    AddLayoutPage.this.oldDatasetName = AddLayoutPage.this.dataSetCombo.getText();
                }
                AddLayoutPage.this.msgDisplayed = false;
            }
        });
        this.dataSetCombo.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                boolean datasetError;
                AddLayoutPage.this.newDatasetName = AddLayoutPage.this.dataSetCombo.getText().trim();
                AddLayoutPage.this.ShowDialog = !AddLayoutPage.this.store.getBoolean("CLOSE_VALUE");
                boolean bl = datasetError = Validator.dataset((String)AddLayoutPage.this.dataSetCombo.getText(), (boolean)true) != 0 && Validator.dataset((String)AddLayoutPage.this.dataSetCombo.getText(), (boolean)true) != 3 && Validator.dataset((String)AddLayoutPage.this.dataSetCombo.getText(), (boolean)true) != 1;
                if (!(!AddLayoutPage.this.ShowDialog.booleanValue() || datasetError || AddLayoutPage.this.checkboxTableViewer.getTable().getItemCount() <= 1 && AddLayoutPage.this.memberNameCombo.getText().isEmpty() || AddLayoutPage.this.oldDatasetName.equalsIgnoreCase(AddLayoutPage.this.newDatasetName))) {
                    AddLayoutPage.this.pendingMessage = true;
                } else {
                    AddLayoutPage.this.pendingMessage = false;
                    if (!AddLayoutPage.this.oldDatasetName.equalsIgnoreCase(AddLayoutPage.this.newDatasetName)) {
                        AddLayoutPage.this.oldDatasetName = AddLayoutPage.this.newDatasetName;
                        AddLayoutPage.this.checkboxTableViewer.getTable().removeAll();
                        AddLayoutPage.this.checkboxTableViewer.setInput(null);
                        AddLayoutPage.this.memberNameCombo.setText("");
                    }
                }
                AddLayoutPage.this.displayDatasetChangedMsg();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.dataSetCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean datasetError;
                AddLayoutPage.this.newDatasetName = AddLayoutPage.this.dataSetCombo.getText().trim();
                AddLayoutPage.this.ShowDialog = !AddLayoutPage.this.store.getBoolean("CLOSE_VALUE");
                boolean bl = datasetError = Validator.dataset((String)AddLayoutPage.this.dataSetCombo.getText(), (boolean)true) != 0 && Validator.dataset((String)AddLayoutPage.this.dataSetCombo.getText(), (boolean)true) != 3 && Validator.dataset((String)AddLayoutPage.this.dataSetCombo.getText(), (boolean)true) != 1;
                if (!(!AddLayoutPage.this.ShowDialog.booleanValue() || datasetError || AddLayoutPage.this.checkboxTableViewer.getTable().getItemCount() <= 1 && AddLayoutPage.this.memberNameCombo.getText().isEmpty() || AddLayoutPage.this.oldDatasetName.equalsIgnoreCase(AddLayoutPage.this.newDatasetName))) {
                    AddLayoutPage.this.pendingMessage = true;
                } else {
                    AddLayoutPage.this.pendingMessage = false;
                    if (!AddLayoutPage.this.oldDatasetName.equalsIgnoreCase(AddLayoutPage.this.newDatasetName)) {
                        AddLayoutPage.this.oldDatasetName = AddLayoutPage.this.newDatasetName;
                        AddLayoutPage.this.checkboxTableViewer.getTable().removeAll();
                        AddLayoutPage.this.checkboxTableViewer.setInput(null);
                        AddLayoutPage.this.memberNameCombo.setText("");
                    }
                }
                AddLayoutPage.this.displayDatasetChangedMsg();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        FMHistory.intializeComboBoxes((Combo)this.dataSetCombo, (String)"DatasetListAddLayoutPage1");
        if (!this.isDirectoryListCaller) {
            this.dataSetCombo.setText(this.dataSetName);
        }
        this.memberNameLabel = new Label(this.dataSetComposite, 0);
        this.memberNameLabel.setText("&Member name:");
        this.memberNameCombo = new Combo(this.dataSetComposite, 2048);
        GridData gd_memberNameCombo = new GridData(4, 4, false, false, 1, 1);
        this.memberNameCombo.setLayoutData((Object)gd_memberNameCombo);
        this.memberNameCombo.addModifyListener((ModifyListener)this);
        this.memberNameCombo.setTextLimit(8);
        this.memberNameCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        if (this.dataSetCombo.getText() != "") {
            this.memberNameCombo.setFocus();
        } else {
            this.dataSetCombo.setFocus();
        }
        FMHistory.intializeComboBoxes((Combo)this.memberNameCombo, (String)"MemberListAddLayoutPage1");
        this.memberSelectBtn = new Button(this.dataSetComposite, 0);
        this.memberSelectBtn.setText("S&elect");
        this.memberSelectBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.memberSelectBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileMasterDataset dsn = new FileMasterDataset(null);
                dsn.setName(AddLayoutPage.this.dataSetName);
                FileMasterMember member = new FileMasterMember(null);
                member.setName(AddLayoutPage.this.memberNameCombo.getText());
                RunGetWCMEM runner = new RunGetWCMEM(dsn, server, member, true, "R");
                BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
                AddLayoutPage.this.xml = runner.getXml();
                AddLayoutPage.this.process();
                if (!AddLayoutPage.this.topLayoutSelection && AddLayoutPage.this.checkboxTableViewer.getTable().getItemCount() > 0) {
                    AddLayoutPage.this.selectAllClearButton.setEnabled(true);
                } else {
                    AddLayoutPage.this.selectAllClearButton.setEnabled(false);
                }
            }
        });
        new Label(this.dataSetComposite, 0);
        GridLayout layout = new GridLayout(1, true);
        this.data = new GridData(4, 4, true, true);
        this.data.heightHint = 300;
        this.container.setLayout((Layout)layout);
        GridLayout layout1 = new GridLayout(2, false);
        this.selectMembersGroup = new Group(this.container, 32);
        this.selectMembersGroup.setText("Select Member");
        this.selectMembersGroup.setLayout((Layout)layout1);
        this.selectMembersGroup.setSize(this.selectMembersGroup.computeSize(-1, -1));
        this.selectMembersGroup.setLayoutData((Object)this.data);
        this.selectMembersGroup.setRedraw(true);
        this.createViewer((Composite)this.selectMembersGroup);
        this.selectAllClearButton = new Button((Composite)this.selectMembersGroup, 0);
        GridData gd_selectAllClearButton = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_selectAllClearButton.widthHint = 120;
        this.selectAllClearButton.setLayoutData((Object)gd_selectAllClearButton);
        this.selectAllClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AddLayoutPage.this.isSingleMember) {
                    if (AddLayoutPage.this.selectAllClearButton.getText() == "Select &All") {
                        AddLayoutPage.this.checkboxTableViewer.setAllChecked(true);
                        AddLayoutPage.this.selectAllClearButton.setText("&Clear Selections");
                    } else {
                        AddLayoutPage.this.selectAllClearButton.setText("Select &All");
                        AddLayoutPage.this.checkboxTableViewer.setAllChecked(false);
                    }
                } else {
                    AddLayoutPage.this.selectAllClearButton.setEnabled(false);
                    AddLayoutPage.this.checkboxTableViewer.setAllChecked(false);
                }
                AddLayoutPage.this.setPageComplete(AddLayoutPage.this.isPageComplete());
            }
        });
        this.checkboxTableViewer.addCheckStateListener((ICheckStateListener)this);
        if (!this.isSingleMember) {
            this.selectAllClearButton.setText("Select &All");
        } else {
            this.selectAllClearButton.setText("&Clear Selections");
        }
        this.selectAllClearButton.setEnabled(false);
        this.selectAllClearButton.setVisible(false);
        if (!this.topLayoutSelection) {
            this.selectAllClearButton.setVisible(true);
        }
        numberOfMem = new Text((Composite)this.selectMembersGroup, 8);
        numberOfMem.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Text)numberOfMem, (int)12);
        numberOfMem.setEnabled(false);
        if (!this.topLayoutSelection) {
            this.getShell().getDefaultButton().setText("OK");
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (this.checkboxTableViewer.getCheckedElements().length >= 1) {
            this.selectAllClearButton.setText("&Clear Selections");
        } else {
            this.selectAllClearButton.setText("Select &All");
        }
        if (this.checkboxTableViewer.getCheckedElements().length == 0) {
            this.selectAllClearButton.setText("Select &All");
        }
        if (this.topLayoutSelection && this.checkboxTableViewer.getCheckedElements().length > 1) {
            this.checkboxTableViewer.setCheckedElements(new Object[]{event.getElement()});
        }
        this.setPageComplete(this.canFlipToNextPage());
    }

    private void createViewer(Composite parent) {
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)this.selectMembersGroup, (int)68354);
        this.membersTable = this.checkboxTableViewer.getTable();
        this.membersTable.setLinesVisible(true);
        this.membersTable.setHeaderVisible(true);
        GridData gd_table = new GridData(4, 4, true, true, 2, 1);
        gd_table.heightHint = 200;
        this.membersTable.setLayoutData((Object)gd_table);
        this.columnSorterListener();
        if (this.getTitle().equalsIgnoreCase("Insert Layout")) {
            this.createInsertLayColumns(parent, this.checkboxTableViewer);
        } else {
            this.createColumns(parent, this.checkboxTableViewer);
        }
        this.checkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.checkboxTableViewer.setInput(null);
    }

    private void createInsertLayColumns(Composite parent, CheckboxTableViewer viewer) {
        String[] titles = new String[]{"Member", "Size", "Created", "Changed", "ID"};
        int[] bounds = new int[]{100, 100, 100, 100, 100};
        viewer.setSorter((ViewerSorter)new GenericAddPageMemberSorter());
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)viewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(titles[i]);
            tableColumn.setWidth(bounds[i]);
            switch (i) {
                case 0: {
                    this.membersTable.setSortColumn(tableColumn);
                    this.membersTable.setSortDirection(128);
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new MemberLabelProvider());
                    break;
                }
                case 1: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new SizeLabelProvider());
                    break;
                }
                case 2: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new CreatedLabelProvider());
                    break;
                }
                case 3: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new ChangedLabelProvider());
                    break;
                }
                case 4: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new IDLabelProvider());
                }
            }
            ++i;
        }
    }

    private void createColumns(Composite parent, CheckboxTableViewer viewer) {
        String[] titles = new String[]{"Member", "Size", "Created", "Changed", "ID", "Description"};
        int[] bounds = new int[]{100, 100, 100, 100, 100, 125};
        viewer.setSorter((ViewerSorter)new GenericAddPageMemberSorter());
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)viewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(titles[i]);
            tableColumn.setWidth(bounds[i]);
            switch (i) {
                case 0: {
                    this.membersTable.setSortColumn(tableColumn);
                    this.membersTable.setSortDirection(128);
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new MemberLabelProvider());
                    break;
                }
                case 1: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new SizeLabelProvider());
                    break;
                }
                case 2: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new CreatedLabelProvider());
                    break;
                }
                case 3: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new ChangedLabelProvider());
                    break;
                }
                case 4: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new IDLabelProvider());
                    break;
                }
                case 5: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new DescriptionLabelProvider());
                }
            }
            ++i;
        }
    }

    private void columnSorterListener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                Table table = AddLayoutPage.this.checkboxTableViewer.getTable();
                if (column.equals(table.getSortColumn())) {
                    int direction = table.getSortDirection();
                    switch (direction) {
                        case 1024: {
                            table.setSortDirection(128);
                            break;
                        }
                        default: {
                            table.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                AddLayoutPage.this.checkboxTableViewer.refresh();
            }
        };
    }

    public void widgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        if (((Button)source).getText().equals("&Select...")) {
            DatasetWizard wizard = new DatasetWizard(true);
            this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
            this.dialog.open();
        } else if (server.getFmpPreferences().getFmParmFilePrefs().getDSNLists().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"DSN lists PDS in preferences is undefined. No DSN lists found");
        } else if (this.dataSetCombo.getText().isEmpty() || Validator.dataset((String)this.dataSetCombo.getText(), (boolean)true) == 3) {
            GenericImportWizard wizard = new GenericImportWizard("Select DSN List", server, false);
            this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
            this.dialog.open();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public IWizardPage getNextPage() {
        FMHistory.clearList((String)"ServerAddLayoutPage1");
        FMHistory.insertHistory((Combo)this.serverNameCombo, (String)"ServerAddLayoutPage1");
        FMHistory.insertHistory((Combo)this.dataSetCombo, (String)"DatasetListAddLayoutPage1");
        FMHistory.insertHistory((Combo)this.memberNameCombo, (String)"MemberListAddLayoutPage1");
        this.changeServer();
        this.dataSetCombo.setText(this.dataSetName);
        if (this.checkboxTableViewer.getCheckedElements().length > 0) {
            this.memberNameCombo.setText(((FileMasterMember)this.checkboxTableViewer.getCheckedElements()[0]).getName());
        }
        FileMasterMember member = CommonMFCalls.getFQMEM((String)this.dataSetCombo.getText(), (String)this.memberNameCombo.getText().trim(), (FileMasterServer)server, (String)"R");
        member.setType("LAYOUT");
        if (CommonMFCalls.RETURN_CODE.equals("0")) {
            if (((InsertTopLayoutWizard)this.getWizard()).getPage("Select top level") == null) {
                AddLayoutPage2 page2 = new AddLayoutPage2("Select top level", server, this.dataSetCombo, this.memberNameCombo, false);
                ((InsertTopLayoutWizard)this.getWizard()).addPage((IWizardPage)page2);
            }
            ((AddLayoutPage2)((InsertTopLayoutWizard)this.getWizard()).getPage("Select top level")).presetText(server, this.dataSetCombo.getText().trim(), this.memberNameCombo.getText().trim());
            return ((InsertTopLayoutWizard)this.getWizard()).getPage("Select top level");
        }
        return null;
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.canFlipToNextPage());
    }

    public boolean canFlipToNextPage() {
        this.error = "";
        boolean returnVal = this.nextOrFinish();
        if (returnVal) {
            returnVal = this.checkboxTableViewer.getCheckedElements().length == 1 || Validator.member((String)this.memberNameCombo.getText(), (boolean)true) == 0;
        }
        return returnVal;
    }

    public boolean canFinish() {
        if (!this.topLayoutSelection) {
            boolean returnVal = false;
            returnVal = this.nextOrFinish();
            if (returnVal) {
                returnVal = true;
            }
            return returnVal;
        }
        return false;
    }

    public boolean nextOrFinish() {
        this.error = "";
        boolean returnVal = false;
        returnVal = super.isPageComplete();
        if (this.dataSetCombo != null && this.memberSelectBtn != null) {
            switch (Validator.dataset((String)this.dataSetCombo.getText(), (boolean)true)) {
                case 0: {
                    this.memberSelectBtn.setEnabled(true);
                    break;
                }
                default: {
                    this.memberSelectBtn.setEnabled(false);
                }
            }
        }
        if (returnVal) {
            returnVal = this.ValidateMember();
        }
        if (this.dataSetCombo != null && this.memberNameCombo != null && this.checkboxTableViewer != null) {
            this.dataSetName = this.dataSetCombo.getText().trim();
            if (returnVal && this.dataSetName.startsWith("\"")) {
                this.dataSetName = this.dataSetName.substring(1, this.dataSetName.length() - 1);
            }
            if (this.getName().equalsIgnoreCase("Add Layout")) {
                if (this.checkboxTableViewer.getCheckedElements().length == 0) {
                    this.memberName = this.memberNameCombo.getText().trim();
                    FileMasterDataset fmdataset = new FileMasterDataset(null);
                    fmdataset.setName(this.dataSetName);
                    fmdataset.setDsOrg("PDS");
                    TT_TreeItem dsItem = null;
                    dsItem = fmltModel.findObject((Object)fmdataset);
                    if (dsItem != null) {
                        FileMasterMember fmmember = new FileMasterMember(dsItem);
                        fmmember.setName(this.memberName);
                    }
                } else {
                    int count = 0;
                    while (count < this.checkboxTableViewer.getCheckedElements().length) {
                        this.memberName = ((FileMasterMember)this.checkboxTableViewer.getCheckedElements()[count]).getName();
                        FileMasterDataset fmdataset = new FileMasterDataset(null);
                        fmdataset.setName(this.dataSetName);
                        fmdataset.setDsOrg("PDS");
                        TT_TreeItem dsItem = null;
                        dsItem = fmltModel.findObject((Object)fmdataset);
                        if (dsItem != null) {
                            FileMasterMember fmmember = new FileMasterMember(dsItem);
                            fmmember.setName(this.memberName);
                        }
                        ++count;
                    }
                }
            }
        }
        return returnVal;
    }

    private String[] getServers() {
        String[] listOfServers = new String[this.fmstModel.getServers().length];
        int serverCount = 0;
        while (serverCount < this.fmstModel.getServers().length) {
            listOfServers[serverCount] = this.fmstModel.getServers()[serverCount].getServer().getText();
            ++serverCount;
        }
        if (!this.isDirectoryListCaller && this.fmstModel.getServers().length > 0) {
            server = (FileMasterServer)this.fmstModel.getServers()[0].getServer();
        }
        this.serverChanged(server);
        return listOfServers;
    }

    protected boolean ValidateMember() {
        if (this.memberNameCombo != null && this.memberSelectBtn != null) {
            if (Validator.member((String)this.memberNameCombo.getText(), (boolean)true) == 0) {
                this.memberSelectBtn.setEnabled(false);
                return true;
            }
            if (this.memberSelectBtn != null && this.checkboxTableViewer != null) {
                switch (Validator.member((String)this.memberNameCombo.getText(), (boolean)true)) {
                    case 0: 
                    case 7: {
                        this.memberSelectBtn.setEnabled(true);
                        break;
                    }
                    case 6: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member((String)this.memberNameCombo.getText(), (boolean)true)] + "\n";
                        this.memberSelectBtn.setEnabled(false);
                        break;
                    }
                    case 5: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member((String)this.memberNameCombo.getText(), (boolean)true)] + "\n";
                        if (this.checkboxTableViewer.getCheckedElements().length <= 0) break;
                        this.error = new String();
                    }
                }
                if (this.error.length() > 0) {
                    this.setErrorMessage(this.error);
                    return this.checkboxTableViewer.getCheckedElements().length > 0;
                }
                this.setErrorMessage(null);
                return this.checkboxTableViewer.getCheckedElements().length > 0;
            }
        }
        return false;
    }

    private void process() {
        fmMemberList.clear();
        int oldCheckedElements = this.checkboxTableViewer.getCheckedElements().length;
        int count = 0;
        while (count < oldCheckedElements) {
            fmMemberList.add((FileMasterMember)this.checkboxTableViewer.getCheckedElements()[count]);
            ++count;
        }
        if (this.xml != null) {
            Element element = this.xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
                numberOfMem.setText("No members returned.");
                numberOfMem.setEnabled(true);
            } else {
                NodeList nodes = element.getElementsByTagName("MemberInfo");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodes.getLength() == 0) {
                    int i = 0;
                    while (i < messages.getLength()) {
                        Node msgNode = messages.item(i);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + AddLayoutPage.getTagValue("Message", msgElement);
                        ++i;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = AddLayoutPage.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                    numberOfMem.setText("No members returned.");
                    numberOfMem.setEnabled(true);
                } else {
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element dsElement = (Element)nodes.item(i);
                        FileMasterMember wcMember = new FileMasterMember(null);
                        wcMember.setName(dsElement.getAttribute("name"));
                        wcMember.setSize(dsElement.getAttribute("recordCount"));
                        wcMember.setDateCreated(dsElement.getAttribute("dateCreated"));
                        wcMember.setDateChanged(dsElement.getAttribute("dateChanged"));
                        wcMember.setTimeChanged(dsElement.getAttribute("timeChanged"));
                        wcMember.setID(dsElement.getAttribute("userID"));
                        wcMember.setCLDescription(dsElement.getAttribute("description"));
                        if (this.getTitle().equalsIgnoreCase("Insert Layout")) {
                            if (wcMember.getCLDescription().isEmpty() && !fmMemberList.contains(wcMember)) {
                                fmMemberList.add(wcMember);
                            }
                        } else if (!fmMemberList.contains(wcMember)) {
                            fmMemberList.add(wcMember);
                        }
                        ++i;
                    }
                    this.checkboxTableViewer.setInput((Object)fmMemberList.toArray(new FileMasterMember[fmMemberList.size()]));
                    this.checkboxTableViewer.refresh();
                    if (fmMemberList.size() == 1) {
                        numberOfMem.setText(String.valueOf(fmMemberList.size()) + " member returned.");
                    } else {
                        numberOfMem.setText(String.valueOf(fmMemberList.size()) + " members returned.");
                    }
                    numberOfMem.setEnabled(true);
                }
            }
        }
        if (fmMemberList.size() > 0) {
            this.selectAllClearButton.setEnabled(true);
        } else {
            this.selectAllClearButton.setEnabled(false);
        }
        Object[] checkedMembers = (Object[])this.checkboxTableViewer.getCheckedElements().clone();
        if (this.checkboxTableViewer.getTable().getItemCount() > 0) {
            if (this.isSingleMember) {
                if (this.checkboxTableViewer.getTable().getItemCount() == 1) {
                    this.checkboxTableViewer.setAllChecked(true);
                } else {
                    this.checkboxTableViewer.setAllChecked(false);
                }
            } else {
                this.selectAllClearButton.setEnabled(true);
                this.checkboxTableViewer.setAllChecked(false);
                int i = 0;
                while (i < this.checkboxTableViewer.getTable().getItemCount()) {
                    int j = 0;
                    while (j < checkedMembers.length) {
                        if (((FileMasterMember)this.checkboxTableViewer.getElementAt(i)).getName().equals(((FileMasterMember)checkedMembers[j]).getName())) {
                            this.checkboxTableViewer.setChecked(this.checkboxTableViewer.getElementAt(i), true);
                        }
                        ++j;
                    }
                    ++i;
                }
                if (this.checkboxTableViewer.getCheckedElements().length == this.checkboxTableViewer.getTable().getItemCount()) {
                    this.selectAllClearButton.setText("&Clear Selections");
                } else {
                    this.selectAllClearButton.setText("Select &All");
                }
            }
        }
    }

    private void changeServer() {
        String TestServer = "";
        int servers = 0;
        while (servers < this.fmstModel.getServers().length) {
            TestServer = this.fmstModel.getServers()[servers].getText();
            if (TestServer.equalsIgnoreCase(this.serverNameCombo.getText())) {
                server = (FileMasterServer)this.fmstModel.getServers()[servers].getAdapter(FileMasterServer.class);
                this.serverChanged(server);
                break;
            }
            ++servers;
        }
    }

    private int displayServerChangedMsg() {
        this.msgDisplayed = true;
        int returncode = -1;
        boolean remove = false;
        if (this.pendingMessage) {
            this.pendingMessage = false;
            if (this.newServer != null && !this.newServer.equals(this.oldServer)) {
                String title = "Confirm Server Change";
                String question = "Are you sure you want to change the server? Clicking yes will reset all fields on this dialog. ";
                String toggleMessage = "Do not ask me again";
                MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Server Change", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)this.store, (String)"CLOSE_VALUE");
                returncode = result.getReturnCode();
                if (returncode == 2) {
                    remove = true;
                }
                if (remove) {
                    this.oldServer = this.newServer;
                    this.store.setValue("CLOSE_VALUE", result.getToggleState());
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.checkboxTableViewer.getTable().removeAll();
                    this.checkboxTableViewer.setInput(null);
                    this.memberNameCombo.setText("");
                    this.dataSetCombo.setText("");
                } else {
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.serverNameCombo.setText(this.oldServer);
                    this.newServer = this.oldServer;
                }
            }
        }
        return returncode;
    }

    private int displayDatasetChangedMsg() {
        this.msgDisplayed = true;
        int returncode = -1;
        boolean remove = false;
        if (this.pendingMessage) {
            this.pendingMessage = false;
            if (this.newDatasetName != null && !this.newDatasetName.equals(this.oldDatasetName)) {
                String title = "Confirm Change Data Set";
                String question = "Are you sure you want to change the data set? Clicking yes will reset all fields on this dialog. ";
                String toggleMessage = "Do not ask me again";
                MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Change Data Set", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)this.store, (String)"CLOSE_VALUE");
                returncode = result.getReturnCode();
                if (returncode == 2) {
                    remove = true;
                }
                if (remove) {
                    this.oldDatasetName = this.newDatasetName;
                    this.store.setValue("CLOSE_VALUE", result.getToggleState());
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.checkboxTableViewer.getTable().removeAll();
                    this.checkboxTableViewer.setInput(null);
                    this.memberNameCombo.setText("");
                } else {
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.dataSetCombo.setText(this.oldDatasetName);
                    this.newDatasetName = this.oldDatasetName;
                }
            }
        }
        return returncode;
    }

    public boolean doFinish() {
        FMHistory.clearList((String)"ServerAddLayoutPage1");
        FMHistory.insertHistory((Combo)this.serverNameCombo, (String)"ServerAddLayoutPage1");
        FMHistory.insertHistory((Combo)this.dataSetCombo, (String)"DatasetListAddLayoutPage1");
        FMHistory.insertHistory((Combo)this.memberNameCombo, (String)"MemberListAddLayoutPage1");
        Object[] checkedLayoutMembers = this.checkboxTableViewer.getCheckedElements();
        boolean isDuplicatedMember = false;
        boolean yesToAll = false;
        boolean noToAll = false;
        boolean singelYes = false;
        String title = "Replace Members";
        String question = "Do you want to replace ";
        if (this.fmdataset == null || !this.fmdataset.getName().equalsIgnoreCase(this.dataSetCombo.getText().trim())) {
            this.fmdataset = CommonMFCalls.getFQDSN((String)this.dataSetCombo.getText(), (String)"", (FileMasterServer)server);
            if (!CommonMFCalls.RETURN_CODE.equals("0")) {
                return false;
            }
        }
        TT_TreeItem dsItem = null;
        dsItem = fmltModel.findObject((Object)this.fmdataset);
        if (dsItem == null) {
            Element dsElement = fmltModel.addDataset(null, this.fmdataset);
            dsItem = fmltModel.insertDataset(dsElement);
        }
        if (checkedLayoutMembers.length == 0) {
            checkedLayoutMembers = new Object[]{new FileMasterMember(null)};
            checkedLayoutMembers[0] = CommonMFCalls.getFQMEM((String)this.fmdataset.getName(), (String)this.memberNameCombo.getText().trim(), (FileMasterServer)server, (String)"R");
            ((FileMasterMember)checkedLayoutMembers[0]).setType("LAYOUT");
            if (!CommonMFCalls.RETURN_CODE.equals("0")) {
                return false;
            }
        }
        FileMasterMember fmmember = new FileMasterMember(null);
        int count = 0;
        while (count < checkedLayoutMembers.length) {
            if (checkedLayoutMembers[count] instanceof FileMasterMember) {
                fmmember.setName(((FileMasterMember)checkedLayoutMembers[count]).getName());
                if (((FileMasterMember)checkedLayoutMembers[count]).getCLDescription() == null || ((FileMasterMember)checkedLayoutMembers[count]).getCLDescription().isEmpty()) {
                    fmmember.setType("LAYOUT");
                } else {
                    fmmember.setCLDescription(((FileMasterMember)checkedLayoutMembers[count]).getCLDescription());
                    fmmember.setType("CRL");
                }
                if (fmltModel.findObjectInTree((Object)fmmember, dsItem) != null) {
                    isDuplicatedMember = true;
                }
                if (isDuplicatedMember) {
                    if (!yesToAll && !noToAll) {
                        MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), "Replace Members", null, String.valueOf(question) + fmmember.getName() + " ?", 3, new String[]{"No", "No &To All", "Yes", "Yes &To All"}, 0);
                        dialog.open();
                        if (dialog.getReturnCode() != 0) {
                            if (dialog.getReturnCode() == 1) {
                                noToAll = true;
                                yesToAll = false;
                            } else if (dialog.getReturnCode() == 2) {
                                fmltModel.removeItem((Object)fmmember);
                                AddLayoutPage.AddUpdateLayViewMem(this.fmdataset, fmmember);
                            } else if (dialog.getReturnCode() == 3) {
                                fmltModel.removeItem((Object)fmmember);
                                AddLayoutPage.AddUpdateLayViewMem(this.fmdataset, fmmember);
                                yesToAll = true;
                            }
                        }
                    }
                    if (yesToAll || singelYes) {
                        fmltModel.removeItem((Object)fmmember);
                        AddLayoutPage.AddUpdateLayViewMem(this.fmdataset, fmmember);
                        singelYes = false;
                    }
                    isDuplicatedMember = false;
                } else if (!isDuplicatedMember) {
                    AddLayoutPage.AddUpdateLayViewMem(this.fmdataset, fmmember);
                }
            }
            ++count;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        try {
            TreeViewer viewer;
            IWorkbenchPage page = window.getActivePage();
            IViewPart view = page.showView("com.ca.filemaster.layout.views.layoutview");
            if (view instanceof LayoutView && (viewer = ((LayoutView)view).getViewer()) != null) {
                TT_TreeItem selection = fmltModel.findObjectInTree((Object)fmmember, fmltModel.findObject((Object)this.fmdataset));
                Object[] expandedElements = viewer.getExpandedElements();
                viewer.setInput((Object)fmltModel.getDatasets());
                viewer.refresh(true);
                viewer.setExpandedElements(expandedElements);
                if (this.isDirectoryListCaller && selection == null) {
                    view = page.showView("com.ca.filemaster.views.directorylist");
                } else {
                    if (selection != null) {
                        viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                    }
                    view = page.showView("com.ca.filemaster.layout.views.layoutview");
                    page.activate((IWorkbenchPart)view);
                    page.bringToTop((IWorkbenchPart)view);
                }
                view.setFocus();
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        fmltModel.save();
        return true;
    }

    public static void AddUpdateLayViewMem(FileMasterDataset fmdataset, FileMasterMember fmmember) {
        TT_TreeItem dsItem = fmltModel.findObject((Object)fmdataset);
        if (fmmember.getType().equals("LAYOUT")) {
            AddLayoutPage.UpdateLayoutViewCB(dsItem, fmdataset, fmmember, server);
        } else {
            AddLayoutPage.UpdateLayoutViewCRL(dsItem, fmdataset, fmmember, server);
        }
    }

    public static Object[] getCB(FileMasterDataset dataset, FileMasterMember member, FileMasterServer server) {
        ArrayList<Object> fmLayoutList = new ArrayList<Object>();
        RunGetViewLayout runner = new RunGetViewLayout(dataset.getText(), member.getText(), server, true);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
            } else {
                NodeList nodes = element.getElementsByTagName("Field");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodes.getLength() == 0) {
                    int i = 0;
                    while (i < messages.getLength()) {
                        Node msgNode = messages.item(i);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + AddLayoutPage.getTagValue("Message", msgElement);
                        ++i;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = AddLayoutPage.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                    return null;
                }
                int i = 0;
                while (i < nodes.getLength()) {
                    Element layoutElement = (Element)nodes.item(i);
                    Element NameElement = (Element)layoutElement.getElementsByTagName("Name").item(0);
                    Element levelElement = (Element)layoutElement.getElementsByTagName("Level").item(0);
                    Element signedElement = (Element)layoutElement.getElementsByTagName("Signed").item(0);
                    Element integerLenElement = (Element)layoutElement.getElementsByTagName("IntegerLength").item(0);
                    Element fractionLenElement = (Element)layoutElement.getElementsByTagName("FractionLength").item(0);
                    Element lengthElement = (Element)layoutElement.getElementsByTagName("Length").item(0);
                    Element positionElement = (Element)layoutElement.getElementsByTagName("Position").item(0);
                    Element redefineInfoElement = (Element)layoutElement.getElementsByTagName("RedefineInfo").item(0);
                    if (AddLayoutPage.getTagValue("Level", levelElement).equalsIgnoreCase("01")) {
                        FileMasterLayout layout = new FileMasterLayout(null);
                        layout.setName(AddLayoutPage.getTagValue("Name", NameElement));
                        layout.setLevel(AddLayoutPage.getTagValue("Level", levelElement));
                        if (signedElement != null) {
                            layout.setSigned(AddLayoutPage.getTagValue("Signed", signedElement));
                        }
                        layout.setIntegerLength(AddLayoutPage.getTagValue("IntegerLength", integerLenElement));
                        layout.setFractionLength(AddLayoutPage.getTagValue("FractionLength", fractionLenElement));
                        layout.setLength(AddLayoutPage.getTagValue("Length", lengthElement));
                        layout.setPosition(AddLayoutPage.getTagValue("Postion", positionElement));
                        if (redefineInfoElement != null) {
                            layout.setRedefineInfo(AddLayoutPage.getTagValue("RedefineInfo", redefineInfoElement));
                        } else {
                            layout.setRedefineInfo("");
                        }
                        fmLayoutList.add(layout);
                    } else {
                        Element formatCharElement = (Element)layoutElement.getElementsByTagName("FormatChar").item(0);
                        FileMasterLayoutField layout = new FileMasterLayoutField(null);
                        layout.setName(AddLayoutPage.getTagValue("Name", NameElement));
                        layout.setLevel(AddLayoutPage.getTagValue("Level", levelElement));
                        if (formatCharElement != null) {
                            layout.setFormatChar(AddLayoutPage.getTagValue("FormatChar", formatCharElement));
                        }
                        if (signedElement != null) {
                            layout.setSigned(AddLayoutPage.getTagValue("Signed", signedElement));
                        }
                        layout.setIntegerLength(AddLayoutPage.getTagValue("IntegerLength", integerLenElement));
                        layout.setFractionLength(AddLayoutPage.getTagValue("FractionLength", fractionLenElement));
                        layout.setLength(AddLayoutPage.getTagValue("Length", lengthElement));
                        layout.setPosition(AddLayoutPage.getTagValue("Postion", positionElement));
                        if (redefineInfoElement != null) {
                            layout.setRedefineInfo(AddLayoutPage.getTagValue("RedefineInfo", redefineInfoElement));
                        } else {
                            layout.setRedefineInfo("");
                        }
                        fmLayoutList.add(layout);
                    }
                    ++i;
                }
            }
        }
        return fmLayoutList.toArray();
    }

    public static void UpdateLayoutViewCB(TT_TreeItem dsItem, FileMasterDataset dataset, FileMasterMember member, FileMasterServer server) {
        Object[] fmLayoutList = AddLayoutPage.getCB(dataset, member, server);
        if (fmLayoutList != null && fmLayoutList.length > 0) {
            memElement = fmltModel.addMember(dsItem.getElement(), member.getName(), member.getType());
            memItem = fmltModel.insertMember(dsItem, memElement);
            Element fmlayoutElement = null;
            TT_TreeItem fmlayoutItem = null;
            int countLay = 0;
            while (countLay < fmLayoutList.length) {
                if (fmLayoutList[countLay] instanceof FileMasterLayout) {
                    fmlayoutElement = fmltModel.addLayout(memElement, (FileMasterLayout)fmLayoutList[countLay]);
                    fmlayoutItem = fmltModel.insertLayout(memItem, fmlayoutElement);
                } else {
                    Element fmlayoutfieldElement;
                    FileMasterLayoutField fmlayoutfield = new FileMasterLayoutField(null);
                    fmlayoutfield.setName(((FileMasterLayoutField)fmLayoutList[countLay]).getName());
                    fmlayoutfield.setLevel(((FileMasterLayoutField)fmLayoutList[countLay]).getLevel());
                    if (fmlayoutElement != null) {
                        fmlayoutfieldElement = fmltModel.addLayoutField(fmlayoutElement, (FileMasterLayoutField)fmLayoutList[countLay]);
                        fmltModel.insertLayoutField(fmlayoutItem, fmlayoutfieldElement);
                    } else {
                        fmlayoutfieldElement = fmltModel.addLayoutField(memElement, (FileMasterLayoutField)fmLayoutList[countLay]);
                        fmltModel.insertLayoutField(memItem, fmlayoutfieldElement);
                    }
                }
                ++countLay;
            }
        }
    }

    public static CRLClass getCRL(FileMasterDataset dataset, FileMasterMember member, FileMasterServer server) {
        RunGetCRLMem runner = new RunGetCRLMem(server, dataset, member);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
            } else {
                NodeList crlEntryNodes = element.getElementsByTagName("CrlEntry");
                NodeList nodes = element.getElementsByTagName("CrlField");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                int i = 0;
                while (i < messages.getLength()) {
                    Node msgNode = messages.item(i);
                    Element msgElement = (Element)msgNode;
                    message = String.valueOf(message) + AddLayoutPage.getTagValue("Message", msgElement);
                    ++i;
                }
                Node rcNode = retCode.item(0);
                Element rcElement = (Element)rcNode;
                String returnCode = AddLayoutPage.getTagValue("ReturnCode", rcElement);
                if (nodes.getLength() == 0) {
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                    return null;
                }
                if (!returnCode.equals("0")) {
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                }
                crl = new CRLClass();
                NodeList crlHdrInfoNodes = element.getElementsByTagName("CrlHdrInfo");
                crl.setDescription(((Element)crlHdrInfoNodes.item(0)).getAttribute("FMProcessingParmDescription"));
                crl.setProcParmVersion(((Element)crlHdrInfoNodes.item(0)).getAttribute("FMProcessingParmVersion"));
                String offset = ((Element)crlHdrInfoNodes.item(0)).getAttribute("recordoffset");
                if (!offset.isEmpty()) {
                    if (offset.startsWith("+")) {
                        offset = offset.substring(1);
                    }
                    try {
                        crl.setOffset(Integer.valueOf(offset).intValue());
                    }
                    catch (NumberFormatException e) {
                        crl.setOffset(0);
                    }
                }
                int CRLEntryCount = 0;
                while (CRLEntryCount < crlEntryNodes.getLength()) {
                    Element layoutElement = (Element)crlEntryNodes.item(CRLEntryCount);
                    Element DsnElement = (Element)layoutElement.getElementsByTagName("DataSetName").item(0);
                    Element MemberElement = (Element)layoutElement.getElementsByTagName("MemberName").item(0);
                    CRLClass cRLClass = crl;
                    cRLClass.getClass();
                    crl.addLayout(new CRLClass.Layout(cRLClass, CommonMFCalls.getTagValue((String)"DataSetName", (Element)DsnElement), CommonMFCalls.getTagValue((String)"MemberName", (Element)MemberElement), layoutElement.hasAttribute("default")));
                    NodeList crlFieldNodes = layoutElement.getElementsByTagName("CrlField");
                    int CRLFieldCount = 0;
                    while (CRLFieldCount < crlFieldNodes.getLength()) {
                        Element crlField = (Element)crlFieldNodes.item(CRLFieldCount);
                        String fieldName = CommonMFCalls.getTagValue((String)"Name", (Element)((Element)crlField.getElementsByTagName("Name").item(0)));
                        int level = Integer.parseInt(CommonMFCalls.getTagValue((String)"Level", (Element)((Element)crlField.getElementsByTagName("Level").item(0))));
                        boolean isTop = level == 1;
                        int position = Integer.parseInt(CommonMFCalls.getTagValue((String)"Position", (Element)((Element)crlField.getElementsByTagName("Position").item(0))));
                        String formatType = "";
                        int formatNum = 0;
                        int formatDec = 0;
                        int length = 0;
                        int logOperator = 0;
                        int operator = 0;
                        String value = "";
                        boolean selected = !((Element)crlFieldNodes.item(CRLFieldCount)).getAttribute("excluded").equalsIgnoreCase("Y");
                        if (crlField.getElementsByTagName("FormatChar").getLength() > 0) {
                            formatType = CommonMFCalls.getTagValue((String)"FomatChar", (Element)((Element)crlField.getElementsByTagName("FormatChar").item(0)));
                            if (crlField.getElementsByTagName("Signed").getLength() > 0 && (CommonMFCalls.getTagValue((String)"Signed", (Element)((Element)crlField.getElementsByTagName("Signed").item(0))).equalsIgnoreCase("S") || CommonMFCalls.getTagValue((String)"Signed", (Element)((Element)crlField.getElementsByTagName("Signed").item(0))).equalsIgnoreCase("Y"))) {
                                formatType = String.valueOf(formatType) + "S";
                            }
                        }
                        if (crlField.getElementsByTagName("IntegerLength").getLength() > 0) {
                            formatNum = Integer.parseInt(CommonMFCalls.getTagValue((String)"IntegerLength", (Element)((Element)crlField.getElementsByTagName("IntegerLength").item(0))));
                        }
                        if (crlField.getElementsByTagName("DecimalLength").getLength() > 0) {
                            formatDec = Integer.parseInt(CommonMFCalls.getTagValue((String)"DecimalLength", (Element)((Element)crlField.getElementsByTagName("DecimalLength").item(0))));
                        }
                        if (crlField.getElementsByTagName("Length").getLength() > 0) {
                            length = Integer.parseInt(CommonMFCalls.getTagValue((String)"Length", (Element)((Element)crlField.getElementsByTagName("Length").item(0))));
                        }
                        if (crlField.getElementsByTagName("ORorAND").getLength() > 0) {
                            String logOp = CommonMFCalls.getTagValue((String)"ORorAND", (Element)((Element)crlField.getElementsByTagName("ORorAND").item(0)));
                            if (logOp.equalsIgnoreCase("O")) {
                                logOperator = 1;
                            } else if (logOp.equalsIgnoreCase("A")) {
                                logOperator = 2;
                            }
                        }
                        if (crlField.getElementsByTagName("Operand").getLength() > 0) {
                            String operand = CommonMFCalls.getTagValue((String)"Operand", (Element)((Element)crlField.getElementsByTagName("Operand").item(0)));
                            if (operand.equals("None")) {
                                operator = 0;
                            } else if (operand.equals("EQ") || operand.equals("=")) {
                                operator = 1;
                            } else if (operand.equals("NE") || operand.equals("^=") || operand.equals("<>") || operand.equals("\ufffd=")) {
                                operator = 2;
                            } else if (operand.equals("GT") || operand.equals(">")) {
                                operator = 3;
                            } else if (operand.equals("LT") || operand.equals("<")) {
                                operator = 4;
                            } else if (operand.equals("GE") || operand.equals(">=")) {
                                operator = 5;
                            } else if (operand.equals("LE") || operand.equals("<=")) {
                                operator = 6;
                            } else if (operand.equals("CO")) {
                                operator = 7;
                            }
                        }
                        if (crlField.getElementsByTagName("Condition").getLength() > 0) {
                            value = CommonMFCalls.getTagValue((String)"Condition", (Element)((Element)crlField.getElementsByTagName("Condition").item(0)));
                        }
                        crl.getLayout(CRLEntryCount).addField(fieldName, level, isTop, selected, position, formatType, formatNum, formatDec, length, logOperator, operator, value);
                        ++CRLFieldCount;
                    }
                    ++CRLEntryCount;
                }
            }
        }
        return crl;
    }

    public static void UpdateLayoutViewCRL(TT_TreeItem dsItem, FileMasterDataset dataset, FileMasterMember member, FileMasterServer server) {
        if (AddLayoutPage.getCRL(dataset, member, server) != null) {
            memElement = fmltModel.addMember(dsItem.getElement(), member.getName(), member.getType(), member.getCLDescription(), 0);
            memItem = fmltModel.insertMember(dsItem, memElement);
            int i = 0;
            while (i < crl.getLayouts().size()) {
                FileMasterLayout fmlayout = new FileMasterLayout(null);
                fmlayout.setName(String.valueOf(crl.getLayout(i).getLayoutMember()) + ": " + crl.getLayout(i).getTopLayoutField());
                fmlayout.setLevel(crl.getLayout(i).getTopLayoutLevelString());
                Element fmlayoutElement = fmltModel.addLayout(memItem.getElement(), fmlayout.getName(), crl.getLayout(i).getLayoutDataset(), crl.getLayout(i).getLayoutMember(), crl.getLayout(i).isDefault());
                TT_TreeItem fmlayoutItem = fmltModel.insertLayout(memItem, fmlayoutElement);
                int j = 0;
                while (j < crl.getLayout(i).getLayoutFields().size()) {
                    FileMasterLayoutField fmlayoutfield = new FileMasterLayoutField(null);
                    fmlayoutfield.setName(crl.getLayout(i).getLayoutField(j).getField());
                    fmlayoutfield.setLevel(crl.getLayout(i).getLayoutField(j).getLevelString());
                    Element fmlayoutfieldElement = fmltModel.addLayoutField(fmlayoutElement, fmlayoutfield.getName(), fmlayoutfield.getLevel(), crl.getLayout(i).getLayoutField(j).isTop(), crl.getLayout(i).getLayoutField(j).isSelected(), crl.getLayout(i).getLayoutField(j).getPosition(), crl.getLayout(i).getLayoutField(j).getFormatType(), crl.getLayout(i).getLayoutField(j).getFormatNum(), crl.getLayout(i).getLayoutField(j).getFormatDec(), crl.getLayout(i).getLayoutField(j).getLogOperator(), crl.getLayout(i).getLayoutField(j).getOperator(), crl.getLayout(i).getLayoutField(j).getValue());
                    fmltModel.insertLayoutField(fmlayoutItem, fmlayoutfieldElement);
                    ++j;
                }
                ++i;
            }
            fmltModel.save();
        }
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        return nValue.getNodeValue();
    }
}

