/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.ui.wizards.DatasetWizard;
import com.ca.filemaster.ui.wizards.DatasetWizardPage;
import com.ca.filemaster.ui.wizards.GenericImportWizard;
import com.ca.filemaster.views.report.ReportView;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.UUID;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class FileMasterWizard
extends WizardPage
implements ModifyListener {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    protected Composite container;
    protected Composite dataSetComposite;
    protected Label dataSetLabel;
    protected String dataSetName;
    public Combo dataSetCombo;
    protected Button dataSetSelectBtn;
    protected Button dataSetDSNListBtn;
    protected TestingToolsWizardDialog dialog = null;
    protected String error = "";
    protected GridData data;
    protected FileMasterServer server;
    public FileMasterDataset fmdataset;

    public FileMasterWizard(String pageName, String dataSetName, FileMasterServer server) {
        super(pageName);
        this.dataSetName = dataSetName;
        this.server = server;
    }

    public FileMasterWizard(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.dataSetComposite = new Composite(this.container, 0);
        this.dataSetComposite.setLayout((Layout)new GridLayout(4, false));
        this.setControl((Control)this.container);
    }

    public void createDataSet() {
        this.createDataSet("&Data set name:");
    }

    public void createDataSet(String labelText) {
        this.dataSetLabel = new Label(this.dataSetComposite, 0);
        this.dataSetLabel.setText(labelText);
        this.dataSetCombo = new Combo(this.dataSetComposite, 2048);
        this.dataSetCombo.addModifyListener((ModifyListener)this);
        this.dataSetCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.data = new GridData();
        this.data.horizontalAlignment = 4;
        this.data.verticalAlignment = 0;
        this.data.grabExcessHorizontalSpace = true;
        this.data.grabExcessVerticalSpace = true;
        this.data.horizontalSpan = 1;
        this.data.verticalSpan = 1;
        this.dataSetCombo.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
        TextUtil.setWidth((Combo)this.dataSetCombo, (int)37);
        this.dataSetCombo.setTextLimit(44);
        this.dataSetSelectBtn = new Button(this.dataSetComposite, 0);
        this.dataSetSelectBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileMasterWizard.this.FMWWidgetSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.dataSetSelectBtn.setText("&Select...");
        this.dataSetDSNListBtn = new Button(this.dataSetComposite, 0);
        this.dataSetDSNListBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileMasterWizard.this.FMWWidgetSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.dataSetDSNListBtn.setText("DSN &List...");
        this.dataSetDSNListBtn.setVisible(false);
    }

    public void FMWWidgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        if (source instanceof Button) {
            if (((Button)source).getText().equals("&Select...")) {
                DatasetWizard wizard = new DatasetWizard(true, this.dataSetCombo.getText(), "", this.server.getName());
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
                this.dialog.create();
                DatasetWizardPage.dsnValue.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        FileMasterWizard.this.fmdataset = DatasetWizardPage.getSelectedDSN();
                        FileMasterWizard.this.dataSetCombo.setText(FileMasterWizard.this.fmdataset.getName());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                this.dialog.open();
            } else if (this.server.getFmpPreferences().getFmParmFilePrefs().getDSNLists().isEmpty()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)Validator.errorMsg[20]);
            } else {
                GenericImportWizard wizard = new GenericImportWizard("Select DSN List", this.server, false);
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
                this.dialog.open();
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        return this.isPageComplete(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isPageComplete(boolean value) {
        if (this.dataSetCombo != null && this.dataSetSelectBtn != null) {
            switch (Validator.dataset(this.dataSetCombo.getText(), value)) {
                case 3: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[3] + "\n";
                    this.dataSetSelectBtn.setEnabled(true);
                    this.dataSetDSNListBtn.setEnabled(true);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.dataset(this.dataSetCombo.getText(), true)] + "\n ";
                    this.dataSetSelectBtn.setEnabled(false);
                    break;
                }
                case 0: {
                    this.dataSetSelectBtn.setEnabled(false);
                    break;
                }
            }
        }
        if (this.error.equalsIgnoreCase(Validator.errorMsg[3])) {
            return false;
        }
        if (this.error.length() <= 0) {
            this.setErrorMessage(null);
            return true;
        }
        if (this.getErrorMessage() == null) {
            this.setErrorMessage(this.error);
            this.error = new String();
            return false;
        }
        if (!this.getErrorMessage().equalsIgnoreCase(this.error)) {
            this.setErrorMessage(this.error);
            this.error = new String();
            return false;
        }
        this.error = new String();
        return false;
    }

    public IViewPart updateReportsView(String[] content) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            if (!content.toString().isEmpty()) {
                IViewPart view = page.showView("com.ca.filemaster.views.reportsview", UUID.randomUUID().toString(), 1);
                if (view instanceof ReportView) {
                    ((ReportView)view).updateReportViewer(content);
                }
                return view;
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void serverChanged(FileMasterServer server) {
        this.server = server;
    }

    public Combo getDataSetCombo() {
        return this.dataSetCombo;
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public void setDataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
    }
}

