/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMLayoutTreeModel;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.GenericSelectionCriteriaBox;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.ui.wizards.DatasetWizard;
import com.ca.filemaster.ui.wizards.DatasetWizardPage;
import com.ca.filemaster.ui.wizards.GenericImportWizard;
import com.ca.filemaster.ui.wizards.LayoutMemberWizard;
import com.ca.filemaster.ui.wizards.LayoutMemberWizardPage;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class GenericLayoutBox
implements ModifyListener {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private FMLayoutTreeModel fmltModel = FMLayoutTreeModel.getInstance();
    private ArrayList<String> layoutViewDS;
    private String serverName;
    private FileMasterServer server;
    public Button layoutDsnRadio;
    public Button layoutViewRadio;
    public Combo layoutViewCombo;
    public Combo layoutDataSetCombo;
    public Button layoutDataSetSelectBtn;
    public Button layoutDataSetDSNListBtn;
    public Label layoutMemberNameLabel;
    public Combo layoutMemberNameCombo;
    public Button layoutMemberSelectBtn;
    private Object wizard;
    private Shell parentShell;
    private boolean isMandatory = false;
    private String layoutDS;
    private String layoutMem;
    private FileMasterDataset fmdataset;
    private FileMasterMember member;
    public Button useOldDataSetLayoutCheckBtn;
    private GenericSelectionCriteriaBox genSelCriteriaBox;

    public GenericLayoutBox(String serverName, Object wizard, String layoutDS, String layoutMem, String layoutGroup) {
        this.serverName = serverName;
        this.server = FMServerTreeModel.getInstance().getServer(serverName);
        this.wizard = wizard;
        this.layoutDS = layoutDS;
        this.layoutMem = layoutMem;
        if (wizard instanceof WizardPage) {
            this.parentShell = ((WizardPage)wizard).getShell();
        } else if (wizard instanceof FileMasterWizard) {
            this.parentShell = ((FileMasterWizard)((Object)wizard)).getShell();
        }
        this.genSelCriteriaBox = new GenericSelectionCriteriaBox(serverName, this, this, true, "", "");
    }

    public void createLayoutBox(Composite parent, String layoutGroupName) {
        this.createLayoutBox(parent, layoutGroupName, "Layout vie&w:", "&Data set name:", "&Select...", "DSN &List...", "&Member name:", "S&elect...");
    }

    public void createLayoutBox(Composite parent, String layoutGroupName, String layoutViewLabel, String dataSetNameLabel, String dataSetSelectLabel, String dsnListLabel, String memberNameLabel, String memberSelectLabel) {
        String layoutViewItem;
        int selectedItem;
        GridData data = new GridData();
        Group layoutGroup = new Group(parent, 0);
        layoutGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        if (layoutGroupName == "oldLayout") {
            layoutGroup.setText("Old data set layout");
        } else if (layoutGroupName == "newLayout") {
            layoutGroup.setText("New data set layout");
        } else if (layoutGroupName == "") {
            layoutGroup.setText("Layout");
        }
        layoutGroup.setLayout((Layout)new GridLayout(1, false));
        Composite compositelay = new Composite((Composite)layoutGroup, 0);
        GridLayout container_compositelay = new GridLayout(4, false);
        compositelay.setLayout((Layout)container_compositelay);
        this.layoutViewRadio = new Button(compositelay, 16);
        this.layoutViewRadio.setText(layoutViewLabel);
        this.layoutViewRadio.setLayoutData((Object)data);
        this.layoutViewRadio.setSelection(true);
        this.layoutViewCombo = new Combo(compositelay, 8);
        this.layoutViewCombo.setVisibleItemCount(10);
        TextUtil.setWidth((Combo)this.layoutViewCombo, (int)37);
        GridData gd_layoutViewCombo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_layoutViewCombo.horizontalIndent = 2;
        this.layoutViewCombo.setLayoutData((Object)gd_layoutViewCombo);
        this.layoutViewDS = new ArrayList();
        this.layoutViewDS.add("(none)");
        int count = 0;
        while (count < this.fmltModel.getDatasets().length) {
            int childCount = 0;
            while (childCount < this.fmltModel.getDatasets()[count].getChildren().length) {
                this.layoutViewDS.add(String.valueOf(this.fmltModel.getDatasets()[count].getName()) + "(" + ((TT_TreeItem)this.fmltModel.getDatasets()[count].getChildren()[childCount]).getName() + ")");
                ++childCount;
            }
            ++count;
        }
        this.layoutViewCombo.setItems(this.layoutViewDS.toArray(new String[this.layoutViewDS.size()]));
        this.layoutViewCombo.select(0);
        new Label(compositelay, 0);
        new Label(compositelay, 0);
        this.layoutDsnRadio = new Button(compositelay, 16);
        this.layoutDsnRadio.setText(dataSetNameLabel);
        this.layoutDsnRadio.setLayoutData((Object)data);
        this.layoutDataSetCombo = new Combo(compositelay, 0);
        GridData gd_layoutDataSetNameCombo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_layoutDataSetNameCombo.horizontalIndent = 2;
        this.layoutDataSetCombo.setLayoutData((Object)gd_layoutDataSetNameCombo);
        TextUtil.setWidth((Combo)this.layoutDataSetCombo, (int)37);
        this.layoutDataSetCombo.setTextLimit(44);
        this.layoutDataSetCombo.setText(this.layoutDS);
        this.layoutDataSetSelectBtn = new Button(compositelay, 0);
        this.layoutDataSetSelectBtn.setText(dataSetSelectLabel);
        this.layoutDataSetDSNListBtn = new Button(compositelay, 0);
        this.layoutDataSetDSNListBtn.setText(dsnListLabel);
        this.layoutDataSetDSNListBtn.setVisible(false);
        this.layoutMemberNameLabel = new Label(compositelay, 0);
        GridData gd_layoutMemberNameLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_layoutMemberNameLabel.horizontalIndent = 16;
        this.layoutMemberNameLabel.setLayoutData((Object)gd_layoutMemberNameLabel);
        this.layoutMemberNameLabel.setText(memberNameLabel);
        this.layoutMemberNameLabel.setEnabled(true);
        this.layoutMemberNameCombo = new Combo(compositelay, 0);
        this.layoutMemberNameCombo.setTextLimit(8);
        GridData gd_layoutMemberNameCombo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_layoutMemberNameCombo.horizontalIndent = 2;
        this.layoutMemberNameCombo.setLayoutData((Object)gd_layoutMemberNameCombo);
        TextUtil.setWidth((Combo)this.layoutMemberNameCombo, (int)37);
        this.layoutMemberNameCombo.setText(this.layoutMem);
        this.layoutMemberSelectBtn = new Button(compositelay, 0);
        this.layoutMemberSelectBtn.setText(memberSelectLabel);
        new Label(compositelay, 0);
        this.disableDsn();
        FMHistory.intializeComboBoxes(this.layoutDataSetCombo, "layoutDataSetComboGenericOptions");
        FMHistory.intializeComboBoxes(this.layoutMemberNameCombo, "layoutMemberNameComboGenericOptions");
        if (layoutGroupName == "oldLayout") {
            new Label(compositelay, 0);
            new Label(compositelay, 0);
            new Label(compositelay, 0);
            new Label(compositelay, 0);
            this.genSelCriteriaBox.createConditionBoxContent(compositelay, "La&yout...", "&Validate", "&Import...");
        }
        if ((selectedItem = this.layoutViewDS.indexOf(layoutViewItem = String.valueOf(this.layoutDS) + "(" + this.layoutMem + ")")) == -1) {
            this.layoutViewCombo.select(0);
            this.layoutDataSetCombo.setText(this.layoutDS);
            this.layoutMemberNameCombo.setText(this.layoutMem);
            this.layoutDsnRadio.setSelection(true);
            this.layoutViewRadio.setSelection(false);
            this.layoutViewCombo.setEnabled(false);
            this.layoutDataSetCombo.setEnabled(true);
            this.layoutMemberNameCombo.setEnabled(true);
        } else {
            this.layoutViewCombo.select(selectedItem);
            this.layoutDsnRadio.setSelection(false);
            this.layoutViewRadio.setSelection(true);
            this.layoutViewCombo.setEnabled(true);
            this.layoutDataSetCombo.setEnabled(false);
            this.layoutMemberNameCombo.setEnabled(false);
        }
        this.layoutDataSetCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.layoutMemberNameCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.layoutViewCombo.addModifyListener((ModifyListener)this);
        this.layoutDataSetCombo.addModifyListener((ModifyListener)this);
        this.layoutMemberNameCombo.addModifyListener((ModifyListener)this);
        this.layoutViewRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GenericLayoutBox.this.layoutViewCombo.setEnabled(true);
                GenericLayoutBox.this.disableDsn();
                GenericLayoutBox.this.callParentComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.layoutDsnRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GenericLayoutBox.this.layoutViewCombo.setEnabled(false);
                GenericLayoutBox.this.enableDsn();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.layoutDataSetSelectBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenericLayoutBox.this.genericWidgetSelected(e);
            }
        });
        this.layoutDataSetDSNListBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenericLayoutBox.this.genericWidgetSelected(e);
            }
        });
        this.layoutMemberSelectBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String oldMemberName = GenericLayoutBox.this.layoutMemberNameCombo.getText();
                GenericLayoutBox.this.fmdataset = CommonMFCalls.getFQDSN(GenericLayoutBox.this.layoutDataSetCombo.getText(), "", GenericLayoutBox.this.server);
                GenericLayoutBox.this.member = new FileMasterMember(null);
                GenericLayoutBox.this.member.setName(oldMemberName);
                WizardDialog dialog = new WizardDialog(GenericLayoutBox.this.parentShell, (IWizard)new LayoutMemberWizard(GenericLayoutBox.this.member, GenericLayoutBox.this.fmdataset, GenericLayoutBox.this.server, true));
                dialog.create();
                dialog.open();
                oldMemberName = ((LayoutMemberWizardPage)dialog.getCurrentPage()).getMemberName();
                GenericLayoutBox.this.layoutMemberNameCombo.setText(oldMemberName);
            }
        });
    }

    private void genericWidgetSelected(SelectionEvent e) {
        TestingToolsWizardDialog dialog = null;
        Widget source = e.widget;
        if (source instanceof Button) {
            if (((Button)source).getText().equals("&Select...")) {
                DatasetWizard wizard = new DatasetWizard(true, this.layoutDataSetCombo.getText(), "", this.serverName);
                dialog = new TestingToolsWizardDialog(this.parentShell, (IWizard)wizard);
                dialog.create();
                DatasetWizardPage.dsnValue.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        GenericLayoutBox.this.fmdataset = DatasetWizardPage.getSelectedDSN();
                        GenericLayoutBox.this.layoutDataSetCombo.setText(GenericLayoutBox.this.fmdataset.getName());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                dialog.open();
            } else if (this.server.getFmpPreferences().getFmParmFilePrefs().getDSNLists().isEmpty()) {
                MessageDialog.openWarning((Shell)this.parentShell, (String)"Warning", (String)Validator.errorMsg[20]);
            } else {
                GenericImportWizard wizard = new GenericImportWizard("Select DSN List", this.server, false);
                dialog = new TestingToolsWizardDialog(this.parentShell, (IWizard)wizard);
                dialog.open();
            }
        }
    }

    public void disableLayoutBox() {
        this.layoutDsnRadio.setEnabled(false);
        this.layoutViewRadio.setEnabled(false);
        this.layoutViewCombo.setEnabled(false);
        this.disableDsn();
    }

    public void enableLayoutBox() {
        this.layoutDsnRadio.setEnabled(true);
        this.layoutViewRadio.setEnabled(true);
        if (this.layoutViewRadio.getSelection()) {
            this.layoutViewCombo.setEnabled(true);
        } else {
            this.enableDsn();
        }
    }

    public void disableDsn() {
        this.layoutDataSetCombo.setEnabled(false);
        this.layoutMemberNameCombo.setEnabled(false);
        this.layoutDataSetDSNListBtn.setEnabled(false);
        this.layoutMemberSelectBtn.setEnabled(false);
        this.layoutDataSetSelectBtn.setEnabled(false);
    }

    public boolean isLayoutSet() {
        return (this.layoutDsnRadio != null && this.layoutDataSetCombo != null && this.layoutMemberNameCombo != null || this.layoutViewCombo != null) && (this.layoutDsnRadio.getSelection() ? this.layoutDataSetCombo.getText().trim().length() > 0 && this.layoutMemberNameCombo.getText().trim().length() > 0 && this.validateLayoutBox().length() == 0 : this.layoutViewCombo.getSelectionIndex() > 0);
    }

    public String getSelCriteriaBoxText() {
        return this.genSelCriteriaBox.getText();
    }

    public void AddLayoutSelCondition(String layoutSelCondition) {
        this.genSelCriteriaBox.setText(layoutSelCondition);
    }

    public boolean isLayoutViewSelected() {
        if (this.layoutViewRadio != null) {
            return this.layoutViewRadio.getSelection();
        }
        return false;
    }

    public String getLayoutDataSetName() {
        return this.layoutDataSetCombo == null ? "" : this.layoutDataSetCombo.getText().trim();
    }

    public String getLayoutMemberName() {
        return this.layoutMemberNameCombo == null ? "" : this.layoutMemberNameCombo.getText().trim();
    }

    public void setLayoutDataSetName(String layoutDataSetName) {
        this.layoutDataSetCombo.setText(layoutDataSetName);
    }

    public void setLayoutMemberName(String layoutMemberName) {
        this.layoutMemberNameCombo.setText(layoutMemberName);
    }

    public String getLayoutViewComboString() {
        if (this.layoutViewCombo == null) {
            return "(none)";
        }
        if (this.layoutViewCombo.getSelectionIndex() > 0) {
            return this.layoutViewCombo.getItem(this.layoutViewCombo.getSelectionIndex());
        }
        return "(none)";
    }

    public void setLayoutMandatory(boolean mandatory) {
        this.isMandatory = mandatory;
        this.callParentComplete();
    }

    public void updateHistory() {
        FMHistory.insertHistory(this.layoutDataSetCombo, "layoutDataSetComboGenericOptions");
        FMHistory.insertHistory(this.layoutMemberNameCombo, "layoutMemberNameComboGenericOptions");
    }

    public void setDsnActive() {
        this.layoutViewRadio.setSelection(false);
        this.layoutViewCombo.setEnabled(false);
        this.layoutDsnRadio.setSelection(true);
        this.enableDsn();
    }

    public void enableDsn() {
        this.layoutDataSetCombo.setEnabled(true);
        this.layoutMemberNameCombo.setEnabled(true);
        this.layoutDataSetDSNListBtn.setEnabled(true);
        this.layoutMemberNameLabel.setEnabled(true);
        this.callParentComplete();
        this.layoutDataSetCombo.setFocus();
    }

    private void callParentComplete() {
        if (this.wizard instanceof WizardPage) {
            ((WizardPage)this.wizard).setPageComplete(((WizardPage)this.wizard).isPageComplete());
        } else if (this.wizard instanceof FileMasterWizard) {
            ((FileMasterWizard)((Object)this.wizard)).setPageComplete(((FileMasterWizard)((Object)this.wizard)).isPageComplete());
        }
    }

    public String validateLayoutBox() {
        String error = "";
        if (this.isMandatory) {
            if (this.layoutViewRadio.getSelection() && this.layoutViewCombo.getSelectionIndex() == 0) {
                return "Please select a layout data set and member\n ";
            }
            if (this.layoutDsnRadio.getSelection() && Validator.dataset(this.layoutDataSetCombo.getText(), true) == 1) {
                return Validator.errorMsg[Validator.dataset(this.layoutDataSetCombo.getText(), true)];
            }
        }
        if (this.layoutDsnRadio.getSelection() && this.layoutDsnRadio.getEnabled()) {
            switch (Validator.dataset(this.layoutDataSetCombo.getText(), false)) {
                case 3: {
                    error = String.valueOf(error) + Validator.errorMsg[3] + "\n ";
                    this.layoutDataSetSelectBtn.setEnabled(true);
                    this.layoutDataSetDSNListBtn.setEnabled(true);
                    this.layoutMemberSelectBtn.setEnabled(false);
                    break;
                }
                case 2: 
                case 4: {
                    error = String.valueOf(error) + Validator.errorMsg[Validator.dataset(this.layoutDataSetCombo.getText(), true)] + "\n ";
                    this.layoutDataSetSelectBtn.setEnabled(false);
                    this.layoutDataSetDSNListBtn.setEnabled(false);
                    this.layoutMemberSelectBtn.setEnabled(false);
                    break;
                }
                case 0: {
                    this.layoutDataSetSelectBtn.setEnabled(false);
                    this.layoutMemberSelectBtn.setEnabled(false);
                }
            }
            switch (Validator.member(this.layoutMemberNameCombo.getText(), false)) {
                case 7: {
                    if (Validator.dataset(this.layoutDataSetCombo.getText(), true) != 1) {
                        this.layoutMemberSelectBtn.setEnabled(true);
                        error = String.valueOf(error) + Validator.errorMsg[Validator.member(this.layoutMemberNameCombo.getText(), true)] + "\n ";
                        break;
                    }
                    error = String.valueOf(error) + Validator.errorMsg[Validator.dataset(this.layoutDataSetCombo.getText(), true)] + "\n ";
                    this.layoutMemberSelectBtn.setEnabled(false);
                    break;
                }
                case 6: {
                    error = Validator.dataset(this.layoutDataSetCombo.getText(), true) != 1 ? String.valueOf(error) + Validator.errorMsg[Validator.member(this.layoutMemberNameCombo.getText(), false)] + "\n " : String.valueOf(error) + Validator.errorMsg[Validator.dataset(this.layoutDataSetCombo.getText(), true)] + "\n ";
                    this.layoutMemberSelectBtn.setEnabled(false);
                    break;
                }
                case 0: {
                    if (Validator.member(this.layoutMemberNameCombo.getText(), true) != 5) {
                        if (Validator.dataset(this.layoutDataSetCombo.getText(), true) == 1) {
                            error = String.valueOf(error) + Validator.errorMsg[Validator.dataset(this.layoutDataSetCombo.getText(), true)] + "\n ";
                        }
                        this.layoutMemberSelectBtn.setEnabled(false);
                        break;
                    }
                    if (Validator.dataset(this.layoutDataSetCombo.getText(), true) == 1) break;
                    error = String.valueOf(error) + Validator.errorMsg[Validator.member(this.layoutMemberNameCombo.getText(), true)] + "\n ";
                }
            }
            if (this.layoutMemberNameCombo.getText().trim().length() == 0 && Validator.dataset(this.layoutDataSetCombo.getText(), true) == 0) {
                this.layoutMemberSelectBtn.setEnabled(true);
            }
        }
        return error;
    }

    public void modifyText(ModifyEvent e) {
        this.callParentComplete();
    }

    public void setLayoutButtonEnabled(boolean enabled) {
        this.genSelCriteriaBox.setLayoutButtonEnabled(enabled);
    }

    public String validateCriteriaBox() {
        return this.genSelCriteriaBox.validateCriteriaBox();
    }

    public void validateSelCrtButton(boolean value) {
        this.genSelCriteriaBox.enableSelCrtButton(value);
    }
}

