/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;

public class Validator {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    public static final int NO_ERROR = 0;
    public static final int DS_MISSING = 1;
    public static final int DS_INVALID = 2;
    public static final int DS_WILDCARD = 3;
    public static final int DS_LONG = 4;
    public static final int MEM_MISSING = 5;
    public static final int MEM_INVALID = 6;
    public static final int MEM_WILDCARD = 7;
    public static final int VOL_MISSING = 8;
    public static final int VOL_INVALID = 9;
    public static final int REMEM_INVALID = 10;
    public static final int NEWDS_ALLOC = 11;
    public static final int OLD_POSITION_MISSING = 12;
    public static final int OLD_POSITION_INVALID = 13;
    public static final int LENGTH_MISSING = 14;
    public static final int LENGTH_INVALID = 15;
    public static final int NEW_POSITION_MISSING = 16;
    public static final int NEW_POSITION_INVALID = 17;
    public static final int DASD_MISSING = 18;
    public static final int SMS_MISSING = 19;
    public static final int DSNLIST_MISSING = 20;
    public static final int CL_NON_MATCHING_QUOTES = 21;
    public static final int CL_UNSUPPORTED_CHARS = 22;
    public static final int CL_TOO_LONG = 23;
    public static final int CL_INCOMPATIBILE_TYPE = 24;
    public static final int CL_INVALID = 25;
    public static final int CL_FORMAT_ERROR = 26;
    public static final int CL_FIELD_NAME = 27;
    public static final int CL_WHITE_SPACE = 28;
    public static final int CL_VALUE_NOT_IN_QUOTES = 29;
    public static final int CL_EMPTY_VALUE = 30;
    public static final int PID_MISSING = 31;
    public static final int PID_TOO_LONG = 32;
    public static final int PID_INVALID = 33;
    public static final int JESN_MISSING = 34;
    public static final int JESN_TOO_LONG = 35;
    public static final int JESN_INVALID = 36;
    public static final int JESID_MISSING = 37;
    public static final int JESID_TOO_LONG = 38;
    public static final int JESID_INVALID = 39;
    public static final int SYSWRTR_MISSING = 40;
    public static final int SYSWRTR_INVALID = 41;
    public static final int PDSET_MISSING = 42;
    public static final int PDSET_INVALID = 43;
    public static final int PDSET_TOO_LONG = 44;
    public static final int SKEY_TOO_LONG = 45;
    public static final int SKEY_INVALID = 46;
    public static final int CHANGELOG_PRIMARYLOCATION_INVALID = 47;
    public static final int PMEM_INVALID = 48;
    public static final int PMEM_WILDCARD = 49;
    public static final int PackedDecimal_LENGTH_INVALID = 50;
    public static final int Hexadecimal_LENGTH_INVALID = 51;
    public static final int SELCRIT_VALIDATION_ERROR = 52;
    public static final String[] errorMsg = new String[]{"", "Missing data set name", "Data set name has invalid format", "Unresolved data set name", "Data set name is too long", "Missing member name", "Member name has invalid format", "Unresolved member name", "Missing volume name", "Volume name has invalid format", "Rename has invalid format", "New data set is not yet allocated", "Missing old position", "Old position has invalid format", "Missing length", "Length has invalid format", "Missing new position", "New position has invalid format", "Missing DASD Unit Name", "Missing SMS Storage Class", "DSN List in Configure Mainframe Settings not defined", "Missing quote", "Value contains characters not supported by specified data type", "Compare value is too long", "Compare value of incompatible type", "Invalid compare value", "Compare value has incorrect format", "", "White spaces are not allowed inside single quotes", "Character values must be within quotes", "Empty value is not allowed", "Missing destination printer", "Destination printer is too long", "Destination printer has invalid format", "Missing external JES node", "External JES node is too long", "External JES node has invalid format", "Missing userid at JES node", "Userid at JES node is too long", "Userid at JES node has invalid format", "Missing sysout writer name", "Sysout writer name has invalid format", "Missing print data set name", "Print data set name has invalid format", "Print data set name is too long", "Starting key is too long", "Starting key has invalid format", "Increase the Primary Allocation value ", "Print member name has invalid format", "Unresolved print member name", "PackedDecimal has invalid format", "Hexadecimal has invalid format", "Validation failed \ufffd no details available"};

    public static int dataset(String input, boolean mandatory) {
        input = input.trim();
        if (mandatory && input.length() == 0) {
            return 1;
        }
        if (input.length() > 44) {
            return 4;
        }
        if (!input.matches("(([a-zA-Z#@$\\*\\%][a-zA-Z0-9#@$\\-\\*\\%]{0,7}))([.](([a-zA-Z#@$\\*\\%][a-zA-Z0-9#@$\\-\\*\\%]{0,7})))*?") && input.length() != 0) {
            return 2;
        }
        if (input.contains("**")) {
            int pos = input.lastIndexOf("**");
            if (pos > 0 && input.charAt(pos - 1) == '.' && input.length() >= pos + 2) {
                if (input.length() == pos + 2) {
                    return 3;
                }
                if (input.charAt(pos + 2) == '.') {
                    return 3;
                }
            }
            return 2;
        }
        if (input.equals("\\*") || input.contains("*") || input.contains("%")) {
            return 3;
        }
        return 0;
    }

    public static int member(String input, boolean mandatory) {
        input = input.trim();
        if (mandatory && input.length() == 0) {
            return 5;
        }
        if (!input.matches("[a-zA-Z#@$\\*\\%][a-zA-Z0-9#@$\\*\\%]{0,7}([;][a-zA-Z#@$\\*\\%][a-zA-Z0-9#@$\\*\\%]{0,7})*?") && !input.equals("\\*") && input.length() != 0) {
            return 6;
        }
        if (input.contains("*") || input.contains("%")) {
            return 7;
        }
        return 0;
    }

    public static int renameMember(String input, boolean mandatory) {
        if ((input = input.trim()).length() > 0 && !input.matches("[a-zA-Z#@$][a-zA-Z0-9#@$]{0,7}([;][a-zA-Z#@$][a-zA-Z0-9#@$]{0,7})*?")) {
            return 10;
        }
        return 0;
    }

    public static int volume(String input, boolean mandatory) {
        input = input.trim();
        if (mandatory && input.length() == 0) {
            return 8;
        }
        if (!input.matches("[a-zA-Z0-9@#$-]{0,6}")) {
            return 9;
        }
        return 0;
    }

    public static int Changelog(String input, boolean mandatory) {
        if (input == "") {
            return 47;
        }
        if (Integer.parseInt(input) == 0) {
            return 47;
        }
        return 0;
    }

    public static int oldPosition(String input, boolean mandatory) {
        if (!(input = input.trim()).matches("[0-9]{0,6}")) {
            return 13;
        }
        if (mandatory && input.length() == 0) {
            return 12;
        }
        return 0;
    }

    public static int length(String input, boolean mandatory) {
        if (!(input = input.trim()).matches("[0-9]{0,6}")) {
            return 15;
        }
        if (mandatory && input.length() == 0) {
            return 14;
        }
        return 0;
    }

    public static int HexadecimalLength(String input, boolean mandatory) {
        if (!(input = input.trim()).matches("[a-fA-F0-9]{0,}")) {
            return 51;
        }
        if (mandatory && input.length() == 0) {
            return 14;
        }
        if (input.length() % 2 > 0) {
            return 51;
        }
        return 0;
    }

    public static int PackedDecimalLength(String input, boolean mandatory) {
        if ((input = input.trim()).matches("[-+]") ? !input.matches("[-+]{0,1}+[0-9]{0,32}") : !input.matches("[-+]{0,1}+[0-9]{0,31}")) {
            return 50;
        }
        if (mandatory && input.length() == 0) {
            return 14;
        }
        return 0;
    }

    public static int Hexadecimal(String input, boolean mandatory) {
        if (!(input = input.trim()).matches("[a-fA-F0-9]{2}")) {
            return 15;
        }
        if (mandatory && input.length() == 0) {
            return 14;
        }
        return 0;
    }

    public static int Character(String input, boolean mandatory) {
        input = input.trim();
        if (!mandatory && input.length() > 1) {
            return 15;
        }
        if (!mandatory && input.length() == 0) {
            return 14;
        }
        return 0;
    }

    public static int newPosition(String input, boolean mandatory) {
        if (!(input = input.trim()).matches("[0-9]{0,6}")) {
            return 17;
        }
        if (mandatory && input.length() == 0) {
            return 16;
        }
        return 0;
    }

    public static int DASDUnite(String input, boolean mandatory) {
        input = input.trim();
        if (mandatory && input.length() == 0) {
            return 18;
        }
        return 0;
    }

    public static int SMSStorage(String input, boolean mandatory) {
        input = input.trim();
        if (mandatory && input.length() == 0) {
            return 19;
        }
        return 0;
    }

    public static int CLConditionField(String value, String formatType, int formatNum, int formatDec, int length, boolean mandatory) {
        String fieldType = formatType;
        int fieldLength = length;
        char singleQuote = '\'';
        char doubleQuote = '\"';
        char comma = ',';
        String input = value.trim();
        if (!fieldType.matches("C") && value.contains("\"")) {
            return 22;
        }
        boolean singleQuoteEncapsulation = false;
        boolean doubleQuoteEncapsulation = false;
        int i = 0;
        while (i < input.length()) {
            switch (input.charAt(i)) {
                case '\'': {
                    String tmp;
                    if (doubleQuoteEncapsulation) {
                        tmp = input;
                        input = String.valueOf(tmp.substring(0, i)) + "a";
                        if (i + 1 >= tmp.length()) break;
                        input = String.valueOf(input) + tmp.substring(i + 1);
                        break;
                    }
                    if (!singleQuoteEncapsulation) {
                        singleQuoteEncapsulation = true;
                        break;
                    }
                    if (singleQuoteEncapsulation) {
                        singleQuoteEncapsulation = false;
                        doubleQuoteEncapsulation = false;
                        break;
                    }
                }
                case '\"': {
                    String tmp;
                    if (singleQuoteEncapsulation) {
                        tmp = input;
                        input = String.valueOf(tmp.substring(0, i)) + "a";
                        if (i + 1 >= tmp.length()) break;
                        input = String.valueOf(input) + tmp.substring(i + 1);
                        break;
                    }
                    if (!doubleQuoteEncapsulation) {
                        doubleQuoteEncapsulation = true;
                        break;
                    }
                    if (doubleQuoteEncapsulation) {
                        singleQuoteEncapsulation = false;
                        doubleQuoteEncapsulation = false;
                        break;
                    }
                }
                case ',': {
                    String tmp;
                    if (!singleQuoteEncapsulation && !doubleQuoteEncapsulation && fieldType.matches("C")) {
                        tmp = input;
                        input = String.valueOf(tmp.substring(0, i)) + " ";
                        if (i + 1 >= tmp.length()) break;
                        input = String.valueOf(input) + tmp.substring(i + 1);
                        break;
                    }
                    if (!singleQuoteEncapsulation) break;
                    tmp = input;
                    input = String.valueOf(tmp.substring(0, i)) + ";";
                    if (i + 1 >= tmp.length()) break;
                    input = String.valueOf(input) + tmp.substring(i + 1);
                }
            }
            ++i;
        }
        boolean isNumericField = true;
        int inputLength = fieldLength;
        String inputType = fieldType;
        int fieldPrimaryLength = formatNum;
        int fieldSecondaryLength = formatDec;
        int valueLength = 0;
        String possibleCompareTypeChar = new String("a-zA-Z");
        String regEx = new String("(?<=(('.{0,155}'))|([" + possibleCompareTypeChar + "]('.{0,155}'))|([\\d]{0,15}[" + possibleCompareTypeChar + "][\\d]{0,15}('.{0,155}'))|" + "((\".{0,155}\"))|([" + possibleCompareTypeChar + "](\".{0,155}\"))|([\\d]{0,15}[" + possibleCompareTypeChar + "][\\d]{0,15}(\".{0,155}\"))|" + "([+-]?[0-9A-Za-z]{0,155}[.]?[0-9A-Za-z]{0,155}[,])" + ")");
        if (input.length() > 0 && input.matches("[a-zA-Z][a-zA-Z 0-9\\-\\(\\)]{0,31}") && !input.contains("'") && !input.contains("\"")) {
            return 27;
        }
        int singleQuoteCount = 0;
        int doubleQuoteCount = 0;
        int i2 = 0;
        while (i2 < input.length()) {
            if (input.charAt(i2) == singleQuote) {
                ++singleQuoteCount;
            }
            if (input.charAt(i2) == doubleQuote) {
                ++doubleQuoteCount;
            }
            ++i2;
        }
        if (singleQuoteCount % 2 != 0 || doubleQuoteCount % 2 != 0) {
            return 21;
        }
        String valType = new String("");
        String valLength = new String("");
        String val = new String("");
        int quoteType = 0;
        boolean valueParsed = false;
        int turn = 0;
        String[] result = input.split(regEx);
        while (result.length > 0 && result[0].length() > 0) {
            int res;
            input = input.substring(result[0].length(), input.length());
            quoteType = 0;
            valueParsed = false;
            boolean parseValue = false;
            String tmp = result[0];
            if ((tmp = tmp.trim()).length() > 0) {
                if (tmp.charAt(tmp.length() - 1) == singleQuote) {
                    quoteType = 1;
                    parseValue = true;
                }
                if (tmp.charAt(tmp.length() - 1) == doubleQuote) {
                    quoteType = 2;
                }
            }
            if (tmp.matches("([+-]?[0-9A-Za-z]{0,155}[.]?[0-9A-Za-z]{0,155}[,])|([+-]?[0-9A-Za-z]{0,155}[.]?[0-9A-Za-z]{0,155})")) {
                val = tmp;
                if (tmp.length() < 1) break;
                if (tmp.charAt(tmp.length() - 1) == comma) {
                    val = val.substring(0, val.length() - 1);
                }
                valueParsed = true;
            }
            if (tmp.matches("(('.{0,155}'))|((\".{0,155}\"))")) {
                valType = "";
                valLength = "";
                val = (String)tmp.trim().subSequence(1, tmp.length() - 1);
                valueParsed = true;
            }
            if (tmp.matches("([" + possibleCompareTypeChar + "]{1,155}('.{0,155}'))|([" + possibleCompareTypeChar + "]{1,155}(\".{0,155}\"))")) {
                valType = tmp.split("['\"]")[0];
                tmp = tmp.substring(valType.length(), tmp.length());
                valLength = "";
                val = (String)tmp.trim().subSequence(1, tmp.length() - 1);
                valueParsed = true;
            }
            if (tmp.matches("([\\d]{0,15}[" + possibleCompareTypeChar + "]{1,155}[\\d]{0,15}('.{0,155}'))|([\\d]{0,15}[" + possibleCompareTypeChar + "]{1,155}[\\d]{0,15}(\".{0,155}\"))")) {
                return 26;
            }
            if (!valueParsed) {
                val = tmp;
            }
            valueLength = valLength.matches("") ? fieldPrimaryLength + fieldSecondaryLength : Integer.valueOf(valLength);
            if (valLength.length() > 0) {
                inputLength = Math.min(Integer.parseInt(valLength), inputLength);
            }
            if (parseValue) {
                String[] subValues = val.split(";");
                int i3 = 0;
                while (i3 < subValues.length) {
                    res = Validator.validateValue(subValues[i3], valueLength, valType.toUpperCase(), inputType.toUpperCase(), fieldPrimaryLength, fieldSecondaryLength, fieldLength, quoteType);
                    if (res != 0) {
                        return res;
                    }
                    ++i3;
                }
            } else {
                res = Validator.validateValue(val, valueLength, valType.toUpperCase(), inputType.toUpperCase(), fieldPrimaryLength, fieldSecondaryLength, fieldLength, quoteType);
                if (res != 0) {
                    return res;
                }
            }
            quoteType = 0;
            result = input.split(regEx);
            ++turn;
        }
        return 0;
    }

    public static int validateValue(String value, int valueLength, String valueType, String fieldType, int fieldPrimaryLength, int fieldSecondaryLength, int length, int quoteType) {
        String sign = new String("");
        if (fieldType.matches("PS") || fieldType.matches("NS") || fieldType.matches("BS") || fieldType.matches("1") || fieldType.matches("2") || fieldType.matches("F")) {
            sign = "[-+]{0,1}";
        }
        if (value.length() == 0) {
            return 30;
        }
        fieldType = fieldType.toUpperCase();
        valueType = valueType.toUpperCase();
        if (fieldType.matches("C")) {
            if (valueType.matches("X")) {
                if (value.length() > length * 2) {
                    return 23;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches("[0-9A-Fa-f]*")) {
                    return 22;
                }
                if (value.length() % 2 > 0) {
                    return 51;
                }
            } else if (valueType.matches("C") || valueType.matches("T") || valueType.matches("")) {
                if (quoteType == 0) {
                    return 29;
                }
                if (value.length() > length) {
                    return 23;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches(".*")) {
                    return 22;
                }
            } else {
                return 24;
            }
            return 0;
        }
        if (fieldType.matches("B") || fieldType.matches("BS")) {
            if (valueType.matches("X")) {
                if (value.length() > length * 2) {
                    return 23;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches("[0-9A-Fa-f]*")) {
                    return 22;
                }
                if (value.length() % 2 > 0) {
                    return 51;
                }
            } else if (valueType.matches("N") || valueType.matches("")) {
                String[] decimalSplit;
                if (value.contains(".") && fieldSecondaryLength == 0) {
                    return 22;
                }
                if (value.startsWith("-") || value.startsWith("+")) {
                    ++fieldPrimaryLength;
                }
                if ((decimalSplit = value.split("[.]"))[0].length() > fieldPrimaryLength) {
                    return 23;
                }
                if (decimalSplit.length > 1 && decimalSplit[1].length() > fieldSecondaryLength) {
                    return 23;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches(String.valueOf(sign) + "[0-9]*[.]?[0-9]*")) {
                    return 22;
                }
            } else {
                return 24;
            }
            return 0;
        }
        if (fieldType.matches("N") || fieldType.matches("NS")) {
            if (valueType.matches("X")) {
                if (value.length() > length * 2) {
                    return 23;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches("[0-9A-Fa-f]*") || value.length() == 0) {
                    return 22;
                }
                if (value.length() % 2 > 0) {
                    return 51;
                }
            } else if (valueType.matches("N") || valueType.matches("NS") || valueType.matches("")) {
                String[] decimalSplit;
                if (value.contains(".") && fieldSecondaryLength == 0) {
                    return 22;
                }
                if (value.startsWith("-") || value.startsWith("+")) {
                    ++fieldPrimaryLength;
                }
                if ((decimalSplit = value.split("[.]"))[0].length() > fieldPrimaryLength) {
                    return 23;
                }
                if (decimalSplit.length > 1 && decimalSplit[1].length() > fieldSecondaryLength) {
                    return 23;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches(String.valueOf(sign) + "[0-9]*[.]?[0-9]*")) {
                    return 22;
                }
            } else {
                return 24;
            }
            return 0;
        }
        if (fieldType.matches("P") || fieldType.matches("PS")) {
            if (valueType.matches("") || valueType.matches("N") || valueType.matches("NS") || valueType.matches("P") || valueType.matches("PS")) {
                String[] decimalSplit;
                if (value.contains(".") && fieldSecondaryLength == 0) {
                    return 22;
                }
                if (value.startsWith("-") || value.startsWith("+")) {
                    ++fieldPrimaryLength;
                }
                if ((decimalSplit = value.split("[.]"))[0].length() > fieldPrimaryLength) {
                    return 23;
                }
                if (decimalSplit.length > 1 && decimalSplit[1].length() > fieldSecondaryLength) {
                    return 23;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches(String.valueOf(sign) + "[0-9]*[.]?[0-9]*")) {
                    return 22;
                }
            } else if (valueType.matches("X")) {
                if (value.length() > length * 2) {
                    return 23;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches("[0-9A-Fa-f]*")) {
                    return 22;
                }
                if (value.length() % 2 > 0) {
                    return 51;
                }
            } else {
                return 24;
            }
            return 0;
        }
        if (fieldType.matches("1") || fieldType.matches("2") || fieldType.matches("F")) {
            if (valueType.matches("X")) {
                if (value.length() > length * 2) {
                    return 23;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches("[0-9A-Fa-f]*")) {
                    return 22;
                }
                if (value.length() % 2 > 0) {
                    return 51;
                }
                if (value.length() != length * 2) {
                    return 26;
                }
            } else if (valueType.matches("") || valueType.matches("C") || valueType.matches("T")) {
                if (quoteType == 0) {
                    return 29;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (value.length() > length) {
                    return 23;
                }
                if (value.length() != length) {
                    return 26;
                }
            } else if (valueType.matches("P") || valueType.matches("PS")) {
                if (value.length() == 0) {
                    return 0;
                }
                if (quoteType == 0) {
                    return 29;
                }
                if (value.length() > length) {
                    return 23;
                }
                if (value.length() != length) {
                    return 26;
                }
                if (!value.matches(String.valueOf(sign) + "[0-9]*")) {
                    return 22;
                }
            } else {
                return 24;
            }
            return 0;
        }
        return 0;
    }

    public static String validateDataSet(Combo dataSetCombo, Combo memberCombo, Button dataSetSelectButton, Button memberSelectButton, String error) {
        return Validator.validateDataSet(dataSetCombo, memberCombo, dataSetSelectButton, memberSelectButton, error, true);
    }

    public static String validateDataSet(Combo dataSetCombo, Combo memberCombo, Button dataSetSelectButton, Button memberSelectButton, String error, boolean requiredField) {
        if (!error.isEmpty()) {
            return error;
        }
        switch (Validator.dataset(dataSetCombo.getText(), requiredField)) {
            case 3: {
                error = String.valueOf(error) + errorMsg[3] + "\n";
                dataSetSelectButton.setEnabled(true);
                memberSelectButton.setEnabled(false);
                break;
            }
            case 1: {
                error = String.valueOf(error) + errorMsg[1] + "\n";
                memberSelectButton.setEnabled(false);
                break;
            }
            case 2: {
                error = String.valueOf(error) + errorMsg[2] + "\n";
                memberSelectButton.setEnabled(false);
                break;
            }
            case 4: {
                error = String.valueOf(error) + errorMsg[Validator.dataset(dataSetCombo.getText(), true)] + "\n ";
                dataSetSelectButton.setEnabled(false);
                memberSelectButton.setEnabled(false);
                break;
            }
            case 0: {
                dataSetSelectButton.setEnabled(false);
                memberCombo.setEnabled(true);
                memberSelectButton.setEnabled(true);
            }
        }
        return error;
    }

    public static String validateMember(Combo memberCombo, Button memberSelectButton, String error) {
        return Validator.validateMember(memberCombo, memberSelectButton, error, true);
    }

    public static String validateMember(Combo memberCombo, Button memberSelectButton, String error, boolean requiredField) {
        if (!error.isEmpty() || memberCombo == null || memberSelectButton == null) {
            return error;
        }
        if (error.length() == 0) {
            switch (Validator.member(memberCombo.getText(), requiredField)) {
                case 5: {
                    memberSelectButton.setEnabled(true);
                    error = String.valueOf(error) + errorMsg[5] + "\n";
                    break;
                }
                case 6: {
                    memberSelectButton.setEnabled(false);
                    error = String.valueOf(error) + errorMsg[6] + "\n";
                    break;
                }
                case 7: {
                    memberSelectButton.setEnabled(true);
                    error = String.valueOf(error) + errorMsg[7] + "\n";
                    break;
                }
                case 0: {
                    memberSelectButton.setEnabled(false);
                }
            }
        }
        return error;
    }

    public static String validateVolume(Combo volumeSerialCombo, String error) {
        return Validator.validateVolume(volumeSerialCombo, error, true);
    }

    public static String validateVolume(Combo volumeSerialCombo, String error, boolean requiredField) {
        if (!error.isEmpty()) {
            return error;
        }
        if (volumeSerialCombo != null) {
            switch (Validator.volume(volumeSerialCombo.getText(), requiredField)) {
                case 8: {
                    error = String.valueOf(error) + errorMsg[8] + "\n";
                    break;
                }
                case 9: {
                    error = String.valueOf(error) + errorMsg[9] + "\n";
                }
            }
        }
        return error;
    }

    public static int printerID(String input) {
        if ((input = input.trim()).length() < 1) {
            return 31;
        }
        if (input.length() > 8) {
            return 32;
        }
        if (input.matches("[a-zA-Z0-9$#@]{1,8}")) {
            return 0;
        }
        return 33;
    }

    public static int nodeJES(String input) {
        if ((input = input.trim()).length() < 1) {
            return 34;
        }
        if (input.length() > 8) {
            return 35;
        }
        if (input.matches("[a-zA-Z0-9$#@]{1,8}")) {
            return 0;
        }
        return 36;
    }

    public static int userJES(String input) {
        if ((input = input.trim()).length() < 1) {
            return 37;
        }
        if (input.length() > 8) {
            return 38;
        }
        if (input.matches("[a-zA-Z0-9$#@]{1,8}")) {
            return 0;
        }
        return 39;
    }

    public static int sysoutWriter(String input) {
        if ((input = input.trim()).length() == 0) {
            return 40;
        }
        if (!input.matches("[a-zA-Z#@$][a-zA-Z0-9#@$]{0,7}") && !input.equals("\\*") && input.length() != 0) {
            return 41;
        }
        return 0;
    }

    public static int printDataset(String input) {
        if ((input = input.trim()).length() == 0) {
            return 42;
        }
        if (input.length() > 44) {
            return 44;
        }
        if (input.startsWith("\"") && input.endsWith("\"")) {
            if (input.length() == 1) {
                return 43;
            }
            if (input.length() == 2) {
                input = "";
            } else if (input.length() > 2) {
                input = input.substring(1, input.length() - 1);
            }
        }
        if (!input.matches("(([a-zA-Z#@$\\*\\%][a-zA-Z0-9#@$\\-\\*\\%]{0,7}))([.](([a-zA-Z#@$\\*\\%][a-zA-Z0-9#@$\\-\\*\\%]{0,7})))*?(\\([a-zA-Z#@$][a-zA-Z0-9#@$]{0,7}\\)){0,1}") && input.length() != 0) {
            return 43;
        }
        if (input.equals("\\*") || input.contains("*") || input.contains("%")) {
            return 43;
        }
        return 0;
    }

    public static int printStartingKey(String input, String fileType, String subTypeOfDSN) {
        if ((input = input.trim()).length() == 0) {
            return 0;
        }
        if (input.length() > 28) {
            return 45;
        }
        if (fileType.endsWith("VSAM") && subTypeOfDSN.equalsIgnoreCase("E") ? !input.matches("([Xx]['][0-9a-fA-F]{1,25}['])") : (fileType.endsWith("VSAM") && subTypeOfDSN.equalsIgnoreCase("K") ? !input.matches("([CXcx]['][0-9a-fA-F]{1,25}['])") : (fileType.endsWith("Sequential") || fileType.endsWith("PDS") || fileType.endsWith("VSAM") && subTypeOfDSN.equalsIgnoreCase("R") ? !input.matches("([0-9]{1,28})") : !input.matches("([0-9]{1,28})|([CXcx]['][0-9a-fA-F]{1,25}['])")))) {
            return 46;
        }
        return 0;
    }
}

