/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.layout.views.layoutview;

import com.ca.filemaster.common.ContextSwitch;
import com.ca.filemaster.common.FMLayoutTreeModel;
import com.ca.filemaster.layout.views.layoutview.LayoutDoubleClickListener;
import com.ca.filemaster.layout.views.layoutview.LayoutViewComparator;
import com.ca.filemaster.layout.views.layoutview.LayoutViewContentProvider;
import com.ca.filemaster.layout.views.layoutview.LayoutViewLabelProvider;
import com.ca.testingtools.core.TT_TreeItem;
import java.util.logging.Logger;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class LayoutView
extends ViewPart {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final String sourceClass = LayoutView.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    public static final String ID = "com.ca.filemaster.layout.views.layoutview";
    public static final String CONTEXT_HELP_ID = "com.ca.filemaster.help.layoutView";
    private TreeViewer viewer;
    private FMLayoutTreeModel model;

    public void init(IViewSite site) throws PartInitException {
        this.model = FMLayoutTreeModel.getInstance();
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 68354);
        LayoutViewContentProvider contentprovider = new LayoutViewContentProvider(this);
        LayoutViewLabelProvider labelProvider = new LayoutViewLabelProvider();
        LayoutDoubleClickListener doubleClickListener = new LayoutDoubleClickListener();
        this.viewer.setComparator((ViewerComparator)new LayoutViewComparator());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
        this.viewer.setContentProvider((IContentProvider)contentprovider);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.addDoubleClickListener((IDoubleClickListener)doubleClickListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        Control control = this.viewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
        TT_TreeItem[] datasets = this.model.getDatasets();
        this.viewer.setInput((Object)datasets);
        this.viewer.collapseAll();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.hookDoubleClickCommand();
    }

    private void hookDoubleClickCommand() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IHandlerService handlerService = (IHandlerService)LayoutView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.ca.filemaster.commands.openeditor", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void setFocus() {
        ContextSwitch.activate("com.ca.filemaster.layout");
        this.viewer.getControl().setFocus();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public boolean isActiveView(IWorkbenchPage activePage) {
        IWorkbenchPart activeView = activePage.getActivePart();
        try {
            IViewPart view = activePage.showView(ID);
            return activeView == null ? false : activeView.equals(view);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
    }
}

