/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.ui.wizards;

import com.ca.filemaster.ConfigureMFsettingVariableList;
import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.filemaster.runners.RunSetConfigureSetting;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifyDigit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AddServerPage
extends WizardPage
implements ModifyListener,
SelectionListener {
    static final String cacopyright = "Copyright \ufffd 2011 CA";
    private static final String sourceClass = AddServerPage.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    private Text name;
    private Text host;
    private Text port;
    private TTServer server = null;
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    private boolean newserver = true;
    private boolean changed = false;
    private String invokerId = "com.ca.filemaster.views.directorylist";
    private final String NEW_CONTEXT_HELP_ID = "com.ca.filemaster.help.serverWizardPageNew";
    private final String OLD_CONTEXT_HELP_ID = "com.ca.filemaster.help.serverWizardPageOld";
    public String returnCode = "";
    private Combo protocol;

    public AddServerPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription("Specify Server Details");
    }

    public AddServerPage() {
        super("dummy");
    }

    public void SetServer(TTServer server) {
        this.server = server;
        this.newserver = server == null;
    }

    public void SetInvokingViewId(String viewId) {
        this.invokerId = viewId;
    }

    public void createControl(Composite parent) {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), "com.ca.testingtools");
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        Composite two_col = new Composite(top, 0);
        two_col.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(two_col, 0);
        label.setText("&Name:");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        label.setLayoutData((Object)data);
        this.name = new Text(two_col, 2048);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.name.setLayoutData((Object)data);
        label = new Label(two_col, 0);
        label.setText("&Host:");
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        label.setLayoutData((Object)data);
        this.host = new Text(two_col, 2048);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.host.setLayoutData((Object)data);
        label = new Label(two_col, 0);
        label.setText("&Port:");
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        label.setLayoutData((Object)data);
        this.port = new Text(two_col, 2048);
        this.port.setTextLimit(5);
        this.port.setToolTipText(String.format("Port must be number not greater than %d", 65535));
        data = new GridData(768);
        GC gc = new GC((Drawable)this.port);
        try {
            Point extent = gc.textExtent("0");
            data.widthHint = 5 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.port.addVerifyListener((VerifyListener)new verifyDigit(false));
        this.port.setLayoutData((Object)data);
        this.port.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AddServerPage.this.port.setSelection(0, AddServerPage.this.port.getText().length());
            }

            public void focusLost(FocusEvent e) {
            }
        });
        label = new Label(two_col, 0);
        label.setText("P&rotocol:");
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        label.setLayoutData((Object)data);
        this.protocol = new Combo(two_col, 40);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.protocol.setLayoutData((Object)data);
        this.protocol.add("HTTP");
        this.protocol.add("HTTPS");
        this.protocol.setToolTipText(String.format("Select the server protocol", new Object[0]));
        if (this.newserver) {
            this.name.setText("");
            this.host.setText("");
            this.port.setText(store.getString("DEFAULT_SERVER_PORT"));
            this.protocol.select(1);
        } else {
            this.name.setText(this.server.getName());
            this.host.setText(this.server.getHostname());
            this.port.setText(Integer.toString(this.server.getPort()));
            this.protocol.setText(this.server.getProtocol());
        }
        this.name.addModifyListener((ModifyListener)this);
        this.port.addModifyListener((ModifyListener)this);
        this.host.addModifyListener((ModifyListener)this);
        this.protocol.addModifyListener((ModifyListener)this);
        TextUtil.setWidth((Text)this.name, (int)30);
        TextUtil.setWidth((Text)this.host, (int)20);
        if (this.newserver) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.serverWizardPageNew");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.serverWizardPageOld");
        }
        this.getShell().getDefaultButton().setText("OK");
        this.setControl((Control)top);
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
    }

    public void modifyText(ModifyEvent event) {
        this.changed = true;
        this.getWizard().getContainer().updateButtons();
    }

    public boolean performUpdate() {
        block17: {
            RunSetConfigureSetting runner;
            ConfigureMFsettingVariableList configureVariableList;
            if (this.newserver) {
                try {
                    Element serverElement = this.model.addServer(this.name.getText().trim(), this.host.getText().trim(), Integer.parseInt(this.port.getText()), null, "Y", this.protocol.getText());
                    TT_TreeItem result = this.model.insertServer(serverElement);
                    if (result != null) {
                        this.server = (TTServer)result.getValue();
                    }
                    if (this.server.getStatusText().equalsIgnoreCase("active")) {
                        configureVariableList = new ConfigureMFsettingVariableList();
                        configureVariableList.setPreferencescalltype("I");
                        runner = new RunSetConfigureSetting((FileMasterServer)this.server, configureVariableList);
                        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
                        this.setPreferance(runner);
                        break block17;
                    }
                    this.model.updateserver(serverElement, this.server, "N");
                }
                catch (NumberFormatException e) {
                    this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
                }
                catch (Exception e) {
                    this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
                }
            } else {
                this.cancelOldSessionIfneeded(this.server);
                TT_TreeItem selection = this.model.findObject(this.server);
                this.server.setName(this.name.getText().trim());
                this.server.setPort(Integer.parseInt(this.port.getText()));
                this.server.setHostname(this.host.getText().trim());
                this.server.setProtocol(this.protocol.getText());
                this.model.dlistMap.put(this.server.getUUIDString().hashCode(), selection);
                if (this.server.getStatusText().equalsIgnoreCase("active") && selection.getElement().getAttribute("PreferenceIsSet").equalsIgnoreCase("N")) {
                    configureVariableList = new ConfigureMFsettingVariableList();
                    configureVariableList.setPreferencescalltype("I");
                    runner = new RunSetConfigureSetting((FileMasterServer)this.server, configureVariableList);
                    BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
                    if (runner.getXml() != null) {
                        ConfigureMFsettingVariableList configureMFsettingVariableList = this.setPreferance(runner);
                        this.updateFMServerTreeModel(this.server, configureMFsettingVariableList, this.model);
                        this.model.updateserver(this.server.getElement(), this.server, "Y");
                        this.model.save();
                    }
                } else if (!selection.getElement().getAttribute("PreferenceIsSet").equalsIgnoreCase("Y")) {
                    this.model.updateserver(selection.getElement(), this.server, "N");
                }
            }
        }
        if (this.server == null) {
            return false;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        try {
            TreeViewer viewer;
            IWorkbenchPage page = window.getActivePage();
            IViewPart view = page.showView(this.invokerId);
            if (view instanceof DirectoryListView && (viewer = ((DirectoryListView)view).getViewer()) != null) {
                if (this.newserver) {
                    viewer.setInput((Object)this.model.getServers());
                } else {
                    viewer.refresh(true);
                }
                TT_TreeItem selectionserver = this.model.findObject(this.server);
                viewer.setSelection((ISelection)new StructuredSelection((Object)selectionserver), true);
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        this.model.save();
        return true;
    }

    private void cancelOldSessionIfneeded(TTServer currentServer) {
        if (currentServer.getPort() != Integer.parseInt(this.port.getText()) || !currentServer.getHostname().equalsIgnoreCase(this.host.getText().trim())) {
            FileMasterSession.cancelOneSession((FileMasterServer)currentServer);
        }
    }

    public boolean isNewserver() {
        return this.newserver;
    }

    public void setNewserver(boolean newserver) {
        this.newserver = newserver;
    }

    public boolean isPageComplete() {
        String connection = this.name.getText().trim();
        if (connection.length() == 0) {
            this.setErrorMessage("Missing Name");
            return false;
        }
        if (this.host.getText().trim().length() == 0) {
            this.setErrorMessage("Missing Host");
            return false;
        }
        String portStr = this.port.getText().trim();
        if (portStr.length() == 0) {
            this.setErrorMessage("Missing Port");
            return false;
        }
        try {
            int port = Integer.parseInt(portStr);
            if (port < 0 || port > 65535) {
                this.setErrorMessage(String.format("Port must be number not greater than %d", 65535));
                return false;
            }
        }
        catch (NumberFormatException exc) {
            this.setErrorMessage("Port entry must be a number");
            return false;
        }
        FileMasterServer checkit = this.model.getServer(connection);
        if (checkit != null && (this.newserver || checkit != this.server) && checkit.getName().compareTo(connection) == 0) {
            this.setErrorMessage("Duplicate Server Name");
            return false;
        }
        this.setErrorMessage(null);
        return this.changed;
    }

    public void widgetSelected(SelectionEvent e) {
        this.changed = true;
        this.getWizard().getContainer().updateButtons();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public ConfigureMFsettingVariableList setPreferance(RunSetConfigureSetting runner) {
        XMLRequest xml = runner.getXml();
        ConfigureMFsettingVariableList configureVariableList = new ConfigureMFsettingVariableList();
        if (xml != null) {
            Node rcNode;
            NodeList retCode;
            NodeList messages;
            NodeList ChangeLogData;
            NodeList PrintOptionsData;
            Element element = xml.getRoot();
            NodeList SetPreferences = element.getElementsByTagName("SetPreferencesResponse");
            Element preferenceElement = (Element)SetPreferences.item(0);
            if (preferenceElement != null) {
                if (preferenceElement.hasAttribute("setpreferencescalltype")) {
                    configureVariableList.setPreferencescalltype(preferenceElement.getAttribute("setpreferencescalltype"));
                } else {
                    this.log.log(Level.WARNING, "prerenceElement has no attribute setpreferencescalltype");
                }
            } else {
                this.log.log(Level.WARNING, "preferenceElement is null");
                this.log.log(Level.WARNING, xml.toString());
            }
            NodeList DefaultOptionsData = element.getElementsByTagName("DefaultOptionsData");
            if (DefaultOptionsData.getLength() > 0) {
                String confirmDataSetDeletes = ((Element)DefaultOptionsData.item(0)).getAttribute("confirmDataSetDeletes");
                if (confirmDataSetDeletes.equalsIgnoreCase("Y")) {
                    configureVariableList.setDeleteDataset(true);
                } else {
                    configureVariableList.setDeleteDataset(false);
                }
                String confirmMemberDeletes = ((Element)DefaultOptionsData.item(0)).getAttribute("confirmMemberDeletes");
                if (confirmMemberDeletes.equalsIgnoreCase("Y")) {
                    configureVariableList.setDeleteMember(true);
                } else {
                    configureVariableList.setDeleteMember(false);
                }
                if (((Element)DefaultOptionsData.item(0)).getAttribute("maxSize") != null && !((Element)DefaultOptionsData.item(0)).getAttribute("maxSize").isEmpty()) {
                    configureVariableList.setSizeCylinders(((Element)DefaultOptionsData.item(0)).getAttribute("maxSize"));
                }
                String[] jobCard = new String[]{((Element)DefaultOptionsData.item(0)).getAttribute("JobInformationLine1"), ((Element)DefaultOptionsData.item(0)).getAttribute("JobInformationLine2"), ((Element)DefaultOptionsData.item(0)).getAttribute("JobInformationLine3"), ((Element)DefaultOptionsData.item(0)).getAttribute("JobInformationLine4")};
                configureVariableList.setJobCard(jobCard);
            }
            if (((Element)DefaultOptionsData.item(0)).getElementsByTagName("DASDUnitName").getLength() > 0) {
                Element DASDUnitName = (Element)((Element)DefaultOptionsData.item(0)).getElementsByTagName("DASDUnitName").item(0);
                configureVariableList.setWorkSpaceallocationvalue(CommonMFCalls.getTagValue("DASDUnitName", DASDUnitName));
                configureVariableList.setWorkSpaceallocationName("DASDUnitName");
            }
            if (((Element)DefaultOptionsData.item(0)).getElementsByTagName("SMSStorageClass").getLength() > 0) {
                Element SMSStorageClass = (Element)((Element)DefaultOptionsData.item(0)).getElementsByTagName("SMSStorageClass").item(0);
                configureVariableList.setWorkSpaceallocationvalue(CommonMFCalls.getTagValue("SMSStorageClass", SMSStorageClass));
                configureVariableList.setWorkSpaceallocationName("SMSStorageClass");
            }
            if ((PrintOptionsData = element.getElementsByTagName("PrintOptionsData")).getLength() > 0) {
                configureVariableList.setSysoutClass(((Element)PrintOptionsData.item(0)).getAttribute("SysoutClass"));
                configureVariableList.setNumberOfCopies(((Element)PrintOptionsData.item(0)).getAttribute("NumberOfCopies"));
            }
            if (((Element)PrintOptionsData.item(0)).getElementsByTagName("PrintDest").getLength() > 0) {
                Element PrintDest = (Element)((Element)PrintOptionsData.item(0)).getElementsByTagName("PrintDest").item(0);
                configureVariableList.setPrintDestination1(CommonMFCalls.getTagValue("PrintDest", PrintDest));
                configureVariableList.setPrintDesSelection(1);
            } else if (((Element)PrintOptionsData.item(0)).getElementsByTagName("PrintJESNode").getLength() > 0) {
                Element PrintJESNode = (Element)((Element)PrintOptionsData.item(0)).getElementsByTagName("PrintJESNode").item(0);
                configureVariableList.setPrintDestination1(PrintJESNode.getAttribute("JESNode"));
                configureVariableList.setPrintDestination2(PrintJESNode.getAttribute("JESUserid"));
                configureVariableList.setPrintDesSelection(2);
            } else if (((Element)PrintOptionsData.item(0)).getElementsByTagName("SYSOUTWriterName").getLength() > 0) {
                Element SYSOUTWriterName = (Element)((Element)PrintOptionsData.item(0)).getElementsByTagName("SYSOUTWriterName").item(0);
                configureVariableList.setPrintDestination1(CommonMFCalls.getTagValue("SYSOUTWriterName", SYSOUTWriterName));
                configureVariableList.setPrintDesSelection(3);
            } else if (((Element)PrintOptionsData.item(0)).getElementsByTagName("PrintDSN").getLength() > 0) {
                Element PrintDSN = (Element)((Element)PrintOptionsData.item(0)).getElementsByTagName("PrintDSN").item(0);
                configureVariableList.setPrintDestination1(PrintDSN.getAttribute("dsname"));
                configureVariableList.setPrintDestination2(PrintDSN.getAttribute("member"));
                configureVariableList.setDisPosition(PrintDSN.getAttribute("disp"));
                configureVariableList.setPrintDesSelection(4);
            }
            NodeList ParmFilesData = element.getElementsByTagName("ParmFilesData");
            if (ParmFilesData.getLength() > 0) {
                configureVariableList.setDsnList(((Element)ParmFilesData.item(0)).getAttribute("DSNListsDSN"));
                configureVariableList.setSelCriteriaField(((Element)ParmFilesData.item(0)).getAttribute("SelectionCriteriaDSN"));
                configureVariableList.setReformatControl(((Element)ParmFilesData.item(0)).getAttribute("ReformatControlDSN"));
                configureVariableList.setCusRecordLayout(((Element)ParmFilesData.item(0)).getAttribute("CustomRecordLayoutsDSN"));
            }
            if ((ChangeLogData = element.getElementsByTagName("ChangeLogData")).getLength() > 0) {
                configureVariableList.setNewDSN(((Element)ChangeLogData.item(0)).getAttribute("ChangeLogDSNPattern"));
                if (((Element)ChangeLogData.item(0)).getAttribute("ChangeLogSpacePrim").isEmpty()) {
                    configureVariableList.setPrimaryAllocation("0");
                } else {
                    configureVariableList.setPrimaryAllocation(((Element)ChangeLogData.item(0)).getAttribute("ChangeLogSpacePrim"));
                }
                if (((Element)ChangeLogData.item(0)).getAttribute("ChangeLogSpaceSec").isEmpty() || ((Element)ChangeLogData.item(0)).getAttribute("ChangeLogSpaceSec").equalsIgnoreCase("N")) {
                    configureVariableList.setSecondaryAllocation("0");
                } else {
                    configureVariableList.setSecondaryAllocation(((Element)ChangeLogData.item(0)).getAttribute("ChangeLogSpaceSec"));
                }
                if (((Element)ChangeLogData.item(0)).getAttribute("ChangeLogForce").equalsIgnoreCase("Y")) {
                    configureVariableList.setChangeLogForce(true);
                } else {
                    configureVariableList.setChangeLogForce(false);
                }
            }
            if ((Element)ChangeLogData.item(0) != null && ((Element)ChangeLogData.item(0)).getElementsByTagName("ChangeLogVolser").getLength() > 0) {
                Element ChangeLogVolser = (Element)((Element)ChangeLogData.item(0)).getElementsByTagName("ChangeLogVolser").item(0);
                configureVariableList.setStorageValue(CommonMFCalls.getTagValue("ChangeLogVolser", ChangeLogVolser));
                configureVariableList.setStorageName("ChangeLogVolser");
            }
            if ((Element)ChangeLogData.item(0) != null && ((Element)ChangeLogData.item(0)).getElementsByTagName("ChangeLogUnit").getLength() > 0) {
                Element ChangeLogUnit = (Element)((Element)ChangeLogData.item(0)).getElementsByTagName("ChangeLogUnit").item(0);
                configureVariableList.setStorageValue(CommonMFCalls.getTagValue("ChangeLogUnit", ChangeLogUnit));
                configureVariableList.setStorageName("ChangeLogUnit");
            }
            if ((messages = element.getElementsByTagName("Message")).getLength() > 0) {
                MessageDialog.openInformation(null, (String)"Information", (String)CommonMFCalls.getTagValue("Message", (Element)messages.item(0)));
            }
            if ((retCode = element.getElementsByTagName("ReturnCode")) != null && (rcNode = retCode.item(0)) != null) {
                Element rcElement = (Element)rcNode;
                this.returnCode = CommonMFCalls.getTagValue("ReturnCode", rcElement);
            }
        }
        return configureVariableList;
    }

    public void updateFMServerTreeModel(TTServer server, ConfigureMFsettingVariableList configureMFsettingVariableList, FMServerTreeModel model) {
        boolean UseDasdUnit;
        String DASD_UNIT = "";
        String SMS_Storage = "";
        if (configureMFsettingVariableList.getWorkSpaceallocationName().equalsIgnoreCase("DASDUnitName")) {
            UseDasdUnit = true;
            DASD_UNIT = configureMFsettingVariableList.getWorkSpaceallocationvalue();
        } else {
            UseDasdUnit = false;
            SMS_Storage = configureMFsettingVariableList.getWorkSpaceallocationvalue();
        }
        boolean UseVolSer = false;
        String Volume_Serial = "";
        String Generic_Unit = "";
        if (configureMFsettingVariableList.getStorageName() != null) {
            if (configureMFsettingVariableList.getStorageName().equalsIgnoreCase("ChangeLogVolser")) {
                Volume_Serial = configureMFsettingVariableList.getStorageValue();
                UseVolSer = true;
            } else {
                UseVolSer = false;
                Generic_Unit = configureMFsettingVariableList.getStorageValue();
            }
        }
        boolean btnSetPrintDestination = false;
        String PrintDSN = "";
        String PrintMember = "";
        String DestPrinter = "";
        String ExtJESNode = "";
        String UserJESNode = "";
        String SysoutWriter = "";
        String dataSetDisposition = "";
        String newAllocationType = "";
        if (configureMFsettingVariableList.getPrintDesSelection() > 0) {
            switch (configureMFsettingVariableList.getPrintDesSelection()) {
                case 1: {
                    DestPrinter = configureMFsettingVariableList.getPrintDestination1();
                    btnSetPrintDestination = true;
                    break;
                }
                case 2: {
                    ExtJESNode = configureMFsettingVariableList.getPrintDestination1();
                    UserJESNode = configureMFsettingVariableList.getPrintDestination2();
                    btnSetPrintDestination = true;
                    break;
                }
                case 3: {
                    SysoutWriter = configureMFsettingVariableList.getPrintDestination1();
                    btnSetPrintDestination = true;
                    break;
                }
                case 4: {
                    PrintDSN = configureMFsettingVariableList.getPrintDestination1();
                    PrintMember = configureMFsettingVariableList.getPrintDestination2();
                    dataSetDisposition = configureMFsettingVariableList.getDisPosition();
                    btnSetPrintDestination = true;
                }
            }
        }
        Element serverElement = model.updatePrefs(server.getElement(), configureMFsettingVariableList.isDeleteDataset(), configureMFsettingVariableList.isDeleteMember(), UseDasdUnit, DASD_UNIT, SMS_Storage, configureMFsettingVariableList.getSizeCylinders(), configureMFsettingVariableList.getDsnList(), configureMFsettingVariableList.getSelCriteriaField(), configureMFsettingVariableList.getReformatControl(), configureMFsettingVariableList.getCusRecordLayout(), configureMFsettingVariableList.getNewDSN(), UseVolSer, Volume_Serial, Generic_Unit, Integer.parseInt(configureMFsettingVariableList.getPrimaryAllocation()), Integer.parseInt(configureMFsettingVariableList.getSecondaryAllocation()), configureMFsettingVariableList.isChangeLogForce(), PrintDSN, PrintMember, DestPrinter, ExtJESNode, UserJESNode, SysoutWriter, configureMFsettingVariableList.getNumberOfCopies().isEmpty() ? 0 : Integer.parseInt(configureMFsettingVariableList.getNumberOfCopies()), configureMFsettingVariableList.getSysoutClass(), btnSetPrintDestination, configureMFsettingVariableList.getPrintDesSelection(), dataSetDisposition, newAllocationType);
        model.updateModelPrefs(serverElement, (FileMasterServer)server);
        String jobcard = "";
        int i = 0;
        while (i < configureMFsettingVariableList.getJobCard().length) {
            jobcard = String.valueOf(jobcard) + configureMFsettingVariableList.getJobCard()[i] + "\r\n";
            ++i;
        }
        model.updateJCLPrefs(serverElement, jobcard);
        model.save();
    }
}

