/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.ui.wizards;

import com.ca.filemaster.ConfigureSettingsWizardPageOne;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.runners.RunGetWCdsn;
import com.ca.filemaster.ui.wizards.BLKSizeLabelProvider;
import com.ca.filemaster.ui.wizards.DSNLabelProvider;
import com.ca.filemaster.ui.wizards.DSOrgLabelProvider;
import com.ca.filemaster.ui.wizards.DateCreatedLabelProvider;
import com.ca.filemaster.ui.wizards.DateReferencedLabelProvider;
import com.ca.filemaster.ui.wizards.ExtentsLabelProvider;
import com.ca.filemaster.ui.wizards.FileTypeLabelProvider;
import com.ca.filemaster.ui.wizards.FilesDatasetWizardPageSorter;
import com.ca.filemaster.ui.wizards.ImportSelCritWizardPage;
import com.ca.filemaster.ui.wizards.LRECLLabelProvider;
import com.ca.filemaster.ui.wizards.RECFMLabelProvider;
import com.ca.filemaster.ui.wizards.TracksLabelProvider;
import com.ca.filemaster.ui.wizards.VolumeLabelProvider;
import com.ca.filemaster.utilities.AllocateNewDataSetWizardPage1;
import com.ca.filemaster.utilities.AllocateNewVSAMDataSetWizardPage1;
import com.ca.filemaster.utility.copy.CopyPDSFromWizardPage;
import com.ca.filemaster.utility.print.PrintUtilityWizardPageTwo;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatasetWizardPage
extends WizardPage {
    private static final String sourceClass = DatasetWizardPage.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    static TableViewer viewer;
    private static final int DATASET = 0;
    private static final int VOLUME = 1;
    private static final int FILETYPE = 2;
    public static final int dsorgStr = 3;
    public static final int lrecl = 4;
    public static final int blkSize = 5;
    public static final int recfm = 6;
    public static final int tracks = 7;
    public static final int extents = 8;
    public static final int dateCreated = 9;
    public static final int dateReferenced = 10;
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    private FileMasterDataset dataset;
    private String dataSetName = "";
    private String volume = "";
    private String serverName;
    private Listener sortListener;
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.datasetWildCardWizard";
    ArrayList<String> parameters = new ArrayList();
    ArrayList<FileMasterDataset> fmdsList;
    private CopyPDSFromWizardPage copyPDSFromWizardPage;
    private PrintUtilityWizardPageTwo printUtilityWizardPageTwo;
    private ImportSelCritWizardPage importSelCritWizardPage;
    private AllocateNewDataSetWizardPage1 allocateNewDataSetWizardPage1;
    private AllocateNewVSAMDataSetWizardPage1 allocateNewVSAMDataSetWizardPage1;
    private ConfigureSettingsWizardPageOne configureSettingsWizardPage;
    public static Button dsnValue;
    private Text numberOfDS;

    public DatasetWizardPage(String dataSetName, String volume, String server) {
        super("new data set");
        this.setTitle("Select Data Set");
        this.dataSetName = dataSetName;
        this.volume = volume;
        this.serverName = server;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout container_layout = new GridLayout(1, false);
        container.setLayout((Layout)container_layout);
        Composite select_dataset_composite = new Composite(container, 0);
        select_dataset_composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        select_dataset_composite.setLayout((Layout)new GridLayout(1, false));
        this.createViewer(select_dataset_composite);
        this.numberOfDS = new Text(select_dataset_composite, 8);
        this.numberOfDS.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Text)this.numberOfDS, (int)14);
        this.numberOfDS.setEnabled(false);
        this.doSelect();
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.datasetWildCardWizard");
        if (this.getShell().getParent().getData() instanceof TestingToolsWizardDialog) {
            IWizardPage page = ((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage();
            if (page instanceof CopyPDSFromWizardPage) {
                this.copyPDSFromWizardPage = (CopyPDSFromWizardPage)page;
            } else if (page instanceof PrintUtilityWizardPageTwo) {
                this.printUtilityWizardPageTwo = (PrintUtilityWizardPageTwo)page;
            } else if (page instanceof ImportSelCritWizardPage) {
                this.importSelCritWizardPage = (ImportSelCritWizardPage)page;
            } else if (page instanceof AllocateNewDataSetWizardPage1) {
                this.allocateNewDataSetWizardPage1 = (AllocateNewDataSetWizardPage1)page;
            } else if (page instanceof AllocateNewVSAMDataSetWizardPage1) {
                this.allocateNewVSAMDataSetWizardPage1 = (AllocateNewVSAMDataSetWizardPage1)page;
            } else if (page instanceof ConfigureSettingsWizardPageOne) {
                this.configureSettingsWizardPage = (ConfigureSettingsWizardPageOne)page;
            }
        }
        this.getShell().getDefaultButton().setText("OK");
        dsnValue = new Button(parent, 0);
        dsnValue.setEnabled(false);
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
    }

    private void createViewer(Composite parent) {
        viewer = new TableViewer(parent, 68354);
        viewer.getTable().setLinesVisible(true);
        viewer.getTable().setHeaderVisible(true);
        GridData gd_table = new GridData(4, 4, true, true, 2, 1);
        gd_table.heightHint = 300;
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DatasetWizardPage.this.setPageComplete(DatasetWizardPage.this.isPageComplete());
            }
        });
        viewer.getTable().setLayoutData((Object)gd_table);
        this.setupColumnListener();
        this.createColumns(parent, viewer);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private void setupColumnListener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                Table table = viewer.getTable();
                if (column.equals(table.getSortColumn())) {
                    int direction = table.getSortDirection();
                    switch (direction) {
                        case 1024: {
                            table.setSortDirection(128);
                            break;
                        }
                        default: {
                            table.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                viewer.refresh();
            }
        };
    }

    private void createColumns(Composite parent, TableViewer viewer2) {
        String[] titles = new String[]{"Data Set Name", "Volume", "File Type", "DSOrgStr", "LRECL", "BlkSize", "RecFM", "Tracks", "Extents", "Date Created", "Date Refereced"};
        int[] bounds = new int[]{300, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};
        Table table = viewer.getTable();
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableColumn = new TableViewerColumn(viewer, bounds[i]);
            switch (i) {
                case 0: {
                    tableColumn.setLabelProvider((CellLabelProvider)new DSNLabelProvider());
                    break;
                }
                case 1: {
                    tableColumn.setLabelProvider((CellLabelProvider)new VolumeLabelProvider());
                    break;
                }
                case 2: {
                    tableColumn.setLabelProvider((CellLabelProvider)new FileTypeLabelProvider());
                    break;
                }
                case 3: {
                    tableColumn.setLabelProvider((CellLabelProvider)new DSOrgLabelProvider());
                    break;
                }
                case 4: {
                    tableColumn.setLabelProvider((CellLabelProvider)new LRECLLabelProvider());
                    tableColumn.getColumn().setAlignment(131072);
                    break;
                }
                case 5: {
                    tableColumn.setLabelProvider((CellLabelProvider)new BLKSizeLabelProvider());
                    tableColumn.getColumn().setAlignment(131072);
                    break;
                }
                case 6: {
                    tableColumn.setLabelProvider((CellLabelProvider)new RECFMLabelProvider());
                    break;
                }
                case 7: {
                    tableColumn.setLabelProvider((CellLabelProvider)new TracksLabelProvider());
                    tableColumn.getColumn().setAlignment(131072);
                    break;
                }
                case 8: {
                    tableColumn.setLabelProvider((CellLabelProvider)new ExtentsLabelProvider());
                    tableColumn.getColumn().setAlignment(131072);
                    break;
                }
                case 9: {
                    tableColumn.setLabelProvider((CellLabelProvider)new DateCreatedLabelProvider());
                    tableColumn.getColumn().setAlignment(131072);
                    break;
                }
                case 10: {
                    tableColumn.setLabelProvider((CellLabelProvider)new DateReferencedLabelProvider());
                    tableColumn.getColumn().setAlignment(131072);
                }
            }
            tableColumn.getColumn().setText(titles[i]);
            tableColumn.getColumn().setWidth(bounds[i]);
            tableColumn.getColumn().addListener(13, this.sortListener);
            ++i;
        }
        viewer.setSorter((ViewerSorter)new FilesDatasetWizardPageSorter());
        table.setSortColumn(table.getColumn(0));
        table.setSortDirection(128);
    }

    public TableViewer getViewer() {
        return viewer;
    }

    public boolean isPageComplete() {
        return viewer.getTable().getSelectionCount() == 1;
    }

    private void doSelect() {
        this.fmdsList = new ArrayList();
        viewer.getTable().removeAll();
        String datasetName = this.dataSetName.trim().toUpperCase();
        String volumeName = this.volume.trim().toUpperCase();
        String DSLength = Integer.toHexString(this.dataSetName.length());
        if (datasetName.startsWith("\"")) {
            datasetName = datasetName.substring(1, datasetName.length() - 1);
        }
        this.dataset = new FileMasterDataset(null);
        this.dataset.setName(datasetName);
        this.dataset.setVolume(volumeName);
        this.dataset.setDSLength(DSLength);
        RunGetWCdsn runner = new RunGetWCdsn(this.dataset, this.model.getServer(this.serverName), volumeName, true);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
                this.numberOfDS.setText("No data sets returned.");
                this.numberOfDS.setEnabled(true);
            } else {
                NodeList nodes = element.getElementsByTagName("DataSetInfo");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodes.getLength() == 0) {
                    int i = 0;
                    while (i < messages.getLength()) {
                        Node msgNode = messages.item(i);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + DatasetWizardPage.getTagValue("Message", msgElement);
                        ++i;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = DatasetWizardPage.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                    this.numberOfDS.setText("No data sets returned.");
                    this.numberOfDS.setEnabled(true);
                } else {
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element dsElement = (Element)nodes.item(i);
                        FileMasterDataset dataset = new FileMasterDataset(null);
                        dataset.setName(dsElement.getAttribute("dsname"));
                        dataset.setFileType(dsElement.getAttribute("fileType"));
                        dataset.setVolume(dsElement.getAttribute("volser"));
                        dataset.setDSLength(DSLength);
                        dataset.setDsOrg(dsElement.getAttribute("dsorgStr"));
                        dataset.setLrecl(dsElement.getAttribute("lrecl"));
                        dataset.setBlksize(dsElement.getAttribute("blksize"));
                        dataset.setRecfm(dsElement.getAttribute("recfm"));
                        dataset.setTracks(dsElement.getAttribute("tracks"));
                        dataset.setExtents(dsElement.getAttribute("extents"));
                        dataset.setDateCreated(dsElement.getAttribute("dateCreated"));
                        dataset.setDateReferenced(dsElement.getAttribute("dateReferenced"));
                        this.fmdsList.add(dataset);
                        ++i;
                    }
                    viewer.setInput((Object)this.fmdsList.toArray(new FileMasterDataset[this.fmdsList.size()]));
                    viewer.refresh();
                    if (nodes.getLength() == 1) {
                        this.numberOfDS.setText(String.valueOf(nodes.getLength()) + " data set returned.");
                    } else {
                        this.numberOfDS.setText(String.valueOf(nodes.getLength()) + " data sets returned.");
                    }
                    this.numberOfDS.setEnabled(true);
                }
            }
        }
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        return nValue.getNodeValue();
    }

    public boolean doFinish() {
        if (this.copyPDSFromWizardPage != null) {
            this.copyPDSFromWizardPage.insertDSNToField(viewer.getSelection().toString().substring(1, viewer.getSelection().toString().length() - 1));
        } else if (this.printUtilityWizardPageTwo != null) {
            this.printUtilityWizardPageTwo.insertDSNToField(viewer.getSelection().toString().substring(1, viewer.getSelection().toString().length() - 1));
        } else if (this.importSelCritWizardPage != null) {
            this.importSelCritWizardPage.setDSNCombo(viewer.getSelection().toString().substring(1, viewer.getSelection().toString().length() - 1));
        } else if (this.allocateNewDataSetWizardPage1 != null) {
            this.allocateNewDataSetWizardPage1.insertDSNToField(viewer.getSelection().toString().substring(1, viewer.getSelection().toString().length() - 1));
        } else if (this.allocateNewVSAMDataSetWizardPage1 != null) {
            this.allocateNewVSAMDataSetWizardPage1.insertDSNToField(viewer.getSelection().toString().substring(1, viewer.getSelection().toString().length() - 1));
        } else if (this.configureSettingsWizardPage != null) {
            this.configureSettingsWizardPage.setField(viewer.getSelection().toString().substring(1, viewer.getSelection().toString().length() - 1));
        }
        dsnValue.notifyListeners(13, new Event());
        return true;
    }

    public static FileMasterDataset getSelectedDSN() {
        return (FileMasterDataset)((Object)viewer.getElementAt(viewer.getTable().getSelectionIndex()));
    }
}

