/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.ui.wizards;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMDSNListTreeModel;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.ui.wizards.ImportSelCritWizardPage;
import com.ca.testingtools.core.TT_TreeItem;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class ImportDSNListWizardPage
extends ImportSelCritWizardPage
implements ModifyListener,
SelectionListener,
Listener,
ICheckStateListener {
    private FMDSNListTreeModel fmdlModel = FMDSNListTreeModel.getInstance();
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.importDSNList";

    public ImportDSNListWizardPage(String pageName, FileMasterServer server) {
        super(pageName, server);
        this.setTitle(pageName);
        this.server = server;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.importDSNList");
        this.selView.setText("&DSN list view:");
        ArrayList<String> SelectViewDS = new ArrayList<String>();
        SelectViewDS.add("(none)");
        int count = 0;
        while (count < this.fmdlModel.getDatasets().length) {
            int childCount = 0;
            while (childCount < this.fmdlModel.getDatasets()[count].getChildren().length) {
                SelectViewDS.add(String.valueOf(this.fmdlModel.getDatasets()[count].getName()) + "(" + ((TT_TreeItem)this.fmdlModel.getDatasets()[count].getChildren()[childCount]).getName() + ")");
                ++childCount;
            }
            ++count;
        }
        this.selectViewCombo.setItems(SelectViewDS.toArray(new String[SelectViewDS.size()]));
        this.selectViewCombo.select(0);
        this.seldsnBtn.setText("DS&N list data set:");
        this.dataSetDSNListBtn.setVisible(false);
        FMHistory.intializeComboBoxes(this.selectdsnCombo, "ImportDSNListSelectDSN");
        FMHistory.intializeComboBoxes(this.selectMemberCombo, "ImportDSNListSelectMember");
    }

    @Override
    public boolean doFinish() {
        FMHistory.insertHistory(this.selectdsnCombo, "ImportDSNListSelectDSN");
        FMHistory.insertHistory(this.selectMemberCombo, "ImportDSNListSelectMember");
        Object[] checkedDSNListMembers = this.viewer.getCheckedElements();
        if (checkedDSNListMembers.length == 0) {
            checkedDSNListMembers = new Object[]{new FileMasterMember(null)};
            checkedDSNListMembers[0] = CommonMFCalls.getFQMEM(this.selectdsnCombo.getText(), this.selectMemberCombo.getText().trim(), this.server, "S");
            ((FileMasterMember)((Object)checkedDSNListMembers[0])).setType("DSNLIST");
            if (!CommonMFCalls.RETURN_CODE.equals("0")) {
                return false;
            }
        }
        saveSelCrit.notifyListeners(13, new Event());
        return true;
    }

    public static String[] getImportedDSNames() {
        String[] DSNames = new String[]{"APM.TUN42.LST", "CDE.TEMP.PROTSYM.DATA", "APM.IPC.R11.ADROUT", "AD1QA.SYMDUM85.BASETEST.PROTSYM.DATA"};
        return DSNames;
    }
}

