/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.ui.wizards;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FMXMLProfile;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.runners.RunRenameFile;
import com.ca.filemaster.ui.wizards.RenameFileVariable;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.filemaster.views.report.ReportView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RenameDatasetWizardPage
extends WizardPage
implements ModifyListener {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private final String CONTEXT_HELP_ID_NoneVsam = "com.ca.filemaster.help.renameNoneVsamWizard";
    private final String CONTEXT_HELP_ID_Vsam = "com.ca.filemaster.help.renameVsamWizard";
    private Text DatasetText;
    private TT_TreeItem dataSetName;
    private FileMasterServer server;
    private String datasetName;
    private String oldDatasetName;
    private Composite VsamFileHolderComposite;
    private Group grpUpdateIndexData;
    FileMasterDataset dataSet = new FileMasterDataset(null);
    private Text datasetDataText;
    private Text datasetIndexText;
    private String datasetData;
    private String datasetIndex;
    private Button sameUpdate;
    protected String error = "";
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    private RenameFileVariable renameFileVariable = new RenameFileVariable();

    public RenameDatasetWizardPage(TT_TreeItem datasetName, FileMasterServer serverName, String datasetCluster, String datasetData, String datasetIndex) {
        super("wizardPage");
        this.setTitle("Rename " + datasetName);
        this.setDescription("");
        if (datasetName != null) {
            this.dataSetName = datasetName;
        }
        this.dataSet = (FileMasterDataset)datasetName.getValue();
        this.server = serverName;
        this.datasetName = datasetName.getName();
        this.renameFileVariable.setOldDataset(datasetName.getName());
        if (this.dataSet.getDsOrg().equalsIgnoreCase("VSAM")) {
            if (this.dataSet.getDsType().equalsIgnoreCase("T")) {
                this.datasetData = "";
                this.datasetIndex = "";
                this.renameFileVariable.setVsamtypeOfDataset("T");
            } else {
                this.datasetData = datasetData;
                this.datasetIndex = datasetIndex;
                this.renameFileVariable.setVsamtypeOfDataset("N/A");
            }
            this.renameFileVariable.setTypeOfDataset("VSAM");
            this.renameFileVariable.setIndexName(datasetIndex);
            this.renameFileVariable.setDataName(datasetName.getName());
            this.renameFileVariable.setRenameVameComponents(true);
        } else {
            this.renameFileVariable.setTypeOfDataset(this.dataSet.getDsOrg());
            this.renameFileVariable.setVsamtypeOfDataset("N/A");
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setSize(container.computeSize(-1, -1));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite datasetComposite = new Composite(container, 0);
        datasetComposite.setLayout((Layout)new GridLayout(2, false));
        datasetComposite.setSize(datasetComposite.computeSize(4, 4));
        datasetComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.renameNoneVsamWizard");
        Label datasetLabel = new Label(datasetComposite, 0);
        datasetLabel.setText("&New name:");
        this.DatasetText = new Text(datasetComposite, 2048);
        TextUtil.setWidth((Text)this.DatasetText, (int)30);
        this.DatasetText.setTextLimit(44);
        this.DatasetText.setText(this.dataSetName.getName());
        this.DatasetText.addModifyListener((ModifyListener)this);
        this.DatasetText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.DatasetText.getCursor();
        this.DatasetText.setFocus();
        this.DatasetText.setSelection(30);
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                Text t = (Text)e.widget;
                t.selectAll();
            }

            public void focusLost(FocusEvent e) {
                Text t = (Text)e.widget;
                if (t.getSelectionCount() > 0) {
                    t.clearSelection();
                }
            }
        };
        this.DatasetText.addFocusListener(focusListener);
        this.oldDatasetName = String.valueOf(this.oldDatasetName) + this.dataSetName.getName();
        if (this.dataSet.getDsOrg().equalsIgnoreCase("VSAM") && !this.dataSet.getDsType().equalsIgnoreCase("T")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.renameVsamWizard");
            datasetLabel.setText("&New cluster:");
            this.VsamFileHolderComposite = new Composite(container, 0);
            GridData gd_VsamFileHolderComposite = new GridData(16384, 0x1000000, false, false, 1, 1);
            gd_VsamFileHolderComposite.heightHint = 20;
            this.VsamFileHolderComposite.setLayoutData((Object)gd_VsamFileHolderComposite);
            this.VsamFileHolderComposite.setSize(this.VsamFileHolderComposite.computeSize(-1, -1));
            this.sameUpdate = new Button(container, 32);
            this.sameUpdate.setText("Same update to data and index");
            this.grpUpdateIndexData = new Group(container, 0);
            this.grpUpdateIndexData.setEnabled(false);
            this.grpUpdateIndexData.setSize(this.grpUpdateIndexData.computeSize(-1, -1));
            GridData gd_grpUpdateIndexData = new GridData(4, 0x1000000, false, false, 1, 1);
            gd_grpUpdateIndexData.widthHint = 537;
            this.grpUpdateIndexData.setLayoutData((Object)gd_grpUpdateIndexData);
            this.grpUpdateIndexData.setText("Updated Names");
            this.grpUpdateIndexData.setLayout((Layout)new GridLayout(2, false));
            Label datasetDataLabel = new Label((Composite)this.grpUpdateIndexData, 0);
            datasetDataLabel.setText("New &data:");
            this.datasetDataText = new Text((Composite)this.grpUpdateIndexData, 2048);
            this.datasetDataText.setTextLimit(44);
            TextUtil.setWidth((Text)this.datasetDataText, (int)30);
            this.datasetDataText.setEnabled(false);
            this.datasetDataText.setText(this.datasetData);
            this.datasetDataText.addModifyListener((ModifyListener)this);
            this.datasetDataText.addVerifyListener((VerifyListener)new verifytoUpperCase());
            this.datasetDataText.getCursor();
            this.datasetDataText.setFocus();
            this.datasetDataText.setSelection(30);
            this.datasetDataText.addFocusListener(focusListener);
            Label datasetIndexLabel = new Label((Composite)this.grpUpdateIndexData, 0);
            datasetIndexLabel.setText("New &index:");
            this.datasetIndexText = new Text((Composite)this.grpUpdateIndexData, 2048);
            TextUtil.setWidth((Text)this.datasetIndexText, (int)30);
            this.datasetIndexText.setTextLimit(44);
            this.datasetIndexText.setEnabled(false);
            if (this.datasetIndex != null) {
                this.datasetIndexText.setText(this.datasetIndex);
            }
            this.datasetIndexText.addModifyListener((ModifyListener)this);
            this.datasetIndexText.addVerifyListener((VerifyListener)new verifytoUpperCase());
            this.datasetIndexText.getCursor();
            this.datasetIndexText.setFocus();
            this.datasetIndexText.setSelection(30);
            this.datasetIndexText.addFocusListener(focusListener);
            if (this.datasetData.startsWith(this.renameFileVariable.getOldDataset()) || this.datasetIndex.startsWith(this.renameFileVariable.getOldDataset())) {
                this.sameUpdate.setSelection(true);
            } else {
                this.sameUpdate.setSelection(false);
            }
            this.sameUpdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.getSource()).getSelection()) {
                        RenameDatasetWizardPage.this.grpUpdateIndexData.setEnabled(false);
                        RenameDatasetWizardPage.this.datasetDataText.setEnabled(false);
                        RenameDatasetWizardPage.this.datasetIndexText.setEnabled(false);
                        RenameDatasetWizardPage.this.renameFileVariable.setRenameVameComponents(true);
                    } else {
                        RenameDatasetWizardPage.this.grpUpdateIndexData.setEnabled(true);
                        RenameDatasetWizardPage.this.datasetDataText.setEnabled(true);
                        RenameDatasetWizardPage.this.datasetIndexText.setEnabled(true);
                        RenameDatasetWizardPage.this.renameFileVariable.setRenameVameComponents(false);
                    }
                    RenameDatasetWizardPage.this.setPageComplete(RenameDatasetWizardPage.this.isPageComplete());
                }
            });
            this.sameUpdate.notifyListeners(13, new Event());
        }
        this.getShell().getDefaultButton().setText("OK");
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isPageComplete() {
        String input = this.DatasetText.getText();
        input = input.trim();
        switch (Validator.dataset(this.DatasetText.getText(), true)) {
            case 3: {
                this.error = String.valueOf(this.error) + Validator.errorMsg[3] + "\n";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.dataset(this.DatasetText.getText(), true)] + "\n ";
                break;
            }
        }
        if (this.sameUpdate != null && !this.sameUpdate.getSelection()) {
            switch (Validator.dataset(this.datasetDataText.getText(), true)) {
                case 3: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[3] + "\n";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.dataset(this.datasetDataText.getText(), true)] + "\n ";
                    break;
                }
            }
            switch (Validator.dataset(this.datasetIndexText.getText(), true)) {
                case 3: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[3] + "\n";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.dataset(this.datasetIndexText.getText(), true)] + "\n ";
                    break;
                }
            }
        }
        if (this.error.length() <= 0) {
            this.setErrorMessage(null);
            return true;
        }
        if (this.getErrorMessage() == null) {
            this.setErrorMessage(this.error);
            this.error = new String();
            return false;
        }
        if (!this.getErrorMessage().equalsIgnoreCase(this.error)) {
            this.setErrorMessage(this.error);
            this.error = new String();
            return false;
        }
        this.error = new String();
        return false;
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public void widgetSelected(SelectionEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean doFinish() {
        String newDatasetName;
        boolean showDiag;
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
        String key = "CLOSE_VALUE";
        boolean bl = showDiag = !store.getBoolean(key);
        if (showDiag) {
            boolean remove;
            String question = String.format("Do you want to rename %s : %s ?", this.datasetName, this.DatasetText.getText());
            String title = "Confirm Rename";
            String toggleMessage = "Always rename items without this prompt";
            MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Rename", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)store, (String)key);
            int returncode = result.getReturnCode();
            store.setValue(key, result.getToggleState());
            boolean bl2 = remove = returncode == 0 || returncode == 2;
            if (!remove) {
                return true;
            }
        }
        if ((newDatasetName = this.DatasetText.getText().trim().toUpperCase()) == "") {
            newDatasetName = this.dataSetName.getName();
        }
        this.renameFileVariable.setNewDataset(this.DatasetText.getText());
        if (this.dataSet.getDsOrg().equalsIgnoreCase("VSAM") && !this.dataSet.getDsType().equalsIgnoreCase("T") && !this.sameUpdate.getSelection()) {
            this.renameFileVariable.setDataName(this.datasetDataText.getText());
            this.renameFileVariable.setIndexName(this.datasetIndexText.getText());
        }
        RunRenameFile runner = new RunRenameFile(this.server, this.renameFileVariable);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            ArrayList<String> contentAL = new ArrayList<String>();
            Element RenameFileResponse = xml.getRoot();
            String errorMessage = "";
            NodeList programReturnCode = RenameFileResponse.getElementsByTagName("DSNUtilityResponse");
            int returnCodeError = Integer.parseInt(((Element)programReturnCode.item(0)).getAttribute("programReturnCode"));
            NodeList nodes = RenameFileResponse.getElementsByTagName("Line");
            NodeList messages = RenameFileResponse.getElementsByTagName("Message");
            int i = 0;
            while (i < messages.getLength()) {
                Node msgNode = messages.item(i);
                Element msgElement = (Element)msgNode;
                NodeList msgList = msgElement.getChildNodes();
                Node msgValue = msgList.item(0);
                errorMessage = msgValue.getNodeValue();
                ++i;
            }
            i = 0;
            while (i < nodes.getLength()) {
                Element lineElement = (Element)nodes.item(i);
                String line = new String();
                line = RenameDatasetWizardPage.getTagValue("Line", lineElement);
                contentAL.add(line);
                ++i;
            }
            if (errorMessage.length() > 0 && returnCodeError > 0) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCodeError), (Throwable)new Throwable(errorMessage));
                errorMessage = new String();
                if (contentAL.size() > 0) {
                    this.updateReportsView(contentAL.toArray(new String[contentAL.size()]));
                    return true;
                }
                return false;
            }
            TT_TreeItem itemFound = this.model.dlistMap.remove((String.valueOf(this.server.getUUIDString()) + this.datasetName).hashCode());
            Element[] memberList = this.model.getProfiles().getMembers(itemFound.getElement());
            ((FileMasterDataset)((Object)itemFound.getAdapter(FileMasterDataset.class))).setName(this.renameFileVariable.getNewDataset());
            this.model.getProfiles();
            FMXMLProfile.setName((Element)itemFound.getElement(), (String)this.renameFileVariable.getNewDataset());
            this.model.dlistMap.put((String.valueOf(this.server.getUUIDString()) + this.renameFileVariable.getNewDataset()).hashCode(), itemFound);
            Element[] elementArray = memberList;
            int msgValue = memberList.length;
            int msgList = 0;
            while (msgList < msgValue) {
                Element member = elementArray[msgList];
                TT_TreeItem itemMemberFound = this.model.dlistMap.remove((String.valueOf(this.server.getUUIDString()) + this.datasetName + member.getAttribute("name")).hashCode());
                this.model.dlistMap.put((String.valueOf(this.server.getUUIDString()) + this.renameFileVariable.getNewDataset() + member.getAttribute("name")).hashCode(), itemMemberFound);
                ++msgList;
            }
            if (this.dataSet.getDsOrg().equalsIgnoreCase("VSAM") && (this.model.dlistMap.containsKey((String.valueOf(this.server.getUUIDString()) + this.datasetIndex).hashCode()) || this.model.dlistMap.containsKey((String.valueOf(this.server.getUUIDString()) + this.datasetData).hashCode()))) {
                String newVSAMIndexName;
                String newVSAMDataName;
                if (this.sameUpdate.getSelection()) {
                    FMPVSAMDataset renamedDataSet = (FMPVSAMDataset)CommonMFCalls.getFQDSN(this.renameFileVariable.getNewDataset(), "", this.server, false);
                    newVSAMDataName = renamedDataSet.getData();
                    newVSAMIndexName = renamedDataSet.getIndex();
                } else {
                    newVSAMDataName = this.datasetDataText.getText().trim();
                    newVSAMIndexName = this.datasetIndexText.getText().trim();
                }
                TT_TreeItem itemFoundIndex = this.model.dlistMap.remove((String.valueOf(this.server.getUUIDString()) + this.datasetIndex).hashCode());
                TT_TreeItem itemFoundData = this.model.dlistMap.remove((String.valueOf(this.server.getUUIDString()) + this.datasetData).hashCode());
                if (itemFoundIndex != null) {
                    ((FileMasterDataset)((Object)itemFoundIndex.getAdapter(FileMasterDataset.class))).setName(newVSAMIndexName);
                    this.model.getProfiles();
                    FMXMLProfile.setName((Element)itemFoundIndex.getElement(), (String)newVSAMIndexName);
                    this.model.dlistMap.put((String.valueOf(this.server.getUUIDString()) + newVSAMIndexName).hashCode(), itemFoundIndex);
                }
                if (itemFoundData != null) {
                    ((FileMasterDataset)((Object)itemFoundData.getAdapter(FileMasterDataset.class))).setName(newVSAMDataName);
                    this.model.getProfiles();
                    FMXMLProfile.setName((Element)itemFoundData.getElement(), (String)newVSAMDataName);
                    this.model.dlistMap.put((String.valueOf(this.server.getUUIDString()) + newVSAMDataName).hashCode(), itemFoundData);
                }
            }
            this.model.save();
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            Shell shell = window.getShell();
            shell.setMinimized(false);
            shell.forceActive();
            shell.forceFocus();
            try {
                TreeViewer viewer;
                IWorkbenchPage page = window.getActivePage();
                IViewPart view = page.showView("com.ca.filemaster.views.directorylist");
                if (view instanceof DirectoryListView && (viewer = ((DirectoryListView)view).getViewer()) != null) {
                    TT_TreeItem selection = this.model.dlistMap.get((String.valueOf(this.server.getUUIDString()) + this.renameFileVariable.getNewDataset()).hashCode());
                    TT_TreeItem parent = selection.getParent();
                    viewer.refresh((Object)parent, true);
                    viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                    view.setFocus();
                }
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
            this.model.save();
            return true;
        }
        return false;
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue != null) {
            return nValue.getNodeValue();
        }
        return "";
    }

    public void updateReportsView(String[] content) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            IViewPart view;
            if (!content.toString().isEmpty() && (view = page.showView("com.ca.filemaster.views.reportsview", UUID.randomUUID().toString(), 1)) instanceof ReportView) {
                ((ReportView)view).updateReportViewer(content);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }
}

