/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utilities;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.ui.wizards.AllocateDatasetWizard;
import com.ca.filemaster.ui.wizards.DatasetWizard;
import com.ca.filemaster.ui.wizards.GenericImportWizard;
import com.ca.filemaster.utilities.AllocateNewVSAMDataSetWizard;
import com.ca.filemaster.utilities.AllocateNewVSAMDataSetWizardPage2;
import com.ca.filemaster.utilities.MultipleVolumeWizard;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;

public class AllocateNewVSAMDataSetWizardPage1
extends WizardPage
implements ModifyListener {
    static final String cacopyright = "Copyright \ufffd 2011 CA";
    private Composite container;
    private Combo dataText;
    private Combo modelDataSetNameText;
    private Combo indexText;
    private Combo VSAMFileTypeText;
    private Text VolIndexText;
    private Text VolDataText;
    private Text SMSClassStorageText;
    private Text SMSClassDataText;
    private Text SMSClassManagementText;
    private Button selectButton;
    private Button confirmButton;
    private Button multiVolBtn;
    private Button multiVolEditBtn;
    private Button ReuseOptBtn;
    private Button WriteCheckBtn;
    private Button SpanRecordsBtn;
    private Button LoadRestartBtn;
    private Button EraseDelBtn;
    private Button volumebtn;
    private Button dirListInsert;
    private String modelDataSetName = "";
    private String DatasetName = "";
    private boolean indexNeeded = true;
    private Button smsClassbtn;
    ArrayList<String> vsamFileTypeList = new ArrayList();
    private FileMasterDataset modelDataset;
    private FileMasterServer server;
    private Text ClusterLabelData;
    private AllocateNewVSAMDataSetWizardPage2 nextPage;
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.allocateNewVSAMDataSetWizardPageOne";

    public AllocateNewVSAMDataSetWizardPage1(FileMasterServer server, String datasetName, String modelDataSetName) {
        super("allocateNewVSAMDataSetWizardPage1");
        this.setTitle("Allocate VSAM Data Set (Page 1 of 2)");
        this.setDescription("New data set allocation parameters");
        this.DatasetName = datasetName;
        this.modelDataSetName = modelDataSetName;
        this.server = server;
    }

    public void createControl(Composite parent) {
        String prefiledDataText = "";
        String prefiledIndexText = "";
        this.container = new Composite(parent, 0);
        GridLayout container_layout = new GridLayout(1, false);
        this.container.setLayout((Layout)container_layout);
        Composite dataSetComposite = new Composite(this.container, 0);
        GridLayout gl_dataSetComposite = new GridLayout(2, false);
        gl_dataSetComposite.marginWidth = 0;
        gl_dataSetComposite.marginHeight = 0;
        dataSetComposite.setLayout((Layout)gl_dataSetComposite);
        dataSetComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label ClusterLabel = new Label(dataSetComposite, 0);
        ClusterLabel.setText("Cluster:                   ");
        this.ClusterLabelData = new Text(dataSetComposite, 8);
        this.ClusterLabelData.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.ClusterLabelData.setText(this.DatasetName);
        Group modelDataSetGroup = new Group(this.container, 0);
        modelDataSetGroup.setLayout((Layout)new GridLayout(4, false));
        modelDataSetGroup.setSize(modelDataSetGroup.computeSize(-1, -1));
        modelDataSetGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        modelDataSetGroup.setText("Options");
        Label modelDataSetNameLabel = new Label((Composite)modelDataSetGroup, 0);
        modelDataSetNameLabel.setText("&Model data set name:");
        this.modelDataSetNameText = new Combo((Composite)modelDataSetGroup, 2048);
        this.modelDataSetNameText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TextUtil.setWidth((Combo)this.modelDataSetNameText, (int)35);
        this.modelDataSetNameText.addModifyListener((ModifyListener)this);
        this.modelDataSetNameText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes(this.modelDataSetNameText, "modelVSAMDataSetNameList");
        this.modelDataSetNameText.setText(this.modelDataSetName);
        this.modelDataSetNameText.addModifyListener((ModifyListener)this);
        this.modelDataSetNameText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.selectButton = new Button((Composite)modelDataSetGroup, 0);
        this.selectButton.setText("&Select...");
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasetWizard wizard = new DatasetWizard(false, AllocateNewVSAMDataSetWizardPage1.this.modelDataSetNameText.getText(), "", AllocateNewVSAMDataSetWizardPage1.this.server.getName());
                TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(AllocateNewVSAMDataSetWizardPage1.this.getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
        Button dsnListButton = new Button((Composite)modelDataSetGroup, 0);
        dsnListButton.setText("DSN &List...");
        dsnListButton.setVisible(false);
        dsnListButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AllocateNewVSAMDataSetWizardPage1.this.getDSNListPDS().isEmpty()) {
                    MessageDialog.openWarning((Shell)AllocateNewVSAMDataSetWizardPage1.this.getShell(), (String)"Warning", (String)"DSN Lists PDS in Prefernces is undefined. No DSNLists found");
                } else if (AllocateNewVSAMDataSetWizardPage1.this.modelDataSetNameText.getText().isEmpty() || Validator.dataset(AllocateNewVSAMDataSetWizardPage1.this.modelDataSetNameText.getText(), true) == 3) {
                    GenericImportWizard wizard = new GenericImportWizard("Select DSN List", AllocateNewVSAMDataSetWizardPage1.this.server, false);
                    TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(AllocateNewVSAMDataSetWizardPage1.this.getShell(), (IWizard)wizard);
                    dialog.open();
                } else {
                    DatasetWizard wizard = new DatasetWizard(false);
                    TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(AllocateNewVSAMDataSetWizardPage1.this.getShell(), (IWizard)wizard);
                    dialog.open();
                }
            }
        });
        this.confirmButton = new Button((Composite)modelDataSetGroup, 0);
        this.confirmButton.setText("&Confirm");
        this.confirmButton.setEnabled(false);
        new Label((Composite)modelDataSetGroup, 0);
        new Label((Composite)modelDataSetGroup, 0);
        new Label((Composite)modelDataSetGroup, 0);
        this.nextPage = (AllocateNewVSAMDataSetWizardPage2)this.getNextPage();
        this.confirmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AllocateNewVSAMDataSetWizardPage1.this.setModelParameters(null);
            }
        });
        GridLayout component_dsn_layout = new GridLayout(1, false);
        Group component_dsn_group = new Group(this.container, 0);
        component_dsn_layout = new GridLayout(2, false);
        component_dsn_group.setLayout((Layout)component_dsn_layout);
        component_dsn_group.setText("Component DSNs");
        component_dsn_group.setSize(component_dsn_group.computeSize(-1, -1));
        component_dsn_group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label dataLabel = new Label((Composite)component_dsn_group, 0);
        dataLabel.setText("&Data:");
        this.setControl((Control)parent);
        this.dataText = new Combo((Composite)component_dsn_group, 2048);
        this.dataText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TextUtil.setWidth((Combo)this.dataText, (int)37);
        this.dataText.addModifyListener((ModifyListener)this);
        this.dataText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        prefiledDataText = String.valueOf(this.DatasetName) + ".DATA";
        if (prefiledDataText.length() > 44) {
            prefiledDataText = prefiledDataText.substring(0, 44).toString();
        }
        this.dataText.setText(prefiledDataText);
        Label indexLabel = new Label((Composite)component_dsn_group, 0);
        indexLabel.setText("Inde&x:");
        this.indexText = new Combo((Composite)component_dsn_group, 2048);
        this.indexText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TextUtil.setWidth((Combo)this.indexText, (int)37);
        this.indexText.addModifyListener((ModifyListener)this);
        this.indexText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        prefiledIndexText = String.valueOf(this.DatasetName) + ".INDEX";
        if (prefiledIndexText.length() > 44) {
            prefiledIndexText = prefiledIndexText.substring(0, 44).toString();
        }
        this.indexText.setText(prefiledIndexText);
        Label VSAMFileTypeLabel = new Label((Composite)component_dsn_group, 0);
        VSAMFileTypeLabel.setText("VSAM file t&ype:");
        this.VSAMFileTypeText = new Combo((Composite)component_dsn_group, 2056);
        this.VSAMFileTypeText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Combo)this.VSAMFileTypeText, (int)10);
        this.VSAMFileTypeText.add("KSDS");
        this.VSAMFileTypeText.add("ESDS");
        this.VSAMFileTypeText.add("RRDS");
        this.VSAMFileTypeText.add("Linear");
        this.VSAMFileTypeText.select(0);
        this.VSAMFileTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AllocateNewVSAMDataSetWizardPage1.this.VSAMFileTypeText.getText().equalsIgnoreCase("KSDS")) {
                    AllocateNewVSAMDataSetWizardPage1.this.indexEnabled(true);
                } else {
                    AllocateNewVSAMDataSetWizardPage1.this.indexEnabled(false);
                }
                if (AllocateNewVSAMDataSetWizardPage1.this.VSAMFileTypeText.getText().equalsIgnoreCase("RRDS")) {
                    ((AllocateNewVSAMDataSetWizardPage2)AllocateNewVSAMDataSetWizardPage1.this.getNextPage()).isPageComplete();
                }
            }
        });
        Composite radio_composite = new Composite((Composite)component_dsn_group, 0);
        radio_composite.setSize(radio_composite.computeSize(-1, -1));
        GridLayout smsClass_layout1 = new GridLayout(1, true);
        radio_composite.setLayout((Layout)smsClass_layout1);
        new Label(radio_composite, 0);
        this.volumebtn = new Button(radio_composite, 16);
        this.volumebtn.setText("&Volume");
        final AllocateNewVSAMDataSetWizardPage2 page = (AllocateNewVSAMDataSetWizardPage2)this.getNextPage();
        this.volumebtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AllocateNewVSAMDataSetWizardPage1.this.CheckSMS();
                page.setDataVolumesCount("1");
                page.setIndexVolumesCount("1");
                ArrayList<String> dataVolumes = new ArrayList<String>();
                dataVolumes.add(AllocateNewVSAMDataSetWizardPage1.this.VolDataText.getText());
                page.setDataSerials(dataVolumes);
                ArrayList<String> indexVolumes = new ArrayList<String>();
                indexVolumes.add(AllocateNewVSAMDataSetWizardPage1.this.VolDataText.getText());
                page.setIndexSerials(indexVolumes);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(radio_composite, 0);
        this.smsClassbtn = new Button(radio_composite, 16);
        this.smsClassbtn.setText("SMS cl&ass");
        this.smsClassbtn.setSelection(true);
        this.smsClassbtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AllocateNewVSAMDataSetWizardPage1.this.CheckSMS();
                page.setDataVolumesCount("1");
                page.setIndexVolumesCount("1");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite smsClass_composite2 = new Composite((Composite)component_dsn_group, 0);
        smsClass_composite2.setSize(smsClass_composite2.computeSize(-1, -1));
        GridLayout smsClass_layout2 = new GridLayout(3, true);
        smsClass_composite2.setLayout((Layout)smsClass_layout2);
        Composite smsClass_composite3 = new Composite(smsClass_composite2, 0);
        smsClass_composite3.setSize(smsClass_composite2.computeSize(-1, -1));
        GridLayout smsClass_layout3 = new GridLayout(1, true);
        smsClass_composite3.setLayout((Layout)smsClass_layout3);
        Label VolDataLabel = new Label(smsClass_composite3, 0);
        VolDataLabel.setText("Da&ta:");
        this.VolDataText = new Text(smsClass_composite3, 2048);
        this.VolDataText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Text)this.VolDataText, (int)7);
        this.VolDataText.setTextLimit(6);
        this.VolDataText.addModifyListener((ModifyListener)this);
        this.VolDataText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        Label SMSClassStorageLabel = new Label(smsClass_composite3, 0);
        SMSClassStorageLabel.setText("Stora&ge:");
        this.SMSClassStorageText = new Text(smsClass_composite3, 2048);
        this.SMSClassStorageText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Text)this.SMSClassStorageText, (int)7);
        this.SMSClassStorageText.addModifyListener((ModifyListener)this);
        this.SMSClassStorageText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.SMSClassStorageText.setTextLimit(8);
        Composite smsClass_composite4 = new Composite(smsClass_composite2, 0);
        smsClass_composite4.setSize(smsClass_composite2.computeSize(-1, -1));
        GridLayout smsClass_layout4 = new GridLayout(1, true);
        smsClass_composite4.setLayout((Layout)smsClass_layout4);
        Label VolIndexLabel = new Label(smsClass_composite4, 0);
        VolIndexLabel.setText("Ind&ex:");
        this.VolIndexText = new Text(smsClass_composite4, 2048);
        this.VolIndexText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Text)this.VolIndexText, (int)7);
        this.VolIndexText.setTextLimit(6);
        this.VolIndexText.addModifyListener((ModifyListener)this);
        this.VolIndexText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        Label SMSClassDataLabel = new Label(smsClass_composite4, 0);
        SMSClassDataLabel.setText("Da&ta:");
        this.SMSClassDataText = new Text(smsClass_composite4, 2048);
        this.SMSClassDataText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Text)this.SMSClassDataText, (int)7);
        this.SMSClassDataText.addModifyListener((ModifyListener)this);
        this.SMSClassDataText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.SMSClassDataText.setTextLimit(8);
        Composite smsClass_composite5 = new Composite(smsClass_composite2, 0);
        smsClass_composite5.setSize(smsClass_composite2.computeSize(-1, -1));
        GridLayout smsClass_layout5 = new GridLayout(1, true);
        smsClass_composite5.setLayout((Layout)smsClass_layout5);
        new Label(smsClass_composite5, 0);
        new Text(smsClass_composite5, 2048).setVisible(false);
        Label SMSClassManagementLabel = new Label(smsClass_composite5, 0);
        SMSClassManagementLabel.setText("Manag&ement:");
        this.SMSClassManagementText = new Text(smsClass_composite5, 2048);
        this.SMSClassManagementText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Text)this.SMSClassManagementText, (int)7);
        this.SMSClassManagementText.addModifyListener((ModifyListener)this);
        this.SMSClassManagementText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.SMSClassManagementText.setTextLimit(8);
        GridLayout options_layout = new GridLayout(1, false);
        Group options_group = new Group(this.container, 0);
        options_layout = new GridLayout(5, false);
        options_group.setLayout((Layout)options_layout);
        options_group.setText("Options");
        options_group.setSize(options_group.computeSize(-1, -1));
        options_group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.ReuseOptBtn = new Button((Composite)options_group, 32);
        this.ReuseOptBtn.setText("Re&use option");
        this.ReuseOptBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        new Label((Composite)options_group, 0).setText("                        ");
        this.WriteCheckBtn = new Button((Composite)options_group, 32);
        this.WriteCheckBtn.setText("Write c&heck");
        this.WriteCheckBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        new Label((Composite)options_group, 0).setText("                        ");
        this.SpanRecordsBtn = new Button((Composite)options_group, 32);
        this.SpanRecordsBtn.setText("&Spanned records");
        this.SpanRecordsBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.LoadRestartBtn = new Button((Composite)options_group, 32);
        this.LoadRestartBtn.setText("L&oad restartable");
        this.LoadRestartBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        new Label((Composite)options_group, 0);
        this.EraseDelBtn = new Button((Composite)options_group, 32);
        this.EraseDelBtn.setText("E&rase on delete");
        this.EraseDelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        new Label((Composite)options_group, 0);
        new Label((Composite)options_group, 0);
        this.multiVolBtn = new Button((Composite)options_group, 32);
        this.multiVolBtn.setText("Multi&ple volumes");
        this.multiVolEditBtn = new Button((Composite)options_group, 8);
        this.multiVolEditBtn.setText("&Edit...        ");
        this.multiVolEditBtn.setEnabled(false);
        this.multiVolBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AllocateNewVSAMDataSetWizardPage1.this.multiVolBtn.getSelection()) {
                    AllocateNewVSAMDataSetWizardPage1.this.multiVolEditBtn.setEnabled(false);
                    ArrayList<String> indexSerials = new ArrayList<String>();
                    indexSerials.add(AllocateNewVSAMDataSetWizardPage1.this.VolIndexText.getText());
                    ((AllocateNewVSAMDataSetWizardPage2)AllocateNewVSAMDataSetWizardPage1.this.getNextPage()).setIndexSerials(indexSerials);
                    ((AllocateNewVSAMDataSetWizardPage2)AllocateNewVSAMDataSetWizardPage1.this.getNextPage()).setIndexVolumesCount("1");
                    ArrayList<String> dataSerials = new ArrayList<String>();
                    dataSerials.add(AllocateNewVSAMDataSetWizardPage1.this.VolIndexText.getText());
                    ((AllocateNewVSAMDataSetWizardPage2)AllocateNewVSAMDataSetWizardPage1.this.getNextPage()).setDataSerials(dataSerials);
                    ((AllocateNewVSAMDataSetWizardPage2)AllocateNewVSAMDataSetWizardPage1.this.getNextPage()).setDataVolumesCount("1");
                } else {
                    AllocateNewVSAMDataSetWizardPage1.this.multiVolEditBtn.setEnabled(true);
                }
            }
        });
        new Label((Composite)options_group, 0);
        new Label((Composite)options_group, 0);
        new Label((Composite)options_group, 0);
        this.dirListInsert = new Button(this.container, 32);
        this.dirListInsert.setText("Add to Director&y List view");
        final AllocateNewVSAMDataSetWizardPage2 valuesReciever = (AllocateNewVSAMDataSetWizardPage2)this.getNextPage();
        this.multiVolEditBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleVolumeWizard wizard = new MultipleVolumeWizard(AllocateNewVSAMDataSetWizardPage1.this.smsClassbtn.getSelection(), AllocateNewVSAMDataSetWizardPage1.this.indexNeeded, valuesReciever);
                TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(AllocateNewVSAMDataSetWizardPage1.this.getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
        this.setControl((Control)this.container);
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.allocateNewVSAMDataSetWizardPageOne");
        this.CheckSMS();
    }

    public boolean isPageComplete() {
        String error = "";
        if (this.modelDataSetNameText != null && this.dataText != null && this.indexText != null && this.VolDataText != null && this.VolIndexText != null) {
            switch (Validator.dataset(this.modelDataSetNameText.getText(), false)) {
                case 3: {
                    this.confirmButton.setEnabled(false);
                    this.selectButton.setEnabled(true);
                    break;
                }
                case 2: {
                    error = String.valueOf(error) + "Model data set name has invalid format\n ";
                    this.selectButton.setEnabled(false);
                    this.confirmButton.setEnabled(false);
                    this.setErrorMessage(error);
                    return false;
                }
                case 4: {
                    error = String.valueOf(error) + "Model data set name is too long\n ";
                    this.confirmButton.setEnabled(false);
                    this.selectButton.setEnabled(false);
                    this.setErrorMessage(error);
                    return false;
                }
                case 1: {
                    this.confirmButton.setEnabled(false);
                    break;
                }
                case 0: {
                    this.selectButton.setEnabled(false);
                    this.confirmButton.setEnabled(true);
                }
            }
            if (this.modelDataSetNameText.getText().length() == 0) {
                this.confirmButton.setEnabled(false);
            }
            switch (Validator.dataset(this.dataText.getText(), true)) {
                case 1: 
                case 2: 
                case 4: {
                    error = String.valueOf(error) + Validator.errorMsg[Validator.dataset(this.dataText.getText(), true)] + "\n ";
                    this.setErrorMessage(error);
                    return false;
                }
                case 0: {
                    break;
                }
                default: {
                    return true;
                }
            }
            switch (Validator.dataset(this.indexText.getText(), true)) {
                case 2: 
                case 4: {
                    error = String.valueOf(error) + Validator.errorMsg[Validator.dataset(this.indexText.getText(), true)] + "\n ";
                    this.setErrorMessage(error);
                    return false;
                }
                case 1: {
                    if (!this.VSAMFileTypeText.getText().equalsIgnoreCase("KSDS")) break;
                    error = String.valueOf(error) + Validator.errorMsg[Validator.dataset(this.indexText.getText(), true)] + "\n ";
                    this.setErrorMessage(error);
                    return false;
                }
                case 0: {
                    break;
                }
                default: {
                    return true;
                }
            }
            if (this.dataText.getText().trim().equalsIgnoreCase(this.indexText.getText().trim())) {
                this.setErrorMessage("Duplicate Data set Name");
                return false;
            }
            switch (Validator.volume(this.VolDataText.getText(), false)) {
                case 9: {
                    error = String.valueOf(error) + Validator.errorMsg[Validator.volume(this.VolDataText.getText(), false)] + "\n ";
                    this.setErrorMessage(error);
                    return false;
                }
            }
            switch (Validator.volume(this.VolIndexText.getText(), false)) {
                case 9: {
                    error = String.valueOf(error) + Validator.errorMsg[Validator.volume(this.VolIndexText.getText(), false)] + "\n ";
                    this.setErrorMessage(error);
                    return false;
                }
            }
            this.setErrorMessage(null);
        }
        return true;
    }

    private void CheckSMS() {
        if (this.volumebtn.getSelection()) {
            this.SMSClassStorageText.setEnabled(false);
            this.SMSClassDataText.setEnabled(false);
            this.SMSClassManagementText.setEnabled(false);
            this.VolDataText.setEnabled(true);
            if (this.VSAMFileTypeText.getText().equalsIgnoreCase("KSDS")) {
                this.VolIndexText.setEnabled(true);
            }
        } else {
            this.SMSClassStorageText.setEnabled(true);
            this.SMSClassDataText.setEnabled(true);
            this.SMSClassManagementText.setEnabled(true);
            this.VolDataText.setEnabled(false);
            this.VolIndexText.setEnabled(false);
        }
    }

    private String getDSNListPDS() {
        ScopedPreferenceStore store = null;
        if (store == null) {
            store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
        }
        String DSNListPDS = store.getString("DSNLISTSPDS_VALUE");
        return DSNListPDS;
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.container.setFocus();
    }

    public void insertIntoDirecotryList(FileMasterServer server) {
        FileMasterDataset fmdataset = new FileMasterDataset(null);
        fmdataset.setName(this.DatasetName);
        fmdataset.setDsOrg("VSAM");
        TT_TreeItem dsItem = null;
        int index = 0;
        int i = 0;
        while (i < this.model.getServers().length) {
            if (this.model.getServers()[i].getName().equals(server.getName())) {
                index = i;
                break;
            }
            ++i;
        }
        dsItem = this.model.findObjectInTree((Object)fmdataset, this.model.getServers()[index]);
        if (dsItem == null) {
            Element dsElement = this.model.addDataset(this.model.getServers()[index].getElement(), fmdataset.getName(), "", "", "", fmdataset.getDsOrg());
            dsItem = this.model.insertDataset(this.model.getServers()[index], dsElement);
            this.model.save();
        }
        fmdataset.setName(this.dataText.getText());
        dsItem = this.model.findObjectInTree((Object)fmdataset, this.model.getServers()[index]);
        if (dsItem == null) {
            Element dsElement = this.model.addDataset(this.model.getServers()[index].getElement(), fmdataset.getName(), "", "", "", fmdataset.getDsOrg());
            dsItem = this.model.insertDataset(this.model.getServers()[index], dsElement);
            this.model.save();
        }
        fmdataset.setName(this.indexText.getText());
        dsItem = this.model.findObjectInTree((Object)fmdataset, this.model.getServers()[index]);
        if (dsItem == null) {
            Element dsElement = this.model.addDataset(this.model.getServers()[index].getElement(), fmdataset.getName(), "", "", "", fmdataset.getDsOrg());
            dsItem = this.model.insertDataset(this.model.getServers()[index], dsElement);
            this.model.save();
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            DirectoryListView DirectoryView = (DirectoryListView)page.findView("com.ca.filemaster.views.directorylist");
            TreeViewer viewer = DirectoryView.getViewer();
            viewer.refresh();
            viewer.setSelection((ISelection)new StructuredSelection(), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Button getDirListInsert() {
        return this.dirListInsert;
    }

    public HashMap<String, Object> OptionValues() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reuseOption", this.ReuseOptBtn.getSelection() ? "Y" : "N");
        map.put("writeCheck", this.WriteCheckBtn.getSelection() ? "Y" : "N");
        map.put("spannedRecords", this.SpanRecordsBtn.getSelection() ? "Y" : "N");
        map.put("loadRestartable", this.LoadRestartBtn.getSelection() ? "Y" : "N");
        map.put("eraseOnDelete", this.EraseDelBtn.getSelection() ? "Y" : "N");
        map.put("multipleVolumes", this.volumebtn.getSelection() ? "Y" : "N");
        return map;
    }

    public String getCluster() {
        return this.DatasetName;
    }

    public String getComponentDSNData() {
        return this.dataText.getText();
    }

    public String getComponentDSNIndex() {
        return this.indexText.getText();
    }

    public String getVolumeData() {
        return this.VolDataText.getText();
    }

    public String getVolumeIndex() {
        return this.VolIndexText.getText();
    }

    public void setVolumeData(String volumeData) {
        this.VolDataText.setText(volumeData);
    }

    public void setVolumeIndex(String volumeIndex) {
        this.VolIndexText.setText(volumeIndex);
    }

    public String getSMSStorage() {
        return this.SMSClassStorageText.getText();
    }

    public String getSMSData() {
        return this.SMSClassDataText.getText();
    }

    public String getSMSManagement() {
        return this.SMSClassManagementText.getText();
    }

    public String getVSAMFileType() {
        return this.VSAMFileTypeText.getText().substring(0, 1);
    }

    public boolean isSMSClass() {
        return this.smsClassbtn.getSelection();
    }

    public IWizardPage getNextPage() {
        if (this.getWizard() instanceof AllocateDatasetWizard) {
            if (this.getWizard().getPage("allocateNewVSAMDataSetWizardPage2") == null) {
                AllocateNewVSAMDataSetWizardPage2 newPage = new AllocateNewVSAMDataSetWizardPage2(this.server, this.DatasetName);
                ((AllocateDatasetWizard)this.getWizard()).addPage((IWizardPage)newPage);
            }
            return this.getWizard().getPage("allocateNewVSAMDataSetWizardPage2");
        }
        if (this.getWizard().getPage("allocateNewVSAMDataSetWizardPage2") == null) {
            AllocateNewVSAMDataSetWizardPage2 newPage = new AllocateNewVSAMDataSetWizardPage2(this.server, this.DatasetName);
            ((AllocateNewVSAMDataSetWizard)this.getWizard()).addPage((IWizardPage)newPage);
        }
        return this.getWizard().getPage("allocateNewVSAMDataSetWizardPage2");
    }

    public void updateDataSet(String dataSet) {
        this.DatasetName = dataSet;
        if (this.ClusterLabelData != null) {
            this.ClusterLabelData.setText(this.DatasetName);
        }
        if (this.dataText != null) {
            this.dataText.setText(String.valueOf(this.DatasetName) + ".DATA");
        }
        if (this.indexText != null) {
            this.indexText.setText(String.valueOf(this.DatasetName) + ".INDEX");
        }
    }

    public void indexEnabled(boolean indexEnabled) {
        this.indexText.setEnabled(indexEnabled);
        if (this.volumebtn.getSelection()) {
            this.VolIndexText.setEnabled(indexEnabled);
        }
        this.indexNeeded = indexEnabled;
        ((AllocateNewVSAMDataSetWizardPage2)this.getNextPage()).setIndexNeeded(this.indexNeeded);
    }

    public void insertDSNToField(String value) {
        this.modelDataSetNameText.setText(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setModelParameters(FileMasterDataset model) {
        if (model == null) {
            this.modelDataSetName = this.modelDataSetNameText.getText();
            FileMasterDataset FMDataSet = CommonMFCalls.getFQDSN(this.modelDataSetName, "", this.server);
            if (!CommonMFCalls.RETURN_CODE.equals("0")) return;
            this.modelDataset = FMDataSet;
        } else {
            this.modelDataset = model;
        }
        if (this.modelDataset.getVolume().equalsIgnoreCase("ARCIVE")) {
            TT_ErrorDialog.openError(null, (String)"Error", (String)"Archived data set");
        } else if (!this.modelDataset.getDsOrg().equalsIgnoreCase("VSAM")) {
            TT_ErrorDialog.openError(null, (String)"Error", (String)"Invalid model data set", (Throwable)new Throwable("Model data set and new data set must have the same file type."));
        } else if (((FMPVSAMDataset)this.modelDataset).getDsType().equalsIgnoreCase("K") || ((FMPVSAMDataset)this.modelDataset).getDsType().equalsIgnoreCase("E") || ((FMPVSAMDataset)this.modelDataset).getDsType().equalsIgnoreCase("R") || ((FMPVSAMDataset)this.modelDataset).getDsType().equalsIgnoreCase("Y") || ((FMPVSAMDataset)this.modelDataset).getDsType().equalsIgnoreCase("N")) {
            this.VolIndexText.setText("");
            this.VolDataText.setText("");
            this.SMSClassStorageText.setText("");
            this.SMSClassDataText.setText("");
            this.SMSClassManagementText.setText("");
            if (this.modelDataset.isSMSdataset()) {
                this.volumebtn.setSelection(false);
                this.smsClassbtn.setSelection(true);
            } else {
                this.volumebtn.setSelection(true);
                this.smsClassbtn.setSelection(false);
            }
            this.CheckSMS();
            if (((FMPVSAMDataset)this.modelDataset).getDsType().equalsIgnoreCase("K")) {
                this.VSAMFileTypeText.select(0);
            } else if (((FMPVSAMDataset)this.modelDataset).getDsType().equalsIgnoreCase("E")) {
                this.VSAMFileTypeText.select(1);
            } else if (((FMPVSAMDataset)this.modelDataset).getDsType().equalsIgnoreCase("R") || ((FMPVSAMDataset)this.modelDataset).getDsType().equalsIgnoreCase("Y")) {
                this.VSAMFileTypeText.select(2);
            } else if (((FMPVSAMDataset)this.modelDataset).getDsType().equalsIgnoreCase("N")) {
                this.VSAMFileTypeText.select(3);
            }
            if (((FMPVSAMDataset)this.modelDataset).getIndexVolumes().size() > 0) {
                this.VolIndexText.setText(((FMPVSAMDataset)this.modelDataset).getIndexVolumes().get(0));
            }
            this.VolDataText.setText(((FMPVSAMDataset)this.modelDataset).getDataVolumes().get(0));
            this.SMSClassStorageText.setText(((FMPVSAMDataset)this.modelDataset).getSmsStorage());
            this.SMSClassDataText.setText(((FMPVSAMDataset)this.modelDataset).getSmsData());
            this.SMSClassManagementText.setText(((FMPVSAMDataset)this.modelDataset).getSmsManagement());
            this.multiVolBtn.setSelection(((FMPVSAMDataset)this.modelDataset).getIndexVolumes().size() > 1 || ((FMPVSAMDataset)this.modelDataset).getDataVolumes().size() > 1);
            this.ReuseOptBtn.setSelection(!((FMPVSAMDataset)this.modelDataset).getReuse().equalsIgnoreCase("N"));
            this.WriteCheckBtn.setSelection(!((FMPVSAMDataset)this.modelDataset).getWriteCheck().equalsIgnoreCase("N"));
            this.SpanRecordsBtn.setSelection(!((FMPVSAMDataset)this.modelDataset).getSpanned().equalsIgnoreCase("N"));
            this.LoadRestartBtn.setSelection(!((FMPVSAMDataset)this.modelDataset).getLoadRestartable().equalsIgnoreCase("N"));
            this.EraseDelBtn.setSelection(!((FMPVSAMDataset)this.modelDataset).getErase().equalsIgnoreCase("N"));
            this.nextPage.setModelParameters(this.modelDataset);
        } else {
            TT_ErrorDialog.openError(null, (String)"Error", (String)"Invalid model data set", (Throwable)new Throwable("Model data set and new data set must have the same file type."));
        }
        FMHistory.insertHistory(this.modelDataSetNameText, "modelVSAMDataSetNameList");
        FMHistory.intializeComboBoxes(this.modelDataSetNameText, "modelVSAMDataSetNameList");
        this.modelDataSetNameText.setText(this.modelDataSetName);
    }
}

