/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utilities;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.utilities.CompareGenericWizard;
import com.ca.filemaster.utility.compare.CompareProgramPage3;
import com.ca.filemaster.utility.compare.CompareWizardPage1;
import com.ca.filemaster.utility.compare.CompareWizardPage2;
import com.ca.filemaster.utility.compare.CompareWizardPage4;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class CompareGenericWizardPage1
extends FileMasterWizard {
    private FileMasterServer server;
    private FileMasterDataset dataSet;
    private CompareWizardPage2 cp2;
    private boolean isComparePgm = false;
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.compareGenericPage";
    protected FileMasterMember member;

    protected CompareGenericWizardPage1(FileMasterServer server) {
        super("Select Data set", "", server);
        this.setTitle("Compare Utility");
        this.setDescription("Select data set or program to compare");
        this.server = server;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.compareGenericPage");
        super.createDataSet();
        FMHistory.intializeComboBoxes(this.dataSetCombo, "DatasetListCompareGeneric");
    }

    @Override
    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.canFlipToNextPage());
    }

    public boolean canFlipToNextPage() {
        return super.isPageComplete();
    }

    public IWizardPage getNextPage() {
        FMHistory.insertHistory(this.dataSetCombo, "DatasetListCompareGeneric");
        String DatasetName = this.dataSetCombo.getText().trim().toUpperCase();
        String typeOfDSN = "";
        this.dataSet = CommonMFCalls.getFQDSN(DatasetName, "", this.server, true);
        if (CommonMFCalls.RETURN_CODE.equals("0")) {
            if (this.dataSet.getVolume().equalsIgnoreCase("ARCIVE")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)"Archived data set", (Throwable)new Throwable("Archived data set"));
                return null;
            }
            if (this.dataSet.getDsOrg().equalsIgnoreCase("VSAM")) {
                this.dataSet.setName(((FMPVSAMDataset)this.dataSet).getCluster());
            }
            if (this.dataSet.getDsOrg().equalsIgnoreCase("HFS") || this.dataSet.getDsOrg().equalsIgnoreCase("VSAM") && this.dataSet.getDsType().equalsIgnoreCase("N") || this.dataSet.getDsOrg().equalsIgnoreCase("GDG")) {
                MessageDialog.openError(null, (String)"Data Set Not Supported", (String)(String.valueOf(this.dataSet.getName()) + " not supported."));
                return null;
            }
            this.isComparePgm = this.isLoadLib(this.dataSet);
            typeOfDSN = this.dataSet.getDsOrg();
            if (typeOfDSN.trim().isEmpty()) {
                typeOfDSN = this.dataSet.getFileType();
            }
        } else {
            return null;
        }
        if (!CommonMFCalls.RETURN_CODE.equals("0")) {
            return null;
        }
        CompareWizardPage1 cp1 = (CompareWizardPage1)((CompareGenericWizard)this.getWizard()).getPage("Old Data Set");
        cp1.setDatasetCombo(this.dataSet.getName());
        cp1.setDatasetType(typeOfDSN);
        this.cp2 = (CompareWizardPage2)((CompareGenericWizard)this.getWizard()).getPage("New Data Set");
        this.cp2.setIsComparePgm(this.isComparePgm);
        if (this.isComparePgm) {
            ((CompareGenericWizard)this.getWizard()).setWindowTitle("Compare Program Utility");
        } else {
            ((CompareGenericWizard)this.getWizard()).setWindowTitle("Compare Data Set Utility");
        }
        return cp1;
    }

    @Override
    public boolean isPageComplete() {
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.dataSetCombo.setFocus();
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() instanceof CompareWizardPage1) {
            return false;
        }
        if (this.cp2 != null) {
            if (this.isComparePgm) {
                return this.cp2.isPageComplete() && this.cp2.getNextPage().isPageComplete() && ((CompareProgramPage3)((CompareGenericWizard)this.getWizard()).getPage("Compare Program Options")).isPageComplete();
            }
            return this.cp2.isPageComplete() && this.cp2.getNextPage().isPageComplete() && ((CompareWizardPage4)((CompareGenericWizard)this.getWizard()).getPage("wizardPage")).isPageComplete();
        }
        return false;
    }

    public boolean doFinish() {
        if (this.cp2 != null) {
            return this.cp2.doFinish();
        }
        return false;
    }

    private boolean isLoadLib(FileMasterDataset dataSet) {
        return (dataSet.getDsOrg().equalsIgnoreCase("PDS") || dataSet.getDsOrg().equalsIgnoreCase("PDSE")) && dataSet.getRecfm().equalsIgnoreCase("U");
    }
}

