/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utilities;

import com.ca.filemaster.common.Validator;
import com.ca.filemaster.utilities.AllocateNewDataSetWizardPage1;
import com.ca.filemaster.utilities.AllocateNewDataSetWizardPage2;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifytoUpperCase;
import java.util.ArrayList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MultipleVolumeSeqWizardPage
extends WizardPage
implements ModifyListener {
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.multipleVol";
    private Composite grpNumberOfVolumes;
    private Group dataVolumesGrp;
    private Control[] Tab_Volumes;
    private String error;
    private boolean useNumberOfVolumes;
    private Spinner spinnerNumberOfVolumes;
    private static final int MAXVOLUMES = 50;
    AllocateNewDataSetWizardPage2 valuesReciever;

    public MultipleVolumeSeqWizardPage(boolean useNumberOfVolumes, AllocateNewDataSetWizardPage2 valuesReciever) {
        super("add volume");
        this.useNumberOfVolumes = useNumberOfVolumes;
        this.setTitle("Add Multiple Volumes");
        this.setDescription("Enter volumes for data set");
        this.valuesReciever = valuesReciever;
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.multipleVol");
        Composite container = new Composite(parent, 0);
        GridLayout container_layout = new GridLayout(1, false);
        container.setLayout((Layout)container_layout);
        if (this.useNumberOfVolumes) {
            this.grpNumberOfVolumes = new Composite(container, 0);
            this.grpNumberOfVolumes.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.grpNumberOfVolumes.setLayout((Layout)new GridLayout(2, false));
            Label lblNumberOfVolumes = new Label(this.grpNumberOfVolumes, 0);
            GridData gd_lblNumberOfVolumes = new GridData(4, 0x1000000, false, false, 1, 1);
            gd_lblNumberOfVolumes.widthHint = 157;
            lblNumberOfVolumes.setLayoutData((Object)gd_lblNumberOfVolumes);
            lblNumberOfVolumes.setText("&Number of volumes:");
            this.spinnerNumberOfVolumes = new Spinner(this.grpNumberOfVolumes, 2048);
            this.spinnerNumberOfVolumes.setMaximum(99999);
            this.spinnerNumberOfVolumes.setTextLimit(5);
            this.spinnerNumberOfVolumes.addModifyListener((ModifyListener)this);
            GridData gd_NumberOfDataVols = new GridData(16384, 4, false, true, 1, 1);
            gd_NumberOfDataVols.widthHint = 50;
            this.spinnerNumberOfVolumes.setLayoutData((Object)gd_NumberOfDataVols);
            this.spinnerNumberOfVolumes.setSelection(this.valuesReciever.getCount().intValue());
        } else {
            this.dataVolumesGrp = new Group(container, 0);
            this.dataVolumesGrp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.dataVolumesGrp.setSize(this.dataVolumesGrp.computeSize(-1, -1));
            this.dataVolumesGrp.setText("&List of volumes");
            this.dataVolumesGrp.setLayout((Layout)new GridLayout(5, true));
            int i = 0;
            while (i < 50) {
                new Text((Composite)this.dataVolumesGrp, 2048);
                ++i;
            }
            Control[] controlArray = this.Tab_Volumes = this.dataVolumesGrp.getChildren();
            int n = this.Tab_Volumes.length;
            int gd_NumberOfDataVols = 0;
            while (gd_NumberOfDataVols < n) {
                Control Tab_Vol = controlArray[gd_NumberOfDataVols];
                if (Tab_Vol instanceof Text) {
                    Text t = (Text)Tab_Vol;
                    TextUtil.setWidth((Text)t, (int)6);
                    t.setTextLimit(6);
                    t.addModifyListener((ModifyListener)this);
                    t.addVerifyListener((VerifyListener)new verifytoUpperCase());
                }
                ++gd_NumberOfDataVols;
            }
            Button clearbtn = new Button(container, 8);
            clearbtn.setText("&Clear");
            clearbtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Control[] controlArray = MultipleVolumeSeqWizardPage.this.Tab_Volumes;
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control Tab_Vol = controlArray[n2];
                        if (Tab_Vol instanceof Text) {
                            Text t = (Text)Tab_Vol;
                            t.setText("");
                        }
                        ++n2;
                    }
                }
            });
            int i2 = 0;
            Control[] controlArray2 = this.Tab_Volumes;
            int n2 = this.Tab_Volumes.length;
            int n3 = 0;
            while (n3 < n2) {
                Control Tab_Vol = controlArray2[n3];
                if (Tab_Vol instanceof Text) {
                    Text t = (Text)Tab_Vol;
                    if (i2 == 0) {
                        String initVol = ((AllocateNewDataSetWizardPage1)this.valuesReciever.getWizard().getPage("allocateNewSeqDataSetWizardPage1")).getVolumeSerial();
                        if (this.Tab_Volumes != null) {
                            t.setText(initVol == null ? "" : initVol);
                        }
                        ++i2;
                    } else {
                        if (i2 + 1 > this.valuesReciever.getSer().size()) break;
                        t.setText(this.valuesReciever.getSer().get(i2));
                        ++i2;
                    }
                }
                ++n3;
            }
        }
        this.setControl((Control)parent);
        this.getShell().getDefaultButton().setText("OK");
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
    }

    public boolean doFinish() {
        ArrayList<String> ser = new ArrayList<String>();
        if (this.useNumberOfVolumes) {
            this.valuesReciever.setCount(Integer.parseInt(this.spinnerNumberOfVolumes.getText()));
            this.valuesReciever.setSer(ser);
        } else {
            String volume;
            ser.clear();
            Control[] controlArray = this.Tab_Volumes;
            int n = this.Tab_Volumes.length;
            int n2 = 0;
            while (n2 < n) {
                Control Tab_Vol = controlArray[n2];
                if (Tab_Vol instanceof Text && (volume = ((Text)Tab_Vol).getText().trim()).length() != 0) {
                    ser.add(volume);
                }
                ++n2;
            }
            this.valuesReciever.setSer(ser);
            this.valuesReciever.setCount(ser.size());
            volume = "";
            if (ser.size() > 0) {
                volume = ser.get(0);
            }
            ((AllocateNewDataSetWizardPage1)this.valuesReciever.getPreviousPage()).setVolumeSerial(volume);
        }
        return true;
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        this.error = new String();
        int counter = 0;
        if (!this.useNumberOfVolumes) {
            Control[] controlArray = this.Tab_Volumes;
            int n = this.Tab_Volumes.length;
            int n2 = 0;
            while (n2 < n) {
                Control Tab_Vol = controlArray[n2];
                if (Tab_Vol instanceof Text) {
                    Text t = (Text)Tab_Vol;
                    switch (Validator.volume(t.getText(), true)) {
                        case 9: {
                            this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.volume(t.getText(), false)] + "\n ";
                            break;
                        }
                        case 8: {
                            ++counter;
                        }
                    }
                }
                ++n2;
            }
        }
        if (counter == 50) {
            return false;
        }
        if (this.spinnerNumberOfVolumes != null) {
            this.setErrorMessage(null);
            if (!(this.spinnerNumberOfVolumes.getText().isEmpty() || Integer.parseInt(this.spinnerNumberOfVolumes.getText()) <= 32768 && Integer.parseInt(this.spinnerNumberOfVolumes.getText()) >= 0)) {
                this.error = String.valueOf(this.error) + "Number Of Volumes must be in between 0 - 32768" + "\n ";
                this.setErrorMessage(this.error);
                return false;
            }
        }
        if (this.error.length() > 0) {
            this.setErrorMessage(this.error);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

