/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.copy;

import com.ca.filemaster.common.FMPreferences;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.utilities.CopyGenericWizard;
import com.ca.filemaster.utility.copy.CopyVSAMToWizardPage;
import com.ca.filemaster.utility.copy.CopyVSAMUtilityWizard;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CopyVSAMFromWizardPage
extends FileMasterWizard
implements SelectionListener {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    Logger log = Logger.getLogger(CopyVSAMFromWizardPage.class.getName());
    Level baseLevel = this.log.getLevel();
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.copyVSAMWizardPage";
    public Label serverNameLabel;
    public Text serverNameCombo;
    private String datasetName;
    private Text FromDatasetCombo;
    protected FileMasterDataset dataSet;
    protected FileMasterServer server;
    private Button dirListInsert;
    private boolean isCopyVSAMWizard;

    public CopyVSAMFromWizardPage(String pageName, FileMasterServer server, FileMasterDataset dataSet, boolean isCopyVSAMWizard) {
        super(pageName, "", server);
        this.setTitle("Copy VSAM From");
        this.datasetName = dataSet.getName();
        this.server = server;
        this.dataSet = dataSet;
        this.isCopyVSAMWizard = isCopyVSAMWizard;
    }

    @Override
    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.copyVSAMWizardPage");
        super.createControl(parent);
        this.data = new GridData();
        this.data.horizontalAlignment = 4;
        this.data.verticalAlignment = 0;
        this.data.grabExcessHorizontalSpace = true;
        this.data.grabExcessVerticalSpace = true;
        this.data.horizontalSpan = 1;
        this.data.verticalSpan = 1;
        this.serverNameLabel = new Label(this.dataSetComposite, 0);
        this.serverNameLabel.setText("Se&rver:");
        this.serverNameCombo = new Text(this.dataSetComposite, 2056);
        this.serverNameCombo.setLayoutData((Object)this.data);
        this.serverNameCombo.setText(this.server.getText());
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.dataSetLabel = new Label(this.dataSetComposite, 0);
        this.dataSetLabel.setText("&Data set name:");
        this.FromDatasetCombo = new Text(this.dataSetComposite, 2056);
        this.FromDatasetCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.FromDatasetCombo.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
        TextUtil.setWidth((Text)this.FromDatasetCombo, (int)37);
        this.FromDatasetCombo.setText(this.datasetName);
        if (!this.isCopyVSAMWizard) {
            this.dirListInsert = new Button(this.container, 32);
            this.dirListInsert.setText("Add to Director&y List view");
        }
        if (!FMPreferences.disabledPreview()) {
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&Preview");
        }
    }

    public void widgetSelected(SelectionEvent e) {
        super.FMWWidgetSelected(e);
    }

    @Override
    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.canFlipToNextPage());
    }

    @Override
    public boolean isPageComplete() {
        return false;
    }

    public boolean canFlipToNextPage() {
        this.error = "";
        return super.isPageComplete();
    }

    public IWizardPage getNextPage() {
        CopyVSAMToWizardPage page1 = new CopyVSAMToWizardPage("Copy VSAM To", this.server, this.dataSet, this.isCopyVSAMWizard);
        if (this.isCopyVSAMWizard) {
            ((CopyVSAMUtilityWizard)this.getWizard()).addPage((IWizardPage)page1);
            return ((CopyVSAMUtilityWizard)this.getWizard()).getPage("Copy VSAM To");
        }
        ((CopyGenericWizard)this.getWizard()).addPage((IWizardPage)page1);
        return ((CopyGenericWizard)this.getWizard()).getPage("Copy VSAM To");
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.FromDatasetCombo.setFocus();
    }

    public String getFromDataSetName() {
        return this.FromDatasetCombo.getText().trim();
    }

    public void insertDSNToField(String value) {
        this.FromDatasetCombo.setText(value);
    }

    public boolean dirListInsertFrom() {
        if (this.dirListInsert == null) {
            return false;
        }
        return this.dirListInsert.getSelection();
    }

    public void setFromDataSetCombo(FileMasterDataset fromDataset) {
        this.dataSet = fromDataset;
        if (this.FromDatasetCombo != null) {
            this.FromDatasetCombo.setText(fromDataset.getName());
        }
    }

    public FileMasterDataset getFromDataSet() {
        return this.dataSet;
    }
}

