/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.print;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.utility.print.PrintUtilityWizardPageFive;
import com.ca.filemaster.utility.print.PrintUtilityWizardPageFour;
import com.ca.filemaster.utility.print.PrintUtilityWizardPageOne;
import com.ca.filemaster.utility.print.PrintUtilityWizardPageThree;
import com.ca.filemaster.utility.print.PrintUtilityWizardPageTwo;
import com.ca.testingtools.core.TT_TreeItem;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class PrintUtilityWizard
extends Wizard
implements INewWizard {
    PrintUtilityWizardPageOne page1;
    PrintUtilityWizardPageTwo page2;
    PrintUtilityWizardPageThree page3;
    PrintUtilityWizardPageFour page4;
    PrintUtilityWizardPageFive page5;
    public String titlePageOne = "Print";
    public String titlePageTwo = "Options";
    public String titlePageThree = "Print Output Control";
    public String titlePageFour = "Job information";
    public String titlePageFive = "Summary";
    public IStructuredSelection selection;
    public Map<String, String> map;
    public FileMasterServer server;
    public FileMasterDataset dataSet;
    public FileMasterMember member;
    public String layoutDS = "";
    public String layoutMem = "";
    public static String fileType = "";
    public static String subTypeOfDSN = "";

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        if (selection.getFirstElement() != null) {
            TT_TreeItem treeItem = (TT_TreeItem)selection.getFirstElement();
            if (treeItem.getParent() == null) {
                this.server = (FileMasterServer)treeItem.getValue();
            } else if (treeItem.getParent().getParent() != null) {
                this.server = (FileMasterServer)treeItem.getParent().getParent().getValue();
                this.dataSet = (FileMasterDataset)treeItem.getParent().getValue();
                this.member = (FileMasterMember)treeItem.getValue();
                this.layoutDS = treeItem.getElement().getAttribute("layoutDS");
                this.layoutMem = treeItem.getElement().getAttribute("layoutMem");
                fileType = "PDS";
                this.dataSet = CommonMFCalls.getFQDSN(this.dataSet.getText(), "", this.server);
                if (CommonMFCalls.RETURN_CODE.equals("0") && this.dataSet.getDsOrg().equalsIgnoreCase("VSAM")) {
                    this.dataSet.setName(((FMPVSAMDataset)this.dataSet).getCluster());
                }
            } else {
                this.dataSet = (FileMasterDataset)treeItem.getValue();
                this.server = (FileMasterServer)treeItem.getParent().getValue();
                if (((FileMasterDataset)treeItem.getValue()).getDsOrg().equalsIgnoreCase("VSAM")) {
                    fileType = "VSAM";
                }
                if (((FileMasterDataset)treeItem.getValue()).getDsOrg().equalsIgnoreCase("Sequential")) {
                    fileType = "Sequential";
                } else if (((FileMasterDataset)treeItem.getValue()).getDsOrg().equalsIgnoreCase("PS")) {
                    fileType = "PS";
                } else if (((FileMasterDataset)treeItem.getValue()).getDsOrg().equalsIgnoreCase("PSL")) {
                    fileType = "PSL";
                } else if (((FileMasterDataset)treeItem.getValue()).getDsOrg().equalsIgnoreCase("PDS")) {
                    fileType = "PDS";
                } else if (((FileMasterDataset)treeItem.getValue()).getDsOrg().equalsIgnoreCase("Direct Access")) {
                    fileType = "Direct Access";
                }
                subTypeOfDSN = ((FileMasterDataset)treeItem.getValue()).getDsType();
                this.dataSet = CommonMFCalls.getFQDSN(this.dataSet.getText(), "", this.server);
                if (CommonMFCalls.RETURN_CODE.equals("0") && this.dataSet.getDsOrg().equalsIgnoreCase("VSAM")) {
                    this.dataSet.setName(((FMPVSAMDataset)this.dataSet).getCluster());
                }
            }
        }
        this.map = new HashMap<String, String>();
    }

    public void addPages() {
        this.setWindowTitle("Print Utility");
        this.setForcePreviousAndNextButtons(true);
        TrayDialog.setDialogHelpAvailable((boolean)true);
        this.page1 = new PrintUtilityWizardPageOne(this.titlePageOne, this.server, this.dataSet, this.member, fileType, subTypeOfDSN, this.map);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new PrintUtilityWizardPageTwo(this.titlePageTwo, this.server.getName(), this.layoutDS, this.layoutMem, this.map);
        this.addPage((IWizardPage)this.page2);
        this.page3 = new PrintUtilityWizardPageThree(this.titlePageThree, this.server.getName(), this.map);
        this.addPage((IWizardPage)this.page3);
        this.page4 = new PrintUtilityWizardPageFour(this.titlePageFour, this.server.getName(), this.map);
        this.addPage((IWizardPage)this.page4);
        this.page5 = new PrintUtilityWizardPageFive(this.titlePageFive, this.map);
        this.addPage((IWizardPage)this.page5);
    }

    public boolean canFinish() {
        return this.page1.isPageComplete() && this.page2.isPageComplete() && this.page3.isPageComplete() && this.page4.isPageComplete();
    }

    public boolean performFinish() {
        if (this.map.get("Action") == "Finish") {
            this.page1.doFinish();
            this.page2.doFinish();
            this.page3.doFinish();
            this.page5.doFinish();
            return true;
        }
        this.map.put("Action", "Finish");
        return false;
    }
}

