/*
 * Decompiled with CFR 0.152.
 */
package com.ca.fmp.ims.common;

import com.ca.fmp.ims.common.FMNodeChild;
import com.ca.fmp.ims.common.FMServerTreeModel;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.runners.RunGetCancelSession;
import com.ca.fmp.ims.common.runners.RunGetSession;
import com.ca.testingtools.common.XMLRequest;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FileMasterSession
extends FMNodeChild {
    private String uuid;
    private String type;
    public static String user;
    private static FMServerTreeModel model;
    private FileMasterServer server;
    private String displayMode;
    private String hexMode;
    private int recordCount = 0;
    private String editMode;
    private String reportViewID;

    static {
        model = FMServerTreeModel.getInstance();
    }

    public String getEditMode() {
        return this.editMode;
    }

    public void setEditMode(String editMode) {
        this.editMode = editMode;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public FileMasterSession(String uuid, String type, String user) {
        this.uuid = uuid;
        this.type = type;
    }

    public FileMasterSession() {
    }

    public String getUuid() {
        return this.uuid;
    }

    public FileMasterServer getServer() {
        return this.server;
    }

    public void setServer(FileMasterServer server) {
        this.server = server;
    }

    public String getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(String displayMode) {
        this.displayMode = displayMode;
    }

    public String getHexMode() {
        return this.hexMode;
    }

    public void setHexMode(String hexMode) {
        this.hexMode = hexMode;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
    }

    public static FileMasterSession startSession(FileMasterServer server, boolean isTransactional) {
        RunGetSession runner = new RunGetSession(server);
        runner.run();
        XMLRequest xml = runner.getXml();
        FileMasterSession fmSession = new FileMasterSession("", "", "");
        if (xml != null) {
            Element sessionElement = xml.getCommand();
            if (sessionElement != null) {
                fmSession.setUuid(sessionElement.getAttribute("uuid"));
                if (isTransactional) {
                    fmSession.setType("transactional");
                } else {
                    fmSession.setType("conversational");
                }
                fmSession.setUser(sessionElement.getAttribute("user"));
            }
        } else {
            return new FileMasterSession("", "", "");
        }
        model.addSession(server.getElement(), fmSession.getUuid(), fmSession.getType(), fmSession.getUser());
        model.save();
        return fmSession;
    }

    public static void cancelSession() {
        int countServer = 0;
        while (countServer < model.getServers().length) {
            FileMasterServer server = (FileMasterServer)model.getServers()[countServer].getServer();
            while (model.getSessions(server).size() > 0) {
                if (!model.getSessions(server).get(0).getUuid().trim().isEmpty()) {
                    RunGetCancelSession runner = new RunGetCancelSession(server, model.getSessions(server).get(0).getUuid());
                    runner.run();
                }
                server.getElement().removeChild(server.getElement().getElementsByTagName("session").item(0));
                model.save();
            }
            ++countServer;
        }
    }

    public static synchronized void cancelOneSession(FileMasterServer server) {
        while (model.getSessions(server).size() > 0) {
            if (!model.getSessions(server).get(0).getUuid().trim().isEmpty()) {
                RunGetCancelSession runner = new RunGetCancelSession(server, model.getSessions(server).get(0).getUuid());
                runner.run();
            }
            server.getElement().removeChild(server.getElement().getElementsByTagName("session").item(0));
            model.save();
        }
    }

    public static synchronized void cancelOneSession(FileMasterServer server, String uuid) {
        if (!model.getSessions(server).get(0).getUuid().trim().isEmpty()) {
            RunGetCancelSession runner = new RunGetCancelSession(server, uuid);
            runner.run();
        }
        NodeList sessionList = server.getElement().getElementsByTagName("session");
        int i = 0;
        while (i < sessionList.getLength()) {
            if (sessionList.item(i).getAttributes().item(2).getNodeValue().equalsIgnoreCase(uuid)) {
                server.getElement().removeChild(sessionList.item(i));
                model.save();
                break;
            }
            ++i;
        }
    }

    public static void removeOneSessionFromList(FileMasterServer server, String uuid) {
        NodeList sessionList = server.getElement().getElementsByTagName("session");
        int i = 0;
        while (i < sessionList.getLength()) {
            if (sessionList.item(i).getAttributes().item(2).getNodeValue().equalsIgnoreCase(uuid)) {
                server.getElement().removeChild(sessionList.item(i));
                model.save();
                break;
            }
            ++i;
        }
    }

    public static String getUUID(FileMasterServer server, boolean isTransactional) {
        return FileMasterSession.getUUID(server, isTransactional, false);
    }

    public static String getUUID(FileMasterServer server, boolean isTransactional, boolean createNew) {
        String uuid = "";
        if (createNew) {
            FileMasterSession session = FileMasterSession.startSession(server, isTransactional);
            if (session == null) {
                return null;
            }
            uuid = session.getUuid();
            return uuid;
        }
        ArrayList<Object> fmSessions = new ArrayList();
        fmSessions = model.getSessions(server);
        if (fmSessions.size() > 0) {
            int count = 0;
            while (count < fmSessions.size()) {
                if (((FileMasterSession)((Object)fmSessions.get(count))).getType().equalsIgnoreCase(isTransactional ? "TRANSACTIONAL" : "CONVERSATIONAL")) {
                    uuid = ((FileMasterSession)((Object)fmSessions.get(count))).getUuid();
                    break;
                }
                ++count;
            }
            if (uuid.isEmpty()) {
                uuid = FileMasterSession.startSession(server, isTransactional).getUuid();
            }
        } else {
            FileMasterSession session = FileMasterSession.startSession(server, isTransactional);
            if (session != null) {
                uuid = session.getUuid();
            } else {
                return null;
            }
        }
        return uuid;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this;
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FileMasterSession)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        FileMasterSession other = (FileMasterSession)((Object)obj);
        String session = this.getName();
        String sessionother = other.getName();
        if (session == null || sessionother == null) {
            return false;
        }
        boolean result = session.equals(sessionother);
        if (result && session.isEmpty()) {
            return this.getParent() == other.getParent();
        }
        return result;
    }

    public static void removeSession(FileMasterServer server, String uuid2) {
        ArrayList<FileMasterSession> sessions = model.getSessions(server);
        int i = 0;
        while (i < sessions.size()) {
            if (sessions.get(i).getUuid().equalsIgnoreCase(uuid2)) {
                server.getElement().removeChild(server.getElement().getElementsByTagName("session").item(i));
                model.save();
            }
            ++i;
        }
    }

    public void setReportViewID(String reportViewID) {
        this.reportViewID = reportViewID;
    }

    public String getReportViewID() {
        return this.reportViewID;
    }
}

