/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;

import com.ca.fmp.ims.common.Constants;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.model.EditODOChangeResponse;
import com.ca.fmp.ims.model.IMSSegment;
import com.ca.fmp.ims.model.UpdateSegmentFieldTypeRequest;
import com.ca.fmp.ims.model.UpdateSegmentRequestType;
import com.ca.fmp.ims.model.generated.CursorType;
import com.ca.fmp.ims.model.generated.DisplayModeType;
import com.ca.fmp.ims.model.generated.EditModeType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.KeyInfoType;
import com.ca.fmp.ims.model.generated.MFRequestType;
import com.ca.fmp.ims.model.generated.MessageType;
import com.ca.fmp.ims.model.generated.ODOResponseType;
import com.ca.fmp.ims.model.generated.RangeListType;
import com.ca.fmp.ims.model.generated.RangeType;
import com.ca.fmp.ims.model.generated.SegmentFieldType;
import com.ca.fmp.ims.model.generated.SegmentFieldsType;
import com.ca.fmp.ims.model.generated.SegmentType;
import com.ca.fmp.ims.model.generated.YorNType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.handlers.FileMasterPlusKeyListener;
import com.ca.fmp.ims.view.handlers.TraverseListenerTable;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;

/**
 * 2014/09/10 carel06
 * - updated focusGained() to update the subStringBeginIndex and subStringEndIndex
 *   for the FileMasterPlusKeyListener class.  
 * - removed getActiveSegmentType() since it is not being used.
 * - removed updateChanges() since it is not being used.
 * - made Text into a local member variable since it is only being used by one method.
 * 
 * @author navri01 
 */
public class EditingSupportFileMasterIMS extends EditingSupport implements FocusListener {

	public static boolean isOvertypeMode = true; // by default the value for overtype should be true.
    
	private int colName;
	private Logger log = Logger.getLogger(EditingSupportFileMasterIMS.class.getName());
    protected FormatMode formatMode;
	private TextCellEditor textCellEditor;
	protected GUIResponseType response;
	protected EditorView editorView;	
	protected int numberOfCharactersThatWeCanDisplay;
	protected FileMasterPlusKeyListener fileMasterPlusKeyListener;
	private TraverseListenerTable traverseListenerTable;
	protected TableViewer tableViewer;

	// carel06 2014/10/15
	// This variables are being updated in the getCellEditor()
    protected SegmentFieldType segmentFieldType = null;
    protected SegmentType segmentType = null;
    
	/**
     * 2014/09/10 carel06
     * - removed table parameter since it can be accessed from tableViewer.
	 * 
	 * @param eView
	 * @param columnViewer
	 * @param colName
	 * @param tableViewerColumn Not being used currently, so I removed the member variable for this
	 * @param formatMode
	 * @param table
	 */
	public EditingSupportFileMasterIMS(EditorView eView, TableViewer tableViewer, int colName, TableViewerColumn tableViewerColumn, FormatMode formatMode) {
		super(tableViewer);
		this.colName=colName;
        this.tableViewer = tableViewer;
		this.formatMode = formatMode;
		this.editorView = eView;
	}

	@Override
	protected boolean canEdit(Object element) {
		// carel06 2014/12/04
		// Defect 3223
		// we should enable cursor position in browse mode
		// hence we need this to be true all the time.
		if(colName == 2)
			return false;
		return true;
	}

	/**
	 * carel06
	 * We can't return the full value of the segment data.
	 * We have to filter it so that it returns only what can be viewed 
	 * by the Text widget without it being resized.
	 * 
	 * TODO I think the tablerow and the edit widget have two different fonts.
	 * we have to match these up.
	 */
	@Override
	protected Object getValue(Object element) {
		SegmentType segmentType = null;
        SegmentFieldType segmentFieldType = null;
        String charData = null;
        String hexData1 = null;
        String hexData2 = null;
        String value = ""; // this is the data that needs to be displayed
        
		// carel06 2014/10/15
		// we should be working with it's simplest form.
		// instead of working with both the SegmentType and SegmentFieldType
		// I think we can just work with the segmentFieldType
        if(element instanceof IMSSegment) {
        	// it seems we are working in char mode
        	// let's get the segmentFieldType from the segmentType
            segmentType = ((IMSSegment)element).segmentType;
        	segmentFieldType = segmentType.getSegmentFields().getSegmentField().get(0);
        } else if(element instanceof SegmentFieldType) {
            // we are in SingleRecordFormatMode
        	segmentFieldType = (SegmentFieldType) element;
        } else {
            // unrecognized type, just return
        	log.warning("unrecognized type");
        	return null;
        }
        
		charData = segmentFieldType.getCharData();
        hexData1 = segmentFieldType.getHexData1();
        hexData2 = segmentFieldType.getHexData2();
        
		if(element instanceof IMSSegment){
			if(colName==2){
				value = ((IMSSegment)element).getSegName();
			} else {
				value = charData;				
			}
		} else if(element instanceof SegmentFieldType) {
			value = charData;
		}
        
        // this is the index values that have to be display 
//		@polra04: #3090, #3101, #3112 - use of substring indices stored in getCellEditor()
//		int substringBeginIndex = charFormatMode.getSubstringBeginIndex();
//		int substringEndIndex = charFormatMode.getSubstringEndIndex();

		// we can only display this # of characters
		numberOfCharactersThatWeCanDisplay = formatMode.getSubstringEndIndex() - formatMode.getSubstringBeginIndex();

		if(formatMode.getSubstringBeginIndex() > value.length()) {
			return "";
		} else if(formatMode.getSubstringEndIndex() > value.length()) {
            if(hexData1 == null) {
            	return value.substring(formatMode.getSubstringBeginIndex());
            } else {
                // 20141006 carel06
				// we need to account for updating the hexdata portion as well.
				String charDataStripped = charData.substring(formatMode.getSubstringBeginIndex());
				String hexData1Stripped = hexData1.substring(formatMode.getSubstringBeginIndex());
				String hexData2Stripped = hexData2.substring(formatMode.getSubstringBeginIndex());
				return charDataStripped + Constants.LINE_SEPARATOR + hexData1Stripped + Constants.LINE_SEPARATOR + hexData2Stripped;
            }
		} else {
			if(hexData1 == null) {
				// 20140908 carel06
				// removed "substringEndIndex - 1" since the variable substringEndIndex
				// is no longer 1 based.
				return value.substring(formatMode.getSubstringBeginIndex(), formatMode.getSubstringEndIndex());			
			} else {
                // 20141006 carel06
				// we need to account for updating the hexdata portion as well.
				String charDataStripped = charData.substring(formatMode.getSubstringBeginIndex(), formatMode.getSubstringEndIndex());
				String hexData1Stripped = hexData1.substring(formatMode.getSubstringBeginIndex(), formatMode.getSubstringEndIndex());
				String hexData2Stripped = hexData2.substring(formatMode.getSubstringBeginIndex(), formatMode.getSubstringEndIndex());
				return charDataStripped + Constants.LINE_SEPARATOR + hexData1Stripped + Constants.LINE_SEPARATOR + hexData2Stripped;
			}
		}
	}
    
	@Override
	protected void setValue(Object element, Object value) {
        // do nothing at setValue()
		// Update the records only after a mainframe response
	}

	@Override
	public CellEditor getCellEditor(Object element) {

        String charData = null;
        String hexData1 = null;
        String hexData2 = null;
        
		// carel06 2014/10/15
		// we should be working with it's simplest form.
		// instead of working with both the SegmentType and SegmentFieldType
		// I think we can just work with the segmentFieldType
        if(element instanceof IMSSegment) {
        	// it seems we are working in char mode
        	// let's get the segmentFieldType from the segmentType
            segmentType = ((IMSSegment)element).segmentType;
        	segmentFieldType = segmentType.getSegmentFields().getSegmentField().get(0);
        } else if(element instanceof SegmentFieldType) {
            // we are in SingleRecordFormatMode
        	segmentFieldType = (SegmentFieldType) element;
        } else {
            // unrecognized type, just return
        	log.warning("unrecognized type");
        	return null;
        }
		
        //Allow to put the cursor
      /*  if(YorNType.Y == segmentFieldType.getKeyPart()) {
            // carel06 - 2014/10/15
        	// don't return the cell editor because  this is the key section of the field
        	return null;
        }*/
        
		//@parra12: Moved the initialization here because it was causing 
		//single click edit to not work.
		if(textCellEditor==null){
			textCellEditor = new TextCellEditor(tableViewer.getTable(), SWT.WRAP);
		}
		// @polra04: #3090, #3101, #3112 - store substring indices for current cell editor
        // 2014/09/08 carel06
		// subStringBeginIndex and subStringEndIndex is 0 based
		numberOfCharactersThatWeCanDisplay = formatMode.getSubstringEndIndex() - formatMode.getSubstringBeginIndex();
        
        charData = segmentFieldType.getCharData();
        hexData1 = segmentFieldType.getHexData1();
        hexData2 = segmentFieldType.getHexData2();
        
		//@parra12: added the following to ensure we use max if max < numberOfCharactersThatWeCanDisplay
        int maxLengthP = segmentFieldType.getMaxLengthP().intValue();
        
		if(fileMasterPlusKeyListener == null) {
            log.info("creating new instance of FileMasterPlusKeyListener");
			fileMasterPlusKeyListener = new FileMasterPlusKeyListener(editorView, formatMode, textCellEditor, charData, hexData1, hexData2,segmentFieldType);
		}
	
		final Text text = (Text) textCellEditor.getControl();
		text.setFont(tableViewer.getTable().getFont());
		
		Menu cellMenu = formatMode.getMenuManager().createContextMenu(text);
		text.setMenu(cellMenu);
		
		// add mouseUp listener for cursor
		Listener[] mouseUpListener = text.getListeners(SWT.MouseUp);
		if(mouseUpListener.length == 1) {
			text.addListener(SWT.MouseUp, new Listener(){	
			@Override
			public void handleEvent(Event arg0) {
				setCursor(text);				
			}});;
		}
        
		// carel06 20140904
		// TODO need to figure out what to do with the 3rd parameter which isLastRecord
		// We want only one Traverse Listener
		TraverseListenerTable traverseListenerTable = new TraverseListenerTable(textCellEditor, tableViewer, formatMode);
		Listener[] traverseListener = text.getListeners(SWT.Traverse);
		if(traverseListener.length == 1) {
			 text.addTraverseListener(traverseListenerTable);
			 setTraverseTable(traverseListenerTable);
		}
		
        if (editorView.getEditMode() == EditModeType.B | YorNType.Y == segmentFieldType.getKeyPart()) {
        	if(formatMode instanceof CharFormatMode) {
        		((CharFormatMode)formatMode).getEditingSupportFileMasterIMS().getTraverseTable().setkeyTraversed(false);
        	} else {
        		((SingleRecordFormatMode)formatMode).getEditingSupportFileMasterIMS().getTraverseTable().setkeyTraversed(false);				
        	}
        }

        // 2014/09/08 carel06
        // don't want more than one KeyListener handling the many edits
        // we just want 1 instance of fileMasterPlusKeyListener
		Listener[] keyListener = text.getListeners(SWT.KeyDown);
		if(keyListener.length == 1) {
			assignKeyListenerToText(text);
		}
        
        setTextLimit(hexData1, maxLengthP, text);
        
		// 2014/09/08 carel06
		// don't want more than one FocusListener handing the many focus events
		Listener[] listener = text.getListeners(SWT.FocusOut);
		if(listener.length == 1 ) { //defect 2892 - This is a condition we use to make sure only one focus listener is added to the cell
			log.info("adding focus listener");
			text.addFocusListener(this);
		}
		text.setFocus();
		// update fileMasterPlusKeyListener based on the new element
		fileMasterPlusKeyListener.setMaxLengthP(maxLengthP);
		fileMasterPlusKeyListener.setProtectedValues(getProtectedValues(segmentType, segmentFieldType.getProtectedList()));
		fileMasterPlusKeyListener.setKeyValues(getKeyValues(segmentType));
		fileMasterPlusKeyListener.setSegmentFieldType(segmentFieldType);
        fileMasterPlusKeyListener.setCharData(charData);
        fileMasterPlusKeyListener.setHexData1(hexData1);
        fileMasterPlusKeyListener.setHexData2(hexData2);
		return textCellEditor;
	}

	protected  void assignKeyListenerToText(Text text) {
		text.addKeyListener(fileMasterPlusKeyListener);
	}
	
	protected FileMasterPlusKeyListener getKeyListener() {
		return fileMasterPlusKeyListener;
	}

	protected void setTextLimit(String hexData1, int maxLengthP, final Text text) {
		// 2014/09/08 carel06
		// before we were substracting 1 from the numberOfCharactersThatWeCanDisplay variable
		// we dont' need to do this anymore since we are standardizing everything to be 0 based.
        int textLimit = maxLengthP < numberOfCharactersThatWeCanDisplay ? maxLengthP  : numberOfCharactersThatWeCanDisplay;
        if(hexData1 != null) {
            // need to update the text limit if we are displaying the hex values as well.
        	textLimit = textLimit + Constants.LINE_SEPARATOR.length() + textLimit + Constants.LINE_SEPARATOR.length() + textLimit;
        }
        
        text.setTextLimit(textLimit);
	}

	
	/*
	 * carel06 - 2014/10/17
	 * had to add a new method called getKeyValues
	 * since the keys have different behavior from the protected data
	 */
	private ArrayList<Integer> getKeyValues(SegmentType segmentType) {
		ArrayList<Integer> protectedValues = new ArrayList<Integer>();
		
		// TODO: refactor this - editingSupportFileMasterIMS class is already doing this
		// the only reason why I couldn't do it was because TextTraverseListener was using
		// the method found in editingSupportFileMasterIMS and I wasn't sure if it was expecting
		// base 0.
		if(segmentType != null) {
			KeyInfoType keyInfo = segmentType.getKeyInfo();
			if(keyInfo != null) {
				int keyStart = new Long(keyInfo.getStart() - 1).intValue(); // need to substract one since that key start position is not zero based.
				int keyLength = new Long(keyInfo.getLength()).intValue();
				String keyProtect = keyInfo.getProtect().toString();
				if(keyProtect.equalsIgnoreCase("Y")) {
					for(int i=keyStart; i < keyStart+keyLength; i++) {
						protectedValues.add(i);
					}
				}        	
			}
		}
        
        // make sure it is sorted
        Collections.sort(protectedValues);
        return protectedValues;
	}
	
	private ArrayList<Integer> getProtectedValues(SegmentType segmentType, RangeListType rangeListType) {
		ArrayList<Integer> protectedValues = new ArrayList<Integer>();
        
		// TODO: refactor this - editingSupportFileMasterIMS class is already doing this
		// the only reason why I couldn't do it was because TextTraverseListener was using
		// the method found in editingSupportFileMasterIMS and I wasn't sure if it was expecting
		// base 0.
		if(rangeListType != null) {
			ArrayList<RangeType> ranges = (ArrayList<RangeType>) rangeListType.getRange();
	        for(RangeType range: ranges) {
	            // the range values are 1 based
	        	// and the text caret position is 0 based.
	        	// need to subtract 1 so that they are compatible with
	        	// each other.
	        	int start = new Long(range.getStart() - 1).intValue();
	        	int end = new Long(range.getEnd() - 1).intValue();
                for(int i = start; i <= end; i++) {
                    protectedValues.add(i);
	        	}        	
	        }
		}
        
		// TODO: refactor this - editingSupportFileMasterIMS class is already doing this
		// the only reason why I couldn't do it was because TextTraverseListener was using
		// the method found in editingSupportFileMasterIMS and I wasn't sure if it was expecting
		// base 0.
		if(segmentType != null) {
			KeyInfoType keyInfo = segmentType.getKeyInfo();
			if(keyInfo != null) {
				int keyStart = new Long(keyInfo.getStart() - 1).intValue(); // need to substract one since that key start position is not zero based.
				int keyLength = new Long(keyInfo.getLength()).intValue();
				String keyProtect = keyInfo.getProtect().toString();
				if(keyProtect.equalsIgnoreCase("Y")) {
					for(int i=keyStart; i < keyStart+keyLength; i++) {
						protectedValues.add(i);
					}
				}        	
			}
		}
        
        // make sure it is sorted
        Collections.sort(protectedValues);
        return protectedValues;
	}

	/**
     * 2014/09/08 carel06
     * - removing "element" parameter in the method arguments since it is 
     *   not being used.
     *   
	 * @author parra12
	 * Create and send the a send update request based on the segmentType.
	 * 
	 * @parm element old element that contains the segment information
	 * @parm segmentType the modified segment to send for update.
	 * 
	 * @return true if there are no errors else false
	 *
	 */
	protected synchronized boolean sendSegmentUpdateRequest(XMLDocument xmlDocument) {
//		IWorkbench wb = PlatformUI.getWorkbench();
//		IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
//		IWorkbenchPage page = win.getActivePage();
//		IWorkbenchPart workbenchPart = page.getActivePart();
//		EditorView view = ((EditorView) page.getActivePart());
//		if(workbenchPart==null)
//			return false;
//		if (!(workbenchPart instanceof EditorView)) { 
//			log.log(Level.INFO, "workbenchPart is not instanceof EditorView.  Unable to send request");
//			return false;
//
//		}
//		// use the active editor when searching for a term.
//		FileMasterServer server = view.getServer();
		//@polra04: we have a reference to the active editor stored in this class
		FileMasterServer server = editorView.getServer();
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req=new SendRequestToMainframe(server, map, "opendb", true, xmlDocument);
		if(req.getResult()==Status.CANCEL_STATUS){
			return false;
		}
		MFRequestType request;
		response = req.getGuiResponseType();
		if(response==null) {
			request = req.getMFRequestType();
			if(request == null)
				return false;
			if (request.getEditODOChange()!=null) { // ODO value change occured and we need to make sure the change is valid.
				/* Show ODO change confirmation dialog */
					String message = "";
					for(MessageType m : request.getMessages().getMessage()){
						for(String msg : m.getMessageText()){
							message = message + msg + "\n";
						}
						
					}
					XMLDocument xmlDocumentMFResponse = null;
					if(request.getEditODOChange().getCancelOnly() == YorNType.Y){
						MessageDialog.openError(tableViewer.getControl().getShell(), "Edit Length Modification",message);
						try {
							xmlDocumentMFResponse = new XMLDocument(new EditODOChangeResponse(editorView.getServer(),ODOResponseType.C).createXml());
						} catch (TTException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
					else{
					boolean ODOChangeConfirm = MessageDialog.openConfirm(tableViewer.getControl().getShell(), "Edit Length Modification", message);
					
						try {
							xmlDocumentMFResponse = new XMLDocument(new EditODOChangeResponse(editorView.getServer(),ODOChangeConfirm ? ODOResponseType.G : ODOResponseType.C).createXml());
						} catch (TTException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
					req=new SendRequestToMainframe(server, map, "opendb", true, xmlDocumentMFResponse);
					if(req.getResult()==Status.CANCEL_STATUS){
						return false;
					}
					response = req.getGuiResponseType();
					if(response==null) {
						return false;
					}
					((SingleRecordFormatMode)formatMode).updateDisplay(response);
					return true;
			}
		}
		
		
		SegmentFieldsType segmentFields = response.getEditResponse().getSegmentList().getSegment().get(0).getSegmentFields();
		
		// defaults to 0 since we assume we are in CharFormatMode
		int segmentFieldIndex = 0;
		if(formatMode instanceof SingleRecordFormatMode) {
			segmentFieldIndex = tableViewer.getTable().getSelectionIndex();
		}
		String charData = segmentFields.getSegmentField().get(segmentFieldIndex).getCharData();
		String hexData1 = segmentFields.getSegmentField().get(segmentFieldIndex).getHexData1();
		String hexData2 = segmentFields.getSegmentField().get(segmentFieldIndex).getHexData2();

		handleReturnCode(response, charData, hexData1, hexData2);		
		setSegmentUpdateRequest(response);
		
		updateTableItems(charData, hexData1, hexData2);
		
		// carel06 - 2014-10-23
		// duplicate code, we are already making it dirty in other part of the code.
		// editorView.setDirty();
        
		((StatusLineContributionItem) ((IViewSite) editorView.getViewSite()).getActionBars().getStatusLineManager().find("messages")).setText(" ");
		editorView.refreshCommitAndRollbackCommandAvailability();
		return true;
	}

	/**
	 * carel06 - Defect 3182
	 * Update the table items for the different modes.
	 * In CharFormatMode, we only update one tableItem
	 * In SF mode, we update all the table items provided.
	 */
	protected void updateTableItems(String charData, String hexData1, String hexData2) {
		TableItem item = tableViewer.getTable().getItem(tableViewer.getTable().getSelectionIndex());
		String charDataStripped = charData.length()<formatMode.getSubstringBeginIndex() ? "" : charData.substring(formatMode.getSubstringBeginIndex(),charData.length()<formatMode.getSubstringEndIndex()?charData.length() : formatMode.getSubstringEndIndex());
        String hexData1Stripped = null;
        String hexData2Stripped = null;
		if(hexData1 != null) {
			hexData1Stripped = hexData1.length()<formatMode.getSubstringBeginIndex() ? "" : hexData1.substring(formatMode.getSubstringBeginIndex(),hexData1.length()<formatMode.getSubstringEndIndex()?hexData1.length() : formatMode.getSubstringEndIndex());
		}
        if(hexData2 != null) {
        	hexData2Stripped = hexData2.length()<formatMode.getSubstringBeginIndex() ? "" : hexData2.substring(formatMode.getSubstringBeginIndex(),hexData2.length()<formatMode.getSubstringEndIndex()?hexData2.length() : formatMode.getSubstringEndIndex());
        }
        
        int columnIndex = 2;
        if(formatMode instanceof SingleRecordFormatMode) {
        	columnIndex = 3;
        }
        
        if(hexData1 == null) {
        	item.setText(columnIndex, charDataStripped);
        } else {
        	item.setText(columnIndex, charDataStripped + Constants.LINE_SEPARATOR + hexData1Stripped + Constants.LINE_SEPARATOR + hexData2Stripped);
        }
		if(item.getData() instanceof IMSSegment){
			IMSSegment seg = ((IMSSegment)item.getData());
			seg.segmentType= response.getEditResponse().getSegmentList().getSegment().get(0);
			item.setData(seg);
			// We don't want to send duplicate UpdateRequest
			// this keeps the charData the same value as the MF response
			// TODO we need to do this for the hex data as well.
			fileMasterPlusKeyListener.setCharData(charData);
			fileMasterPlusKeyListener.setHexData1(hexData1);
			fileMasterPlusKeyListener.setHexData2(hexData2);
		} else{
			// carel06 - 20141023
            // when dealing with SingleRecordFormatMode
			// we assign the field types properly
            SegmentFieldType data = response.getEditResponse().getSegmentList().getSegment().get(0).getSegmentFields().getSegmentField().get(tableViewer.getTable().getSelectionIndex());
            String name = getNameIndented(response.getEditResponse().getSegmentList().getSegment().get(0), tableViewer.getTable().getSelectionIndex());
            item.setText(0, name);
            item.setText(1, String.valueOf(data.getPosition()));
            String formatData = getFormatChar(response.getEditResponse().getSegmentList().getSegment().get(0), tableViewer.getTable().getSelectionIndex());
            item.setText(2, formatData); 
            data.setFormatChar(formatData);
            data.setName(name);
            item.setData(data);
		}
	}

	protected void handleReturnCode(GUIResponseType response, String charData, String hexData1, String hexData2) {
		if(response.getFunctionRC()!=0 || response.getReturnCode() !=0){
			for(int i=0;i<response.getMessages().getMessage().size();i++){
				String shortText = response.getMessages().getMessage().get(i).getShortText();
				String messageID = response.getMessages().getMessage().get(i).getMessageId();
				List<String> messageText = response.getMessages().getMessage().get(i).getMessageText();
				TT_ErrorDialog.openError(null, "Error", messageID+": "+shortText, new Throwable(messageText.get(i)));
			}
			// If we get an error coming back from the mainframe,
			// we revert the users changes to the original value.
            if(hexData1 == null) {
            	((Text)textCellEditor.getControl()).setText(charData);
            } else {
                String value = charData + Constants.LINE_SEPARATOR + hexData1 + Constants.LINE_SEPARATOR + hexData2; 
            	((Text)textCellEditor.getControl()).setText(value);
            }
            // 2014/10/17 carel06
            // why are we returning after getting an error message from MF.
            // we need to update the values return from MF
            // so for now, I'm just commenting it out.
//			return false;
		}
	}	

	@Override
	public void focusGained(FocusEvent arg0) {
		// we need to update the values for subStringBeginIndex and subStringEndIndex
		// in the focusGained method because it is not being updated correctly 
		// inside the FileMasterPlusKeyListener.
		// when we scroll, we don't register the index values properly.
		if(fileMasterPlusKeyListener != null) {
			fileMasterPlusKeyListener.setSubStringBeginIndex(formatMode.getSubstringBeginIndex());
			fileMasterPlusKeyListener.setSubStringEndIndex(formatMode.getSubstringEndIndex());
		}
	}

	
	@Override
	public void focusLost(FocusEvent arg0) {
		//@parra12: Solution to defect 2292. Update request is sent twice beacause focusLost listener is invoked twice.
		//The first time its invoked textCellEditorFileMaster.isActivated() = true the second time it is false. Therefore
		//added the following condition to avoid the scenario.*/
//		if(formatMode.bypassFocusLost){
//			formatMode.bypassFocusLost =false;
//			return;
//		}
		if(fileMasterPlusKeyListener==null){
			return;
		}
        ArrayList<String> updatedResult = fileMasterPlusKeyListener.getUpdateRecordRequest();

        if(updatedResult == null || updatedResult.size() == 0) {
        	response = null; // Set response to null, prevent from the previous run
        	return;
        }

        // TODO this to fix the ordering.
        // there might be only the hexData1 portion that gets updated
        // and this whole updatedResults would be wrong.
        String charData = updatedResult.get(0);
        String hexData1 = null;
        String hexData2 = null;
        if(updatedResult.size() > 1) {
        	hexData1 = updatedResult.get(1);
        	hexData2 = updatedResult.get(2);        	
        }

        if(charData == null && hexData1 == null && hexData2 == null) {
        	// there are no updated values.
        	// no need to send anything
        	return;
        }
        
        if(charData != null) {
        	segmentFieldType.setCharData(charData);
        }
        if(hexData1 != null) {
        	segmentFieldType.setHexData1(hexData1);
        }
        if(hexData2 != null) {
        	segmentFieldType.setHexData2(hexData2);
        }
        if(segmentType != null && editorView.getEditMode() != EditModeType.B) {
            File file = new UpdateSegmentRequestType(editorView.getServer(),segmentType).createXML();
            updateXMLDocumentAndSend(file);
        } else if(segmentFieldType != null && editorView.getEditMode() != EditModeType.B) {
        	File file = new UpdateSegmentFieldTypeRequest(editorView.getServer(),segmentFieldType, editorView.getCurrentSegment().segmentType).createXML();
        	updateXMLDocumentAndSend(file);
        }
		
//		String[] text = textCellEditorFileMaster.toString().split(Constant.LINE_SEPARATOR);
//		updateChanges(element, value)
//		XMLRequest xmlResponse = null;

//		log.log(Level.INFO, "focus has been lost, updating recordfield.");
//		fileMasterRecord = setupFileMasterRecordRequestMessage();
//		if(fileMasterRecord == null) {
//			log.log(Level.INFO, "fileMasterRecord is null, not sending request to mainframe");
//			//navri01: i added deactivate to fix the issue when we place the cursor on a record and then scroll, the data needs to move as well.
//			textCellEditorFileMaster.deactivate();
//			return;
//		}
//		
//		xmlResponse = sendFileMasterRecordFieldUpdateRequestToMainFrame(fileMasterRecord);
//		if(xmlResponse == null) {
//			log.log(Level.WARNING, "xmlResponse is null, will not update view");
//			textCellEditorFileMaster.deactivate();
//			return;
//		}
//		fieldEdited = true;
//		if(this instanceof SRFValueEditingSupport) { //Check if is SF mode being edited
//			updateView(xmlResponse, fieldEdited);;
//		} else {
//			updateView(xmlResponse);
//		}
//		updateView(xmlResponse);
//		charFormatMode.up
	}

	protected void updateXMLDocumentAndSend(File document) {
		try {
            XMLDocument xmlDocument = new XMLDocument(document);
			sendSegmentUpdateRequest(xmlDocument);
		} catch (TTException e) {
			e.printStackTrace();
		}
	}
	
	protected TextCellEditor getTextCellEditor() {
		return textCellEditor;
	}
	
	public void setSegmentUpdateRequest(GUIResponseType response){
		this.response = response;
	}
	
	public GUIResponseType getSegmentUpdateRequest(){
		return response;	
	}

	protected void setCursor(Text text) {		
		if (text != null) {
			int positionInText = text.getCaretPosition(); 
			int positionInRow = positionInText;
			int columnEnd = text.getText().length();
			if (formatMode.getEditorView().getHexToggled()== YorNType.Y & formatMode.getEditorView().getDisplayMode() == DisplayModeType.C) {
				columnEnd = columnEnd / 3;
				}	

			while (positionInRow > columnEnd){
				positionInRow = positionInRow - columnEnd - 1; 
			}
			positionInRow = positionInRow + formatMode.getSubstringBeginIndex();
			CursorType fmiCursor = editorView.getCursor();
			fmiCursor.setCursorPosition(positionInRow);
	        // carel06 - 2014/10/16
			// sometimes segmentType variable is null when in SF mode
			// we can always get the currentSegment using the editorView.currentSegment.segmentType
			// instead.
			fmiCursor.setSegid(editorView.currentSegment.segmentType.getSegid());
//			fmiCursor.setSegid(segmentType.getSegid());
			editorView.setCursor(fmiCursor);
		}
	}

	public void setTraverseTable(TraverseListenerTable traverseListenerTable){
		this.traverseListenerTable = traverseListenerTable;
	}
	
	public TraverseListenerTable getTraverseTable(){
		return traverseListenerTable;
		
	}

	protected String getNameIndented(SegmentType segmentType, int i) {
		int count = segmentType.getSegmentFields().getSegmentField().size();
		String fieldLevelRepresentedAstwoDigitString;
		// Level and Field name indentation calculation 
		TreeSet<String> fieldLevelSet = new TreeSet<String>();
	
		for (int j = 0; j < count; j++){ 
			fieldLevelRepresentedAstwoDigitString = (segmentType.getSegmentFields().getSegmentField().get(j).getLevel() < 10 ? "0" : "") + String.valueOf(segmentType.getSegmentFields().getSegmentField().get(j).getLevel()); 
			fieldLevelSet.add(fieldLevelRepresentedAstwoDigitString);
		}
        
		ArrayList<String> fieldLevels = new ArrayList<String>(fieldLevelSet);
		
		fieldLevelRepresentedAstwoDigitString = (segmentType.getSegmentFields().getSegmentField().get(i).getLevel() < 10 ? "0" : "") + String.valueOf(segmentType.getSegmentFields().getSegmentField().get(i).getLevel());			
		int indentation = fieldLevels.indexOf(fieldLevelRepresentedAstwoDigitString);
		char[] array = new char[indentation * 2];
		Arrays.fill(array, ' ');							
		String result = new String(array) + fieldLevelRepresentedAstwoDigitString + " " +  String.valueOf(segmentType.getSegmentFields().getSegmentField().get(i).getName());
        return result;
	}
	/**
	 * We copied getFormatChar from another class,
	 * since it is very particular on how formatChar string is formatted.
	 * 
	 * @param segmentType
	 * @param segmentFieldTypeIndex
	 * @return
	 */
	protected String getFormatChar(SegmentType segmentType, int segmentFieldTypeIndex) {
		String result = null;
		String fieldFomratForDisplay = segmentType.getSegmentFields().getSegmentField().get(segmentFieldTypeIndex).getFormatChar();
		if (fieldFomratForDisplay == null) {
			fieldFomratForDisplay = "";
		}
		
		// floating point type, response form the mainframe is 1 or 2
		if (fieldFomratForDisplay == "1" || fieldFomratForDisplay == "2") {
			fieldFomratForDisplay = "FP";
		}
		
		// unsigned or signed format type; if signed add 'S' to format 
		if (segmentType.getSegmentFields().getSegmentField().get(segmentFieldTypeIndex).getSigned() == YorNType.Y) {
			fieldFomratForDisplay += "S";
		}
		
		// length of some format types can consist of two parts, integer and fraction
		String fieldFomratMaxLengthDisplay = "";

		if (segmentType.getSegmentFields().getSegmentField().get(segmentFieldTypeIndex).getIntegerLength() == null) {
			fieldFomratMaxLengthDisplay = segmentType.getSegmentFields().getSegmentField().get(segmentFieldTypeIndex).getMaxLengthP().toString();
		} else {
			fieldFomratMaxLengthDisplay = segmentType.getSegmentFields().getSegmentField().get(segmentFieldTypeIndex).getIntegerLength().toString();
			if (segmentType.getSegmentFields().getSegmentField().get(segmentFieldTypeIndex).getFractionLength() != null) {
				fieldFomratMaxLengthDisplay += "." + segmentType.getSegmentFields().getSegmentField().get(segmentFieldTypeIndex).getFractionLength().toString();
			}
		}
		
		// Format column consists at last 7 characters 
		int charFormatLength = fieldFomratForDisplay.length() + fieldFomratMaxLengthDisplay.length();			
		if (charFormatLength <= 7) {
			char[] array = new char[7 - charFormatLength];
			Arrays.fill(array, ' ');
			result = fieldFomratForDisplay + new String(array) + fieldFomratMaxLengthDisplay;
		} else {
            result = fieldFomratForDisplay + " " + fieldFomratMaxLengthDisplay;
		}
        return result;
	}
}
