
/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.editor;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

import com.ca.fmp.ims.model.IMSSegment;
import com.ca.fmp.ims.model.generated.DisplayModeType;
import com.ca.fmp.ims.model.generated.SegmentFieldType;
import com.ca.fmp.ims.model.generated.SegmentInfoType;
import com.ca.fmp.ims.model.generated.SegmentType;
import com.ca.fmp.ims.model.generated.SegmentInfoListType;
import com.ca.fmp.ims.model.generated.YorNType;

public class FormatMode {
	
	protected Slider slider;
	protected TableViewer tableViewer;
	protected Composite parent;
	protected EditorView editorView;
	protected SegmentInfoListType segmentInfo;
	
	protected DisplayModeType ckeyDisplay;
	protected YorNType ckeyHex;

	protected String processingMessageString = "";
	protected int maxSegmentLength;
	protected String columnRangeString = "";
	
	protected long maxFieldLength = -1;
	
	private MenuManager menuManager;
	
	private int intialTableItemHeight = 0;

	
	public FormatMode(Composite parent, EditorView editorView, SegmentInfoListType segmentInfo, int maxSegmentLength){
		this.parent = parent;
		this.editorView = editorView;
		this.segmentInfo = segmentInfo;
		this.maxSegmentLength = maxSegmentLength;
	}

	protected ArrayList<IMSSegment> processInput(List<SegmentType> input, DisplayModeType mode){
		if(editorView.isHexToggled == YorNType.N)
			this.intialTableItemHeight = tableViewer.getTable().getItemHeight(); 
		ArrayList<IMSSegment> output = new ArrayList<IMSSegment>(input.size()+1);
		IMSSegment segment = null;
		SegmentInfoType segInfo;
		
		for(int i = 0; i < input.size(); i++){
			segment = new IMSSegment(input.get(i));
			segInfo = editorView.segmentInfoMap.get(segment.segmentType.getSegNum());
			
			segment.setSegName(segInfo.getSegName());
			segment.setSegLevel(segInfo.getSegLvl());
			segment.setSegParNum(segInfo.getSegParNum());

			output.add(segment);
		}

		if(mode == DisplayModeType.C){
			IMSSegment segmentNext;
			
			for(int i = 0; i < output.size(); i++){
				segment = output.get(i);

				if(i < output.size() - 1){
					segmentNext = output.get(i + 1);	

					if(segmentNext.getSegLevel() > segment.getSegLevel()
							&& segmentNext.getSegParNum() == segment.segmentType.getSegNum()){
						segment.setExpanded(true);
					}
				}

				for (int j = 0; j < segmentInfo.getSegmentInfo().size(); j++){
					if(segment.segmentType.getSegNum() == segmentInfo.getSegmentInfo().get(j).getSegParNum()){
						segment.setParent(true);
						break;
					}
				}
			}
		}
		else if(mode == DisplayModeType.S){
			maxFieldLength = 0;
			
			int charDataLength;
			long fieldLengthP;
			
			for(SegmentFieldType field : segment.segmentType.getSegmentFields().getSegmentField()){
				if(field.getFormatChar() != null){
					charDataLength = field.getCharData().length();
					fieldLengthP = field.getMaxLengthP();
					
					if(charDataLength > maxFieldLength){
						maxFieldLength = charDataLength;
					}
					if(fieldLengthP > maxFieldLength){
						maxFieldLength = fieldLengthP;
					}
				}
			}
		}

		return output;
	}
	
	protected static Image getImage(String fileName) {
		Bundle bundle = Platform.getBundle("com.ca.fmp.ims.view");
		URL url = FileLocator.find(bundle, new Path("icons/" + fileName), null);
		ImageDescriptor image = ImageDescriptor.createFromURL(url);

		return image.createImage();
	} 

	protected int getPixelSizeOfCharacter() {
		int pixelSizeOfCharacter;
		
		Shell shell = new Shell(Display.getDefault());
		Text text = new Text(shell, SWT.NONE);
		text.setFont(JFaceResources.getTextFont());
		GC gc = new GC(text);
		
		pixelSizeOfCharacter = gc.textExtent("W").x;
		gc.dispose();
		text.dispose();
		shell.dispose();
		
		return pixelSizeOfCharacter;
	}

	// This method includes partially displayed segment if present. 
	public int getVisibleItemCount(Table table){
		Rectangle rect = table.getClientArea ();
		int itemHeight = table.getItemHeight ();
		//@parra12: The following code was added to get correct item height when switching to hex mode.
		if(editorView.isHexToggled == YorNType.Y){
			if(itemHeight<= intialTableItemHeight)
				itemHeight = (int) (itemHeight*2.5);
		}
		int headerHeight = table.getHeaderHeight ();
		int returnValue = (rect.height - headerHeight + itemHeight - 1) / itemHeight;
		return (returnValue > -1)? returnValue : 0;
	}
	
	// This method does not include partially displayed segment if present. 
	public int getFullyVisibleItemCount(Table table){
		Rectangle rect = table.getClientArea ();
		int itemHeight = table.getItemHeight ();
		int headerHeight = table.getHeaderHeight ();
		int returnValue = (rect.height - headerHeight - 1) / itemHeight;
		return (returnValue > -1)? returnValue : 0;
	}
	
	public int getSubstringBeginIndex() {
		return slider.getSelection();
	}
	
	/**
	 * 2014/09/11 carel06
     * - I got confused when the gui was only displaying two characters.
     *   In the status bar the column range was listed as 1-2.
     *   When I inspect the subStringEndIndex for this condition, it was 2 as 
     *   well.  It seemed odd to me at first that the columne range end value
     *   was 2 and the substringEndIndex was also 2.
     *   The reason why they are the same is that the cursor position of the 
     *   last character is at the right hand side of that character.
     *   
	 * @return index value for the last viewable character in the text widget
	 *         the return value is 0 based
	 */
	public int getSubstringEndIndex() {
		return getSubstringEndIndex(2);
	}
	
	public int getSubstringEndIndex(int columnIndex) {
		int dataColumnWidth = tableViewer.getTable().getColumn(columnIndex).getWidth();
		int pixelSizeOfCharacter = getPixelSizeOfCharacter();
        // need to subtract 1 so that it is zero based.
		int returnValue = (dataColumnWidth / pixelSizeOfCharacter) + getSubstringBeginIndex() - 1;
        // this is just an edge case that we don't want to encounter
        // just want to make sure we don't return a negative value
        if(returnValue < 0) {
        	returnValue = 0;
        }
        return returnValue;
	}
	
	public void loadCurrentSegmentsWithCKEYInfo(DisplayModeType ckeyDisplay, YorNType ckeyHex){}

	public EditorView getEditorView() {
		return editorView;
	}
	
	protected void setMenuManager(MenuManager popupMenuMgr) {
		this.menuManager = popupMenuMgr;
	}

	protected MenuManager getMenuManager() {
		return menuManager;
	}
	
	public void setCKeyDisplay(DisplayModeType ckeyDisplay){
		this.ckeyDisplay = ckeyDisplay;
	}
	
	public void setCKeyHex(YorNType ckeyHex){
		this.ckeyHex = ckeyHex;
	}
	
	public long getmaxSegmentLength(){
		return maxSegmentLength;
	}
	
	public TableViewer getTableViewer(){
		return tableViewer;
	}
	
	public SegmentInfoListType getSegmentInfo(){
		return segmentInfo;
	}
}
