/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.handlers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

import com.ca.fmp.ims.model.CommitRequest;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.YorNType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.editor.EditorView;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;

public class CommitRequestHandler extends AbstractHandler implements
		IElementUpdater {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		boolean result = MessageDialog.openQuestion(null, "Save",
				"Are you sure you want to save the data?");

		if (!result) {
			return false;
		}
		// TODO Auto-generated method stub
		else {
			XMLDocument xmlDocument = null;
			GUIResponseType response;
			IWorkbench wb = PlatformUI.getWorkbench();
			IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
			IWorkbenchPage page = win.getActivePage();
			IWorkbenchPart workbenchPart = page.getActivePart();
			if (!(page.getActivePart() instanceof EditorView)) {
				return false;
			} else {
				EditorView editorView = ((EditorView) page.getActivePart());
				editorView.setFocus();
				try {
					xmlDocument = new XMLDocument(
							new CommitRequest(editorView.getServer(),
									((IViewSite) editorView.getSite())
											.getSecondaryId(), YorNType.N)
									.createXml());
				} catch (TTException e1) {
					e1.printStackTrace();
				}
				final HashMap<String, Object> map = new HashMap<String, Object>();
				SendRequestToMainframe req = new SendRequestToMainframe(
						editorView.getServer(), map, "opendb", true,
						xmlDocument);
				if (req.getResult() == Status.CANCEL_STATUS) {
					return false;
				} else {
					response = req.getGuiResponseType();
					if (response == null)
						return false;
					if (response.getFunctionRC() != 0
							|| response.getReturnCode() != 0) {
						for (int i = 0; i < response.getMessages().getMessage()
								.size(); i++) {
							String shortText = response.getMessages()
									.getMessage().get(i).getShortText();
							String messageID = response.getMessages()
									.getMessage().get(i).getMessageId();
							List<String> messageText = response.getMessages()
									.getMessage().get(i).getMessageText();
							TT_ErrorDialog.openError(null, "Error", messageID
									+ ": " + shortText, new Throwable(
									messageText.get(i)));
						}
					}
				}
				return true;
			}
		}
	}

	@Override
	public void updateElement(UIElement element, Map parameters) {
		// TODO Auto-generated method stub

	}
}
