/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

/**
 * @author mahma04
 *
 */

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.common.FileMasterMember;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.VPATSortDialog;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.LoadLibMemberInfoListType;
import com.ca.fmp.ims.model.generated.LoadLibMemberInfoType;
import com.ca.fmp.ims.view.wizards.AModeLabelProvider;
import com.ca.fmp.ims.view.wizards.AccessMethodLabelProvider;
import com.ca.fmp.ims.view.wizards.CreatedLabelProvider;
import com.ca.fmp.ims.view.wizards.DsNameforMemberDialogLabelProvider;
import com.ca.fmp.ims.view.wizards.MemberNameLabelProvider;
import com.ca.fmp.ims.view.wizards.RModeLabelProvider;
import com.ca.fmp.ims.view.wizards.SizeLabelProvider;
import com.ca.fmp.ims.view.wizards.TTRLabelProvider;
import com.ca.testingtools.ui.TextUtil;

public class MemberWizardPage extends WizardPage implements SelectionListener {
	private static final int MEMBERNAME = 0;
	private static final int DATASETNAME = 1;
	private static final int ACCESSMETHOD = 2;
	public static final int CREATED = 3;
	public static final int SIZE = 4;
	public static final int RMODE = 5;
	public static final int AMODE = 6;
	public static final int TTR = 7;
	public static Button okMemberButton;
	private Text numberOfMember;
	private ArrayList<FileMasterMember> listofMembers;

	private HashMap<String, String> map = null;
	private boolean isGrayRowSelected = false;

	static TableViewer viewer;

	private String dbdName;
	private String memberLabel;
	private GUIResponseType response;
	private String CONTEXT_HELP_ID;
	private int pixelSizeOfCharacter = -1;
	private Shell shell;
	private Text text;
	private GC gc;
	private Listener sortListener;  
	private Listener sortListenerVPAT;  //grake02 26/OCT/2016

	public MemberWizardPage(String title, String memberLabel, GUIResponseType response,
			FileMasterServer server, String dbdName, String CONTEXT_HELP_ID) {

		super("XXX");
		setTitle(title);
		this.response = response;
		this.dbdName = dbdName;
		this.memberLabel=memberLabel;		
		this.CONTEXT_HELP_ID = CONTEXT_HELP_ID;
	}

	@Override
	public void createControl(Composite parent) {

		Composite container = new Composite(parent, SWT.NONE);
		GridLayout container_layout = new GridLayout(1, false);
		container.setLayout(container_layout);
		Composite select_Member_composite = new Composite(container, SWT.NULL);
		select_Member_composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL,
				true, true, 1, 1));
		select_Member_composite.setLayout(new GridLayout(2, false));

		// membername on the top of the table
		Label memberName = new Label(select_Member_composite, SWT.None);
		memberName.setText(memberLabel);

		Text displayMembername = new Text(select_Member_composite,
				SWT.READ_ONLY);
		displayMembername.setText(dbdName);
		// makes space between member name and table
		new Label(select_Member_composite, SWT.NONE);
		new Label(select_Member_composite, SWT.NONE);

		// Create a table view
		createViewer(select_Member_composite);
		// Create a Text area to see number of the Members

		numberOfMember = new Text(select_Member_composite, SWT.READ_ONLY);
		numberOfMember.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true,
				false, 1, 1));
		TextUtil.setWidth(numberOfMember, 14);

		doSelect();

		setControl(container);

		getShell().getDefaultButton().setText("OK");
		okMemberButton = new Button(parent, SWT.NONE);
		okMemberButton.setVisible(false); //remove tab stop

		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, CONTEXT_HELP_ID);

		Point size = getShell().computeSize(SWT.DEFAULT, SWT.DEFAULT);
		getShell().setSize(size);
	}

	private void createViewer(Composite parent) {
		viewer = new TableViewer(parent, SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE | SWT.FULL_SELECTION | SWT.BORDER);
		
		viewer.getTable().setLinesVisible(true);
		viewer.getTable().setHeaderVisible(true);
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gd_table.heightHint = 300;
		viewer.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				setPageComplete(isPageComplete());

			}
		});
		viewer.getTable().setLayoutData(gd_table);
		setupColumnListener();
		createColumns(parent, viewer);

		viewer.setContentProvider(new ArrayContentProvider());

		new Label(parent, SWT.NONE);
		
		setupVPATColumnSorter();
		
	}

	
	
	
	/*Mahma04
	 * we can not have a Sort in this tabel because of the gray out each row which is happeing on DBDwilldcard story
	 * 
	 */
	/*private void setupColumnListener() {
		sortListener = new Listener() {

			public void handleEvent(final Event event) {
				final TableColumn column = (TableColumn) event.widget;
				final Table table = viewer.getTable();
				if (column.equals(table.getSortColumn())) {
					final int direction = table.getSortDirection();
					switch (direction) {
					case SWT.DOWN:
						table.setSortDirection(SWT.UP);
						break;
					case SWT.None:
					case SWT.UP:
					default:
						table.setSortDirection(SWT.DOWN);
						break;
					}
				} else {
					table.setSortColumn(column);
					table.setSortDirection(SWT.UP);
				}
				viewer.refresh();
			}
		};

	}
*/
	private void doSelect() {
		listofMembers = new ArrayList<FileMasterMember>();
		map = new HashMap<String, String>();

		listofMembers = new ArrayList<FileMasterMember>();

		if (response != null) {
			LoadLibMemberInfoListType memberRespond;
			
			if (response.getWildCardMemberResponse().getDBDLIBInfoList()!=null){
				memberRespond = response.getWildCardMemberResponse().getDBDLIBInfoList();
			}
			else if(response.getWildCardMemberResponse().getPSBLIBInfoList()!=null){
				memberRespond = response.getWildCardMemberResponse().getPSBLIBInfoList();
			}
			else{
				return;
			}
							
			List<LoadLibMemberInfoType> loadmemberLib = memberRespond
					.getLoadLibMemberInfo();
			int numOfMembers = memberRespond.getLoadLibMemberInfo().size();

			for (LoadLibMemberInfoType m : loadmemberLib) {
				FileMasterMember fileMasterMember = new FileMasterMember();
				fileMasterMember.setName(m.getName());
				fileMasterMember.setDSNname(m.getDsname());
				fileMasterMember.setSize(m.getSize());
				fileMasterMember.setTtr(m.getTtr());
				fileMasterMember.setAmode(m.getAMode());
				fileMasterMember.setRmode(m.getRMode());
				fileMasterMember.setAccessMethod(m.getAccessMethod());
				fileMasterMember.setCreated(m.getCreationDate().toString());
				fileMasterMember.setSelectable(m.getSelectable().toString());
				listofMembers.add(fileMasterMember);

			}
			viewer.getTable().removeAll();

			viewer.setInput(listofMembers
					.toArray(new FileMasterMember[listofMembers.size()]));
			//int row = 0;

			getShell().getDisplay();
			Color gray = getShell().getDisplay().getSystemColor(SWT.COLOR_GRAY);
			viewer.refresh();
			for (TableItem tableRow : viewer.getTable().getItems()) {
				FileMasterMember memberRow = (FileMasterMember) tableRow.getData();
				if (memberRow.getSelectable().equals("N")) {
					viewer.getTable().getItem(viewer.getTable().indexOf(tableRow)).setForeground(gray);
					map.put(memberRow.getName(), memberRow.getSelectable()
							.toString());

				}
			}
			
			viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			    public void selectionChanged(final SelectionChangedEvent event) {
			        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
			        FileMasterMember memberRow = (FileMasterMember)selection.getFirstElement();
			        if (memberRow.getSelectable().equals("N")) {
			        	
			        	isGrayRowSelected = true;
						

					} else {
						isGrayRowSelected = false;
						
					}
			        setPageComplete(isPageComplete()); 
			    }
			});


			viewer.getTable().setFocus();
			viewer.getTable().setSelection(0);

			viewer.refresh();
			if (numOfMembers == 1) {
				numberOfMember.setText(numOfMembers + " members returned.");
			} else {
				numberOfMember.setText(numOfMembers + " members returned.");
			}

		}
	}

	private void createColumns(Composite parent, TableViewer viewer2) {
		String[] titles = { "Member Name", "Data Set Name", "Access Method",
				"Created", "Size", "RMode", "AMode", "TTR" };
		int[] bounds = { 150, 300, 150, 100, 100, 5*getPixelSizeOfCharacter(), 5*getPixelSizeOfCharacter(), 6*getPixelSizeOfCharacter() };
		Table table = viewer.getTable();

		for (int i = 0; i < titles.length; i++) {
			TableViewerColumn tableColumn = new TableViewerColumn(viewer,
					bounds[i]);
			switch (i) {
			case MEMBERNAME:
				tableColumn.setLabelProvider(new MemberNameLabelProvider());
				break;
			case DATASETNAME:
				tableColumn
						.setLabelProvider(new DsNameforMemberDialogLabelProvider());
				break;
			case ACCESSMETHOD:
				tableColumn.setLabelProvider(new AccessMethodLabelProvider());
				break;
			case CREATED:
				tableColumn.setLabelProvider(new CreatedLabelProvider());
				tableColumn.getColumn().setAlignment(SWT.RIGHT);
				break;
			case SIZE:
				tableColumn.setLabelProvider(new SizeLabelProvider());
				tableColumn.getColumn().setAlignment(SWT.RIGHT);
				break;
			case RMODE:
				tableColumn.setLabelProvider(new RModeLabelProvider());
				tableColumn.getColumn().setAlignment(SWT.RIGHT);
				break;
			case AMODE:
				tableColumn.setLabelProvider(new AModeLabelProvider());
				tableColumn.getColumn().setAlignment(SWT.RIGHT);
				break;
			case TTR:
				tableColumn.setLabelProvider(new TTRLabelProvider());
				tableColumn.getColumn().setAlignment(SWT.RIGHT);

				break;

			}

			tableColumn.getColumn().setText(titles[i]);
			tableColumn.getColumn().setWidth(bounds[i]);
			tableColumn.getColumn().addListener(SWT.Selection, sortListener);
		}

		viewer.setSorter(new MemberWizardPageSorter());
		table.setSortColumn(table.getColumn(0));
		table.setSortDirection(SWT.UP);

	}

	public TableViewer getViewer() {
		return viewer;
	}

	@Override
	public boolean isPageComplete() {
		if (isGrayRowSelected) {
			return false;
		}

		else if (viewer.getTable().getSelectionCount() == 1)
			return true;
		else
			return false;
	}

	public boolean doFinish() {
		okMemberButton.notifyListeners(SWT.Selection, new Event());
		return true;
	}
	

	public static FileMasterMember getSelectedMember() {

		return (FileMasterMember) viewer.getElementAt(viewer.getTable()
				.getSelectionIndex());
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
		// TODO Auto-generated method stub
		
	}
	protected int getPixelSizeOfCharacter() {
		
		if(pixelSizeOfCharacter == -1) {
			if (shell == null)
				// get the pixel size for each character
				shell = new Shell(Display.getDefault());
			if (text == null)
				text = new Text(shell, SWT.NONE);
			text.setFont(this.getFont());
			if (gc == null)
				gc = new GC(text);
			pixelSizeOfCharacter = gc.textExtent("W").x;
		}
		return pixelSizeOfCharacter;
	}
	
	private void setupColumnListener() {
		sortListener = new Listener(){


			public void handleEvent(final Event event) {			
				final TableColumn column =  (TableColumn)event.widget;
				final Table table = viewer.getTable();
				if (column.equals(table.getSortColumn())){
					final int direction = table.getSortDirection();
					switch (direction){
					case SWT.DOWN:
						table.setSortDirection(SWT.UP);
						break;
					case SWT.None:
					case SWT.UP:
					default:
						table.setSortDirection(SWT.DOWN);
						break;
					}
				} else {
					table.setSortColumn(column);
					table.setSortDirection(SWT.UP);
				}
				getShell().getDisplay();
				Color gray = getShell().getDisplay().getSystemColor(SWT.COLOR_GRAY);
				for (TableItem tableRow : viewer.getTable().getItems()) {
						viewer.getTable().getItem(viewer.getTable().indexOf(tableRow)).setForeground(null);
					}
				
				
				viewer.refresh();
				for (TableItem tableRow : viewer.getTable().getItems()) {
					FileMasterMember memberRow = (FileMasterMember) tableRow.getData();
					if (memberRow.getSelectable().equals("N")) {
						viewer.getTable().getItem(viewer.getTable().indexOf(tableRow)).setForeground(gray);
						map.put(memberRow.getName(), memberRow.getSelectable()
								.toString());

					}
				}
			}
		};
		
	}
	
	//grake02 26/OCT/2016 - create filter filter for 508 compliant problem.
	private void setupVPATColumnSorter()
	{
        //grake02 26/OCT/2016 - invoke sort dialog so that application is 508 compliant
		sortListenerVPAT = new Listener() 
        {
        	public void handleEvent(Event event) 
        	{
	            if (event.keyCode == SWT.F12)
	            {
	            	VPATSortDialog VPATdialog = new VPATSortDialog(getShell(), viewer);
	            	VPATdialog.create();
	            	if (VPATdialog.open() == Window.OK)
	            	{
	            		viewer.refresh();
	            	}
	            }
	        }
	    };
	    
	    getShell().getDisplay().addFilter(SWT.KeyDown, sortListenerVPAT);      				
	}
	
	public void dispose()
	{
		getShell().getDisplay().removeFilter(SWT.KeyDown, sortListenerVPAT);  //grake02 26/OCT/2016
		super.dispose();
	}

}
