/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

/**
 * @author depil01
 *
 */
import org.eclipse.jface.dialogs.TrayDialog;

import com.ca.fmp.ims.view.wizardpages.CRLClass.LayoutField;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.view.wizardpages.GenericFieldNameWizard;

public class SelFieldNameWizard extends GenericFieldNameWizard {
	protected SelUpdateLayoutPage page;
	protected boolean isSelectionPage;
	private FileMasterServer server;
	private LayoutField selectedLayoutField;
	
	public SelFieldNameWizard(String datasetName, String memberName,boolean isSelectionPage, FileMasterServer server,
			                  LayoutField selectedLayoutField) {
		super(datasetName,memberName);
		this.isSelectionPage = isSelectionPage;
		this.server = server;
		this.selectedLayoutField = selectedLayoutField;
		selectedLayoutField=null;
		setWindowTitle("Selection Criteria - Fields");
	}	
	
	@Override
	public void addPages() {
		setForcePreviousAndNextButtons(true);
		TrayDialog.setDialogHelpAvailable(true);
		
		setForcePreviousAndNextButtons(false);
		needsPreviousAndNextButtons();
		if (selectedLayoutField==null)
			page = new SelUpdateLayoutPage("Select Field Name", datasetName,
										   memberName, memberName, server);
		else
			page = new SelUpdateLayoutPage("Select Field Name", datasetName,
					   memberName, memberName, server, selectedLayoutField);				
		addPage(page);
	}

	@Override
	public boolean canFinish() {
		return page.isPageComplete();
	}

	@Override
	public boolean performFinish() {
		page.doGetFieldName(isSelectionPage);
		return true;
	}
}