/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizards;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.view.wizardpages.DatasetWizardPage;
import com.ca.testingtools.common.XMLRequest;

public class DatasetWizard extends Wizard implements INewWizard {
	static String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$
	private DatasetWizardPage page;
	private FileMasterServer server;
	private GUIResponseType response;
	private String dataSetName;
	private String volume;

	public DatasetWizard(GUIResponseType response, FileMasterServer server) {
		this.response = response;
		this.server = server;
		setWindowTitle("Data Set Select");
	}

	public DatasetWizard(String dataSetName, String volume,
			FileMasterServer server) {
			this.dataSetName = dataSetName;
			this.volume = volume;
			this.server = server;
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean performFinish() {
		return page.doFinish();
	}

	@Override
	public boolean canFinish() {
		// TODO Auto-generated method stub
		return page.isPageComplete();
	}

	public void addPages() {
		TrayDialog.setDialogHelpAvailable(true);

		page = new DatasetWizardPage(response, server);

		addPage(page);
	}
}
