/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.common.Attribute;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.core.Label;
import com.ca.testingtools.core.Variable;
import java.util.Properties;
import org.w3c.dom.Element;

public class PLIVariable
extends Variable {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final char ZERO_CHAR = '\u0000';
    private PLIVariable base = null;
    private boolean based = false;
    private long handle = 0L;
    private Label parentProc;

    public PLIVariable(Element element) throws TTException {
        super(element);
        this.initBasedInfo();
    }

    private void initBasedInfo() {
        long low = ((Integer)Attribute.getValue((String)"gt_dmaps", (Properties)this.attributes)).intValue();
        long high = ((Integer)Attribute.getValue((String)"gt_dmapd", (Properties)this.attributes)).intValue();
        this.handle = high << 16;
        this.handle += low;
        this.based = 6 == (Integer)Attribute.getValue((String)"gt_dstyp", (Properties)this.attributes);
    }

    @Override
    public boolean canEditDisplay() {
        if (this.hasChildren()) {
            return false;
        }
        switch (this.storagetype) {
            case BIN: {
                return this.datatype != Variable.DataType.FLOAT;
            }
            case PACK: {
                return this.datatype != Variable.DataType.FLOAT;
            }
            case CHAR: 
            case DISPLAY: 
            case DISPLAY_SIGNED_LEFT: 
            case DISPLAY_SIGNED_SEPARATE: 
            case DISPLAY_SIGNED_SEPARATE_LEFT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canEditHex() {
        return true;
    }

    @Override
    public String getValue() {
        this.getBackingdata();
        if (this.hasChildren()) {
            return "(Group Level)";
        }
        if (!this.canEditDisplay()) {
            return "(Not Displayable)";
        }
        if (this.backingdata == null) {
            return "";
        }
        return this.getValue(this.getData());
    }

    @Override
    protected void setDatatype() {
        boolean isFloat = false;
        int pvdes = (Integer)Attribute.getValue((String)"gt_pvdes", (Properties)this.attributes);
        if ((pvdes & 2) != 0) {
            isFloat = true;
        }
        int sign = (Integer)Attribute.getValue((String)"gt_sign", (Properties)this.attributes);
        Variable.DataType numeric = (sign &= 8) == 0 ? Variable.DataType.UNSIGNED : Variable.DataType.SIGNED;
        int pvdtp = (Integer)Attribute.getValue((String)"gt_pvdtp", (Properties)this.attributes);
        switch (pvdtp) {
            case 4: {
                this.datatype = isFloat ? Variable.DataType.FLOAT : numeric;
                this.storagetype = Variable.StorageType.BIN;
                break;
            }
            case 8: {
                this.datatype = isFloat ? Variable.DataType.FLOAT : numeric;
                this.storagetype = Variable.StorageType.PACK;
                break;
            }
            case 16: {
                this.datatype = Variable.DataType.ALPHA;
                this.storagetype = Variable.StorageType.CHAR;
                break;
            }
            case 64: 
            case 80: {
                this.datatype = Variable.DataType.ALPHA;
                this.storagetype = Variable.StorageType.CHAR;
                break;
            }
            case 32: {
                this.datatype = Variable.DataType.BIT;
                this.storagetype = Variable.StorageType.HEX;
            }
            default: {
                this.datatype = Variable.DataType.UNKNOWN;
                this.storagetype = Variable.StorageType.HEX;
            }
        }
        int ix = 0;
        while (ix < 7) {
            String key = String.format("pl1arlb%d", ix + 1);
            String str = this.getAttribute(key);
            if (str.isEmpty()) break;
            this.index_off[ix] = (Integer)Attribute.getValue((String)key, (Properties)this.attributes);
            String key1 = String.format("gt_dmax%d", ix + 1);
            this.levels[ix] = (Integer)Attribute.getValue((String)key1, (Properties)this.attributes);
            String key2 = String.format("gt_incr%d", ix + 1);
            this.gt_incr[ix] = (Integer)Attribute.getValue((String)key2, (Properties)this.attributes);
            ++ix;
        }
    }

    @Override
    public int getDecimalPoint() {
        int dptyp = (Integer)Attribute.getValue((String)"gt_dptyp", (Properties)this.attributes);
        if (dptyp == 5) {
            return 0;
        }
        int iScale = 0;
        String pic = this.getPicture();
        if (pic.length() > 0) {
            return this.parsePic(pic);
        }
        String scale = this.getAttribute("gt_scale");
        if (scale.length() > 0) {
            iScale = (Integer)Attribute.getValue((String)"gt_scale", (Properties)this.attributes);
        }
        if (iScale > 127) {
            iScale -= 256;
        }
        return iScale;
    }

    public int parsePic(String pic) {
        String sep = "V";
        int ptr = pic.indexOf(sep);
        if (ptr == -1) {
            sep = ".";
            ptr = pic.indexOf(sep);
            sep = "[.]";
        }
        if (ptr > -1) {
            String[] tokens = pic.split(sep);
            ptr = tokens[1].indexOf("(");
            if (ptr > -1) {
                int ptr2 = tokens[1].indexOf(")");
                if (ptr2 > -1 && ptr2 > ptr) {
                    int numberofdigits = Integer.valueOf(tokens[1].substring(ptr + 1, ptr2));
                    return tokens[1].length() + numberofdigits - 3 - ptr2 + ptr + 1;
                }
            } else {
                return tokens[1].length();
            }
        }
        return 0;
    }

    @Override
    public String varyCheck(String value, boolean isTrim) {
        int pvdes;
        String sPvdes;
        String newValue = value;
        Integer pvdtp = (Integer)Attribute.getValue((String)"gt_pvdtp", (Properties)this.attributes);
        if (pvdtp == 16 && (sPvdes = this.getAttribute("gt_pvdes")).length() > 0 && ((pvdes = ((Integer)Attribute.getValue((String)"gt_pvdes", (Properties)this.attributes)).intValue()) & 1) != 0) {
            this.isVarying = true;
            newValue = isTrim ? value.substring(2, value.length()) : this.getVarString(value);
        }
        return newValue;
    }

    public String getVarString(String value) {
        int i;
        AbstractStringBuilder sb;
        byte[] sBytes = null;
        byte[] bytes2 = new byte[4];
        String hexStr = "";
        String hexNum = "";
        int len = value.length();
        int varLth = 0;
        if (len > 0) {
            byte[] bytes = new byte[len];
            sb = new StringBuilder(len);
            i = value.length() - 1;
            while (i > -1) {
                char ch1 = value.charAt(i);
                if (ch1 != '\u0000' && ch1 != ' ' && ch1 != HexUtil.dot && varLth == 0) {
                    varLth = i + 1;
                    i = -1;
                }
                --i;
            }
            ((StringBuilder)sb).append(value.substring(0, varLth));
            hexStr = ((StringBuilder)sb).toString();
            try {
                HexUtil.StringtoBytes((String)hexStr, (byte[])bytes);
                hexStr = HexUtil.toHex((byte[])bytes, (int)0);
            }
            catch (Exception exception) {
                hexStr = "";
            }
        }
        try {
            HexUtil.NumbertoByte((String)String.valueOf(varLth), (byte[])bytes2);
            hexNum = HexUtil.toHex((byte[])bytes2).substring(4, 8);
        }
        catch (Exception exception) {}
        hexStr = String.valueOf(hexNum) + hexStr;
        sBytes = HexUtil.HextoBytes((String)hexStr);
        String str = HexUtil.toString((byte[])sBytes, (boolean)true);
        if ((varLth += 2) > 0 && varLth < (len += 2)) {
            sb = new StringBuffer(len);
            i = 0;
            while (i < len) {
                if (i < varLth) {
                    ((StringBuffer)sb).append(str.substring(i, i + 1));
                } else {
                    ((StringBuffer)sb).append('\u0000');
                }
                ++i;
            }
            str = ((StringBuffer)sb).toString();
        }
        return str;
    }

    @Override
    public String getHexText() {
        return this.getHexValue();
    }

    @Override
    public String getHexTextTooltipText() {
        return this.getHexText();
    }

    @Override
    public String getProperties() {
        String ix;
        String picture = this.getPicture();
        Integer fsiz = (Integer)Attribute.getValue((String)"length", (Properties)this.attributes);
        String sFsize = fsiz > 0 ? String.format("[%d]", fsiz) : "";
        int iPvdes = (Integer)Attribute.getValue((String)"gt_pvdes", (Properties)this.attributes);
        int iPrec = (Integer)Attribute.getValue((String)"gt_prec", (Properties)this.attributes);
        int iScale = (Integer)Attribute.getValue((String)"gt_scale", (Properties)this.attributes);
        if (iScale > 127) {
            iScale -= 256;
        }
        String value = "";
        Integer pvdtp = (Integer)Attribute.getValue((String)"gt_pvdtp", (Properties)this.attributes);
        block0 : switch (pvdtp) {
            case 4: {
                value = "Binary";
                String prefix = "FIXED ";
                if ((iPvdes & 2) != 0) {
                    prefix = "FLOAT ";
                }
                if (iPrec <= 0) break;
                String str = iScale != 0 ? "," + String.valueOf(iScale) : "";
                value = String.valueOf(prefix) + "BIN(" + String.valueOf(iPrec) + str + ")";
                sFsize = "";
                break;
            }
            case 8: {
                value = "Decimal";
                String prefix = "FIXED ";
                String suffix = "";
                if ((iPvdes & 2) != 0) {
                    prefix = "FLOAT ";
                }
                if ((iPvdes & 1) != 0) {
                    suffix = " VARYING";
                }
                if ((iPvdes & 0x10) != 0) {
                    suffix = " VARYINGZ";
                }
                if (iPrec <= 0) break;
                String str = iScale != 0 ? "," + String.valueOf(iScale) : "";
                value = String.valueOf(prefix) + "DEC(" + String.valueOf(iPrec) + str + ")" + suffix;
                sFsize = "";
                break;
            }
            case 16: {
                String string;
                int iFsiz = fsiz;
                String suffix = "";
                if ((iPvdes & 2) != 0) {
                    string = "FLOAT ";
                }
                if ((iPvdes & 1) != 0) {
                    suffix = " VARYING";
                    iFsiz -= 2;
                } else if ((iPvdes & 0x10) != 0) {
                    suffix = " VARYINGZ";
                    --iFsiz;
                }
                value = "CHAR(" + String.valueOf(iFsiz) + ")" + suffix;
                sFsize = "";
                break;
            }
            case 32: {
                value = "Bit";
                int iPvigl = 0;
                int iPvigr = 0;
                String pvigl = this.getAttribute("gt_pvigl");
                String pvigr = this.getAttribute("gt_pvigr");
                if (pvigl.length() <= 0) break;
                iPvigl = Integer.decode(pvigl);
                if (pvigr.length() <= 0) break;
                iPvigr = Integer.decode(pvigr);
                int len = 8 * fsiz - (iPvigl + iPvigr);
                value = "BIT(" + String.valueOf(len) + ")";
                sFsize = "";
                break;
            }
            case 64: 
            case 80: {
                value = "Picture";
                if (picture.length() <= 0) break;
                value = "PIC " + picture;
                sFsize = "";
                break;
            }
            case 0: {
                int iPvltp = (Integer)Attribute.getValue((String)"gt_pvltp", (Properties)this.attributes);
                int itype = iPvltp & 0xFFFFFFFB;
                if (itype <= 0) break;
                switch (itype) {
                    case 1: {
                        value = "LABEL VARIABLE";
                        sFsize = "";
                        break block0;
                    }
                    case 2: {
                        value = "DEFINED";
                        sFsize = "";
                        break block0;
                    }
                    case 16: {
                        value = "POINTER";
                        sFsize = "";
                        break block0;
                    }
                    case 32: {
                        value = "PARAMETER";
                        sFsize = "";
                        break block0;
                    }
                    case 64: {
                        value = "STRUCTURE";
                        sFsize = "";
                        break block0;
                    }
                }
                if ((iPvltp & 4) == 0) break;
                value = "BASED(ADDR VARIABLE";
                sFsize = "";
                break;
            }
            case 128: {
                String string;
                int jFsiz = fsiz;
                String suffix = "";
                if ((iPvdes & 2) != 0) {
                    string = "FLOAT ";
                }
                if ((iPvdes & 1) != 0) {
                    suffix = " VARYING";
                    jFsiz -= 2;
                } else if ((iPvdes & 0x10) != 0) {
                    suffix = " VARYINGZ";
                    jFsiz -= 2;
                }
                value = "GRAPHIC(" + String.valueOf(jFsiz /= 2) + ")" + suffix;
                sFsize = "";
            }
        }
        if (value.length() == 0 && (ix = this.getAttribute("gt_pvltp")).equals("40")) {
            value = "Fixed length group";
        }
        StringBuilder arrayTag = new StringBuilder(this.levels.length * 4 + 10);
        if (this.levels[0] > 0) {
            arrayTag.append("OCCURS (");
            int[] nArray = this.levels;
            int n = this.levels.length;
            int n2 = 0;
            while (n2 < n) {
                int iValue = nArray[n2];
                if (iValue > 0) {
                    arrayTag.append(String.format("%d,", iValue));
                }
                ++n2;
            }
            arrayTag.setCharAt(arrayTag.length() - 1, ')');
        }
        return HexUtil.Squeeze((String)String.format("%s %s %s", value, sFsize, arrayTag.toString()));
    }

    @Override
    public String getPropertiesTooltipText() {
        return this.getProperties();
    }

    @Override
    public String getValueTooltipText() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.getName();
    }

    @Override
    public String getDataRequestName() {
        return this.getName();
    }

    public long getHandle() {
        return this.handle;
    }

    public long getBasehandle() {
        long low = ((Integer)Attribute.getValue((String)"gt_pvbsq", (Properties)this.attributes)).intValue();
        long high = ((Integer)Attribute.getValue((String)"gt_pvbds", (Properties)this.attributes)).intValue();
        long handle = high << 16;
        return handle += low;
    }

    public boolean isBased() {
        return this.based;
    }

    public PLIVariable getBase() {
        return this.base;
    }

    public void setBase(PLIVariable base) {
        this.base = (PLIVariable)(base == null ? null : base.copy());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PLIVariable clone = (PLIVariable)super.clone();
        clone.base = (PLIVariable)(this.base == null ? null : this.base.copy());
        clone.parentProc = (Label)(this.parentProc == null ? null : this.parentProc.copy());
        return clone;
    }

    public Label getParentProc() {
        return this.parentProc;
    }

    public void setParentProc(Label parentProc) {
        this.parentProc = (Label)(parentProc == null ? null : parentProc.copy());
    }
}

