/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.DelayLocationRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import com.ca.mat.views.subpages.CallerIdSubpage;
import com.ca.mat.views.subpages.DelayLocationsSubpage;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class DelayLocationsNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        if (obj instanceof DelayLocationRowModel) {
            DelayLocationRowModel rowModel = (DelayLocationRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.delaylocations.callerid")) {
                DelayLocationsSubpage locationView = (DelayLocationsSubpage)page;
                HashMap<String, Object[]> callerIdArgs = new HashMap<String, Object[]>();
                callerIdArgs.putAll(locationView.getFilterExpressions());
                ArrayList<String[]> callerIdTitles = new ArrayList<String[]>();
                callerIdTitles.addAll(locationView.getTitleExpressions());
                callerIdArgs.put("Module", new Object[]{rowModel.getModule()});
                callerIdArgs.put("Csect", new Object[]{rowModel.getCsect()});
                callerIdArgs.put("Offset", rowModel.getAllCorrespondingOffsets().toArray());
                callerIdTitles.add(new String[]{"Module", rowModel.getModule()});
                callerIdTitles.add(new String[]{"Csect", rowModel.getCsect()});
                callerIdTitles.add(new String[]{"Offset", rowModel.getOffset()});
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                model = model.filterBy(callerIdArgs);
                model = AnalysisUtils.calculateCallerId(model, dsn, type, Display.getCurrent());
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(CallerIdSubpage.class, "", dsn, type, presentation, "com.ca.mat.help.callerid", model);
                String partName = "CallerId:";
                for (String[] entry : callerIdTitles) {
                    partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                }
                detachedView.setPresentationName(partName);
                AnalysisPage newPage = detachedView.getCurrentPage();
                if (newPage != null && newPage instanceof CallerIdSubpage) {
                    CallerIdSubpage callerIdPage = (CallerIdSubpage)newPage;
                    callerIdPage.setFilterExpressions(callerIdArgs);
                    callerIdPage.setTitleExpressions(callerIdTitles);
                }
                if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                    ((AnalysisPageCalculated)newPage).refreshHeader();
                }
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.delaylocations.listing")) {
                Singletons.getListingManager().showListing(presentation, rowModel.getModule(), rowModel.getCsect(), rowModel.getStatement(), dsn, page.getControl().getDisplay());
            }
        }
        return null;
    }
}

